//  Persistance of Vision Raytracer V3.0
//  World definition file.

//  Contains 2 lights, 12 textures and 84 primitives.
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar

//  Microscope with Mandelbrot Heightfield
//  Date :  2.5.97 - 25.6.97
//  by Andre Kaempfer

//  eta 2 hrs, 40 min on a Pentium 133MHz with 32 Megs



//  uses "mandel1.gif" for the Mandelbrot Heightfield



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <27.571, -18.606, 3.794>
  direction <0.0,     0.0,  2.5899>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.198, 0.000, -7.199>
}

// *******  L I G H T S *******
light_source { // AreaLight2
  <4.707, -11.150, 2.972>
  color  rgb<1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 0.000, -2.000>, 3, 3
  adaptive 1
  jitter
  atmospheric_attenuation on
}


light_source { // AreaLight1
  <14.139, 0.768, -1.019>
  color  rgb<1.000, 1.000, 1.000>
  area_light <0.000, -2.000, 0.000>, <0.000, 0.000, -2.000>, 3, 3
  adaptive 1
  jitter
}



// ********  TEXTURES  *******
//

#include "microscp.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

sphere { // GreatLens
  <0,0,0>,1
  texture {
    WGlass
  }
  scale <1.0, 1.0, 0.15>
  translate  <-2.309791, -6.637748, -10.576258>
}


object { // Paper1
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.051823, -2.304350, 0.000000>, <-0.902687, -2.411622, 0.000000>, <0.063012, -2.530801, 0.083729>, <0.101389, -2.428773, 0.000000>,
      <-1.868385, -1.205811, 0.000000>, <-0.812565, -1.191856, 0.000000>, <0.131615, -1.205811, 0.000000>, <0.158768, -1.322086, 0.209534>,
      <-1.834083, -0.240113, 0.000000>, <-0.456762, -0.445924, 0.000000>, <0.131615, -0.205811, 0.000000>, <0.342672, -0.377320, 0.000000>,
      <-1.348265, -0.029056, 0.624175>, <-0.718869, 0.279661, -0.011559>, <-0.303995, 0.399717, 0.000000>, <0.222616, 0.331114, 0.000000>
    }
  }
  texture {
    PaperTexture1
  }
  scale <1.75, 2.25, 1.0>
  rotate 40.0*z
  translate  <-2.738022, -1.600158, -10.744422>
}


#declare Lamp = difference {
  superellipsoid { // LampBody
    <1.0, 0.1>
    texture {
      BlackPlastic
    }
    scale <0.9, 0.85, 0.5>
    translate  <7.65, 2.5, -8.7>
  }
  sphere { // LBodyCutout
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale 0.75
    translate  <7.65, 2.5, -8.35>
  }
}
#declare Ring = lathe {
  linear_spline
  13  // control points
  <1.93007, 0.546372>,
  <1.91731, 0.528316>,
  <1.914575, 0.508532>,
  <1.910382, -0.47947>,
  <1.916743, -0.507597>,
  <1.94172, -0.549558>,
  <1.977666, -0.534989>,
  <2.006806, -0.5>,
  <2.006806, 0.101806>,
  <2.006806, 0.35>,
  <2.006806, 0.513612>,
  <1.983657, 0.543904>,
  <1.942999, 0.550791>
  rotate <90,0,90>
  scale <0.5, 0.5, 0.25>
  translate  <7.637869, 1.544624, -9.087269>
}
#declare LampRing = difference {
  object { Ring }
  box { // RingClip
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.75, 0.35>
    rotate 23.0*x
    translate  <7.637869, 2.344066, -8.892007>
  }
  texture {
    MetalTexture
  }
}
union { // SpotLamp
  sphere { // PinHead2
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.025, 0.075, 0.075>
    translate  <8.635, 2.5, -8.7>
  }
  sphere { // PinHead1
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.025, 0.075, 0.075>
    translate  <6.625, 2.5, -8.7>
  }
  cylinder { // LampAxis1
    <0,0,1>, <0,0,0>, 1
    texture {
      MetalTexture
    }
    scale <0.05, 0.05, 0.1>
    rotate -90.0*y
    translate  <8.615, 2.5, -8.715>
  }
  cylinder { // LampAxis2
    <0,0,1>, <0,0,0>, 1
    texture {
      MetalTexture
    }
    scale <0.05, 0.05, 0.1>
    rotate -90.0*y
    translate  <6.75, 2.5, -8.715>
  }
  cylinder { // LampGlass
    <0,0,1>, <0,0,0>, 1
    texture {
      Glass
    }
    scale <0.75, 0.75, 0.05>
    translate  <7.65, 2.5, -8.315>
  }
  object { Lamp }
  superellipsoid { // LampConnect1
    <1.0, 0.1>
    texture {
      MetalTexture
    }
    scale <0.2, 0.2, 0.025>
    rotate -90.0*y
    translate  <8.615, 2.5, -8.715>
  }
  superellipsoid { // LampConnect2
    <1.0, 0.1>
    texture {
      MetalTexture
    }
    scale <0.2, 0.2, 0.025>
    rotate -90.0*y
    translate  <6.665, 2.5, -8.715>
  }
  object { LampRing }
  superellipsoid { // RingPart2
    <0.1, 0.1>
    texture {
      MetalTexture
    }
    scale <0.025, 0.5, 0.15>
    rotate 23.0*x
    translate  <8.615, 2.05, -8.9>
  }
  superellipsoid { // RingPart1
    <0.1, 0.1>
    texture {
      MetalTexture
    }
    scale <0.025, 0.5, 0.15>
    rotate 23.0*x
    translate  <6.67, 2.05, -8.9>
  }
  rotate <-5.0, 20.0, 0.0>
  translate  <-0.675, -1.0, 2.1125>
}


cone { // ScrewHead
  <0,0,0>, 0.5, <0,0,1>, 1.0
  texture {
    MetalTexture
  }
  scale 0.2
  rotate -265.0*x
  translate  <3.35, -0.8, -9.05>
}


cylinder { // ScrewBody
  <0,0,1>, <0,0,0>, 1
  texture {
    MetalTexture
  }
  scale <0.075, 0.075, 0.5>
  rotate -85.0*x
  translate  <3.35, -1.45, -9.1>
}


sphere { // Lens
  <0,0,0>,1
  texture {
    LensTexture
  }
  scale <0.5, 0.5, 0.075>
  rotate 20.0*x
  translate  <3.35, -2.915, -0.6>
}


difference { // TubeCutout
  cylinder { // TubeRing1
    <0,0,1>, <0,0,0>, 1
    texture {
      BPlasticRibs
    }
    scale <0.6, 0.6, 0.15>
    rotate 20.0*x
    translate  <3.35, -2.85, -0.7>
  }
  cylinder { // RingCutout
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackPlastic
    }
    scale <0.5, 0.5, 0.2>
    rotate 20.0*x
    translate  <3.35, -2.875, -0.675>
  }
}


object {   // Mandelbrot
  height_field {
    gif "mandel1.gif"
    water_level 0.008
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    MbTexture
  }
  scale <0.95, 0.65, 0.1>
  rotate 9.0*x
  translate  <3.35, -0.25, -7.49>
}


#declare ClipEnd2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.019908, 1.0>,
  <0.014123, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    MetalTexture
  }
  scale <0.1, 0.15, 0.025>
  rotate <150.0, 0.0, 180.0>
  translate  <4.2, 0.6, -7.4>
}
#declare ClipConnect1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.019908, 1.0>,
  <0.014123, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    MetalTexture
  }
  scale <0.1, 0.15, 0.025>
  rotate -171.0*x
  translate  <4.2, -1.45, -7.65>
}
union { // MetalClip2
  object { ClipEnd2 }
  box { // ClipPart4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MetalTexture
    }
    scale <0.1, 0.7, 0.01>
    rotate 9.0*x
    translate  <4.2, -0.2, -7.6>
  }
  box { // ClipPart2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MetalTexture
    }
    scale <0.1, 0.2, 0.01>
    rotate -10.0*x
    translate  <4.2, -1.1, -7.675>
  }
  object { ClipConnect1 }
}


#declare ClipEnd = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.019908, 1.0>,
  <0.014123, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    MetalTexture
  }
  scale <0.1, 0.15, 0.025>
  rotate <150.0, 0.0, 180.0>
  translate  <2.45, 0.575, -7.4>
}
#declare ClipConnect = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.019908, 1.0>,
  <0.014123, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    MetalTexture
  }
  scale <0.1, 0.15, 0.025>
  rotate -171.0*x
  translate  <2.45, -1.45, -7.65>
}
union { // MetalClip1
  object { ClipEnd }
  box { // ClipPart3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MetalTexture
    }
    scale <0.1, 0.7, 0.01>
    rotate 9.0*x
    translate  <2.45, -0.25, -7.6>
  }
  box { // ClipPart1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MetalTexture
    }
    scale <0.1, 0.2, 0.01>
    rotate -10.0*x
    translate  <2.45, -1.125, -7.675>
  }
  object { ClipConnect }
}


box { // GlassPlate
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WGlass
  }
  scale <1.0, 0.75, 0.025>
  rotate 9.0*x
  translate  <3.35, -0.25, -7.65>
}


#declare OcRing2 = union {
  cone { // RCorner3
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.65, 0.65, 0.1>
    rotate <180.0, 0.0, 180.0>
    translate  <6.65, -2.0, -0.75>
  }
  cylinder { // MetalRing3
    <0,0,1>, <0,0,0>, 1
    scale <0.65, 0.65, 0.15>
    translate  <6.65, -2.0, -1.0>
  }
  texture {
    MetalTexture
  }
  scale <0.6, 0.6, 2.0>
  rotate <-180.0, 0.0, 0.0>
  translate  <-1.0, -0.2, -7.0>
}
union { // OcTube2
  object { OcRing2 }
  cylinder { // SmallTube2
    <0,0,1>, <0,0,0>, 1
    texture {
      MetalTexture
    }
    scale <0.25, 0.25, 1.0>
    translate  <3.0, 1.0, -6.0>
  }
  texture {
    MetalTexture
  }
  rotate <50.0, 0.0, 20.0>
  translate  <1.425, -5.25, -2.6>
}


#declare OcRing1 = union {
  cone { // RCorner2
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.65, 0.65, 0.1>
    rotate <180.0, 0.0, 180.0>
    translate  <6.65, -2.0, -0.75>
  }
  cylinder { // MetalRing2
    <0,0,1>, <0,0,0>, 1
    scale <0.65, 0.65, 0.15>
    translate  <6.65, -2.0, -1.0>
  }
  texture {
    MetalTexture
  }
  scale <0.6, 0.6, 2.0>
  rotate <-180.0, 0.0, 0.0>
  translate  <-1.0, -0.2, -7.0>
}
union { // OcTube1
  object { OcRing1 }
  cylinder { // SmallTube1
    <0,0,1>, <0,0,0>, 1
    texture {
      MetalTexture
    }
    scale <0.25, 0.25, 1.0>
    translate  <3.0, 1.0, -6.0>
  }
  texture {
    MetalTexture
  }
  rotate <50.0, 0.0, -20.0>
  translate  <-0.35, -3.25, -2.6>
}


union { // OcRing
  cone { // RCorner1
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.65, 0.65, 0.1>
    rotate <180.0, 0.0, 180.0>
    translate  <6.65, -2.0, -0.75>
  }
  cylinder { // MetalRing1
    <0,0,1>, <0,0,0>, 1
    scale <0.65, 0.65, 0.15>
    translate  <6.65, -2.0, -1.0>
  }
  texture {
    MetalTexture
  }
  scale <0.6, 0.6, 2.0>
  rotate <-20.0, -180.0, 0.0>
  translate  <7.325, 0.835, -7.275>
}


union { // TubeRing2
  cone { // RCorner
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.65, 0.65, 0.1>
    rotate <180.0, 0.0, 180.0>
    translate  <6.65, -2.0, -0.75>
  }
  cylinder { // MetalRing
    <0,0,1>, <0,0,0>, 1
    scale <0.65, 0.65, 0.15>
    translate  <6.65, -2.0, -1.0>
  }
  texture {
    MetalRibs
  }
  rotate 20.0*x
  translate  <-3.3, -0.925, -0.2>
}


plane { // Background
  z,0
  texture {
    WallTexture
  }
  scale <30.0, 1.0, 1.0>
  rotate <-90.0, 0.0, 45.0>
  translate  <-18.784498, 21.459505, -34.60984>
}






union { // MicAxis
  sphere { // AxisPin2
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale 0.05
    translate  <3.725, -1.85, -8.75>
  }
  sphere { // AxisPin1
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale 0.05
    translate  <2.925, -1.85, -8.75>
  }
  cylinder { // Axis1
    <0,0,1>, <0,0,0>, 1
    texture {
      MetalTexture
    }
    scale <0.05, 0.05, 0.8>
    rotate -90.0*y
    translate  <3.725, -1.85, -8.75>
  }
}


#declare MetalPart = lathe {
  linear_spline
  11  // control points
  <0.013938, 0.625791>,
  <2.296965, 0.622413>,
  <2.332193, 0.771763>,
  <2.299473, 0.820402>,
  <2.209903, 0.872033>,
  <1.933091, 0.945231>,
  <1.570321, 1.010157>,
  <1.190765, 1.06566>,
  <0.793823, 1.122394>,
  <0.408329, 1.165778>,
  <0.016918, 1.167743>
  rotate <90,0,90>
  texture {
    MetalTexture
  }
  scale <0.53, 0.53, 0.95>
  rotate <145.0, 0.0, 180.0>
  translate  <3.35, -1.035, -4.635>
}
#declare PlasticPart = lathe {
  linear_spline
  10  // control points
  <0.037318, 0.615058>,
  <2.445847, 0.617728>,
  <2.338409, 0.777978>,
  <2.305688, 0.814186>,
  <2.26264, 0.848799>,
  <2.209903, 0.872033>,
  <1.927174, 0.92748>,
  <1.564404, 0.962821>,
  <1.184848, 0.98874>,
  <0.01072, 1.027914>
  rotate <90,0,90>
  texture {
    BlackPlastic
  }
  scale <0.5, 0.5, 0.85>
  rotate 35.0*x
  translate  <3.35, -0.39, -5.55>
}
union { // OcChanger
  object { MetalPart }
  object { PlasticPart }
}


cylinder { // SmallTube
  <0,0,1>, <0,0,0>, 1
  texture {
    MetalTexture
  }
  scale <0.25, 0.25, 2.0>
  rotate 20.0*x
  translate  <3.35, -0.6, -6.875>
}


cylinder { // Pin2
  <0,0,1>, <0,0,0>, 1
  texture {
    MetalTexture
  }
  scale <0.075, 0.075, 0.3>
  rotate 9.0*x
  translate  <4.2, -1.35, -7.85>
}


cylinder { // Pin1
  <0,0,1>, <0,0,0>, 1
  texture {
    MetalTexture
  }
  scale <0.075, 0.075, 0.3>
  rotate 9.0*x
  translate  <2.45, -1.35, -7.85>
}


#declare PdPlate = difference {
  superellipsoid { // PdFrame
    <0.2, 0.2>
    scale <1.75, 1.75, 0.1>
    rotate 9.0*x
    translate  <3.35, 0.0, -7.75>
  }
  box { // PdCutout
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.35, 0.125>
    rotate 9.0*x
    translate  <3.35, 0.15, -7.725>
  }
  texture {
    BlackPlastic
  }
}
union { // Pedestal
  object { PdPlate }
  box { // PdGlass
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass
    }
    scale <1.5, 1.35, 0.125>
    rotate 9.0*x
    translate  <3.35, 0.125, -7.75>
  }
  box { // PdCube
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BaseTexture
    }
    scale <1.0, 0.35, 0.075>
    rotate 9.0*x
    translate  <3.35, -1.35, -8.1>
  }
}


#declare LvCylCuts2 = difference {
  cylinder { // AxisEnd2
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 0.3>
    rotate -90.0*y
    translate  <4.4, -2.85, -3.0>
  }
  cone { // CylCutout1
    <0,0,0>, 0.5, <0,0,1>, 0.6
    scale <1.0, 1.0, 0.25>
    rotate 90.0*y
    translate  <4.25, -2.85, -3.0>
  }
}
#declare LvCylCuts = difference {
  cylinder { // AxisEnd1
    <0,0,1>, <0,0,0>, 1
    scale <0.75, 0.75, 0.3>
    rotate -90.0*y
    translate  <2.6, -2.85, -3.0>
  }
  cone { // CylCutout2
    <0,0,0>, 0.5, <0,0,1>, 0.6
    scale <1.0, 1.0, 0.25>
    rotate -90.0*y
    translate  <2.45, -2.85, -3.0>
  }
}
union { // AxisCylinders
  cone { // LvCylCone2
    <0,0,0>, 0.7, <0,0,1>, 1.0
    scale <0.3, 0.3, 0.1>
    rotate 90.0*y
    translate  <2.35, -2.85, -3.0>
  }
  cone { // LvCylCone1
    <0,0,0>, 0.7, <0,0,1>, 1.0
    scale <0.3, 0.3, 0.1>
    rotate -90.0*y
    translate  <4.35, -2.85, -3.0>
  }
  object { LvCylCuts2 }
  object { LvCylCuts }
  cylinder { // LvCylinder
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.5, 1.5>
    rotate -90.0*y
    translate  <4.1, -2.85, -3.0>
  }
  texture {
    MetalTexture
  }
}


#declare Connect1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.836651, 1.0>,
  <-0.210482, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    BaseTexture
  }
  scale <0.7, 0.8, 0.15>
  rotate <75.0, 0.0, 90.0>
  translate  <3.75, -2.0, -9.0>
}
#declare Connect2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <0.836651, 1.0>,
  <-0.210482, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    BaseTexture
  }
  scale <0.7, 0.8, 0.15>
  rotate <105.0, 0.0, 90.0>
  translate  <2.75, -2.0, -9.0>
}
#declare Connects = union {
  object { Connect1 }
  object { Connect2 }
}
difference { // AxisConnect
  object { Connects }
  sphere { // KnobCutout3
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.1, 0.25, 0.25>
    rotate 15.0*y
    translate  <2.825, -1.85, -8.75>
  }
  sphere { // KnobCutout4
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.1, 0.25, 0.25>
    rotate -15.0*y
    translate  <3.825, -1.85, -8.75>
  }
}


cone { // SmallKnob2
  <0,0,0>, 0.2, <0,0,1>, 0.5
  texture {
    BlackPlastic
  }
  scale <0.2, 0.2, 0.1>
  rotate <90.0, 0.0, -85.0>
  translate  <5.35, 2.35, -10.25>
}


cone { // SmallKnob1
  <0,0,0>, 0.2, <0,0,1>, 0.5
  texture {
    BlackPlastic
  }
  scale <0.2, 0.2, 0.1>
  rotate <-90.0, 0.0, -95.0>
  translate  <1.33, 2.35, -10.25>
}


cylinder { // Tube1
  <0,0,1>, <0,0,0>, 1
  texture {
    MetalTexture
  }
  scale <0.5, 0.5, 4.6>
  rotate 20.0*x
  translate  <3.35, -1.3, -5.0>
}


cylinder { // TubeConnect
  <0,0,1>, <0,0,0>, 1
  texture {
    BaseTexture
  }
  scale <0.75, 0.75, 2.25>
  rotate 20.0*x
  translate  <3.35, -1.6, -4.2>
}


difference { // Round
  torus { // Torus001
    1.5, 0.35  rotate -x*90
    scale <1.75, 1.0, 0.75>
    rotate -90.0*y
    translate  <3.321343, 4.087078, -7.888154>
  }
  box { // RoundClip
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35, 1.0, 2.5>
    rotate -5.0*x
    translate  <3.336845, 5.34424, -8.73347>
  }
  box { // Clip3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35, 0.5, 1.0>
    translate  <3.343395, 5.470892, -5.76699>
  }
  box { // Clip2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 0.25>
    translate  <3.303292, 4.083426, -4.82259>
  }
  box { // SideClip1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 2.0, 3.25>
    translate  <3.591884, 4.109319, -7.934405>
  }
  box { // SideClip2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 2.0, 3.25>
    translate  <3.045414, 4.148845, -7.946796>
  }
  texture {
    BaseTexture
  }
  rotate 20.0*x
  translate  <0.0, -8.75, -0.25>
}


#declare BaseParts = union {
  superellipsoid { // BaseConnect
    <1.0, 0.1>
    scale <1.0, 1.0, 0.5>
    translate  <3.35, -3.0, -10.25>
  }
  superellipsoid { // Base1
    <1.0, 0.1>
    scale <1.0, 3.5, 0.5>
    rotate -10.0*z
    translate  <4.25, 0.0, -10.25>
  }
  superellipsoid { // Base2
    <1.0, 0.1>
    scale <1.0, 3.5, 0.5>
    rotate 10.0*z
    translate  <2.45, 0.0, -10.25>
  }
  texture {
    BaseTexture
  }
}
#declare BaseCutout = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.955274, -1.0>,
  <0.891102, -1.0>,
  <0.805343, -0.830662>,
  <0.71414, -0.785167>,
  <-0.81137, -0.785167>,
  <-0.866404, -0.833963>,
  <-0.955274, -1.0>
  rotate -x*90
  texture {
    BaseTexture
  }
  scale <3.0, 1.25, 4.25>
  rotate <90.0, 0.0, 90.0>
  translate  <1.225, -0.5, -9.5>
}
difference { // Base
  object { BaseParts }
  box { // BaseCutout2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BaseTexture
    }
    scale <0.5, 2.0, 0.5>
    translate  <3.35, 0.35, -10.25>
  }
  object { BaseCutout }
  sphere { // KnobCutout1
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.1, 0.25, 0.25>
    rotate -5.0*z
    translate  <1.35, 2.35, -10.25>
  }
  sphere { // KnobCutout2
    <0,0,0>,1
    texture {
      MetalTexture
    }
    scale <0.1, 0.25, 0.25>
    rotate 5.0*z
    translate  <5.35, 2.35, -10.25>
  }
}


box { // Desk
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WoodTexture
  }
  scale <20.0, 20.0, 1.0>
  translate  <1.960784, 1.031992, -11.75>
}


