// Moorish Geometrics include file
// for POV-ray 3.x
// Initial implementation attempt
// 6-27-97 Samuel J. Goldstein libelle@webbwerks.com
// 

// Initialize required variables to defaults if not defined
#ifndef (moorBaseTriangle)
  #declare moorBaseTriangle = union
   {
	sphere {<1,0,0>,0.1 texture{pigment{color Red}}}
	cylinder{<0,0,0>,<1,0,0>,0.05 texture{pigment{color Blue}}}
	cylinder{<0,0,0>,<1,0,0.8660254>,0.05 texture{pigment{color Blue}}}
	}
#end

#ifndef (moorRosetteOrder)
	#declare moorRosetteOrder=1
#end


#declare cleanBaseTriangle = intersection
	{
	object{moorBaseTriangle}
	plane{-x,0 rotate <0,-90,0>}
	plane{x,1}
	plane{-x,0 rotate <0, 30, 0>}
	}
	
	
#declare fullTriangle = union
	{
	object {cleanBaseTriangle}
	object {cleanBaseTriangle rotate <180,0,0>}
	}
	
#declare superTriangle = union
	{
	object {fullTriangle}
	object {fullTriangle rotate <0,120,0>}
	object {fullTriangle rotate <0,-120,0>}
	translate <2,0,0>
	}
	
#if (moorRosetteOrder = 1)
	object{superTriangle translate <-2,0,0>}
#end

#if (moorRosetteOrder = 2)
	#declare loop=0
	#while (loop<6)
		object{superTriangle rotate <0,loop*60,0>}
		#declare loop = loop + 1
	#end	
#end

#if (moorRosetteOrder >= 3)
	#declare bigRose = union {
	#declare loop=0
	#while (loop<6)
		object{superTriangle rotate <0,loop*60,0>}
		#declare loop = loop + 1
	#end
	#declare outerloop = 0
	#while (outerloop < 6)
		#declare loop=0
		#while (loop<6)
			object{superTriangle rotate <0,loop*60,0> 
				translate <6 * cos(radians(outerloop*60)), 0, 6 * sin(radians(outerloop*60))>}
			#declare loop = loop + 1
		#end
		#declare outerloop = outerloop + 1
	#end
	}
	object {bigRose}
#end

#if (moorRosetteOrder = 4)
	#declare loop=0
	#while (loop<6)
		object{bigRose
			translate <12 * cos(radians(loop*60)), 0, 12 * sin(radians(loop*60))>}
		#declare loop = loop + 1
	#end	
#end
