//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 40 textures and 727 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 05/30/1997    (30.05.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-14.195, -11.146, 26.542>
  direction <0.0,     0.0,  0.8195>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-6.636, 2.548, 11.540>
}

// *******  L I G H T S *******
light_source {   // Light002
  <13.900, 4.900, 117.900>
  color rgb <0.857, 0.857, 0.857>
}

light_source {   // Light001
  <-27.100, -18.100, 33.400>
  color rgb <0.630, 0.630, 0.630>
}

light_source {   // Light1
  <10.600, -32.300, 8.100>
  color rgb <0.774, 0.774, 0.774>
}


// ********  TEXTURES  *******
//

#include "moustrap.inc"



// ********  REFERENCED OBJECTS  *******

#declare Penny1 = object {
  cylinder { // Penny1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtPennyMMap
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <0.75, 0.75, 0.1>
    translate  <-0.039996, 0.035337, 0.0>
  }
}


//
// Include file contains 'Nail20'
//
#include "moustrap.in1"
#declare Nail20 = object {
  Nail20_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  rotate <0.0, -50.0, 0.0>
  translate  <-2.97208, -0.5, 1.160912>
}


#declare CageUpperWrCSG = difference {
  torus { // CageUpperWire1
    4.0, 0.05  rotate -x*90
    scale <1.1, 1.0, 1.2>
    rotate -90.0*y
  }
  plane { // UpperWireCut
    z,0
  }
}
#declare CageVertWire1 = object {
  cylinder { // CageVertWire1
    <0,0,1>, <0,0,0>, 1 
    scale <0.06, 0.05, 5.0>
    translate  <0.0, 4.0, -5.0>
  }
}
#declare CageWire1 = union {
  object { CageUpperWrCSG }
  object { CageVertWire1 }
  object { // CageVertWire2->CageVertWire1
    CageVertWire1
    translate  -8.0*y
  }
}
#declare CageMainRing1 = object {
  torus { // CageMainRing1
    1.5, 0.02  rotate -x*90
    scale 2.6
  }
}
#declare ScissorStrng15 = object {
  torus { // ScissorStrng15
    0.1, 0.05  rotate -x*90
    texture {
      txtStringMDullWhite
    }
    scale <1.467557, 1.711915, 1.479458>
    rotate <-91.623184, 21.451689, -136.007568>
    translate  <-0.066211, 0.076483, 4.946504>
  }
}
#declare ScissorStrng18 = object {
  torus { // ScissorStrng18
    0.125, 0.05  rotate -x*90
    texture {
      txtStringMDullWhite
    }
    scale <0.961705, 0.88339, 1.0>
    rotate <-88.616478, 17.225368, 71.854996>
    translate  <-6.210708, 0.016683, 19.434977>
  }
}
//
// Include file contains 'Nail12'
//
#include "moustrap.in2"
#declare Nail12 = object {
  Nail12_Raw
  texture {
    txtNailsMGreyDull
  }
  translate  <-2.357606, 6.653379, 19.712624>
}


#declare MotorFin1 = union {
  box { // MotorFinBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.05, 0.2>
    translate  -1.7*x
  }
  cylinder { // MotorFinCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 3.0>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.2, 0.0, 0.2>
  }
  texture {
    txtMotorFinsMGrayDull
  }
  translate  1.3*z
}
#declare MotorFin6 = union {
  box { // MotorFinBox2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.05, 0.2>
    translate  -1.7*x
  }
  cylinder { // MotorFinCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 3.0>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.2, 0.0, 0.2>
  }
  texture {
    txtMotorFinsMGrayDull
  }
  rotate -90.0*x
  translate  <0.0, 1.3, 0.0>
}
#declare MotorFin16 = union {
  box { // MotorFinBox4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.05, 0.2>
    translate  -1.7*x
  }
  cylinder { // MotorFinCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 3.0>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.2, 0.0, 0.2>
  }
  texture {
    txtMotorFinsMGrayDull
  }
  rotate -270.0*x
  translate  <0.0, -1.3, 0.0>
}
#declare MotorBaseHoleCt = object {
  cylinder { // MotorBaseHoleCt
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    translate  <-0.3, -1.0, -1.6>
  }
}
#declare MotorBaseCSG1 = union {
  box { // MotorMidBase1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 0.6, 0.1>
    translate  <-1.7, -0.6, -1.4>
  }
  object { MotorBaseHoleCt }
  object { // MotorBaseHole1->MotorBaseHoleCt
    MotorBaseHoleCt
    rotate 0.0*y
    translate  -2.8*x
  }
}
#declare MotorSideCut1 = object {
  box { // MotorSideCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.1, 0.2>
    translate  <-3.5, 0.0, 0.7>
  }
}
#declare MotorSide = difference {
  cylinder { // MotorSideCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  -3.4*x
  }
  object { MotorSideCut1 }
  object { // MotorSideCut2->MotorSideCut1
    MotorSideCut1
    rotate -45.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut3->MotorSideCut1
    MotorSideCut1
    rotate -90.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut4->MotorSideCut1
    MotorSideCut1
    rotate -135.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut5->MotorSideCut1
    MotorSideCut1
    rotate 180.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut6->MotorSideCut1
    MotorSideCut1
    rotate 135.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut7->MotorSideCut1
    MotorSideCut1
    rotate 90.0*x
    translate  <0.0, 0.0, 0.0>
  }
  object { // MotorSideCut8->MotorSideCut1
    MotorSideCut1
    rotate 45.0*x
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    txtMotorSidesMWhiteDull
  }
}
#declare interse0_17 = intersection {
  box { // box0_18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35, 0.3125, 0.35>
    translate  2.4875*y
  }
  plane { // plane0_19
    z,0
    rotate <-158.749512, 90.0, 0.0>
    translate  <-0.35, 2.35, 0.0>
  }
  plane { // plane1_20
    z,0
    rotate <360.0, 90.0, 21.2505>
    translate  <0.35, 2.35, 0.0>
  }
}
#declare interse0_19 = intersection {
  box { // box0_20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35, 0.3875, 0.35>
    translate  4.5125*y
  }
  plane { // plane0_21
    z,0
    rotate <-158.749512, 90.0, 0.0>
    translate  <-0.35, 4.45, 0.0>
  }
  plane { // plane1_22
    z,0
    rotate <360.0, 90.0, 21.2505>
    translate  <0.35, 4.45, 0.0>
  }
}
#declare BrngCylCSG = difference {
  cylinder { // BrngCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.8>
    rotate -90.0*x
  }
  cylinder { // BrngCylCut
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtSwitchMBlackPlastic
    }
    scale 0.4
    rotate -90.0*x
    translate  -0.35*y
  }
  cylinder { // BrngCylCut1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtSwitchMBlackPlastic
    }
    scale 0.4
    rotate -90.0*x
    translate  0.75*y
  }
}
#declare BrngBaseRnd1 = object {
  superellipsoid { // BrngBaseRnd1
    <0.05, 2.0>
    scale <0.1, 0.35, 0.4>
    translate  <0.6, 0.4, -0.4>
  }
}
// Include contains 'BrngBolt1'
#include "moustrap.in3"

#declare BrngBolt1 = object {
  BrngBolt1_Raw
  texture {
    txtBrngBoltsMSilverMetal
  }
  scale <0.1, 0.1, 0.078414>
  rotate -20.0*z
  translate  <0.8, 0.1, -0.4>
}
#declare BrngBaseCSG = difference {
  box { // BrngBase1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.4, 0.3>
    translate  <0.0, 0.4, 0.3>
  }
  cylinder { // BrngCylCut2
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtSwitchMBlackPlastic
    }
    scale <0.4, 0.4, 1.0>
    rotate -90.0*x
    translate  <0.0, -0.1, 0.6>
  }
  translate  -0.6*z
}
#declare Brng1 = union {
  object { BrngCylCSG }
  box { // BrngBase2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.9, 0.4, 0.1>
    translate  <0.0, 0.4, -0.5>
  }
  object { BrngBaseRnd1 }
  object { // BrngBaseRnd2->BrngBaseRnd1
    BrngBaseRnd1
    rotate <0.0, 0.0, 0.0>
    translate  -1.2*x
  }
  object { BrngBolt1 }
  object { // BrngBolt2->BrngBolt1
    BrngBolt1
    translate  0.6*y
  }
  object { // BrngBolt3->BrngBolt1
    BrngBolt1
    translate  -1.6*x
  }
  object { // BrngBolt4->BrngBolt1
    BrngBolt1
    translate  <-1.6, 0.6, 0.0>
  }
  object { BrngBaseCSG }
  texture {
    txtBrngMSpunBrass
  }
  rotate -90.0*z
  translate  <-2.7, 4.248171, -0.9>
}
#declare PlatSupportsGrp = union {
  box { // PlatSupport1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <-0.800000, 0.000000, 0.200000>
    }
    scale <0.5, 0.3, 3.9>
    translate  <-9.2, 9.9, 13.4>
  }
  box { // PlatSupport2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <-3.100000, 0.000000, 0.200000>
    }
    scale <0.5, 0.3, 5.5>
    rotate 45.0*x
    translate  <-9.2, 6.0, 13.9>
  }
  rotate 0.0*x
  translate  <-4.0, -4.4, -16.3>
}
#declare ScissorStrngTrs = object {
  torus { // ScissorStrngTrs
    0.29, 0.05  rotate -x*90
    rotate <-90.0, 18.180464, 0.0>
    translate  <-0.253157, 5.251882, 18.798279>
  }
}
#declare ScissorStrng11 = object {
  torus { // ScissorStrng11
    0.125, 0.05  rotate -x*90
    scale <0.961705, 0.88339, 1.0>
    rotate <-90.0, 18.180464, 0.0>
    translate  <-7.389415, 4.805457, 18.469069>
  }
}


#declare Spring1 = union {
  sphere { // sphere0_2
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 2.75, -2.5>
  }
  sphere { // sphere1_3
    <0,0,0>,1
    scale 0.25
    translate  <0.21753, 2.76389, -2.48634>
  }
  sphere { // sphere2_4
    <0,0,0>,1
    scale 0.25
    translate  <0.43267, 2.77778, -2.45381>
  }
  sphere { // sphere3_5
    <0,0,0>,1
    scale 0.25
    translate  <0.64381, 2.79167, -2.40274>
  }
  sphere { // sphere4_6
    <0,0,0>,1
    scale 0.25
    translate  <0.84935, 2.80556, -2.33357>
  }
  sphere { // sphere5_7
    <0,0,0>,1
    scale 0.25
    translate  <1.04774, 2.81944, -2.24689>
  }
  sphere { // sphere6_8
    <0,0,0>,1
    scale 0.25
    translate  <1.2375, 2.83333, -2.14341>
  }
  sphere { // sphere7_9
    <0,0,0>,1
    scale 0.25
    translate  <1.41721, 2.84722, -2.02399>
  }
  sphere { // sphere8_10
    <0,0,0>,1
    scale 0.25
    translate  <1.58554, 2.86111, -1.88958>
  }
  sphere { // sphere9_11
    <0,0,0>,1
    scale 0.25
    translate  <1.74125, 2.875, -1.74125>
  }
  sphere { // sphere10_12
    <0,0,0>,1
    scale 0.25
    translate  <1.88319, 2.88889, -1.58019>
  }
  sphere { // sphere11_13
    <0,0,0>,1
    scale 0.25
    translate  <2.01034, 2.90278, -1.40765>
  }
  sphere { // sphere12_14
    <0,0,0>,1
    scale 0.25
    translate  <2.12176, 2.91667, -1.225>
  }
  sphere { // sphere13_15
    <0,0,0>,1
    scale 0.25
    translate  <2.21668, 2.93055, -1.03365>
  }
  sphere { // sphere14_16
    <0,0,0>,1
    scale 0.25
    translate  <2.29442, 2.94444, -0.8351>
  }
  sphere { // sphere15_17
    <0,0,0>,1
    scale 0.25
    translate  <2.35445, 2.95833, -0.63087>
  }
  sphere { // sphere16_18
    <0,0,0>,1
    scale 0.25
    translate  <2.39637, 2.97222, -0.42254>
  }
  sphere { // sphere17_19
    <0,0,0>,1
    scale 0.25
    translate  <2.41992, 2.98611, -0.21172>
  }
  sphere { // sphere18_20
    <0,0,0>,1
    scale 0.25
    translate  <2.425, 3.0, 0.0>
  }
  sphere { // sphere19_21
    <0,0,0>,1
    scale 0.25
    translate  <2.41162, 3.01389, 0.21099>
  }
  sphere { // sphere20_22
    <0,0,0>,1
    scale 0.25
    translate  <2.37995, 3.02778, 0.41965>
  }
  sphere { // sphere21_23
    <0,0,0>,1
    scale 0.25
    translate  <2.3303, 3.04167, 0.6244>
  }
  sphere { // sphere22_24
    <0,0,0>,1
    scale 0.25
    translate  <2.26309, 3.05555, 0.8237>
  }
  sphere { // sphere23_25
    <0,0,0>,1
    scale 0.25
    translate  <2.17892, 3.06944, 1.01605>
  }
  sphere { // sphere24_26
    <0,0,0>,1
    scale 0.25
    translate  <2.07846, 3.08333, 1.2>
  }
  sphere { // sphere25_27
    <0,0,0>,1
    scale 0.25
    translate  <1.96255, 3.09722, 1.37419>
  }
  sphere { // sphere26_28
    <0,0,0>,1
    scale 0.25
    translate  <1.83212, 3.11111, 1.53734>
  }
  sphere { // sphere27_29
    <0,0,0>,1
    scale 0.25
    translate  <1.68822, 3.125, 1.68822>
  }
  sphere { // sphere28_30
    <0,0,0>,1
    scale 0.25
    translate  <1.53198, 3.13889, 1.82574>
  }
  sphere { // sphere29_31
    <0,0,0>,1
    scale 0.25
    translate  <1.36463, 3.15278, 1.9489>
  }
  sphere { // sphere30_32
    <0,0,0>,1
    scale 0.25
    translate  <1.1875, 3.16667, 2.05681>
  }
  sphere { // sphere31_33
    <0,0,0>,1
    scale 0.25
    translate  <1.00196, 3.18055, 2.14871>
  }
  sphere { // sphere32_34
    <0,0,0>,1
    scale 0.25
    translate  <0.80945, 3.19444, 2.22394>
  }
  sphere { // sphere33_35
    <0,0,0>,1
    scale 0.25
    translate  <0.61146, 3.20833, 2.282>
  }
  sphere { // sphere34_36
    <0,0,0>,1
    scale 0.25
    translate  <0.40952, 3.22222, 2.32251>
  }
  sphere { // sphere35_37
    <0,0,0>,1
    scale 0.25
    translate  <0.20518, 3.23611, 2.34521>
  }
  sphere { // sphere36_38
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 3.25, 2.35>
  }
  sphere { // sphere37_39
    <0,0,0>,1
    scale 0.25
    translate  <-0.20445, 3.26389, 2.33691>
  }
  sphere { // sphere38_40
    <0,0,0>,1
    scale 0.25
    translate  <-0.40663, 3.27778, 2.30609>
  }
  sphere { // sphere39_41
    <0,0,0>,1
    scale 0.25
    translate  <-0.60499, 3.29166, 2.25785>
  }
  sphere { // sphere40_42
    <0,0,0>,1
    scale 0.25
    translate  <-0.79805, 3.30555, 2.19262>
  }
  sphere { // sphere41_43
    <0,0,0>,1
    scale 0.25
    translate  <-0.98435, 3.31944, 2.11094>
  }
  sphere { // sphere42_44
    <0,0,0>,1
    scale 0.25
    translate  <-1.1625, 3.33333, 2.01351>
  }
  sphere { // sphere43_45
    <0,0,0>,1
    scale 0.25
    translate  <-1.33118, 3.34722, 1.90112>
  }
  sphere { // sphere44_46
    <0,0,0>,1
    scale 0.25
    translate  <-1.48913, 3.36111, 1.77467>
  }
  sphere { // sphere45_47
    <0,0,0>,1
    scale 0.25
    translate  <-1.63519, 3.375, 1.63519>
  }
  sphere { // sphere46_48
    <0,0,0>,1
    scale 0.25
    translate  <-1.76829, 3.38889, 1.48377>
  }
  sphere { // sphere47_49
    <0,0,0>,1
    scale 0.25
    translate  <-1.88747, 3.40278, 1.32162>
  }
  sphere { // sphere48_50
    <0,0,0>,1
    scale 0.25
    translate  <-1.99186, 3.41666, 1.15>
  }
  sphere { // sphere49_51
    <0,0,0>,1
    scale 0.25
    translate  <-2.08073, 3.43055, 0.97026>
  }
  sphere { // sphere50_52
    <0,0,0>,1
    scale 0.25
    translate  <-2.15347, 3.44444, 0.7838>
  }
  sphere { // sphere51_53
    <0,0,0>,1
    scale 0.25
    translate  <-2.20956, 3.45833, 0.59205>
  }
  sphere { // sphere52_54
    <0,0,0>,1
    scale 0.25
    translate  <-2.24865, 3.47222, 0.3965>
  }
  sphere { // sphere53_55
    <0,0,0>,1
    scale 0.25
    translate  <-2.2705, 3.48611, 0.19864>
  }
  sphere { // sphere54_56
    <0,0,0>,1
    scale 0.25
    translate  <-2.275, 3.5, 0.0>
  }
  sphere { // sphere55_57
    <0,0,0>,1
    scale 0.25
    translate  <-2.2622, 3.51389, -0.19792>
  }
  sphere { // sphere56_58
    <0,0,0>,1
    scale 0.25
    translate  <-2.23223, 3.52777, -0.3936>
  }
  sphere { // sphere57_59
    <0,0,0>,1
    scale 0.25
    translate  <-2.18541, 3.54166, -0.58558>
  }
  sphere { // sphere58_60
    <0,0,0>,1
    scale 0.25
    translate  <-2.12214, 3.55555, -0.7724>
  }
  sphere { // sphere59_61
    <0,0,0>,1
    scale 0.25
    translate  <-2.04297, 3.56944, -0.95265>
  }
  sphere { // sphere60_62
    <0,0,0>,1
    scale 0.25
    translate  <-1.94856, 3.58333, -1.125>
  }
  sphere { // sphere61_63
    <0,0,0>,1
    scale 0.25
    translate  <-1.83968, 3.59722, -1.28816>
  }
  sphere { // sphere62_64
    <0,0,0>,1
    scale 0.25
    translate  <-1.71722, 3.61111, -1.44092>
  }
  sphere { // sphere63_65
    <0,0,0>,1
    scale 0.25
    translate  <-1.58215, 3.625, -1.58215>
  }
  sphere { // sphere64_66
    <0,0,0>,1
    scale 0.25
    translate  <-1.43556, 3.63889, -1.71084>
  }
  sphere { // sphere65_67
    <0,0,0>,1
    scale 0.25
    translate  <-1.2786, 3.65277, -1.82603>
  }
  sphere { // sphere66_68
    <0,0,0>,1
    scale 0.25
    translate  <-1.1125, 3.66666, -1.92691>
  }
  sphere { // sphere67_69
    <0,0,0>,1
    scale 0.25
    translate  <-0.93857, 3.68055, -2.01276>
  }
  sphere { // sphere68_70
    <0,0,0>,1
    scale 0.25
    translate  <-0.75815, 3.69444, -2.08299>
  }
  sphere { // sphere69_71
    <0,0,0>,1
    scale 0.25
    translate  <-0.57264, 3.70833, -2.13712>
  }
  sphere { // sphere70_72
    <0,0,0>,1
    scale 0.25
    translate  <-0.38347, 3.72222, -2.17479>
  }
  sphere { // sphere71_73
    <0,0,0>,1
    scale 0.25
    translate  <-0.19211, 3.73611, -2.19578>
  }
  sphere { // sphere72_74
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 3.75, -2.2>
  }
  sphere { // sphere73_75
    <0,0,0>,1
    scale 0.25
    translate  <0.19138, 3.76389, -2.18748>
  }
  sphere { // sphere74_76
    <0,0,0>,1
    scale 0.25
    translate  <0.38058, 3.77777, -2.15837>
  }
  sphere { // sphere75_77
    <0,0,0>,1
    scale 0.25
    translate  <0.56617, 3.79166, -2.11297>
  }
  sphere { // sphere76_78
    <0,0,0>,1
    scale 0.25
    translate  <0.74675, 3.80555, -2.05167>
  }
  sphere { // sphere77_79
    <0,0,0>,1
    scale 0.25
    translate  <0.92096, 3.81944, -1.975>
  }
  sphere { // sphere78_80
    <0,0,0>,1
    scale 0.25
    translate  <1.0875, 3.83333, -1.88361>
  }
  sphere { // sphere79_81
    <0,0,0>,1
    scale 0.25
    translate  <1.24514, 3.84722, -1.77825>
  }
  sphere { // sphere80_82
    <0,0,0>,1
    scale 0.25
    translate  <1.39271, 3.86111, -1.65977>
  }
  sphere { // sphere81_83
    <0,0,0>,1
    scale 0.25
    translate  <1.52912, 3.875, -1.52912>
  }
  sphere { // sphere82_84
    <0,0,0>,1
    scale 0.25
    translate  <1.65338, 3.88888, -1.38735>
  }
  sphere { // sphere83_85
    <0,0,0>,1
    scale 0.25
    translate  <1.76459, 3.90277, -1.23558>
  }
  sphere { // sphere84_86
    <0,0,0>,1
    scale 0.25
    translate  <1.86196, 3.91666, -1.075>
  }
  sphere { // sphere85_87
    <0,0,0>,1
    scale 0.25
    translate  <1.94479, 3.93055, -0.90687>
  }
  sphere { // sphere86_88
    <0,0,0>,1
    scale 0.25
    translate  <2.01251, 3.94444, -0.73249>
  }
  sphere { // sphere87_89
    <0,0,0>,1
    scale 0.25
    translate  <2.06467, 3.95833, -0.55323>
  }
  sphere { // sphere88_90
    <0,0,0>,1
    scale 0.25
    translate  <2.10093, 3.97222, -0.37045>
  }
  sphere { // sphere89_91
    <0,0,0>,1
    scale 0.25
    translate  <2.12107, 3.98611, -0.18557>
  }
  sphere { // sphere90_92
    <0,0,0>,1
    scale 0.25
    translate  <2.12501, 4.0, 0.0>
  }
  sphere { // sphere91_93
    <0,0,0>,1
    scale 0.25
    translate  <2.11277, 4.01388, 0.18484>
  }
  sphere { // sphere92_94
    <0,0,0>,1
    scale 0.25
    translate  <2.08452, 4.02777, 0.36756>
  }
  sphere { // sphere93_95
    <0,0,0>,1
    scale 0.25
    translate  <2.04052, 4.04166, 0.54676>
  }
  sphere { // sphere94_96
    <0,0,0>,1
    scale 0.25
    translate  <1.98119, 4.05555, 0.7211>
  }
  sphere { // sphere95_97
    <0,0,0>,1
    scale 0.25
    translate  <1.90703, 4.06944, 0.88926>
  }
  sphere { // sphere96_98
    <0,0,0>,1
    scale 0.25
    translate  <1.81866, 4.08333, 1.05>
  }
  sphere { // sphere97_99
    <0,0,0>,1
    scale 0.25
    translate  <1.71681, 4.09722, 1.20212>
  }
  sphere { // sphere98_100
    <0,0,0>,1
    scale 0.25
    translate  <1.60231, 4.11111, 1.3445>
  }
  sphere { // sphere99_101
    <0,0,0>,1
    scale 0.25
    translate  <1.47609, 4.12499, 1.47609>
  }
  sphere { // sphere100_102
    <0,0,0>,1
    scale 0.25
    translate  <1.33914, 4.13888, 1.59593>
  }
  sphere { // sphere101_103
    <0,0,0>,1
    scale 0.25
    translate  <1.19256, 4.15277, 1.70316>
  }
  sphere { // sphere102_104
    <0,0,0>,1
    scale 0.25
    translate  <1.0375, 4.16666, 1.79701>
  }
  sphere { // sphere103_105
    <0,0,0>,1
    scale 0.25
    translate  <0.87517, 4.18055, 1.87682>
  }
  sphere { // sphere104_106
    <0,0,0>,1
    scale 0.25
    translate  <0.70684, 4.19444, 1.94204>
  }
  sphere { // sphere105_107
    <0,0,0>,1
    scale 0.25
    translate  <0.53381, 4.20833, 1.99223>
  }
  sphere { // sphere106_108
    <0,0,0>,1
    scale 0.25
    translate  <0.35743, 4.22222, 2.02707>
  }
  sphere { // sphere107_109
    <0,0,0>,1
    scale 0.25
    translate  <0.17903, 4.23611, 2.04636>
  }
  sphere { // sphere108_110
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 4.24999, 2.05001>
  }
  sphere { // sphere109_111
    <0,0,0>,1
    scale 0.25
    translate  <-0.17831, 4.26388, 2.03806>
  }
  sphere { // sphere110_112
    <0,0,0>,1
    scale 0.25
    translate  <-0.35453, 4.27777, 2.01066>
  }
  sphere { // sphere111_113
    <0,0,0>,1
    scale 0.25
    translate  <-0.52735, 4.29166, 1.96808>
  }
  sphere { // sphere112_114
    <0,0,0>,1
    scale 0.25
    translate  <-0.69544, 4.30555, 1.91071>
  }
  sphere { // sphere113_115
    <0,0,0>,1
    scale 0.25
    translate  <-0.85757, 4.31944, 1.83906>
  }
  sphere { // sphere114_116
    <0,0,0>,1
    scale 0.25
    translate  <-1.0125, 4.33333, 1.75371>
  }
  sphere { // sphere115_117
    <0,0,0>,1
    scale 0.25
    translate  <-1.15911, 4.34722, 1.65538>
  }
  sphere { // sphere116_118
    <0,0,0>,1
    scale 0.25
    translate  <-1.29629, 4.3611, 1.54486>
  }
  sphere { // sphere117_119
    <0,0,0>,1
    scale 0.25
    translate  <-1.42306, 4.37499, 1.42306>
  }
  sphere { // sphere118_120
    <0,0,0>,1
    scale 0.25
    translate  <-1.53848, 4.38888, 1.29094>
  }
  sphere { // sphere119_121
    <0,0,0>,1
    scale 0.25
    translate  <-1.64172, 4.40277, 1.14955>
  }
  sphere { // sphere120_122
    <0,0,0>,1
    scale 0.25
    translate  <-1.73206, 4.41666, 1.0>
  }
  sphere { // sphere121_123
    <0,0,0>,1
    scale 0.25
    translate  <-1.80885, 4.43055, 0.84348>
  }
  sphere { // sphere122_124
    <0,0,0>,1
    scale 0.25
    translate  <-1.87156, 4.44444, 0.68119>
  }
  sphere { // sphere123_125
    <0,0,0>,1
    scale 0.25
    translate  <-1.91979, 4.45833, 0.5144>
  }
  sphere { // sphere124_126
    <0,0,0>,1
    scale 0.25
    translate  <-1.95321, 4.47222, 0.3444>
  }
  sphere { // sphere125_127
    <0,0,0>,1
    scale 0.25
    translate  <-1.97164, 4.4861, 0.1725>
  }
  sphere { // sphere126_128
    <0,0,0>,1
    scale 0.25
    translate  <-1.97501, 4.49999, 0.0>
  }
  sphere { // sphere127_129
    <0,0,0>,1
    scale 0.25
    translate  <-1.96334, 4.51388, -0.17177>
  }
  sphere { // sphere128_130
    <0,0,0>,1
    scale 0.25
    translate  <-1.9368, 4.52777, -0.34151>
  }
  sphere { // sphere129_131
    <0,0,0>,1
    scale 0.25
    translate  <-1.89564, 4.54166, -0.50794>
  }
  sphere { // sphere130_132
    <0,0,0>,1
    scale 0.25
    translate  <-1.84024, 4.55555, -0.66979>
  }
  sphere { // sphere131_133
    <0,0,0>,1
    scale 0.25
    translate  <-1.77108, 4.56944, -0.82587>
  }
  sphere { // sphere132_134
    <0,0,0>,1
    scale 0.25
    translate  <-1.68875, 4.58333, -0.975>
  }
  sphere { // sphere133_135
    <0,0,0>,1
    scale 0.25
    translate  <-1.59394, 4.59722, -1.11609>
  }
  sphere { // sphere134_136
    <0,0,0>,1
    scale 0.25
    translate  <-1.48741, 4.6111, -1.24808>
  }
  sphere { // sphere135_137
    <0,0,0>,1
    scale 0.25
    translate  <-1.37002, 4.62499, -1.37003>
  }
  sphere { // sphere136_138
    <0,0,0>,1
    scale 0.25
    translate  <-1.24273, 4.63888, -1.48103>
  }
  sphere { // sphere137_139
    <0,0,0>,1
    scale 0.25
    translate  <-1.10653, 4.65277, -1.58029>
  }
  sphere { // sphere138_140
    <0,0,0>,1
    scale 0.25
    translate  <-0.9625, 4.66666, -1.66711>
  }
  sphere { // sphere139_141
    <0,0,0>,1
    scale 0.25
    translate  <-0.81178, 4.68055, -1.74087>
  }
  sphere { // sphere140_142
    <0,0,0>,1
    scale 0.25
    translate  <-0.65554, 4.69444, -1.80108>
  }
  sphere { // sphere141_143
    <0,0,0>,1
    scale 0.25
    translate  <-0.49499, 4.70833, -1.84734>
  }
  sphere { // sphere142_144
    <0,0,0>,1
    scale 0.25
    translate  <-0.33138, 4.72221, -1.87935>
  }
  sphere { // sphere143_145
    <0,0,0>,1
    scale 0.25
    translate  <-0.16596, 4.7361, -1.89693>
  }
  sphere { // sphere144_146
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 4.74999, -1.90001>
  }
  sphere { // sphere145_147
    <0,0,0>,1
    scale 0.25
    translate  <0.16523, 4.76388, -1.88863>
  }
  sphere { // sphere146_148
    <0,0,0>,1
    scale 0.25
    translate  <0.32849, 4.77777, -1.86293>
  }
  sphere { // sphere147_149
    <0,0,0>,1
    scale 0.25
    translate  <0.48852, 4.79166, -1.82319>
  }
  sphere { // sphere148_150
    <0,0,0>,1
    scale 0.25
    translate  <0.64414, 4.80555, -1.76976>
  }
  sphere { // sphere149_151
    <0,0,0>,1
    scale 0.25
    translate  <0.79417, 4.81944, -1.70311>
  }
  sphere { // sphere150_152
    <0,0,0>,1
    scale 0.25
    translate  <0.9375, 4.83333, -1.6238>
  }
  sphere { // sphere151_153
    <0,0,0>,1
    scale 0.25
    translate  <1.07307, 4.84721, -1.5325>
  }
  sphere { // sphere152_154
    <0,0,0>,1
    scale 0.25
    translate  <1.19987, 4.8611, -1.42995>
  }
  sphere { // sphere153_155
    <0,0,0>,1
    scale 0.25
    translate  <1.31699, 4.87499, -1.31699>
  }
  sphere { // sphere154_156
    <0,0,0>,1
    scale 0.25
    translate  <1.42357, 4.88888, -1.19452>
  }
  sphere { // sphere155_157
    <0,0,0>,1
    scale 0.25
    translate  <1.51885, 4.90277, -1.06351>
  }
  sphere { // sphere156_158
    <0,0,0>,1
    scale 0.25
    translate  <1.60215, 4.91666, -0.925>
  }
  sphere { // sphere157_159
    <0,0,0>,1
    scale 0.25
    translate  <1.6729, 4.93055, -0.78008>
  }
  sphere { // sphere158_160
    <0,0,0>,1
    scale 0.25
    translate  <1.73061, 4.94444, -0.62989>
  }
  sphere { // sphere159_161
    <0,0,0>,1
    scale 0.25
    translate  <1.77489, 4.95832, -0.47558>
  }
  sphere { // sphere160_162
    <0,0,0>,1
    scale 0.25
    translate  <1.80549, 4.97221, -0.31835>
  }
  sphere { // sphere161_163
    <0,0,0>,1
    scale 0.25
    translate  <1.82221, 4.9861, -0.15942>
  }
  sphere { // sphere162_164
    <0,0,0>,1
    scale 0.25
    translate  <1.82501, 4.99999, 0.0>
  }
  sphere { // sphere163_165
    <0,0,0>,1
    scale 0.25
    translate  <1.81391, 5.01388, 0.1587>
  }
  sphere { // sphere164_166
    <0,0,0>,1
    scale 0.25
    translate  <1.78907, 5.02777, 0.31546>
  }
  sphere { // sphere165_167
    <0,0,0>,1
    scale 0.25
    translate  <1.75075, 5.04166, 0.46911>
  }
  sphere { // sphere166_168
    <0,0,0>,1
    scale 0.25
    translate  <1.69928, 5.05555, 0.61849>
  }
  sphere { // sphere167_169
    <0,0,0>,1
    scale 0.25
    translate  <1.63513, 5.06944, 0.76248>
  }
  sphere { // sphere168_170
    <0,0,0>,1
    scale 0.25
    translate  <1.55885, 5.08332, 0.9>
  }
  sphere { // sphere169_171
    <0,0,0>,1
    scale 0.25
    translate  <1.47106, 5.09721, 1.03005>
  }
  sphere { // sphere170_172
    <0,0,0>,1
    scale 0.25
    translate  <1.3725, 5.1111, 1.15167>
  }
  sphere { // sphere171_173
    <0,0,0>,1
    scale 0.25
    translate  <1.26396, 5.12499, 1.26396>
  }
  sphere { // sphere172_174
    <0,0,0>,1
    scale 0.25
    translate  <1.14631, 5.13888, 1.36612>
  }
  sphere { // sphere173_175
    <0,0,0>,1
    scale 0.25
    translate  <1.02049, 5.15277, 1.45741>
  }
  sphere { // sphere174_176
    <0,0,0>,1
    scale 0.25
    translate  <0.8875, 5.16666, 1.5372>
  }
  sphere { // sphere175_177
    <0,0,0>,1
    scale 0.25
    translate  <0.74839, 5.18055, 1.60492>
  }
  sphere { // sphere176_178
    <0,0,0>,1
    scale 0.25
    translate  <0.60424, 5.19444, 1.66013>
  }
  sphere { // sphere177_179
    <0,0,0>,1
    scale 0.25
    translate  <0.45617, 5.20832, 1.70245>
  }
  sphere { // sphere178_180
    <0,0,0>,1
    scale 0.25
    translate  <0.30533, 5.22221, 1.73162>
  }
  sphere { // sphere179_181
    <0,0,0>,1
    scale 0.25
    translate  <0.15288, 5.2361, 1.7475>
  }
  sphere { // sphere180_182
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 5.24999, 1.75>
  }
  sphere { // sphere181_183
    <0,0,0>,1
    scale 0.25
    translate  <-0.15216, 5.26388, 1.73919>
  }
  sphere { // sphere182_184
    <0,0,0>,1
    scale 0.25
    translate  <-0.30244, 5.27777, 1.71521>
  }
  sphere { // sphere183_185
    <0,0,0>,1
    scale 0.25
    translate  <-0.4497, 5.29166, 1.6783>
  }
  sphere { // sphere184_186
    <0,0,0>,1
    scale 0.25
    translate  <-0.59284, 5.30555, 1.6288>
  }
  sphere { // sphere185_187
    <0,0,0>,1
    scale 0.25
    translate  <-0.73078, 5.31943, 1.56716>
  }
  sphere { // sphere186_188
    <0,0,0>,1
    scale 0.25
    translate  <-0.8625, 5.33332, 1.4939>
  }
  sphere { // sphere187_189
    <0,0,0>,1
    scale 0.25
    translate  <-0.98703, 5.34721, 1.40963>
  }
  sphere { // sphere188_190
    <0,0,0>,1
    scale 0.25
    translate  <-1.10346, 5.3611, 1.31504>
  }
  sphere { // sphere189_191
    <0,0,0>,1
    scale 0.25
    translate  <-1.21092, 5.37499, 1.21092>
  }
  sphere { // sphere190_192
    <0,0,0>,1
    scale 0.25
    translate  <-1.30866, 5.38888, 1.0981>
  }
  sphere { // sphere191_193
    <0,0,0>,1
    scale 0.25
    translate  <-1.39598, 5.40277, 0.97747>
  }
  sphere { // sphere192_194
    <0,0,0>,1
    scale 0.25
    translate  <-1.47225, 5.41666, 0.85>
  }
  sphere { // sphere193_195
    <0,0,0>,1
    scale 0.25
    translate  <-1.53695, 5.43055, 0.71669>
  }
  sphere { // sphere194_196
    <0,0,0>,1
    scale 0.25
    translate  <-1.58965, 5.44443, 0.57858>
  }
  sphere { // sphere195_197
    <0,0,0>,1
    scale 0.25
    translate  <-1.63, 5.45832, 0.43676>
  }
  sphere { // sphere196_198
    <0,0,0>,1
    scale 0.25
    translate  <-1.65776, 5.47221, 0.29231>
  }
  sphere { // sphere197_199
    <0,0,0>,1
    scale 0.25
    translate  <-1.67278, 5.4861, 0.14635>
  }
  sphere { // sphere198_200
    <0,0,0>,1
    scale 0.25
    translate  <-1.675, 5.49999, 0.0>
  }
  sphere { // sphere199_201
    <0,0,0>,1
    scale 0.25
    translate  <-1.66448, 5.51388, -0.14562>
  }
  sphere { // sphere200_202
    <0,0,0>,1
    scale 0.25
    translate  <-1.64135, 5.52777, -0.28942>
  }
  sphere { // sphere201_203
    <0,0,0>,1
    scale 0.25
    translate  <-1.60585, 5.54166, -0.43029>
  }
  sphere { // sphere202_204
    <0,0,0>,1
    scale 0.25
    translate  <-1.55833, 5.55554, -0.56719>
  }
  sphere { // sphere203_205
    <0,0,0>,1
    scale 0.25
    translate  <-1.49919, 5.56943, -0.69908>
  }
  sphere { // sphere204_206
    <0,0,0>,1
    scale 0.25
    translate  <-1.42894, 5.58332, -0.825>
  }
  sphere { // sphere205_207
    <0,0,0>,1
    scale 0.25
    translate  <-1.34819, 5.59721, -0.94401>
  }
  sphere { // sphere206_208
    <0,0,0>,1
    scale 0.25
    translate  <-1.25759, 5.6111, -1.05525>
  }
  sphere { // sphere207_209
    <0,0,0>,1
    scale 0.25
    translate  <-1.15789, 5.62499, -1.15789>
  }
  sphere { // sphere208_210
    <0,0,0>,1
    scale 0.25
    translate  <-1.04989, 5.63888, -1.25121>
  }
  sphere { // sphere209_211
    <0,0,0>,1
    scale 0.25
    translate  <-0.93445, 5.65277, -1.33454>
  }
  sphere { // sphere210_212
    <0,0,0>,1
    scale 0.25
    translate  <-0.8125, 5.66666, -1.40729>
  }
  sphere { // sphere211_213
    <0,0,0>,1
    scale 0.25
    translate  <-0.68499, 5.68054, -1.46898>
  }
  sphere { // sphere212_214
    <0,0,0>,1
    scale 0.25
    translate  <-0.55293, 5.69443, -1.51917>
  }
  sphere { // sphere213_215
    <0,0,0>,1
    scale 0.25
    translate  <-0.41734, 5.70832, -1.55756>
  }
  sphere { // sphere214_216
    <0,0,0>,1
    scale 0.25
    translate  <-0.27928, 5.72221, -1.5839>
  }
  sphere { // sphere215_217
    <0,0,0>,1
    scale 0.25
    translate  <-0.13981, 5.7361, -1.59806>
  }
  sphere { // sphere216_218
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 5.74999, -1.6>
  }
  sphere { // sphere217_219
    <0,0,0>,1
    scale 0.25
    translate  <0.13909, 5.76388, -1.58976>
  }
  sphere { // sphere218_220
    <0,0,0>,1
    scale 0.25
    translate  <0.27639, 5.77777, -1.56749>
  }
  sphere { // sphere219_221
    <0,0,0>,1
    scale 0.25
    translate  <0.41088, 5.79166, -1.53341>
  }
  sphere { // sphere220_222
    <0,0,0>,1
    scale 0.25
    translate  <0.54153, 5.80554, -1.48785>
  }
  sphere { // sphere221_223
    <0,0,0>,1
    scale 0.25
    translate  <0.66739, 5.81943, -1.43121>
  }
  sphere { // sphere222_224
    <0,0,0>,1
    scale 0.25
    translate  <0.7875, 5.83332, -1.36399>
  }
  sphere { // sphere223_225
    <0,0,0>,1
    scale 0.25
    translate  <0.901, 5.84721, -1.28675>
  }
  sphere { // sphere224_226
    <0,0,0>,1
    scale 0.25
    translate  <1.00704, 5.8611, -1.20014>
  }
  sphere { // sphere225_227
    <0,0,0>,1
    scale 0.25
    translate  <1.10486, 5.87499, -1.10485>
  }
  sphere { // sphere226_228
    <0,0,0>,1
    scale 0.25
    translate  <1.19376, 5.88888, -1.00168>
  }
  sphere { // sphere227_229
    <0,0,0>,1
    scale 0.25
    translate  <1.2731, 5.90277, -0.89143>
  }
  sphere { // sphere228_230
    <0,0,0>,1
    scale 0.25
    translate  <1.34234, 5.91665, -0.775>
  }
  sphere { // sphere229_231
    <0,0,0>,1
    scale 0.25
    translate  <1.401, 5.93054, -0.6533>
  }
  sphere { // sphere230_232
    <0,0,0>,1
    scale 0.25
    translate  <1.44869, 5.94443, -0.52728>
  }
  sphere { // sphere231_233
    <0,0,0>,1
    scale 0.25
    translate  <1.48511, 5.95832, -0.39793>
  }
  sphere { // sphere232_234
    <0,0,0>,1
    scale 0.25
    translate  <1.51004, 5.97221, -0.26626>
  }
  sphere { // sphere233_235
    <0,0,0>,1
    scale 0.25
    translate  <1.52335, 5.9861, -0.13327>
  }
  sphere { // sphere234_236
    <0,0,0>,1
    scale 0.25
    translate  <1.525, 5.99999, 0.0>
  }
  sphere { // sphere235_237
    <0,0,0>,1
    scale 0.25
    translate  <1.51505, 6.01388, 0.13255>
  }
  sphere { // sphere236_238
    <0,0,0>,1
    scale 0.25
    translate  <1.49363, 6.02777, 0.26337>
  }
  sphere { // sphere237_239
    <0,0,0>,1
    scale 0.25
    translate  <1.46096, 6.04165, 0.39147>
  }
  sphere { // sphere238_240
    <0,0,0>,1
    scale 0.25
    translate  <1.41737, 6.05554, 0.51588>
  }
  sphere { // sphere239_241
    <0,0,0>,1
    scale 0.25
    translate  <1.36324, 6.06943, 0.63569>
  }
  sphere { // sphere240_242
    <0,0,0>,1
    scale 0.25
    translate  <1.29904, 6.08332, 0.75>
  }
  sphere { // sphere241_243
    <0,0,0>,1
    scale 0.25
    translate  <1.22531, 6.09721, 0.85798>
  }
  sphere { // sphere242_244
    <0,0,0>,1
    scale 0.25
    translate  <1.14268, 6.1111, 0.95883>
  }
  sphere { // sphere243_245
    <0,0,0>,1
    scale 0.25
    translate  <1.05182, 6.12499, 1.05182>
  }
  sphere { // sphere244_246
    <0,0,0>,1
    scale 0.25
    translate  <0.95347, 6.13888, 1.1363>
  }
  sphere { // sphere245_247
    <0,0,0>,1
    scale 0.25
    translate  <0.84841, 6.15276, 1.21166>
  }
  sphere { // sphere246_248
    <0,0,0>,1
    scale 0.25
    translate  <0.7375, 6.16665, 1.27739>
  }
  sphere { // sphere247_249
    <0,0,0>,1
    scale 0.25
    translate  <0.6216, 6.18054, 1.33303>
  }
  sphere { // sphere248_250
    <0,0,0>,1
    scale 0.25
    translate  <0.50163, 6.19443, 1.37822>
  }
  sphere { // sphere249_251
    <0,0,0>,1
    scale 0.25
    translate  <0.37852, 6.20832, 1.41267>
  }
  sphere { // sphere250_252
    <0,0,0>,1
    scale 0.25
    translate  <0.25324, 6.22221, 1.43618>
  }
  sphere { // sphere251_253
    <0,0,0>,1
    scale 0.25
    translate  <0.12674, 6.2361, 1.44863>
  }
  sphere { // sphere252_254
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 6.24999, 1.45>
  }
  sphere { // sphere253_255
    <0,0,0>,1
    scale 0.25
    translate  <-0.12601, 6.26388, 1.44033>
  }
  sphere { // sphere254_256
    <0,0,0>,1
    scale 0.25
    translate  <-0.25034, 6.27776, 1.41976>
  }
  sphere { // sphere255_257
    <0,0,0>,1
    scale 0.25
    translate  <-0.37205, 6.29165, 1.38852>
  }
  sphere { // sphere256_258
    <0,0,0>,1
    scale 0.25
    translate  <-0.49023, 6.30554, 1.34689>
  }
  sphere { // sphere257_259
    <0,0,0>,1
    scale 0.25
    translate  <-0.60399, 6.31943, 1.29526>
  }
  sphere { // sphere258_260
    <0,0,0>,1
    scale 0.25
    translate  <-0.7125, 6.33332, 1.23409>
  }
  sphere { // sphere259_261
    <0,0,0>,1
    scale 0.25
    translate  <-0.81496, 6.34721, 1.16388>
  }
  sphere { // sphere260_262
    <0,0,0>,1
    scale 0.25
    translate  <-0.91062, 6.3611, 1.08523>
  }
  sphere { // sphere261_263
    <0,0,0>,1
    scale 0.25
    translate  <-0.99879, 6.37499, 0.99879>
  }
  sphere { // sphere262_264
    <0,0,0>,1
    scale 0.25
    translate  <-1.07885, 6.38888, 0.90526>
  }
  sphere { // sphere263_265
    <0,0,0>,1
    scale 0.25
    translate  <-1.15023, 6.40276, 0.8054>
  }
  sphere { // sphere264_266
    <0,0,0>,1
    scale 0.25
    translate  <-1.21244, 6.41665, 0.7>
  }
  sphere { // sphere265_267
    <0,0,0>,1
    scale 0.25
    translate  <-1.26505, 6.43054, 0.5899>
  }
  sphere { // sphere266_268
    <0,0,0>,1
    scale 0.25
    translate  <-1.30774, 6.44443, 0.47598>
  }
  sphere { // sphere267_269
    <0,0,0>,1
    scale 0.25
    translate  <-1.34022, 6.45832, 0.35911>
  }
  sphere { // sphere268_270
    <0,0,0>,1
    scale 0.25
    translate  <-1.36232, 6.47221, 0.24021>
  }
  sphere { // sphere269_271
    <0,0,0>,1
    scale 0.25
    translate  <-1.37392, 6.4861, 0.1202>
  }
  sphere { // sphere270_272
    <0,0,0>,1
    scale 0.25
    translate  <-1.375, 6.49999, 0.0>
  }
  sphere { // sphere271_273
    <0,0,0>,1
    scale 0.25
    translate  <-1.36562, 6.51387, -0.11948>
  }
  sphere { // sphere272_274
    <0,0,0>,1
    scale 0.25
    translate  <-1.3459, 6.52776, -0.23732>
  }
  sphere { // sphere273_275
    <0,0,0>,1
    scale 0.25
    translate  <-1.31607, 6.54165, -0.35264>
  }
  sphere { // sphere274_276
    <0,0,0>,1
    scale 0.25
    translate  <-1.27641, 6.55554, -0.46458>
  }
  sphere { // sphere275_277
    <0,0,0>,1
    scale 0.25
    translate  <-1.22729, 6.56943, -0.5723>
  }
  sphere { // sphere276_278
    <0,0,0>,1
    scale 0.25
    translate  <-1.16913, 6.58332, -0.675>
  }
  sphere { // sphere277_279
    <0,0,0>,1
    scale 0.25
    translate  <-1.10244, 6.59721, -0.77194>
  }
  sphere { // sphere278_280
    <0,0,0>,1
    scale 0.25
    translate  <-1.02777, 6.6111, -0.86241>
  }
  sphere { // sphere279_281
    <0,0,0>,1
    scale 0.25
    translate  <-0.94575, 6.62499, -0.94576>
  }
  sphere { // sphere280_282
    <0,0,0>,1
    scale 0.25
    translate  <-0.85705, 6.63887, -1.02139>
  }
  sphere { // sphere281_283
    <0,0,0>,1
    scale 0.25
    translate  <-0.76238, 6.65276, -1.08879>
  }
  sphere { // sphere282_284
    <0,0,0>,1
    scale 0.25
    translate  <-0.6625, 6.66665, -1.14748>
  }
  sphere { // sphere283_285
    <0,0,0>,1
    scale 0.25
    translate  <-0.55821, 6.68054, -1.19708>
  }
  sphere { // sphere284_286
    <0,0,0>,1
    scale 0.25
    translate  <-0.45032, 6.69443, -1.23726>
  }
  sphere { // sphere285_287
    <0,0,0>,1
    scale 0.25
    translate  <-0.3397, 6.70832, -1.26778>
  }
  sphere { // sphere286_288
    <0,0,0>,1
    scale 0.25
    translate  <-0.22719, 6.72221, -1.28846>
  }
  sphere { // sphere287_289
    <0,0,0>,1
    scale 0.25
    translate  <-0.11366, 6.7361, -1.2992>
  }
  sphere { // sphere288_290
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 6.74998, -1.3>
  }
  sphere { // sphere289_291
    <0,0,0>,1
    scale 0.25
    translate  <0.11294, 6.76387, -1.2909>
  }
  sphere { // sphere290_292
    <0,0,0>,1
    scale 0.25
    translate  <0.2243, 6.77776, -1.27204>
  }
  sphere { // sphere291_293
    <0,0,0>,1
    scale 0.25
    translate  <0.33323, 6.79165, -1.24363>
  }
  sphere { // sphere292_294
    <0,0,0>,1
    scale 0.25
    translate  <0.43893, 6.80554, -1.20594>
  }
  sphere { // sphere293_295
    <0,0,0>,1
    scale 0.25
    translate  <0.5406, 6.81943, -1.15932>
  }
  sphere { // sphere294_296
    <0,0,0>,1
    scale 0.25
    translate  <0.6375, 6.83332, -1.10418>
  }
  sphere { // sphere295_297
    <0,0,0>,1
    scale 0.25
    translate  <0.72892, 6.84721, -1.041>
  }
  sphere { // sphere296_298
    <0,0,0>,1
    scale 0.25
    translate  <0.8142, 6.8611, -0.97032>
  }
  sphere { // sphere297_299
    <0,0,0>,1
    scale 0.25
    translate  <0.89272, 6.87498, -0.89272>
  }
  sphere { // sphere298_300
    <0,0,0>,1
    scale 0.25
    translate  <0.96394, 6.88887, -0.80884>
  }
  sphere { // sphere299_301
    <0,0,0>,1
    scale 0.25
    translate  <1.02735, 6.90276, -0.71936>
  }
  sphere { // sphere300_302
    <0,0,0>,1
    scale 0.25
    translate  <1.08253, 6.91665, -0.625>
  }
  sphere { // sphere301_303
    <0,0,0>,1
    scale 0.25
    translate  <1.12911, 6.93054, -0.52651>
  }
  sphere { // sphere302_304
    <0,0,0>,1
    scale 0.25
    translate  <1.16678, 6.94443, -0.42467>
  }
  sphere { // sphere303_305
    <0,0,0>,1
    scale 0.25
    translate  <1.19533, 6.95832, -0.32029>
  }
  sphere { // sphere304_306
    <0,0,0>,1
    scale 0.25
    translate  <1.21459, 6.97221, -0.21416>
  }
  sphere { // sphere305_307
    <0,0,0>,1
    scale 0.25
    translate  <1.22449, 6.98609, -0.10713>
  }
  sphere { // sphere306_308
    <0,0,0>,1
    scale 0.25
    translate  <1.225, 6.99998, 0.0>
  }
  sphere { // sphere307_309
    <0,0,0>,1
    scale 0.25
    translate  <1.21618, 7.01387, 0.1064>
  }
  sphere { // sphere308_310
    <0,0,0>,1
    scale 0.25
    translate  <1.19818, 7.02776, 0.21127>
  }
  sphere { // sphere309_311
    <0,0,0>,1
    scale 0.25
    translate  <1.17118, 7.04165, 0.31382>
  }
  sphere { // sphere310_312
    <0,0,0>,1
    scale 0.25
    translate  <1.13546, 7.05554, 0.41328>
  }
  sphere { // sphere311_313
    <0,0,0>,1
    scale 0.25
    translate  <1.09134, 7.06943, 0.5089>
  }
  sphere { // sphere312_314
    <0,0,0>,1
    scale 0.25
    translate  <1.03923, 7.08332, 0.6>
  }
  sphere { // sphere313_315
    <0,0,0>,1
    scale 0.25
    translate  <0.97957, 7.09721, 0.6859>
  }
  sphere { // sphere314_316
    <0,0,0>,1
    scale 0.25
    translate  <0.91287, 7.11109, 0.76599>
  }
  sphere { // sphere315_317
    <0,0,0>,1
    scale 0.25
    translate  <0.83969, 7.12498, 0.83969>
  }
  sphere { // sphere316_318
    <0,0,0>,1
    scale 0.25
    translate  <0.76063, 7.13887, 0.90648>
  }
  sphere { // sphere317_319
    <0,0,0>,1
    scale 0.25
    translate  <0.67634, 7.15276, 0.96592>
  }
  sphere { // sphere318_320
    <0,0,0>,1
    scale 0.25
    translate  <0.5875, 7.16665, 1.01758>
  }
  sphere { // sphere319_321
    <0,0,0>,1
    scale 0.25
    translate  <0.49481, 7.18054, 1.06113>
  }
  sphere { // sphere320_322
    <0,0,0>,1
    scale 0.25
    translate  <0.39902, 7.19443, 1.09631>
  }
  sphere { // sphere321_323
    <0,0,0>,1
    scale 0.25
    translate  <0.30087, 7.20832, 1.12289>
  }
  sphere { // sphere322_324
    <0,0,0>,1
    scale 0.25
    translate  <0.20114, 7.22221, 1.14073>
  }
  sphere { // sphere323_325
    <0,0,0>,1
    scale 0.25
    translate  <0.10059, 7.23609, 1.14977>
  }
  sphere { // sphere324_326
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 7.24998, 1.15>
  }
  sphere { // sphere325_327
    <0,0,0>,1
    scale 0.25
    translate  <-0.09987, 7.26387, 1.14147>
  }
  sphere { // sphere326_328
    <0,0,0>,1
    scale 0.25
    translate  <-0.19825, 7.27776, 1.12432>
  }
  sphere { // sphere327_329
    <0,0,0>,1
    scale 0.25
    translate  <-0.29441, 7.29165, 1.09874>
  }
  sphere { // sphere328_330
    <0,0,0>,1
    scale 0.25
    translate  <-0.38762, 7.30554, 1.06498>
  }
  sphere { // sphere329_331
    <0,0,0>,1
    scale 0.25
    translate  <-0.47721, 7.31943, 1.02337>
  }
  sphere { // sphere330_332
    <0,0,0>,1
    scale 0.25
    translate  <-0.5625, 7.33332, 0.97427>
  }
  sphere { // sphere331_333
    <0,0,0>,1
    scale 0.25
    translate  <-0.64288, 7.3472, 0.91813>
  }
  sphere { // sphere332_334
    <0,0,0>,1
    scale 0.25
    translate  <-0.71778, 7.36109, 0.85541>
  }
  sphere { // sphere333_335
    <0,0,0>,1
    scale 0.25
    translate  <-0.78665, 7.37498, 0.78665>
  }
  sphere { // sphere334_336
    <0,0,0>,1
    scale 0.25
    translate  <-0.84903, 7.38887, 0.71242>
  }
  sphere { // sphere335_337
    <0,0,0>,1
    scale 0.25
    translate  <-0.90448, 7.40276, 0.63332>
  }
  sphere { // sphere336_338
    <0,0,0>,1
    scale 0.25
    translate  <-0.95263, 7.41665, 0.55>
  }
  sphere { // sphere337_339
    <0,0,0>,1
    scale 0.25
    translate  <-0.99316, 7.43054, 0.46312>
  }
  sphere { // sphere338_340
    <0,0,0>,1
    scale 0.25
    translate  <-1.02583, 7.44443, 0.37337>
  }
  sphere { // sphere339_341
    <0,0,0>,1
    scale 0.25
    translate  <-1.05044, 7.45832, 0.28146>
  }
  sphere { // sphere340_342
    <0,0,0>,1
    scale 0.25
    translate  <-1.06687, 7.4722, 0.18812>
  }
  sphere { // sphere341_343
    <0,0,0>,1
    scale 0.25
    translate  <-1.07506, 7.48609, 0.09405>
  }
  sphere { // sphere342_344
    <0,0,0>,1
    scale 0.25
    translate  <-1.075, 7.49998, 0.0>
  }
  sphere { // sphere343_345
    <0,0,0>,1
    scale 0.25
    translate  <-1.06675, 7.51387, -0.09333>
  }
  sphere { // sphere344_346
    <0,0,0>,1
    scale 0.25
    translate  <-1.05046, 7.52776, -0.18523>
  }
  sphere { // sphere345_347
    <0,0,0>,1
    scale 0.25
    translate  <-1.02629, 7.54165, -0.275>
  }
  sphere { // sphere346_348
    <0,0,0>,1
    scale 0.25
    translate  <-0.9945, 7.55554, -0.36197>
  }
  sphere { // sphere347_349
    <0,0,0>,1
    scale 0.25
    translate  <-0.95539, 7.56943, -0.44551>
  }
  sphere { // sphere348_350
    <0,0,0>,1
    scale 0.25
    translate  <-0.90932, 7.58331, -0.525>
  }
  sphere { // sphere349_351
    <0,0,0>,1
    scale 0.25
    translate  <-0.85669, 7.5972, -0.59986>
  }
  sphere { // sphere350_352
    <0,0,0>,1
    scale 0.25
    translate  <-0.79796, 7.61109, -0.66957>
  }
  sphere { // sphere351_353
    <0,0,0>,1
    scale 0.25
    translate  <-0.73362, 7.62498, -0.73362>
  }
  sphere { // sphere352_354
    <0,0,0>,1
    scale 0.25
    translate  <-0.66421, 7.63887, -0.79158>
  }
  sphere { // sphere353_355
    <0,0,0>,1
    scale 0.25
    translate  <-0.5903, 7.65276, -0.84304>
  }
  sphere { // sphere354_356
    <0,0,0>,1
    scale 0.25
    translate  <-0.5125, 7.66665, -0.88767>
  }
  sphere { // sphere355_357
    <0,0,0>,1
    scale 0.25
    translate  <-0.43142, 7.68054, -0.92519>
  }
  sphere { // sphere356_358
    <0,0,0>,1
    scale 0.25
    translate  <-0.34772, 7.69443, -0.95535>
  }
  sphere { // sphere357_359
    <0,0,0>,1
    scale 0.25
    translate  <-0.26205, 7.70831, -0.97799>
  }
  sphere { // sphere358_360
    <0,0,0>,1
    scale 0.25
    translate  <-0.17509, 7.7222, -0.99301>
  }
  sphere { // sphere359_361
    <0,0,0>,1
    scale 0.25
    translate  <-0.08752, 7.73609, -1.00034>
  }
  sphere { // sphere360_362
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 7.74998, -0.99999>
  }
  sphere { // sphere360_363
    <0,0,0>,1
    scale 0.25
    translate  <0.0, 7.751157, 0.3>
  }
  cylinder { // SpringEndCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.3>
    translate  <0.0, 7.74998, -1.0>
  }
  cylinder { // SpringEndCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 1.0>
    rotate 90.0*x
    translate  <0.0, 2.75, -2.5>
  }
  texture {
    txtSpringsMGoldMetal
  }
  scale 0.1
  rotate 90.0*x
  translate  4.8*z
}


#declare ScaleTic1 = object {
  cylinder { // ScaleTic1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.025, 0.025, 2.3>
    rotate -30.0*y
    translate  <0.0, -1.65, 1.1>
  }
}
#declare ScaleTic2 = object {
  cylinder { // ScaleTic2
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.015, 0.015, 2.15>
    rotate -30.0*y
    translate  <0.0, -1.65, 1.1>
  }
}
#declare FScaleCSG = difference {
  cylinder { // FScaleCyl
    <0,0,1>, <0,0,0>, 1 
    scale <2.45, 2.45, 0.05>
    rotate 90.0*x
    translate  <0.0, -1.6, 1.1>
  }
  cylinder { // FScaleCylCut
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.2>
    rotate 90.0*x
    translate  <0.0, -1.5, 1.1>
  }
  plane { // FScaleCut
    z,0
    scale 0.4
    rotate <0.0, -45.0, 0.0>
    translate  <1.5, -1.5, 2.6>
  }
  plane { // FScaleCut1
    z,0
    scale 0.4
    rotate <0.0, 45.0, 0.0>
    translate  <-1.5, -1.5, 2.6>
  }
  object { ScaleTic1 }
  object { ScaleTic2 }
  object { // ScaleTic3->ScaleTic2
    ScaleTic2
    rotate <0.0, 3.0, 0.0>
    translate  <-0.05757, 0.0, 0.001508>
  }
  object { // ScaleTic4->ScaleTic2
    ScaleTic2
    rotate <0.0, 6.0, 0.0>
    translate  <-0.114981, 0.0, 0.006026>
  }
  object { // ScaleTic5->ScaleTic2
    ScaleTic2
    rotate <0.0, 9.0, 0.0>
    translate  <-0.172078, 0.0, 0.013543>
  }
  object { // ScaleTic6->ScaleTic2
    ScaleTic2
    rotate <0.0, 12.0, 0.0>
    translate  <-0.228703, 0.0, 0.024038>
  }
  object { // ScaleTic7->ScaleTic2
    ScaleTic2
    rotate <0.0, 15.0, 0.0>
    translate  <-0.284701, 0.0, 0.037482>
  }
  object { // ScaleTic8->ScaleTic2
    ScaleTic2
    rotate <0.0, 18.0, 0.0>
    translate  <-0.339919, 0.0, 0.053838>
  }
  object { // ScaleTic9->ScaleTic2
    ScaleTic2
    rotate <0.0, 21.0, 0.0>
    translate  <-0.394205, 0.0, 0.073062>
  }
  object { // ScaleTic10->ScaleTic2
    ScaleTic2
    rotate <0.0, 24.0, 0.0>
    translate  <-0.44741, 0.0, 0.0951>
  }
  object { // ScaleTic11->ScaleTic2
    ScaleTic2
    rotate <0.0, 27.0, 0.0>
    translate  <-0.49939, 0.0, 0.119893>
  }
  object { // ScaleTic12->ScaleTic2
    ScaleTic2
    rotate <0.0, 30.0, 0.0>
    translate  <-0.55, 0.0, 0.147372>
  }
  object { // ScaleTic13->ScaleTic2
    ScaleTic2
    rotate <0.0, 33.0, 0.0>
    translate  <-0.599103, 0.0, 0.177462>
  }
  object { // ScaleTic14->ScaleTic2
    ScaleTic2
    rotate <0.0, 36.0, 0.0>
    translate  <-0.646564, 0.0, 0.210081>
  }
  object { // ScaleTic15->ScaleTic2
    ScaleTic2
    rotate <0.0, 39.0, 0.0>
    translate  <-0.692252, 0.0, 0.245139>
  }
  object { // ScaleTic16->ScaleTic2
    ScaleTic2
    rotate <0.0, 42.0, 0.0>
    translate  <-0.736044, 0.0, 0.282541>
  }
  object { // ScaleTic17->ScaleTic2
    ScaleTic2
    rotate <0.0, 45.0, 0.0>
    translate  <-0.777817, 0.0, 0.322183>
  }
  object { // ScaleTic18->ScaleTic2
    ScaleTic2
    rotate <0.0, 48.0, 0.0>
    translate  <-0.817459, 0.0, 0.363956>
  }
  object { // ScaleTic19->ScaleTic2
    ScaleTic2
    rotate <0.0, 51.0, 0.0>
    translate  <-0.854861, 0.0, 0.407748>
  }
  object { // ScaleTic20->ScaleTic2
    ScaleTic2
    rotate <0.0, 54.0, 0.0>
    translate  <-0.889919, 0.0, 0.453436>
  }
  object { // ScaleTic21->ScaleTic2
    ScaleTic2
    rotate <0.0, 57.0, 0.0>
    translate  <-0.922538, 0.0, 0.500897>
  }
  object { // ScaleTic22->ScaleTic2
    ScaleTic2
    rotate <0.0, 60.0, 0.0>
    translate  <-0.952628, 0.0, 0.55>
  }
  object { // ScaleTic23->ScaleTic1
    ScaleTic1
    rotate <0.0, 15.0, 0.0>
    translate  <-0.284701, 0.0, 0.037482>
  }
  object { // ScaleTic24->ScaleTic1
    ScaleTic1
    rotate <0.0, 30.0, 0.0>
    translate  <-0.55, 0.0, 0.147372>
  }
  object { // ScaleTic25->ScaleTic1
    ScaleTic1
    rotate <0.0, 45.0, 0.0>
    translate  <-0.777817, 0.0, 0.322183>
  }
  object { // ScaleTic26->ScaleTic1
    ScaleTic1
    rotate <0.0, 60.0, 0.0>
    translate  <-0.952628, 0.0, 0.55>
  }
  texture {
    txtBatteryTopMBlackBumpy
  }
}
#declare FScale = union {
  cylinder { // ScaleSupport1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.05, 0.05, 1.5>
    rotate -30.0*y
    translate  <-0.5, -1.625, 1.45>
  }
  cylinder { // ScaleSupport2
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.05, 0.05, 1.5>
    rotate 30.0*y
    translate  <0.5, -1.625, 1.45>
  }
  object { FScaleCSG }
  cone { // FPointer
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      txtBalancePointersMRedPlastic
    }
    scale <0.2, 0.05, 2.0>
    rotate <180.0, 0.0, -180.0>
    translate  <0.0, -1.4, 3.1>
  }
}


#declare Boob1 = object {
  sphere { // Boob1
    <0,0,0>,1
    texture {
      txtDressMRedDull
    }
    scale <0.3, 0.20608, 0.274164>
    rotate -24.518919*x
    translate  <0.4, 0.838412, -1.578455>
  }
}
#declare EarCSG = difference {
  sphere { // Ear1
    <0,0,0>,1
    scale <0.4, 0.1, 0.4>
    translate  <0.6, 0.0, 1.1>
  }
  sphere { // Ear3
    <0,0,0>,1
    texture {
      txtInnerEarMPinkDull
    }
    scale <0.4, 0.1, 0.4>
    translate  <0.6, 0.133461, 1.1>
  }
  translate  0.122689*y
}




// ********  OBJECTS  *******

union { // Wire3
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000561, 0.002728, 0.052208>, <-0.000561, -0.079475, 0.052208>, <-0.000424, -0.079475, -0.070394>, <-0.000424, 0.002728, -0.070394>, 
      <2.990228, 0.002728, 0.187262>, <2.990228, -0.079475, 0.187262>, <2.925942, -0.079475, 0.082866>, <2.925942, 0.002728, 0.082866>, 
      <2.806143, 0.002728, -0.463799>, <2.806143, -0.079475, -0.463799>, <2.699270, -0.079475, -0.523879>, <2.699270, 0.002728, -0.523879>, 
      <3.126267, -0.036474, -1.930335>, <3.126267, -0.114075, -1.949234>, <3.011774, -0.111560, -1.984129>, <3.011774, -0.033960, -1.965230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000424, 0.002728, -0.070394>, <-0.000424, 0.084931, -0.070394>, <-0.000561, 0.084931, 0.052208>, <-0.000561, 0.002728, 0.052208>, 
      <2.925942, 0.002728, 0.082866>, <2.925942, 0.084931, 0.082866>, <2.990228, 0.084931, 0.187262>, <2.990228, 0.002728, 0.187262>, 
      <2.699270, 0.002728, -0.523879>, <2.699270, 0.084931, -0.523879>, <2.806143, 0.084931, -0.463799>, <2.806143, 0.002728, -0.463799>, 
      <3.011774, -0.033960, -1.965230>, <3.011774, 0.043641, -1.946331>, <3.126267, 0.041126, -1.911436>, <3.126267, -0.036474, -1.930335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.126267, -0.036474, -1.930335>, <3.126267, -0.114075, -1.949234>, <3.011774, -0.111560, -1.984129>, <3.011774, -0.033960, -1.965230>, 
      <3.446390, -0.075676, -3.396871>, <3.446390, -0.148674, -3.434669>, <3.324277, -0.143645, -3.444380>, <3.324277, -0.070648, -3.406582>, 
      <3.457326, 0.829175, -4.313773>, <3.457326, 0.771309, -4.372159>, <3.335212, 0.779077, -4.379857>, <3.335212, 0.836942, -4.321471>, 
      <3.360599, 3.588747, -4.703082>, <3.360599, 3.548581, -4.771812>, <3.238485, 3.557724, -4.777156>, <3.238485, 3.597891, -4.708426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.011774, -0.033960, -1.965230>, <3.011774, 0.043641, -1.946331>, <3.126267, 0.041126, -1.911436>, <3.126267, -0.036474, -1.930335>, 
      <3.324277, -0.070648, -3.406582>, <3.324277, 0.002350, -3.368784>, <3.446390, -0.002678, -3.359073>, <3.446390, -0.075676, -3.396871>, 
      <3.335212, 0.836942, -4.321471>, <3.335212, 0.894808, -4.263085>, <3.457326, 0.887041, -4.255387>, <3.457326, 0.829175, -4.313773>, 
      <3.238485, 3.597891, -4.708426>, <3.238485, 3.638057, -4.639696>, <3.360599, 3.628914, -4.634353>, <3.360599, 3.588747, -4.703082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.360599, 3.588747, -4.703082>, <3.360599, 3.548581, -4.771812>, <3.238485, 3.557724, -4.777156>, <3.238485, 3.597891, -4.708426>, 
      <3.263872, 6.348319, -5.092391>, <3.263872, 6.325852, -5.171465>, <3.141758, 6.336372, -5.174454>, <3.141758, 6.358839, -5.095380>, 
      <-2.706029, 7.493053, -4.930488>, <-2.705945, 7.492955, -5.012691>, <-2.805840, 7.421876, -5.012708>, <-2.805924, 7.421974, -4.930505>, 
      <-2.082968, 10.155393, -4.928057>, <-2.082905, 10.170132, -5.007508>, <-2.192409, 10.121053, -5.012770>, <-2.192472, 10.106314, -4.933320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.238485, 3.597891, -4.708426>, <3.238485, 3.638057, -4.639696>, <3.360599, 3.628914, -4.634353>, <3.360599, 3.588747, -4.703082>, 
      <3.141758, 6.358839, -5.095380>, <3.141758, 6.381306, -5.016307>, <3.263872, 6.370787, -5.013318>, <3.263872, 6.348319, -5.092391>, 
      <-2.805924, 7.421974, -4.930505>, <-2.806008, 7.422072, -4.848302>, <-2.706113, 7.493151, -4.848285>, <-2.706029, 7.493053, -4.930488>, 
      <-2.192472, 10.106314, -4.933320>, <-2.192534, 10.091575, -4.853869>, <-2.083031, 10.140654, -4.848607>, <-2.082968, 10.155393, -4.928057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.082968, 10.155393, -4.928057>, <-2.082905, 10.170132, -5.007508>, <-2.192409, 10.121053, -5.012770>, <-2.192472, 10.106314, -4.933320>, 
      <-1.459907, 12.817734, -4.925627>, <-1.459866, 12.847310, -5.002325>, <-1.578977, 12.820230, -5.012832>, <-1.579019, 12.790653, -4.936134>, 
      <-1.488955, 13.402503, -4.357274>, <-1.488913, 13.479336, -4.386496>, <-1.608025, 13.469067, -4.413668>, <-1.608066, 13.392233, -4.384445>, 
      <-1.518002, 13.182046, -2.184238>, <-1.517961, 13.261558, -2.199559>, <-1.637072, 13.256202, -2.227667>, <-1.637114, 13.176690, -2.212345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.192472, 10.106314, -4.933320>, <-2.192534, 10.091575, -4.853869>, <-2.083031, 10.140654, -4.848607>, <-2.082968, 10.155393, -4.928057>, 
      <-1.579019, 12.790653, -4.936134>, <-1.579061, 12.761077, -4.859436>, <-1.459949, 12.788158, -4.848928>, <-1.459907, 12.817734, -4.925627>, 
      <-1.608066, 13.392233, -4.384445>, <-1.608108, 13.315400, -4.355222>, <-1.488997, 13.325669, -4.328051>, <-1.488955, 13.402503, -4.357274>, 
      <-1.637114, 13.176690, -2.212345>, <-1.637156, 13.097178, -2.197024>, <-1.518044, 13.102533, -2.168916>, <-1.518002, 13.182046, -2.184238>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.518002, 13.182046, -2.184238>, <-1.517961, 13.261558, -2.199559>, <-1.637072, 13.256202, -2.227667>, <-1.637114, 13.176690, -2.212345>, 
      <-1.547050, 12.961588, -0.011202>, <-1.547008, 13.043779, -0.012622>, <-1.666120, 13.043338, -0.041667>, <-1.666161, 12.961147, -0.040246>, 
      <-1.576097, 14.757869, 3.255310>, <-1.576056, 14.840060, 3.253890>, <-1.695167, 14.839618, 3.224845>, <-1.695209, 14.757427, 3.226266>, 
      <-1.090020, 14.054374, 8.316042>, <-1.089782, 14.136564, 8.314655>, <-1.202514, 14.136123, 8.269635>, <-1.202752, 14.053932, 8.271022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.637114, 13.176690, -2.212345>, <-1.637156, 13.097178, -2.197024>, <-1.518044, 13.102533, -2.168916>, <-1.518002, 13.182046, -2.184238>, 
      <-1.666161, 12.961147, -0.040246>, <-1.666203, 12.878956, -0.038825>, <-1.547092, 12.879397, -0.009781>, <-1.547050, 12.961588, -0.011202>, 
      <-1.695209, 14.757427, 3.226266>, <-1.695251, 14.675236, 3.227687>, <-1.576139, 14.675678, 3.256731>, <-1.576097, 14.757869, 3.255310>, 
      <-1.202752, 14.053932, 8.271022>, <-1.202990, 13.971741, 8.272409>, <-1.090259, 13.972183, 8.317429>, <-1.090020, 14.054374, 8.316042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.090020, 14.054374, 8.316042>, <-1.089782, 14.136564, 8.314655>, <-1.202514, 14.136123, 8.269635>, <-1.202752, 14.053932, 8.271022>, 
      <-0.603943, 13.350878, 13.376773>, <-0.603508, 13.433069, 13.375420>, <-0.709860, 13.432627, 13.314424>, <-0.710295, 13.350437, 13.315777>, 
      <-4.731957, 13.320132, 13.642741>, <-4.762750, 13.396229, 13.638439>, <-4.810621, 13.370642, 13.528507>, <-4.779828, 13.294546, 13.532809>, 
      <-5.147932, 13.133824, 13.671600>, <-5.371666, 13.191835, 13.655157>, <-5.404038, 13.149957, 13.546892>, <-5.352268, 13.093283, 13.553451>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.202752, 14.053932, 8.271022>, <-1.202990, 13.971741, 8.272409>, <-1.090259, 13.972183, 8.317429>, <-1.090020, 14.054374, 8.316042>, 
      <-0.710295, 13.350437, 13.315777>, <-0.710730, 13.268246, 13.317131>, <-0.604378, 13.268687, 13.378126>, <-0.603943, 13.350878, 13.376773>, 
      <-4.779828, 13.294546, 13.532809>, <-4.749035, 13.218449, 13.537112>, <-4.701164, 13.244036, 13.647043>, <-4.731957, 13.320132, 13.642741>, 
      <-5.352268, 13.093283, 13.553451>, <-5.300499, 13.036608, 13.560009>, <-4.924198, 13.075813, 13.688043>, <-5.147932, 13.133824, 13.671600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.147932, 13.133824, 13.671600>, <-5.371666, 13.191835, 13.655157>, <-5.404038, 13.149957, 13.546892>, <-5.352268, 13.093283, 13.553451>, 
      <-5.563907, 12.947515, 13.700459>, <-5.980583, 12.987441, 13.671875>, <-5.997454, 12.929272, 13.565278>, <-5.924709, 12.892019, 13.574092>, 
      <-7.590320, 12.017324, 13.710215>, <-7.670353, 12.030707, 13.697063>, <-7.670598, 11.944028, 13.610357>, <-7.590565, 11.930645, 13.623509>, 
      <-7.423024, 9.467943, 14.318116>, <-7.504518, 9.461174, 14.309728>, <-7.488555, 9.374092, 14.224915>, <-7.407062, 9.380861, 14.233303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.352268, 13.093283, 13.553451>, <-5.300499, 13.036608, 13.560009>, <-4.924198, 13.075813, 13.688043>, <-5.147932, 13.133824, 13.671600>, 
      <-5.924709, 12.892019, 13.574092>, <-5.851963, 12.854767, 13.582906>, <-5.147231, 12.907589, 13.729044>, <-5.563907, 12.947515, 13.700459>, 
      <-7.590565, 11.930645, 13.623509>, <-7.510532, 11.917261, 13.636662>, <-7.510287, 12.003941, 13.723368>, <-7.590320, 12.017324, 13.710215>, 
      <-7.407062, 9.380861, 14.233303>, <-7.325568, 9.387629, 14.241691>, <-7.341530, 9.474711, 14.326505>, <-7.423024, 9.467943, 14.318116>
    }
  }
  texture {
    txtWireMRedDull
  }
  translate  <10.611897, -5.501053, 5.236221>
}


union { // Wire2
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000739, -0.002358, 0.060199>, <0.000739, -0.085413, 0.060199>, <0.000745, -0.085413, -0.060198>, <0.000745, -0.002358, -0.060198>, 
      <2.088774, -0.191591, 0.060205>, <2.113561, -0.270860, 0.060205>, <2.113567, -0.270858, -0.060192>, <2.088780, -0.191589, -0.060192>, 
      <3.683764, 1.327777, 0.060211>, <3.752053, 1.280504, 0.060211>, <3.752056, 1.280509, -0.060186>, <3.683768, 1.327782, -0.060186>, 
      <3.533257, 2.976375, 0.060217>, <3.601545, 2.929102, 0.060217>, <3.601549, 2.929107, -0.060180>, <3.533260, 2.976380, -0.060180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000745, -0.002358, -0.060198>, <0.000745, 0.080696, -0.060198>, <0.000739, 0.080696, 0.060199>, <0.000739, -0.002358, 0.060199>, 
      <2.088780, -0.191589, -0.060192>, <2.063992, -0.112319, -0.060192>, <2.063986, -0.112321, 0.060205>, <2.088774, -0.191591, 0.060205>, 
      <3.683768, 1.327782, -0.060186>, <3.615479, 1.375055, -0.060186>, <3.615476, 1.375050, 0.060211>, <3.683764, 1.327777, 0.060211>, 
      <3.533260, 2.976380, -0.060180>, <3.464972, 3.023653, -0.060180>, <3.464968, 3.023648, 0.060217>, <3.533257, 2.976375, 0.060217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.533257, 2.976375, 0.060217>, <3.601545, 2.929102, 0.060217>, <3.601549, 2.929107, -0.060180>, <3.533260, 2.976380, -0.060180>, 
      <3.382749, 4.624973, 0.060223>, <3.451038, 4.577699, 0.060223>, <3.451041, 4.577705, -0.060174>, <3.382753, 4.624978, -0.060174>, 
      <7.098162, 3.601192, 0.060229>, <7.179425, 3.584033, 0.060229>, <7.179426, 3.584039, -0.060168>, <7.098164, 3.601198, -0.060168>, 
      <7.472276, 8.755774, 0.060235>, <7.547345, 8.770401, 0.060235>, <7.547344, 8.770407, -0.060162>, <7.472275, 8.755779, -0.060162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.533260, 2.976380, -0.060180>, <3.464972, 3.023653, -0.060180>, <3.464968, 3.023648, 0.060217>, <3.533257, 2.976375, 0.060217>, 
      <3.382753, 4.624978, -0.060174>, <3.314464, 4.672251, -0.060174>, <3.314461, 4.672246, 0.060223>, <3.382749, 4.624973, 0.060223>, 
      <7.098164, 3.601198, -0.060168>, <7.016901, 3.618357, -0.060168>, <7.016900, 3.618351, 0.060229>, <7.098162, 3.601192, 0.060229>, 
      <7.472275, 8.755779, -0.060162>, <7.397206, 8.741152, -0.060162>, <7.397207, 8.741146, 0.060235>, <7.472276, 8.755774, 0.060235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.472276, 8.755774, 0.060235>, <7.547345, 8.770401, 0.060235>, <7.547344, 8.770407, -0.060162>, <7.472275, 8.755779, -0.060162>, 
      <7.846390, 13.910355, 0.060242>, <7.915265, 13.956769, 0.060242>, <7.915262, 13.956774, -0.060155>, <7.846386, 13.910360, -0.060155>, 
      <5.637526, 14.758950, 0.070506>, <5.720538, 14.761372, 0.071613>, <5.720537, 14.811425, -0.037886>, <5.637526, 14.809002, -0.038993>, 
      <5.633665, 15.139919, 0.363215>, <5.716676, 15.141404, 0.365072>, <5.716676, 15.225348, 0.297971>, <5.633664, 15.223863, 0.296114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.472275, 8.755779, -0.060162>, <7.397206, 8.741152, -0.060162>, <7.397207, 8.741146, 0.060235>, <7.472276, 8.755774, 0.060235>, 
      <7.846386, 13.910360, -0.060155>, <7.777511, 13.863947, -0.060155>, <7.777514, 13.863942, 0.060242>, <7.846390, 13.910355, 0.060242>, 
      <5.637526, 14.809002, -0.038993>, <5.554514, 14.806580, -0.040101>, <5.554514, 14.756527, 0.069399>, <5.637526, 14.758950, 0.070506>, 
      <5.633664, 15.223863, 0.296114>, <5.550652, 15.222379, 0.294257>, <5.550653, 15.138435, 0.361358>, <5.633665, 15.139919, 0.363215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.633665, 15.139919, 0.363215>, <5.716676, 15.141404, 0.365072>, <5.716676, 15.225348, 0.297971>, <5.633664, 15.223863, 0.296114>, 
      <5.629803, 15.520888, 0.655924>, <5.712815, 15.521435, 0.658531>, <5.712815, 15.639271, 0.633827>, <5.629803, 15.638724, 0.631221>, 
      <5.625942, 15.767563, 1.943734>, <5.708954, 15.767648, 1.946387>, <5.708954, 15.877891, 1.938875>, <5.625942, 15.877806, 1.936222>, 
      <4.723902, 15.175722, 5.118914>, <4.806914, 15.175806, 5.121567>, <4.806914, 15.286049, 5.114055>, <4.723902, 15.285965, 5.111402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.633664, 15.223863, 0.296114>, <5.550652, 15.222379, 0.294257>, <5.550653, 15.138435, 0.361358>, <5.633665, 15.139919, 0.363215>, 
      <5.629803, 15.638724, 0.631221>, <5.546791, 15.638177, 0.628614>, <5.546792, 15.520342, 0.653317>, <5.629803, 15.520888, 0.655924>, 
      <5.625942, 15.877806, 1.936222>, <5.542930, 15.877722, 1.933569>, <5.542930, 15.767478, 1.941081>, <5.625942, 15.767563, 1.943734>, 
      <4.723902, 15.285965, 5.111402>, <4.640890, 15.285880, 5.108749>, <4.640891, 15.175637, 5.116261>, <4.723902, 15.175722, 5.118914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.723902, 15.175722, 5.118914>, <4.806914, 15.175806, 5.121567>, <4.806914, 15.286049, 5.114055>, <4.723902, 15.285965, 5.111402>, 
      <3.821863, 14.583880, 8.294095>, <3.904875, 14.583965, 8.296748>, <3.904874, 14.694208, 8.289235>, <3.821862, 14.694123, 8.286583>, 
      <5.614359, 15.798667, 14.456499>, <5.697371, 15.798751, 14.459152>, <5.697371, 15.908994, 14.451640>, <5.614359, 15.908910, 14.448987>, 
      <5.285030, 15.672744, 16.246603>, <5.349287, 15.672828, 16.282671>, <5.352362, 15.783071, 16.276757>, <5.288105, 15.782987, 16.240690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.723902, 15.285965, 5.111402>, <4.640890, 15.285880, 5.108749>, <4.640891, 15.175637, 5.116261>, <4.723902, 15.175722, 5.118914>, 
      <3.821862, 14.694123, 8.286583>, <3.738851, 14.694038, 8.283930>, <3.738851, 14.583795, 8.291442>, <3.821863, 14.583880, 8.294095>, 
      <5.614359, 15.908910, 14.448987>, <5.531347, 15.908825, 14.446334>, <5.531347, 15.798582, 14.453846>, <5.614359, 15.798667, 14.456499>, 
      <5.288105, 15.782987, 16.240690>, <5.223849, 15.782902, 16.204623>, <5.220774, 15.672659, 16.210536>, <5.285030, 15.672744, 16.246603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.285030, 15.672744, 16.246603>, <5.349287, 15.672828, 16.282671>, <5.352362, 15.783071, 16.276757>, <5.288105, 15.782987, 16.240690>, 
      <4.955702, 15.546821, 18.036707>, <5.001203, 15.546905, 18.106189>, <5.007353, 15.657148, 18.101874>, <4.961851, 15.657064, 18.032393>, 
      <3.025669, 15.485473, 18.787936>, <3.029548, 15.488832, 18.870832>, <2.964503, 15.578155, 18.870129>, <2.960624, 15.574796, 18.787233>, 
      <2.848230, 15.266985, 18.795313>, <2.850586, 15.271196, 18.878209>, <2.764500, 15.329397, 18.877505>, <2.762144, 15.325186, 18.794610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.288105, 15.782987, 16.240690>, <5.223849, 15.782902, 16.204623>, <5.220774, 15.672659, 16.210536>, <5.285030, 15.672744, 16.246603>, 
      <4.961851, 15.657064, 18.032393>, <4.916350, 15.656979, 17.962912>, <4.910201, 15.546736, 17.967226>, <4.955702, 15.546821, 18.036707>, 
      <2.960624, 15.574796, 18.787233>, <2.956745, 15.571437, 18.704337>, <3.021790, 15.482114, 18.705041>, <3.025669, 15.485473, 18.787936>, 
      <2.762144, 15.325186, 18.794610>, <2.759787, 15.320976, 18.711714>, <2.845873, 15.262775, 18.712417>, <2.848230, 15.266985, 18.795313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.848230, 15.266985, 18.795313>, <2.850586, 15.271196, 18.878209>, <2.764500, 15.329397, 18.877505>, <2.762144, 15.325186, 18.794610>, 
      <2.670790, 15.048498, 18.802690>, <2.671625, 15.053560, 18.885585>, <2.564498, 15.080639, 18.884882>, <2.563663, 15.075577, 18.801986>, 
      <2.194547, 13.498606, 18.810066>, <2.195381, 13.503668, 18.892962>, <2.088254, 13.530747, 18.892258>, <2.087420, 13.525684, 18.809363>, 
      <2.300186, 12.258436, 18.817443>, <2.299716, 12.263545, 18.900338>, <2.189223, 12.262724, 18.899635>, <2.189692, 12.257615, 18.816739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.762144, 15.325186, 18.794610>, <2.759787, 15.320976, 18.711714>, <2.845873, 15.262775, 18.712417>, <2.848230, 15.266985, 18.795313>, 
      <2.563663, 15.075577, 18.801986>, <2.562829, 15.070514, 18.719090>, <2.669956, 15.043435, 18.719794>, <2.670790, 15.048498, 18.802690>, 
      <2.087420, 13.525684, 18.809363>, <2.086585, 13.520622, 18.726467>, <2.193712, 13.493543, 18.727170>, <2.194547, 13.498606, 18.810066>, 
      <2.189692, 12.257615, 18.816739>, <2.190162, 12.252506, 18.733844>, <2.300656, 12.253326, 18.734547>, <2.300186, 12.258436, 18.817443>
    }
  }
  texture {
    txtWireMRedDull
  }
  translate  <2.607353, -8.170043, 0.549718>
}


union { // PennyGrp2
  object { // Penny7->Penny1
    Penny1
    rotate <0.0, 0.0, -81.754875>
    translate  <-4.006562, -3.004009, -6.0>
  }
  object { // Penny8->Penny1
    Penny1
    rotate <7.353846, -13.760517, -3.809615>
    translate  <-4.800521, -2.494652, -5.893097>
  }
  object { // Penny9->Penny1
    Penny1
    rotate <0.0, 0.0, 124.687675>
    translate  <-4.202792, -2.942315, -6.1>
  }
  rotate 73.522781*z
  translate  <4.830145, 4.470686, 12.2>
}


union { // PennyGrp1
  object { Penny1 }
  object { // Penny2->Penny1
    Penny1
    rotate <0.0, 0.0, 35.333313>
    translate  <0.097441, 0.087697, 0.1>
  }
  object { // Penny3->Penny1
    Penny1
    rotate <0.0, 0.0, 175.9422>
    translate  <0.077953, -0.116929, 0.2>
  }
  object { // Penny4->Penny1
    Penny1
    rotate <0.0, 0.0, 0.0>
    translate  <-0.097441, -0.102313, 0.3>
  }
  object { // Penny5->Penny1
    Penny1
    rotate <0.0, 0.0, 139.980713>
    translate  <-0.097441, -0.073081, 0.4>
  }
  object { // Penny6->Penny1
    Penny1
    rotate <0.0, 0.0, -28.058136>
    translate  <-0.02436, 0.068208, 0.5>
  }
  translate  <4.809454, 0.846612, 6.1>
}


union { // Wire1
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.003314, -0.004222, 0.067873>, <-0.040466, -0.075057, 0.067873>, <-0.039618, -0.075502, -0.053836>, <-0.002465, -0.004666, -0.053836>, 
      <0.847895, -0.387134, 0.068831>, <0.810742, -0.457970, 0.068831>, <0.811591, -0.458415, -0.052878>, <0.848743, -0.387579, -0.052878>, 
      <0.912909, -0.457288, 0.013361>, <0.905593, -0.514039, 0.069252>, <0.786434, -0.521858, 0.045716>, <0.793750, -0.465106, -0.010175>, 
      <0.941134, -0.509038, -0.586837>, <0.933819, -0.577181, -0.556719>, <0.814660, -0.576233, -0.579897>, <0.821975, -0.508090, -0.610014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002465, -0.004666, -0.053836>, <0.034687, 0.066170, -0.053835>, <0.033839, 0.066614, 0.067873>, <-0.003314, -0.004222, 0.067873>, 
      <0.848743, -0.387579, -0.052878>, <0.885896, -0.316743, -0.052877>, <0.885047, -0.316299, 0.068831>, <0.847895, -0.387134, 0.068831>, 
      <0.793750, -0.465106, -0.010175>, <0.801066, -0.408355, -0.066065>, <0.920225, -0.400536, -0.042529>, <0.912909, -0.457288, 0.013361>, 
      <0.821975, -0.508090, -0.610014>, <0.829291, -0.439948, -0.640132>, <0.948450, -0.440896, -0.616954>, <0.941134, -0.509038, -0.586837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.941134, -0.509038, -0.586837>, <0.933819, -0.577181, -0.556719>, <0.814660, -0.576233, -0.579897>, <0.821975, -0.508090, -0.610014>, 
      <0.969360, -0.560789, -1.187034>, <0.962044, -0.640323, -1.182690>, <0.842885, -0.630609, -1.205509>, <0.850201, -0.551075, -1.209853>, 
      <1.030860, -0.621093, -4.474275>, <1.023544, -0.700627, -4.469931>, <0.904385, -0.690912, -4.492750>, <0.911701, -0.611379, -4.497094>, 
      <0.963791, -0.759734, -4.690995>, <0.991079, -0.815629, -4.708362>, <0.930214, -0.858679, -4.682264>, <0.902927, -0.802784, -4.664897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.821975, -0.508090, -0.610014>, <0.829291, -0.439948, -0.640132>, <0.948450, -0.440896, -0.616954>, <0.941134, -0.509038, -0.586837>, 
      <0.850201, -0.551075, -1.209853>, <0.857516, -0.471541, -1.214198>, <0.976675, -0.481255, -1.191379>, <0.969360, -0.560789, -1.187034>, 
      <0.911701, -0.611379, -4.497094>, <0.919017, -0.531845, -4.501439>, <1.038176, -0.541559, -4.478620>, <1.030860, -0.621093, -4.474275>, 
      <0.902927, -0.802784, -4.664897>, <0.875639, -0.746889, -4.647530>, <0.936504, -0.703840, -4.673628>, <0.963791, -0.759734, -4.690995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.963791, -0.759734, -4.690995>, <0.991079, -0.815629, -4.708362>, <0.930214, -0.858679, -4.682264>, <0.902927, -0.802784, -4.664897>, 
      <0.896722, -0.898376, -4.907714>, <0.958613, -0.930631, -4.946793>, <0.956043, -1.026445, -4.871778>, <0.894152, -0.994189, -4.832700>, 
      <0.591744, -1.266200, -4.960493>, <0.606704, -1.306072, -5.028202>, <0.612448, -1.410275, -4.965570>, <0.597488, -1.370403, -4.897862>, 
      <-0.766468, -1.090161, -4.790393>, <-0.754693, -1.130953, -4.858101>, <-0.757071, -1.234970, -4.795470>, <-0.768846, -1.194178, -4.727761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.902927, -0.802784, -4.664897>, <0.875639, -0.746889, -4.647530>, <0.936504, -0.703840, -4.673628>, <0.963791, -0.759734, -4.690995>, 
      <0.894152, -0.994189, -4.832700>, <0.832261, -0.961933, -4.793621>, <0.834832, -0.866120, -4.868636>, <0.896722, -0.898376, -4.907714>, 
      <0.597488, -1.370403, -4.897862>, <0.582528, -1.330531, -4.830153>, <0.576784, -1.226328, -4.892785>, <0.591744, -1.266200, -4.960493>, 
      <-0.768846, -1.194178, -4.727761>, <-0.780621, -1.153387, -4.660053>, <-0.778243, -1.049370, -4.722684>, <-0.766468, -1.090161, -4.790393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.766468, -1.090161, -4.790393>, <-0.754693, -1.130953, -4.858101>, <-0.757071, -1.234970, -4.795470>, <-0.768846, -1.194178, -4.727761>, 
      <-2.124679, -0.914123, -4.620292>, <-2.116090, -0.955833, -4.688001>, <-2.126591, -1.059665, -4.625369>, <-2.135180, -1.017954, -4.557660>, 
      <-3.498894, -1.390053, -4.525926>, <-3.490304, -1.431764, -4.593635>, <-3.500805, -1.535595, -4.531003>, <-3.509395, -1.493885, -4.463295>, 
      <-4.249733, -1.949386, -4.785841>, <-4.228339, -1.991097, -4.853549>, <-4.238840, -2.094928, -4.790917>, <-4.260234, -2.053217, -4.723209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.768846, -1.194178, -4.727761>, <-0.780621, -1.153387, -4.660053>, <-0.778243, -1.049370, -4.722684>, <-0.766468, -1.090161, -4.790393>, 
      <-2.135180, -1.017954, -4.557660>, <-2.143770, -0.976243, -4.489952>, <-2.133269, -0.872412, -4.552584>, <-2.124679, -0.914123, -4.620292>, 
      <-3.509395, -1.493885, -4.463295>, <-3.517984, -1.452174, -4.395586>, <-3.507483, -1.348342, -4.458218>, <-3.498894, -1.390053, -4.525926>, 
      <-4.260234, -2.053217, -4.723209>, <-4.256019, -2.011507, -4.655500>, <-4.245518, -1.907675, -4.718132>, <-4.249733, -1.949386, -4.785841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.249733, -1.949386, -4.785841>, <-4.228339, -1.991097, -4.853549>, <-4.238840, -2.094928, -4.790917>, <-4.260234, -2.053217, -4.723209>, 
      <-4.974963, -2.508719, -5.045755>, <-4.966373, -2.550429, -5.113463>, <-4.976874, -2.654261, -5.050832>, <-4.985463, -2.612550, -4.983123>, 
      <-7.010462, -1.959013, -4.908725>, <-7.001873, -2.000723, -4.976433>, <-7.012374, -2.104555, -4.913802>, <-7.020963, -2.062844, -4.846093>, 
      <-8.558659, -1.944477, -4.759453>, <-8.550069, -1.986188, -4.827161>, <-8.560570, -2.090019, -4.764529>, <-8.569160, -2.048308, -4.696821>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.260234, -2.053217, -4.723209>, <-4.256019, -2.011507, -4.655500>, <-4.245518, -1.907675, -4.718132>, <-4.249733, -1.949386, -4.785841>, 
      <-4.985463, -2.612550, -4.983123>, <-4.994053, -2.570839, -4.915415>, <-4.983552, -2.467008, -4.978046>, <-4.974963, -2.508719, -5.045755>, 
      <-7.020963, -2.062844, -4.846093>, <-7.029553, -2.021133, -4.778385>, <-7.019052, -1.917302, -4.841016>, <-7.010462, -1.959013, -4.908725>, 
      <-8.569160, -2.048308, -4.696821>, <-8.577749, -2.006598, -4.629112>, <-8.567248, -1.902766, -4.691744>, <-8.558659, -1.944477, -4.759453>
    }
  }
  texture {
    txtWireMRedDull
  }
  translate  <10.912263, -7.039073, 5.27303>
}


union { // Carpet
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.089021, 8.585322, 0.000000>, <-3.091364, 5.694670, 0.000000>, <-3.007032, 2.645547, 0.000000>, <-2.520145, 1.315453, 0.000000>, 
      <-1.849024, 8.582417, 0.000000>, <-1.851368, 5.691764, 0.000000>, <-1.795952, 2.911792, 0.000000>, <-1.455953, 1.865754, 0.000000>, 
      <-0.609027, 8.579511, 0.000000>, <-0.611371, 5.688858, 0.000000>, <-0.584873, 3.178037, 0.000000>, <-0.391761, 2.416055, 0.000000>, 
      <0.630969, 8.576605, 0.000000>, <0.628626, 5.685953, 0.000000>, <0.626207, 3.444281, 0.000000>, <0.672431, 2.966356, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.520145, 1.315453, 0.000000>, <-2.033258, -0.014642, 0.000000>, <-0.145736, -1.473632, 0.000000>, <0.927132, -1.666816, 0.000000>, 
      <-1.455953, 1.865754, 0.000000>, <-1.115954, 0.819716, 0.000000>, <0.304581, -0.318290, 0.000000>, <1.152290, -0.469145, 0.000000>, 
      <-0.391761, 2.416055, 0.000000>, <-0.198649, 1.654073, 0.000000>, <0.754897, 0.837052, 0.000000>, <1.377449, 0.728526, 0.000000>, 
      <0.672431, 2.966356, 0.000000>, <0.718655, 2.488430, 0.000000>, <1.205214, 1.992394, 0.000000>, <1.602607, 1.926197, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.927132, -1.666816, 0.000000>, <2.000000, -1.860000, 0.000000>, <3.000000, -1.860000, 0.000000>, <4.000000, -1.860000, 0.000000>, 
      <1.152290, -0.469145, 0.000000>, <2.000000, -0.620000, 0.000000>, <3.000000, -0.620000, 0.000000>, <4.000000, -0.620000, 0.000000>, 
      <1.377449, 0.728526, 0.000000>, <2.000000, 0.620000, 0.000000>, <3.000000, 0.620000, 0.000000>, <4.000000, 0.620000, 0.000000>, 
      <1.602607, 1.926197, 0.000000>, <2.000000, 1.860000, 0.000000>, <3.000000, 1.860000, 0.000000>, <4.000000, 1.860000, 0.000000>
    }
  }
  texture {
    txtRedCarpetMRedBumpy
  }
  translate  <-21.0, -0.2, 0.01>
}


union { // StairCarpet
  box { // Stair7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 0.5>
    translate  <0.5, 0.0, 0.5>
  }
  box { // Stair8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 1.0>
    translate  <1.5, 0.0, 1.0>
  }
  box { // Stair9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 1.5>
    translate  <2.5, 0.0, 1.5>
  }
  box { // Stair10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 2.0>
    translate  <3.5, 0.0, 2.0>
  }
  box { // Stair11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 2.5>
    translate  <4.5, 0.0, 2.5>
  }
  box { // Stair12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 3.1, 3.0>
    translate  <5.8, 0.0, 3.0>
  }
  texture {
    txtRedCarpetMRedBumpy
    scale <7.0, 7.0, 3.0>
    rotate <0.0, 90.0, 0.0>
  translate <3.800000, 0.000000, -3.000000>
  }
  scale <1.0, 0.6, 1.0>
  translate  <-17.01, -0.2, 0.01>
}


union { // Stairs
  box { // Stair1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 0.5>
    translate  <0.5, 0.0, 0.5>
  }
  box { // Stair2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 1.0>
    translate  <1.5, 0.0, 1.0>
  }
  box { // Stair3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 1.5>
    translate  <2.5, 0.0, 1.5>
  }
  box { // Stair4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 2.0>
    translate  <3.5, 0.0, 2.0>
  }
  box { // Stair5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.1, 2.5>
    translate  <4.5, 0.0, 2.5>
  }
  box { // Stair6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.1, 3.0>
    translate  <6.0, 0.0, 3.0>
  }
  texture {
    txtStairsMWood8
    scale <12.0, 12.0, 3.0>
    rotate <0.0, 90.0, 0.0>
  translate <3.800000, 0.000000, -3.000000>
  }
  translate  <-17.0, -0.2, 0.0>
}


box { // Slab
  <-1, -1, -1>, <1, 1, 1>
  texture {
    txtSlabCementMGreyBumpy
  }
  scale <21.9, 15.8, 1.0>
  translate  <-22.0, 25.55, -0.99>
}


union { // MarbleRamp
  box { // PlatSupport6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <3.000000, 0.600000, 0.200000>
    }
    scale <0.6, 1.0, 3.1>
    translate  3.1*z
  }
  box { // PlatSupport7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <-2.600000, -1.500000, 0.200000>
    }
    scale <0.6, 1.0, 0.8>
    translate  <-3.4, 0.0, 0.8>
  }
  box { // PlatSupport8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <20.0, 10.0, 0.5>
  translate <3.000000, 0.600000, 0.200000>
    }
    scale <0.1, 1.0, 2.9>
    rotate 40.0*y
    translate  <-2.3, 0.0, 3.8>
  }
  box { // PlatSupport9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <20.0, 20.0, 0.5>
  translate <3.000000, 0.600000, 0.200000>
    }
    scale <0.1, 0.1, 2.5>
    rotate 40.0*y
    translate  <-2.4, -0.8, 3.9>
  }
  box { // PlatSupport10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <20.0, 20.0, 0.5>
  translate <3.000000, 0.600000, 0.200000>
    }
    scale <0.1, 0.1, 2.5>
    rotate 40.0*y
    translate  <-2.4, 0.8, 3.9>
  }
  sphere { // Marble
    <0,0,0>,1
    texture {
      txtMarbleMRedMarble
    }
    scale 1.3
    translate  7.5*z
  }
  object { Nail20 }
  object { // Nail21->Nail20
    Nail20
    rotate <0.0, 0.0, 0.0>
    translate  <0.102709, 0.993638, 0.106095>
  }
  object { // Nail22->Nail20
    Nail20
    rotate <0.0, 0.0, 0.0>
    translate  <3.149343, 0.0, 3.752409>
  }
  object { // Nail23->Nail20
    Nail20
    rotate <0.0, 0.0, 0.0>
    translate  <3.1001, 0.932302, 3.69657>
  }
  rotate 60.0*z
  translate  <4.4, -3.7, 0.0>
}


#declare Cage = union {
  object { CageWire1 }
  torus { // CageRing
    0.3, 0.075  rotate -x*90
    rotate <45.0, -90.0, 0.0>
    translate  4.7*z
  }
  object { CageMainRing1 }
  object { // CageMainRing2->CageMainRing1
    CageMainRing1
    translate  -1.666667*z
  }
  object { // CageMainRing3->CageMainRing1
    CageMainRing1
    translate  -3.333333*z
  }
  object { // CageMainRing4->CageMainRing1
    CageMainRing1
    translate  -4.95*z
  }
  object { // CageMainRing5->CageMainRing1
    CageMainRing1
    scale 0.869524
    translate  2.15*z
  }
  object { // CageMainRing6->CageMainRing1
    CageMainRing1
    scale 0.502327
    translate  3.75*z
  }
  object { // CageWire2->CageWire1
    CageWire1
    rotate -12.0*z
  }
  object { // CageWire3->CageWire1
    CageWire1
    rotate -24.0*z
  }
  object { // CageWire4->CageWire1
    CageWire1
    rotate -36.0*z
  }
  object { // CageWire5->CageWire1
    CageWire1
    rotate -48.0*z
  }
  object { // CageWire6->CageWire1
    CageWire1
    rotate -60.0*z
  }
  object { // CageWire7->CageWire1
    CageWire1
    rotate -72.0*z
  }
  object { // CageWire8->CageWire1
    CageWire1
    rotate -84.0*z
  }
  object { // CageWire9->CageWire1
    CageWire1
    rotate -96.0*z
  }
  object { // CageWire10->CageWire1
    CageWire1
    rotate -108.0*z
  }
  object { // CageWire11->CageWire1
    CageWire1
    rotate -120.0*z
  }
  object { // CageWire12->CageWire1
    CageWire1
    rotate -132.0*z
  }
  object { // CageWire13->CageWire1
    CageWire1
    rotate -144.0*z
  }
  object { // CageWire14->CageWire1
    CageWire1
    rotate -156.0*z
  }
  object { // CageWire15->CageWire1
    CageWire1
    rotate -168.0*z
  }
  object { // CageWire16->CageWire1
    CageWire1
    rotate 180.0*z
  }
  object { // CageWire17->CageWire1
    CageWire1
    rotate 168.0*z
  }
  object { // CageWire18->CageWire1
    CageWire1
    rotate 156.0*z
  }
  object { // CageWire19->CageWire1
    CageWire1
    rotate 144.0*z
  }
  object { // CageWire20->CageWire1
    CageWire1
    rotate 132.0*z
  }
  object { // CageWire21->CageWire1
    CageWire1
    rotate 120.0*z
  }
  object { // CageWire22->CageWire1
    CageWire1
    rotate 108.0*z
  }
  object { // CageWire23->CageWire1
    CageWire1
    rotate 96.0*z
  }
  object { // CageWire24->CageWire1
    CageWire1
    rotate 84.0*z
  }
  object { // CageWire25->CageWire1
    CageWire1
    rotate 72.0*z
  }
  object { // CageWire26->CageWire1
    CageWire1
    rotate 60.0*z
  }
  object { // CageWire27->CageWire1
    CageWire1
    rotate 48.0*z
  }
  object { // CageWire28->CageWire1
    CageWire1
    rotate 36.0*z
  }
  object { // CageWire29->CageWire1
    CageWire1
    rotate 24.0*z
  }
  object { // CageWire30->CageWire1
    CageWire1
    rotate 12.0*z
  }
  object { // CageWire31->CageWire1
    CageWire1
    rotate 0.0*z
  }
  object { ScissorStrng15 }
  object { // ScissorStrng16->ScissorStrng15
    ScissorStrng15
    rotate <0.0, 0.0, 0.0>
    translate  <0.104226, -0.105299, 0.015287>
  }
  object { // ScissorStrng17->ScissorStrng15
    ScissorStrng15
    rotate <0.0, 0.0, 0.0>
    translate  <0.210347, -0.209883, -0.045959>
  }
  cylinder { // ScissorString1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtStringMDullWhite
    }
    scale <0.075, 0.075, 5.60616>
    rotate 180.0*x
    translate  <0.039609, 0.178338, 10.570334>
  }
  texture {
    txtCageMGoldMetal
  }
  scale <0.676118, 0.676118, 0.5>
  translate  <-6.2, 0.0, 14.147374>
}
#declare LHookBzr4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050000, 0.000000, 0.000000>, <-0.050000, -0.068054, 0.000000>, <0.050000, -0.068054, 0.000000>, <0.050000, 0.000000, 0.000000>, 
      <-0.050125, 0.000347, 0.141529>, <-0.050125, -0.067358, 0.141529>, <0.036234, -0.067358, 0.091353>, <0.036234, 0.000347, 0.091353>, 
      <0.103097, 0.000347, 0.143837>, <0.103097, -0.067358, 0.143837>, <0.188116, -0.067358, 0.091190>, <0.188116, 0.000347, 0.091190>, 
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050000, 0.000000, 0.000000>, <0.050000, 0.068054, 0.000000>, <-0.050000, 0.068054, 0.000000>, <-0.050000, 0.000000, 0.000000>, 
      <0.036234, 0.000347, 0.091353>, <0.036234, 0.068053, 0.091353>, <-0.050125, 0.068053, 0.141529>, <-0.050125, 0.000347, 0.141529>, 
      <0.188116, 0.000347, 0.091190>, <0.188116, 0.068053, 0.091190>, <0.103097, 0.068053, 0.143837>, <0.103097, 0.000347, 0.143837>, 
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>, 
      <0.105634, 0.000347, 0.289707>, <0.105634, -0.067358, 0.289707>, <0.200949, -0.067358, 0.319960>, <0.200949, 0.000347, 0.319960>, 
      <0.057180, 0.000347, 0.319684>, <0.057180, -0.067358, 0.319684>, <0.077267, -0.067358, 0.417646>, <0.077267, 0.000347, 0.417646>, 
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>, 
      <0.200949, 0.000347, 0.319960>, <0.200949, 0.068053, 0.319960>, <0.105634, 0.068053, 0.289707>, <0.105634, 0.000347, 0.289707>, 
      <0.077267, 0.000347, 0.417646>, <0.077267, 0.068053, 0.417646>, <0.057180, 0.068053, 0.319684>, <0.057180, 0.000347, 0.319684>, 
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>, 
      <-0.077612, 0.000347, 0.309073>, <-0.077612, -0.067358, 0.309073>, <-0.161716, -0.067358, 0.363171>, <-0.161716, 0.000347, 0.363171>, 
      <-0.141204, 0.000347, 0.253071>, <-0.141204, -0.067357, 0.253071>, <-0.237334, -0.067357, 0.225527>, <-0.237334, 0.000347, 0.225527>, 
      <-0.118242, 0.000347, 0.141795>, <-0.118242, -0.004594, 0.141795>, <-0.123509, -0.004594, 0.136744>, <-0.123509, 0.000347, 0.136744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>, 
      <-0.161716, 0.000347, 0.363171>, <-0.161716, 0.068053, 0.363171>, <-0.077612, 0.068053, 0.309073>, <-0.077612, 0.000347, 0.309073>, 
      <-0.237334, 0.000347, 0.225527>, <-0.237334, 0.068052, 0.225527>, <-0.141204, 0.068052, 0.253071>, <-0.141204, 0.000347, 0.253071>, 
      <-0.123509, 0.000347, 0.136744>, <-0.123509, 0.005289, 0.136744>, <-0.118242, 0.005289, 0.141795>, <-0.118242, 0.000347, 0.141795>
    }
  }
  rotate <180.0, 0.0, 0.0>
  translate  -0.75*z
}
#declare CageHook = union {
  cylinder { // LHookShaft4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.2>
    translate  -0.75*z
  }
  object { LHookBzr4 }
  texture {
    txtBalanceRodsMSilverMetal
  }
  scale 1.436429
  rotate <0.0, 0.0, 162.901932>
  translate  <-6.265729, 0.029341, 21.014791>
}
//
// Include file contains 'Nail16'
//
#include "moustrap.in4"
#declare Nail16 = object {
  Nail16_Raw
  texture {
    txtNailsMGreyDull
  }
  rotate <0.0, -42.207027, 65.41407>
  translate  <-2.378683, 6.754067, 17.752658>
}
//
// Include file contains 'Nail17'
//
#include "moustrap.in5"
#declare Nail17 = object {
  Nail17_Raw
  texture {
    txtNailsMGreyDull
  }
  rotate <0.0, 44.640511, 63.00423>
  translate  <-3.042601, 6.601834, 17.843447>
}
//
// Include file contains 'Nail18'
//
#include "moustrap.in6"
#declare Nail18 = object {
  Nail18_Raw
  texture {
    txtNailsMGreyDull
  }
  rotate <0.0, -50.527611, 65.169724>
  translate  <-5.181892, 2.624168, 17.811404>
}
//
// Include file contains 'Nail19'
//
#include "moustrap.in7"
#declare Nail19 = object {
  Nail19_Raw
  texture {
    txtNailsMGreyDull
  }
  rotate <0.0, 43.70752, 67.884178>
  translate  <-4.834126, 1.85017, 17.827425>
}
union { // CageAndSupports
  object { Cage }
  box { // PlatSupport3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <-1.800000, 0.400000, 0.200000>
    }
    scale <0.5, 0.3, 1.05>
    rotate <0.0, 0.0, -28.0>
    translate  <-2.7, 6.7, 19.1>
  }
  box { // PlatSupport5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <2.700000, 0.000000, 0.200000>
    }
    scale <0.5, 0.3, 4.2>
    rotate <-90.0, 0.0, -28.0>
    translate  <-4.4, 3.4, 20.4>
  }
  box { // PlatSupport4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtPlatSupportsMWood1
      scale <10.0, 10.0, 0.5>
  translate <-0.800000, 0.000000, 0.200000>
    }
    scale <0.5, 0.3, 1.05>
    rotate -28.0*z
    translate  <-5.0, 2.2, 19.1>
  }
  object { CageHook }
  object { ScissorStrng18 }
  object { // ScissorStrng19->ScissorStrng18
    ScissorStrng18
    rotate <0.0, 0.0, 0.0>
    translate  <-0.094062, 0.023752, 0.006722>
  }
  object { Nail12 }
  object { // Nail13->Nail12
    Nail12
    translate  <-0.613517, 0.085211, 0.0>
  }
  object { // Nail14->Nail12
    Nail12
    translate  <-2.880123, -4.226453, 0.0>
  }
  object { // Nail15->Nail12
    Nail12
    translate  <-2.454069, -4.703633, 0.0>
  }
  object { Nail16 }
  object { Nail17 }
  object { Nail18 }
  object { Nail19 }
}


union { // SolidWallCSG1
  cylinder { // BaseBoardCyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBaseBoardMWhiteWrinkles
    }
    scale <1.0, 1.0, 200.0>
    rotate -90.0*y
    translate  <120.500002, 10.3, 10.0>
  }
  box { // BaseBoardCube1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBaseBoardMWhiteWrinkles
    }
    scale <143.5, 1.0, 6.4>
    translate  <-16.0, 10.3, 3.6>
  }
  box { // WallBox1
    <-1, -1, -1>, <1, 1, 1>
    scale <67.0, 2.0, 26.200001>
    translate  <0.2, 12.2, 25.7>
    texture {
      txtWallMBlueSheetRockMap
      scale <8.1, 12.8, 0.6>
      rotate <90.0, 0.0, -180.0>
  translate <24.200001, 9.400001, 8.700000>
    }
  }
  scale 0.6
  rotate -90.0*z
  translate  13.1*x
}


#declare SolidWallCSG = union {
  cylinder { // BaseBoardCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBaseBoardMWhiteWrinkles
    }
    scale <1.0, 1.0, 200.0>
    rotate -90.0*y
    translate  <120.500002, 10.3, 10.0>
  }
  box { // BaseBoardCube
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBaseBoardMWhiteWrinkles
    }
    scale <143.5, 1.0, 6.4>
    translate  <-16.0, 10.3, 3.6>
  }
  box { // WallBox
    <-1, -1, -1>, <1, 1, 1>
    scale <67.0, 2.0, 26.200001>
    translate  <0.2, 12.2, 25.7>
  }
  translate  <24.2, -0.8, 0.0>
}
difference { // WallCSG
  object { SolidWallCSG }
  cylinder { // MouseHoleCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBaseBoardMBrownWrinkles
    }
    scale <4.0, 3.3, 10.0>
    rotate -90.0*x
    translate  <-22.2, 5.9, 6.0>
  }
  box { // MouseHoleBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      txtBaseBoardMBrownWrinkles
    }
    scale <4.0, 5.6, 3.0>
    translate  <-22.2, 10.6, 3.0>
  }
  scale 0.6
  translate  <-8.9, 4.6, 0.0>
  texture {
    txtWallMBlueSheetRockMap
    scale <4.9, 7.7, 1.0>
    rotate <90.0, 0.0, 180.0>
  translate <-32.600002, 12.200000, 6.900000>
  }
}


#declare Motor = union {
  cylinder { // MotorCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 3.5>
    rotate -90.0*y
  }
  object { MotorFin1 }
  object { // MotorFin2->MotorFin1
    MotorFin1
    translate  <0.0, 0.401722, -0.063627>
  }
  object { // MotorFin3->MotorFin1
    MotorFin1
    translate  <0.0, 0.764121, -0.248278>
  }
  object { // MotorFin4->MotorFin1
    MotorFin1
    translate  <0.0, -0.401722, -0.063627>
  }
  object { // MotorFin5->MotorFin1
    MotorFin1
    translate  <0.0, -0.764121, -0.248278>
  }
  object { MotorFin6 }
  object { // MotorFin7->MotorFin6
    MotorFin6
    translate  <0.0, -0.063627, -0.401722>
  }
  object { // MotorFin8->MotorFin6
    MotorFin6
    translate  <0.0, -0.248278, -0.764121>
  }
  object { // MotorFin9->MotorFin6
    MotorFin6
    translate  <0.0, -0.063627, 0.401722>
  }
  object { // MotorFin10->MotorFin6
    MotorFin6
    translate  <0.0, -0.248278, 0.764121>
  }
  object { MotorFin16 }
  object { // MotorFin17->MotorFin16
    MotorFin16
    translate  <0.0, 0.063627, 0.401722>
  }
  object { // MotorFin18->MotorFin16
    MotorFin16
    translate  <0.0, 0.248278, 0.764121>
  }
  object { // MotorFin19->MotorFin16
    MotorFin16
    translate  <0.0, 0.063627, -0.401722>
  }
  object { // MotorFin20->MotorFin16
    MotorFin16
    translate  <0.0, 0.248278, -0.764121>
  }
  object { MotorBaseCSG1 }
  object { // MotorBaseCSG2->MotorBaseCSG1
    MotorBaseCSG1
    rotate 180.0*z
    translate  -3.4*x
  }
  box { // MotorMidBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 0.6, 0.3>
    translate  <-1.7, 0.0, -1.1>
  }
  object { MotorSide }
  object { // MotorSide1->MotorSide
    MotorSide
    translate  3.5*x
  }
  cylinder { // MotorShaft
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.2, 0.2, 4.7>
    rotate <0.0, -90.0, 0.0>
    translate  0.2*x
  }
  texture {
    txtMotorMDarkGrayDull
  }
}
#declare differe0_4 = difference {
  cylinder { // cylinde1_5
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.4>
    translate  -0.2*z
  }
  cylinder { // cylinde2_6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.6>
    translate  -0.3*z
  }
}
#declare differe1_7 = difference {
  cylinder { // cylinde3_8
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtGearsWebMBlackMetal
    }
    scale <2.0, 2.0, 0.25>
    translate  -0.125*z
  }
  cylinder { // cylinde4_9
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.45>
    translate  -0.225*z
  }
  cylinder { // cylinde5_10
    <0,0,1>, <0,0,0>, 1 
    scale <0.464286, 0.464286, 0.45>
    translate  <0.0, 1.35, -0.225>
  }
  cylinder { // cylinde6_11
    <0,0,1>, <0,0,0>, 1 
    scale <0.464286, 0.464286, 0.45>
    rotate 90.0*z
    translate  <-1.35, 0.0, -0.225>
  }
  cylinder { // cylinde7_12
    <0,0,1>, <0,0,0>, 1 
    scale <0.464286, 0.464286, 0.45>
    rotate 180.0*z
    translate  <0.0, -1.35, -0.225>
  }
  cylinder { // cylinde8_13
    <0,0,1>, <0,0,0>, 1 
    scale <0.464286, 0.464286, 0.45>
    rotate 270.0*z
    translate  <1.35, 0.0, -0.225>
  }
}
#declare differe2_13 = difference {
  cylinder { // cylinde9_14
    <0,0,1>, <0,0,0>, 1 
    scale <2.35, 2.35, 0.5>
    translate  -0.25*z
  }
  cylinder { // cylinde10_15
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.7>
    translate  -0.35*z
  }
}
#declare union0_16 = union {
  object { interse0_17 }
  object { // interse0_18->interse0_17
    interse0_17
    rotate -30.0*z
  }
  object { // interse0_20->interse0_17
    interse0_17
    rotate -60.0*z
  }
  object { // interse0_21->interse0_17
    interse0_17
    rotate -90.0*z
  }
  object { // interse0_22->interse0_17
    interse0_17
    rotate -120.0*z
  }
  object { // interse0_23->interse0_17
    interse0_17
    rotate -150.0*z
  }
  object { // interse0_24->interse0_17
    interse0_17
    rotate 180.0*z
  }
  object { // interse0_25->interse0_17
    interse0_17
    rotate 150.0*z
  }
  object { // interse0_26->interse0_17
    interse0_17
    rotate 120.0*z
  }
  object { // interse0_27->interse0_17
    interse0_17
    rotate 90.0*z
  }
  object { // interse0_28->interse0_17
    interse0_17
    rotate 60.0*z
  }
  object { // interse0_29->interse0_17
    interse0_17
    rotate 30.0*z
  }
  object { // interse0_30->interse0_17
    interse0_17
    rotate 0.0*z
  }
}
#declare Cog_1_0 = union {
  object { differe0_4 }
  object { differe1_7 }
  object { differe2_13 }
  object { union0_16 }
  rotate 8.11417*z
}
#declare differe0_3 = difference {
  cylinder { // cylinde1_4
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 0.4>
    translate  -0.2*z
  }
  cylinder { // cylinde2_5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.6>
    translate  -0.3*z
  }
}
#declare differe1_6 = difference {
  cylinder { // cylinde3_7
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtGearsWebMBlackMetal
    }
    scale <3.8, 3.8, 0.25>
    translate  -0.125*z
  }
  cylinder { // cylinde4_8
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 0.45>
    translate  -0.225*z
  }
  cylinder { // cylinde5_9
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    translate  <0.0, 2.525, -0.225>
  }
  cylinder { // cylinde6_10
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    rotate 60.0*z
    translate  <-2.186714, 1.2625, -0.225>
  }
  cylinder { // cylinde7_11
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    rotate 120.0*z
    translate  <-2.186714, -1.2625, -0.225>
  }
  cylinder { // cylinde8_12
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    rotate 180.0*z
    translate  <0.0, -2.525, -0.225>
  }
  cylinder { // cylinde9_13
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    rotate 240.0*z
    translate  <2.186714, -1.2625, -0.225>
  }
  cylinder { // cylinde10_14
    <0,0,1>, <0,0,0>, 1 
    scale <0.910714, 0.910714, 0.45>
    rotate 300.0*z
    translate  <2.186714, 1.2625, -0.225>
  }
}
#declare differe2_15 = difference {
  cylinder { // cylinde11_16
    <0,0,1>, <0,0,0>, 1 
    scale <4.45, 4.45, 0.5>
    translate  -0.25*z
  }
  cylinder { // cylinde12_17
    <0,0,1>, <0,0,0>, 1 
    scale <3.8, 3.8, 0.7>
    translate  -0.35*z
  }
}
#declare union0_18 = union {
  object { interse0_19 }
  object { // interse0_31->interse0_19
    interse0_19
    rotate -17.142857*z
  }
  object { // interse0_32->interse0_19
    interse0_19
    rotate -34.285713*z
  }
  object { // interse0_33->interse0_19
    interse0_19
    rotate -51.42857*z
  }
  object { // interse0_34->interse0_19
    interse0_19
    rotate -68.571426*z
  }
  object { // interse0_35->interse0_19
    interse0_19
    rotate -85.714287*z
  }
  object { // interse0_36->interse0_19
    interse0_19
    rotate -102.85714*z
  }
  object { // interse0_37->interse0_19
    interse0_19
    rotate -120.0*z
  }
  object { // interse0_38->interse0_19
    interse0_19
    rotate -137.142853*z
  }
  object { // interse0_39->interse0_19
    interse0_19
    rotate -154.285721*z
  }
  object { // interse0_40->interse0_19
    interse0_19
    rotate -171.428574*z
  }
  object { // interse0_41->interse0_19
    interse0_19
    rotate 171.428574*z
  }
  object { // interse0_42->interse0_19
    interse0_19
    rotate 154.285721*z
  }
  object { // interse0_43->interse0_19
    interse0_19
    rotate 137.142853*z
  }
  object { // interse0_44->interse0_19
    interse0_19
    rotate 120.0*z
  }
  object { // interse0_45->interse0_19
    interse0_19
    rotate 102.857147*z
  }
  object { // interse0_46->interse0_19
    interse0_19
    rotate 85.714294*z
  }
  object { // interse0_47->interse0_19
    interse0_19
    rotate 68.571442*z
  }
  object { // interse0_48->interse0_19
    interse0_19
    rotate 51.428558*z
  }
  object { // interse0_49->interse0_19
    interse0_19
    rotate 34.285706*z
  }
  object { // interse0_50->interse0_19
    interse0_19
    rotate 17.142853*z
  }
}
#declare Cog_2_0 = union {
  cylinder { // cylinde0_2
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.4, 0.4, 15.0>
    translate  -14.375*z
  }
  object { differe0_3 }
  object { differe1_6 }
  object { differe2_15 }
  object { union0_18 }
  translate  -7.245969*x
}
#declare Cogs = union {
  object { Cog_1_0 }
  object { Cog_2_0 }
  texture {
    txtGearsTeethMBrownMetal
  }
  scale 0.6
  rotate <90.0, -11.962066, -90.0>
  translate  -4.1*x
}
#declare MotorAssembly = union {
  object { Motor }
  object { Cogs }
  object { Brng1 }
  object { // Brng2->Brng1
    Brng1
    rotate 0.0*y
    translate  <5.513198, 0.0, 0.0>
  }
  rotate 90.0*z
  translate  3.4*z
}
//
// Include file contains 'Nail1'
//
#include "moustrap.in8"
#declare Nail1 = object {
  Nail1_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  translate  <-9.117052, 0.249065, 1.603503>
}
//
// Include file contains 'Nail2'
//
#include "moustrap.in9"
#declare Nail2 = object {
  Nail2_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  translate  <-8.952347, 1.227139, 1.666959>
}
//
// Include file contains 'Nail3'
//
#include "moustrap.i10"
#declare Nail3 = object {
  Nail3_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  translate  <-10.069514, -2.097143, 1.681161>
}
//
// Include file contains 'Nail4'
//
#include "moustrap.i11"
#declare Nail4 = object {
  Nail4_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  translate  <-9.694829, 0.832061, 1.578099>
}
//
// Include file contains 'Nail5'
//
#include "moustrap.i12"
#declare Nail5 = object {
  Nail5_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.3
  translate  <-10.772838, -2.215057, 1.620109>
}
//
// Include file contains 'Nail6'
//
#include "moustrap.i13"
#declare Nail6 = object {
  Nail6_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  translate  <-13.2, 5.4, 0.2>
}
//
// Include file contains 'Nail7'
//
#include "moustrap.i14"
#declare Nail7 = object {
  Nail7_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  rotate 90.0*x
  translate  <-13.2, 6.4, -6.1>
}
//
// Include file contains 'Nail8'
//
#include "moustrap.i15"
#declare Nail8 = object {
  Nail8_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  translate  <-13.2, -1.9, 0.2>
}
//
// Include file contains 'Nail9'
//
#include "moustrap.i16"
#declare Nail9 = object {
  Nail9_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  translate  <1.7, 5.4, 0.2>
}
#include "scissors.inc"

#declare scissor01_Ref = object {
  scissor01
  rotate -30.0*y
  translate  <0.57556, 0.0, -2.167413>
}
#declare scissor02_Ref = object {
  scissor02
}
#declare studs_Ref = object {
  studs
}
#declare Scissors_obj = union {
  object { scissor01_Ref }
  object { scissor02_Ref }
  object { studs_Ref }
  texture {
    txtScissorsMSilverMetal
  }
  rotate <-90.0, 0.0, 80.0>
  translate  <-10.9, -6.3, 2.2786>
}
//
// Include file contains 'Nail10'
//
#include "moustrap.i17"
#declare Nail10 = object {
  Nail10_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  rotate <90.0, 0.0, 0.0>
  translate  <1.8, 6.4, -6.1>
}
//
// Include file contains 'Nail11'
//
#include "moustrap.i18"
#declare Nail11 = object {
  Nail11_Raw
  texture {
    txtNailsMGreyDull
  }
  scale 1.7
  translate  <1.878433, -1.8, 0.2>
}
#declare ScissorString = union {
  cylinder { // ScissorStringCy
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 7.2>
    rotate <-11.410679, -85.861542, -164.953186>
    translate  <-7.384296, 4.804653, 18.571818>
  }
  object { ScissorStrngTrs }
  object { // ScissorStrngT1->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.1, 0.0>
  }
  object { // ScissorStrngT2->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.2, 0.0>
  }
  object { // ScissorStrngT3->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.3, 0.0>
  }
  object { // ScissorStrngT4->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.4, 0.0>
  }
  object { // ScissorStrngT5->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.5, 0.0>
  }
  object { // ScissorStrngT6->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.6, 0.0>
  }
  object { // ScissorStrngT7->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.7, 0.0>
  }
  object { // ScissorStrngT8->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.8, 0.0>
  }
  object { // ScissorStrngT9->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.9, 0.0>
  }
  object { // ScissorStrng10->ScissorStrngTrs
    ScissorStrngTrs
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -1.0, 0.0>
  }
  object { ScissorStrng11 }
  object { // ScissorStrng12->ScissorStrng11
    ScissorStrng11
    rotate <0.0, 0.0, 0.0>
    translate  <-0.03, 0.1, 0.0>
  }
  object { // ScissorStrng13->ScissorStrng11
    ScissorStrng11
    rotate <0.0, 0.0, 0.0>
    translate  <-0.06, 0.2, 0.0>
  }
  object { // ScissorStrng14->ScissorStrng11
    ScissorStrng11
    rotate <0.0, 0.0, 0.0>
    translate  <-0.110311, 0.3, 0.0>
  }
  texture {
    txtStringMDullWhite
  }
  rotate 0.0*x
  translate  <-4.0, -4.4, -16.3>
}
union { // Platform
  object { MotorAssembly }
  box { // PlatformBase1
    <-1, -1, -1>, <1, 1, 1>
    scale <8.3, 4.6, 0.5>
    translate  <-5.712423, 1.196274, 1.4>
    texture {
      txtPlatformMWoodMap
      scale <4.0, 3.4, 3.0>
      rotate <0.0, 0.0, -180.0>
  translate <1.475229, 4.982477, 0.000000>
    }
  }
  object { Nail1 }
  object { Nail2 }
  object { Nail3 }
  object { Nail4 }
  object { Nail5 }
  object { Nail6 }
  object { Nail7 }
  object { Nail8 }
  object { Nail9 }
  object { Scissors_obj }
  object { PlatSupportsGrp }
  object { // PlatSupportsG1->PlatSupportsGrp
    PlatSupportsGrp
    rotate 0.0*x
    translate  15.0*x
  }
  object { Nail10 }
  object { Nail11 }
  object { ScissorString }
  translate  <4.0, 4.4, 16.3>
}


#declare SwitchButtonCSG = difference {
  superellipsoid { // SwitchButtonSpr
    <1.0, 0.075>
    scale 0.6
    translate  <-0.4, 0.0, 0.3>
  }
  sphere { // SwitchButtonCut
    <0,0,0>,1
    scale <0.6, 0.6, 0.2>
    translate  <-0.4, 0.0, 1.0>
  }
  texture {
    txtButtonMRedPlastic
  }
}
union { // Switch
  superellipsoid { // SwitchBox2
    <0.1, 0.1>
    scale <1.4, 0.8, 0.5>
    translate  -0.3*z
  }
  object { SwitchButtonCSG }
  superellipsoid { // SwitchBox1
    <0.1, 0.1>
    scale <1.5, 0.9, 0.6>
    translate  -0.1*z
  }
  cylinder { // SwitchButtonCyl
    <0,0,1>, <0,0,0>, 1 
    scale 0.7
    translate  <-0.4, 0.0, -0.1>
  }
  texture {
    txtSwitchMBlackPlastic
  }
  rotate 168.599411*z
  translate  <1.097144, -8.313803, 0.8>
}




plane { // Floor
  z,0
  texture {
    txtFloorMWoodMap
    scale <7.8, 7.8, 1.0>
    rotate -90.0*z
  translate <-8.100000, -14.300000, 0.000000>
  }
}


#declare BatteryCSG = difference {
  superellipsoid { // BatterySpr
    <0.4, 0.05>
    scale <2.0, 2.0, 2.5>
    translate  2.6*z
  }
  superellipsoid { // BatteryTop
    <0.4, 0.05>
    scale <1.9, 1.9, 0.2>
    translate  5.1*z
  }
  texture {
    txtEnergizerMMap
    scale <2.0, 2.0, 5.0>
    rotate <0.0, 0.0, -170.0>
  translate <0.000000, 0.000000, 0.100000>
  }
}
union { // Barrery
  object { BatteryCSG }
  superellipsoid { // BatteryTop1
    <0.4, 0.05>
    texture {
      txtBalanceWeightsMBlackBumpy
    }
    scale <1.9, 1.9, 0.1>
    translate  4.9*z
  }
  object { Spring1 }
  object { // Spring2->Spring1
    Spring1
    rotate <0.0, 0.0, 110.0>
    translate  <-1.05, -1.05, 0.0>
  }
  rotate 55.0*z
  translate  <10.5, -5.5, -0.1>
}


#declare Base = difference {
  box { // BaseCube
    <-1, -1, -1>, <1, 1, 1>
    scale <7.7, 2.5, 0.4>
    translate  -3.5*z
  }
  plane { // PlaneCut001
    z,0
    scale <1.0, 0.4, 0.4>
    rotate -135.0*x
    translate  <0.0, -2.4, -3.2>
  }
  plane { // PlaneCut2
    z,0
    scale <1.0, 0.4, 0.4>
    rotate 135.0*x
    translate  <0.0, 2.4, -3.2>
  }
  plane { // PlaneCut3
    z,0
    scale <1.0, 0.4, 0.4>
    rotate <135.0, 0.0, 90.0>
    translate  <-7.6, 0.0, -3.2>
  }
  plane { // PlaneCut4
    z,0
    scale <1.0, 0.4, 0.4>
    rotate <-135.0, 0.0, 90.0>
    translate  <7.6, 0.0, -3.2>
  }
  cylinder { // CylndrCut001
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.7>
    translate  <-6.0, 0.0, -3.7>
  }
  cylinder { // CylndrCut2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.7>
    translate  <6.0, 0.0, -3.7>
  }
  cone { // ConeCut001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    translate  <-6.0, 0.0, -3.7>
  }
  cone { // ConeCut2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    translate  <6.0, 0.0, -3.7>
  }
  texture {
    txtBalanceBaseMMarble
  }
}
#declare LHookBzr3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050000, 0.000000, 0.000000>, <-0.050000, -0.068054, 0.000000>, <0.050000, -0.068054, 0.000000>, <0.050000, 0.000000, 0.000000>, 
      <-0.050125, 0.000347, 0.141529>, <-0.050125, -0.067358, 0.141529>, <0.036234, -0.067358, 0.091353>, <0.036234, 0.000347, 0.091353>, 
      <0.103097, 0.000347, 0.143837>, <0.103097, -0.067358, 0.143837>, <0.188116, -0.067358, 0.091190>, <0.188116, 0.000347, 0.091190>, 
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050000, 0.000000, 0.000000>, <0.050000, 0.068054, 0.000000>, <-0.050000, 0.068054, 0.000000>, <-0.050000, 0.000000, 0.000000>, 
      <0.036234, 0.000347, 0.091353>, <0.036234, 0.068053, 0.091353>, <-0.050125, 0.068053, 0.141529>, <-0.050125, 0.000347, 0.141529>, 
      <0.188116, 0.000347, 0.091190>, <0.188116, 0.068053, 0.091190>, <0.103097, 0.068053, 0.143837>, <0.103097, 0.000347, 0.143837>, 
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>, 
      <0.105634, 0.000347, 0.289707>, <0.105634, -0.067358, 0.289707>, <0.200949, -0.067358, 0.319960>, <0.200949, 0.000347, 0.319960>, 
      <0.057180, 0.000347, 0.319684>, <0.057180, -0.067358, 0.319684>, <0.077267, -0.067358, 0.417646>, <0.077267, 0.000347, 0.417646>, 
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>, 
      <0.200949, 0.000347, 0.319960>, <0.200949, 0.068053, 0.319960>, <0.105634, 0.068053, 0.289707>, <0.105634, 0.000347, 0.289707>, 
      <0.077267, 0.000347, 0.417646>, <0.077267, 0.068053, 0.417646>, <0.057180, 0.068053, 0.319684>, <0.057180, 0.000347, 0.319684>, 
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>, 
      <-0.077612, 0.000347, 0.309073>, <-0.077612, -0.067358, 0.309073>, <-0.161716, -0.067358, 0.363171>, <-0.161716, 0.000347, 0.363171>, 
      <-0.141204, 0.000347, 0.253071>, <-0.141204, -0.067357, 0.253071>, <-0.237334, -0.067357, 0.225527>, <-0.237334, 0.000347, 0.225527>, 
      <-0.118242, 0.000347, 0.141795>, <-0.118242, -0.004594, 0.141795>, <-0.123509, -0.004594, 0.136744>, <-0.123509, 0.000347, 0.136744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>, 
      <-0.161716, 0.000347, 0.363171>, <-0.161716, 0.068053, 0.363171>, <-0.077612, 0.068053, 0.309073>, <-0.077612, 0.000347, 0.309073>, 
      <-0.237334, 0.000347, 0.225527>, <-0.237334, 0.068052, 0.225527>, <-0.141204, 0.068052, 0.253071>, <-0.141204, 0.000347, 0.253071>, 
      <-0.123509, 0.000347, 0.136744>, <-0.123509, 0.005289, 0.136744>, <-0.118242, 0.005289, 0.141795>, <-0.118242, 0.000347, 0.141795>
    }
  }
  rotate <180.0, 0.0, 0.0>
  translate  -0.75*z
}
#declare RLowerHook = union {
  cylinder { // LHookShaft3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    translate  -0.75*z
  }
  object { LHookBzr3 }
  texture {
    txtBalanceRodsMSilverMetal
  }
  rotate <-180.0, 0.0, -79.0>
  translate  <0.0, 0.011392, -0.079741>
}
#declare RWeight = union {
  superellipsoid { // RWeightQuad
    <0.8, 0.2>
    texture {
      txtBalanceWeightsMBlackBumpy
    }
    scale <0.4, 0.4, 0.6>
    rotate -79.0*z
  }
  object { RLowerHook }
  translate  <6.008345, 0.0, -1.841649>
}
#declare LHookBzr2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050000, 0.000000, 0.000000>, <-0.050000, -0.068054, 0.000000>, <0.050000, -0.068054, 0.000000>, <0.050000, 0.000000, 0.000000>, 
      <-0.050125, 0.000347, 0.141529>, <-0.050125, -0.067358, 0.141529>, <0.036234, -0.067358, 0.091353>, <0.036234, 0.000347, 0.091353>, 
      <0.103097, 0.000347, 0.143837>, <0.103097, -0.067358, 0.143837>, <0.188116, -0.067358, 0.091190>, <0.188116, 0.000347, 0.091190>, 
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050000, 0.000000, 0.000000>, <0.050000, 0.068054, 0.000000>, <-0.050000, 0.068054, 0.000000>, <-0.050000, 0.000000, 0.000000>, 
      <0.036234, 0.000347, 0.091353>, <0.036234, 0.068053, 0.091353>, <-0.050125, 0.068053, 0.141529>, <-0.050125, 0.000347, 0.141529>, 
      <0.188116, 0.000347, 0.091190>, <0.188116, 0.068053, 0.091190>, <0.103097, 0.068053, 0.143837>, <0.103097, 0.000347, 0.143837>, 
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>, 
      <0.105634, 0.000347, 0.289707>, <0.105634, -0.067358, 0.289707>, <0.200949, -0.067358, 0.319960>, <0.200949, 0.000347, 0.319960>, 
      <0.057180, 0.000347, 0.319684>, <0.057180, -0.067358, 0.319684>, <0.077267, -0.067358, 0.417646>, <0.077267, 0.000347, 0.417646>, 
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>, 
      <0.200949, 0.000347, 0.319960>, <0.200949, 0.068053, 0.319960>, <0.105634, 0.068053, 0.289707>, <0.105634, 0.000347, 0.289707>, 
      <0.077267, 0.000347, 0.417646>, <0.077267, 0.068053, 0.417646>, <0.057180, 0.068053, 0.319684>, <0.057180, 0.000347, 0.319684>, 
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>, 
      <-0.077612, 0.000347, 0.309073>, <-0.077612, -0.067358, 0.309073>, <-0.161716, -0.067358, 0.363171>, <-0.161716, 0.000347, 0.363171>, 
      <-0.141204, 0.000347, 0.253071>, <-0.141204, -0.067357, 0.253071>, <-0.237334, -0.067357, 0.225527>, <-0.237334, 0.000347, 0.225527>, 
      <-0.118242, 0.000347, 0.141795>, <-0.118242, -0.004594, 0.141795>, <-0.123509, -0.004594, 0.136744>, <-0.123509, 0.000347, 0.136744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>, 
      <-0.161716, 0.000347, 0.363171>, <-0.161716, 0.068053, 0.363171>, <-0.077612, 0.068053, 0.309073>, <-0.077612, 0.000347, 0.309073>, 
      <-0.237334, 0.000347, 0.225527>, <-0.237334, 0.068052, 0.225527>, <-0.141204, 0.068052, 0.253071>, <-0.141204, 0.000347, 0.253071>, 
      <-0.123509, 0.000347, 0.136744>, <-0.123509, 0.005289, 0.136744>, <-0.118242, 0.005289, 0.141795>, <-0.118242, 0.000347, 0.141795>
    }
  }
  rotate <180.0, 0.0, 0.0>
  translate  -0.75*z
}
#declare LLowerHook = union {
  cylinder { // LHookShaft2
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    translate  -0.75*z
  }
  object { LHookBzr2 }
  texture {
    txtBalanceRodsMSilverMetal
  }
  rotate <-180.0, 0.0, -125.223389>
  translate  <0.0, 0.011392, -0.079741>
}
#declare LWeight = union {
  superellipsoid { // LWeightQuad
    <0.8, 0.2>
    texture {
      txtBalanceWeightsMBlackBumpy
    }
    scale <0.4, 0.4, 0.6>
    rotate -125.0*z
  }
  object { LLowerHook }
  translate  <-5.991655, 0.0, -1.841649>
}
#declare LHookBzr1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050000, 0.000000, 0.000000>, <-0.050000, -0.068054, 0.000000>, <0.050000, -0.068054, 0.000000>, <0.050000, 0.000000, 0.000000>, 
      <-0.050125, 0.000347, 0.141529>, <-0.050125, -0.067358, 0.141529>, <0.036234, -0.067358, 0.091353>, <0.036234, 0.000347, 0.091353>, 
      <0.103097, 0.000347, 0.143837>, <0.103097, -0.067358, 0.143837>, <0.188116, -0.067358, 0.091190>, <0.188116, 0.000347, 0.091190>, 
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050000, 0.000000, 0.000000>, <0.050000, 0.068054, 0.000000>, <-0.050000, 0.068054, 0.000000>, <-0.050000, 0.000000, 0.000000>, 
      <0.036234, 0.000347, 0.091353>, <0.036234, 0.068053, 0.091353>, <-0.050125, 0.068053, 0.141529>, <-0.050125, 0.000347, 0.141529>, 
      <0.188116, 0.000347, 0.091190>, <0.188116, 0.068053, 0.091190>, <0.103097, 0.068053, 0.143837>, <0.103097, 0.000347, 0.143837>, 
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>, 
      <0.105634, 0.000347, 0.289707>, <0.105634, -0.067358, 0.289707>, <0.200949, -0.067358, 0.319960>, <0.200949, 0.000347, 0.319960>, 
      <0.057180, 0.000347, 0.319684>, <0.057180, -0.067358, 0.319684>, <0.077267, -0.067358, 0.417646>, <0.077267, 0.000347, 0.417646>, 
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>, 
      <0.200949, 0.000347, 0.319960>, <0.200949, 0.068053, 0.319960>, <0.105634, 0.068053, 0.289707>, <0.105634, 0.000347, 0.289707>, 
      <0.077267, 0.000347, 0.417646>, <0.077267, 0.068053, 0.417646>, <0.057180, 0.068053, 0.319684>, <0.057180, 0.000347, 0.319684>, 
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>, 
      <-0.077612, 0.000347, 0.309073>, <-0.077612, -0.067358, 0.309073>, <-0.161716, -0.067358, 0.363171>, <-0.161716, 0.000347, 0.363171>, 
      <-0.141204, 0.000347, 0.253071>, <-0.141204, -0.067357, 0.253071>, <-0.237334, -0.067357, 0.225527>, <-0.237334, 0.000347, 0.225527>, 
      <-0.118242, 0.000347, 0.141795>, <-0.118242, -0.004594, 0.141795>, <-0.123509, -0.004594, 0.136744>, <-0.123509, 0.000347, 0.136744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>, 
      <-0.161716, 0.000347, 0.363171>, <-0.161716, 0.068053, 0.363171>, <-0.077612, 0.068053, 0.309073>, <-0.077612, 0.000347, 0.309073>, 
      <-0.237334, 0.000347, 0.225527>, <-0.237334, 0.068052, 0.225527>, <-0.141204, 0.068052, 0.253071>, <-0.141204, 0.000347, 0.253071>, 
      <-0.123509, 0.000347, 0.136744>, <-0.123509, 0.005289, 0.136744>, <-0.118242, 0.005289, 0.141795>, <-0.118242, 0.000347, 0.141795>
    }
  }
  rotate <180.0, 0.0, 0.0>
  translate  -0.75*z
}
#declare RUpperHook = union {
  cylinder { // LHookShaft1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    translate  -0.75*z
  }
  object { LHookBzr1 }
  texture {
    txtBalanceRodsMSilverMetal
  }
  rotate -169.11084*z
  translate  <6.0, 0.0, 0.2>
}
#declare LHookBzr = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050000, 0.000000, 0.000000>, <-0.050000, -0.068054, 0.000000>, <0.050000, -0.068054, 0.000000>, <0.050000, 0.000000, 0.000000>, 
      <-0.050125, 0.000347, 0.141529>, <-0.050125, -0.067358, 0.141529>, <0.036234, -0.067358, 0.091353>, <0.036234, 0.000347, 0.091353>, 
      <0.103097, 0.000347, 0.143837>, <0.103097, -0.067358, 0.143837>, <0.188116, -0.067358, 0.091190>, <0.188116, 0.000347, 0.091190>, 
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.050000, 0.000000, 0.000000>, <0.050000, 0.068054, 0.000000>, <-0.050000, 0.068054, 0.000000>, <-0.050000, 0.000000, 0.000000>, 
      <0.036234, 0.000347, 0.091353>, <0.036234, 0.068053, 0.091353>, <-0.050125, 0.068053, 0.141529>, <-0.050125, 0.000347, 0.141529>, 
      <0.188116, 0.000347, 0.091190>, <0.188116, 0.068053, 0.091190>, <0.103097, 0.068053, 0.143837>, <0.103097, 0.000347, 0.143837>, 
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104366, 0.000347, 0.216772>, <0.104366, -0.067358, 0.216772>, <0.194532, -0.067358, 0.205575>, <0.194532, 0.000347, 0.205575>, 
      <0.105634, 0.000347, 0.289707>, <0.105634, -0.067358, 0.289707>, <0.200949, -0.067358, 0.319960>, <0.200949, 0.000347, 0.319960>, 
      <0.057180, 0.000347, 0.319684>, <0.057180, -0.067358, 0.319684>, <0.077267, -0.067358, 0.417646>, <0.077267, 0.000347, 0.417646>, 
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.194532, 0.000347, 0.205575>, <0.194532, 0.068053, 0.205575>, <0.104366, 0.068053, 0.216772>, <0.104366, 0.000347, 0.216772>, 
      <0.200949, 0.000347, 0.319960>, <0.200949, 0.068053, 0.319960>, <0.105634, 0.068053, 0.289707>, <0.105634, 0.000347, 0.289707>, 
      <0.077267, 0.000347, 0.417646>, <0.077267, 0.068053, 0.417646>, <0.057180, 0.068053, 0.319684>, <0.057180, 0.000347, 0.319684>, 
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010216, 0.000347, 0.314379>, <-0.010216, -0.067358, 0.314379>, <-0.042225, -0.067358, 0.390409>, <-0.042225, 0.000347, 0.390409>, 
      <-0.077612, 0.000347, 0.309073>, <-0.077612, -0.067358, 0.309073>, <-0.161716, -0.067358, 0.363171>, <-0.161716, 0.000347, 0.363171>, 
      <-0.141204, 0.000347, 0.253071>, <-0.141204, -0.067357, 0.253071>, <-0.237334, -0.067357, 0.225527>, <-0.237334, 0.000347, 0.225527>, 
      <-0.118242, 0.000347, 0.141795>, <-0.118242, -0.004594, 0.141795>, <-0.123509, -0.004594, 0.136744>, <-0.123509, 0.000347, 0.136744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.042225, 0.000347, 0.390409>, <-0.042225, 0.068053, 0.390409>, <-0.010216, 0.068053, 0.314379>, <-0.010216, 0.000347, 0.314379>, 
      <-0.161716, 0.000347, 0.363171>, <-0.161716, 0.068053, 0.363171>, <-0.077612, 0.068053, 0.309073>, <-0.077612, 0.000347, 0.309073>, 
      <-0.237334, 0.000347, 0.225527>, <-0.237334, 0.068052, 0.225527>, <-0.141204, 0.068052, 0.253071>, <-0.141204, 0.000347, 0.253071>, 
      <-0.123509, 0.000347, 0.136744>, <-0.123509, 0.005289, 0.136744>, <-0.118242, 0.005289, 0.141795>, <-0.118242, 0.000347, 0.141795>
    }
  }
  rotate <180.0, 0.0, 0.0>
  translate  -0.75*z
}
#declare LUpperHook = union {
  cylinder { // LHookShaft
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.75>
    translate  -0.75*z
  }
  object { LHookBzr }
  texture {
    txtBalanceRodsMSilverMetal
  }
  rotate -35.223389*z
  translate  <-6.0, 0.0, 0.2>
}
#declare LPlatform = union {
  torus { // LPlatformTrs
    3.0, 0.1  rotate -x*90
    texture {
      txtBalancePlatMSilverMetalNoR
    }
    translate  0.1*z
  }
  cylinder { // LPlatformCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalancePlatMSilverMetalNoR
    }
    scale <3.0, 3.0, 0.2>
  }
  texture {
    txtBalanceRodsMSilverMetal
  }
  translate  <-6.0, 0.0, 2.0>
}
#declare RPlatform = union {
  torus { // RPlatformTrs
    3.0, 0.1  rotate -x*90
    texture {
      txtBalancePlatMSilverMetalNoR
    }
    translate  0.1*z
  }
  cylinder { // RPlatformCyl
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalancePlatMSilverMetalNoR
    }
    scale <3.0, 3.0, 0.2>
  }
  texture {
    txtBalanceRodsMSilverMetal
  }
  translate  <6.0, 0.0, 2.0>
}
// Include contains 'LFrontHorizArm'
#include "moustrap.i19"

#declare LFrontHorizArm = object {
  LFrontHorizArm_Raw
  scale <1.0, 1.0, 0.1>
  rotate <90.0, 0.0, 0.0>
  translate  -2.0*y
}
// Include contains 'LBackHorizArm'
#include "moustrap.i20"

#declare LBackHorizArm = object {
  LBackHorizArm_Raw
  scale <1.0, 1.0, 0.1>
  rotate <90.0, 0.0, 0.0>
  translate  2.1*y
}
// Include contains 'RBackHorizArm'
#include "moustrap.i21"

#declare RBackHorizArm = object {
  RBackHorizArm_Raw
  scale <1.0, 1.0, 0.1>
  rotate <-90.0, -180.0, 0.0>
  translate  2.0*y
}
// Include contains 'RFrontHorizArm'
#include "moustrap.i22"

#declare RFrontHorizArm = object {
  RFrontHorizArm_Raw
  scale <1.0, 1.0, 0.1>
  rotate <-90.0, -180.0, 0.0>
  translate  -2.1*y
}
#declare Arms = union {
  object { LFrontHorizArm }
  object { LBackHorizArm }
  object { RBackHorizArm }
  object { RFrontHorizArm }
}
// Include contains 'LSupportBzr'
#include "moustrap.i23"

#declare LSupportBzr = object {
  LSupportBzr_Raw
  scale <1.0, 1.0, 0.3>
  rotate 90.0*x
  translate  <0.0, -1.5, 0.8>
}
// Include contains 'LSupportBzr1'
#include "moustrap.i24"

#declare LSupportBzr1 = object {
  LSupportBzr1_Raw
  scale <1.0, 1.0, 0.3>
  rotate 90.0*x
  translate  <0.0, 1.8, 0.8>
}
// Include contains 'LSupportBzr2'
#include "moustrap.i25"

#declare LSupportBzr2 = object {
  LSupportBzr2_Raw
  scale <1.0, 1.0, 0.3>
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, 1.5, 0.8>
}
// Include contains 'LSupportBzr3'
#include "moustrap.i26"

#declare LSupportBzr3 = object {
  LSupportBzr3_Raw
  scale <1.0, 1.0, 0.3>
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, -1.8, 0.8>
}
#declare Supports = union {
  object { LSupportBzr }
  object { LSupportBzr1 }
  object { LSupportBzr2 }
  object { LSupportBzr3 }
}
#declare BalanceArms = union {
  sphere { // RArmSph2
    <0,0,0>,1
    scale 0.5
    translate  <6.0, 0.0, 1.699>
  }
  sphere { // RArmSph1
    <0,0,0>,1
    scale 0.5
    translate  <6.0, 0.0, 0.0>
  }
  sphere { // LArmSph
    <0,0,0>,1
    scale 0.5
    translate  <-6.0, 0.0, 0.0>
  }
  sphere { // LArmSph3
    <0,0,0>,1
    scale 0.5
    translate  <-6.0, 0.0, 1.699>
  }
  cylinder { // LVertArm
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.2, 0.2, 2.0>
    translate  -6.0*x
  }
  cylinder { // RVertArm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.2, 0.2, 2.0>
    translate  <6.0, 0.0, 0.0>
  }
}
#declare BalanceSupports = union {
  object { Arms }
  object { Supports }
  object { BalanceArms }
  cylinder { // CenterRod
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.3, 0.3, 4.4>
    rotate 90.0*x
    translate  <0.0, 2.2, 1.1>
  }
  cylinder { // LSupportRod1
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.2, 0.2, 4.4>
    rotate 90.0*x
    translate  <6.0, 2.2, 0.0>
  }
  cylinder { // LSupportRod
    <0,0,1>, <0,0,0>, 1 
    texture {
      txtBalanceRodsMSilverMetal
    }
    scale <0.2, 0.2, 4.4>
    rotate 90.0*x
    translate  <-6.0, 2.2, 0.0>
  }
  texture {
    txtBalanceSupportsMWood
    rotate 90.0*y
  }
}
union { // Balance
  object { Base }
  object { RWeight }
  object { LWeight }
  object { RUpperHook }
  object { LUpperHook }
  object { LPlatform }
  object { RPlatform }
  object { FScale }
  object { // FScale1->FScale
    FScale
    rotate 180.0*z
  }
  object { BalanceSupports }
  translate  <-0.2, 0.0, 3.9>
}






#declare Body = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.998627, 0.000000, 0.000000>, <-0.998627, -1.123455, 0.000000>, <0.998627, -1.123455, 0.000000>, <0.998627, 0.000000, 0.000000>, 
      <-0.572327, 0.000000, 0.555227>, <-0.572327, -0.565897, 0.555227>, <0.559468, -0.565897, 0.555227>, <0.559468, 0.000000, 0.555227>, 
      <-0.572327, 0.000000, 1.687021>, <-0.572327, -0.565897, 1.687021>, <0.559468, -0.565897, 1.687021>, <0.559468, 0.000000, 1.687021>, 
      <-0.991799, 0.000000, 2.500000>, <-0.991799, -0.991799, 2.500000>, <0.991799, -0.991799, 2.500000>, <0.991799, 0.000000, 2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.998627, 0.000000, 0.000000>, <0.998627, 1.123455, 0.000000>, <-0.998627, 1.123455, 0.000000>, <-0.998627, 0.000000, 0.000000>, 
      <0.559468, 0.000000, 0.555227>, <0.559468, 0.565897, 0.555227>, <-0.572327, 0.565897, 0.555227>, <-0.572327, 0.000000, 0.555227>, 
      <0.559468, 0.000000, 1.687021>, <0.559468, 0.565897, 1.687021>, <-0.572327, 0.565897, 1.687021>, <-0.572327, 0.000000, 1.687021>, 
      <0.991799, 0.000000, 2.500000>, <0.991799, 0.991799, 2.500000>, <-0.991799, 0.991799, 2.500000>, <-0.991799, 0.000000, 2.500000>
    }
  }
  texture {
    txtDressMRedDull
  }
  scale <1.0, 1.0, 0.714245>
  translate  -3.539632*z
}
#declare LowerArmGrp1 = union {
  sphere { // Elbow1
    <0,0,0>,1
    scale 0.2
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // UpperArm2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.4>
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  rotate <-70.504562, 81.43222, -65.358505>
  translate  <0.9, 0.0, 0.0>
}
#declare UpperArmGrp1 = union {
  sphere { // ShoulderSph1
    <0,0,0>,1
    scale 0.25
    rotate 0.0*y
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // LowerArm1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate <0.0, 90.0, 0.0>
    translate  <0.1, 0.0, 0.0>
  }
  object { LowerArmGrp1 }
  rotate <-5.540554, 45.032906, -31.954571>
  translate  <1.1, -0.1, -1.7>
}
#declare LowerArmGrp2 = union {
  sphere { // Elbow2
    <0,0,0>,1
    scale 0.2
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // UpperArm3
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.58>
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  rotate <27.282116, -37.842335, 96.755783>
  translate  <0.9, 0.0, 0.0>
}
#declare UpperArmGrp2 = union {
  sphere { // ShoulderSph2
    <0,0,0>,1
    scale 0.25
    rotate 0.0*y
    translate  <0.0, 0.0, 0.0>
  }
  cylinder { // LowerArm2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate <0.0, 90.0, 0.0>
    translate  <0.1, 0.0, 0.0>
  }
  object { LowerArmGrp2 }
  rotate <25.711237, -42.325294, 172.247269>
  translate  <-1.1, 0.0, -1.4>
}
#declare Eye1 = union {
  sphere { // EyePupil1
    <0,0,0>,1
    texture {
      txtEyePupilMBlackDull
    }
    scale <0.075524, 0.052112, 0.162947>
    rotate <13.613747, 0.0, 0.0>
    translate  <-0.258015, 0.90148, 0.370702>
  }
  sphere { // EyeBall1
    <0,0,0>,1
    texture {
      txtEyeBallMWhitePlastic
    }
    scale <0.2161, 0.092244, 0.347227>
    rotate <21.691982, -1.407932, 25.330755>
    translate  <-0.3, 0.813145, 0.401923>
  }
}
#declare Eye2 = union {
  sphere { // EyePupil2
    <0,0,0>,1
    texture {
      txtEyePupilMBlackDull
    }
    scale <0.075524, 0.052112, 0.162947>
    rotate <13.613747, 0.0, 0.0>
    translate  <-0.341054, 0.916373, 0.370702>
  }
  sphere { // EyeBall2
    <0,0,0>,1
    texture {
      txtEyeBallMWhitePlastic
    }
    scale <0.2161, 0.092244, 0.347227>
    rotate <23.974964, -1.304342, -30.797327>
    translate  <-0.3, 0.820591, 0.401923>
  }
  translate  0.6*x
}
#declare HeadGrp = union {
  object { EarCSG }
  object { // EarCSG1->EarCSG
    EarCSG
    translate  -1.2*x
  }
  sphere { // HeadSphere
    <0,0,0>,1
  }
  cone { // HeadCone
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.8, 0.575986, 1.026043>
    rotate 62.0*x
    translate  <0.0, 1.509698, -0.731659>
  }
  cylinder { // Wisker1
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <180.0, 80.0, 180.0>
    translate  <0.123397, 1.326923, -0.710305>
  }
  cylinder { // Wisker2
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <-180.0, 78.895782, -180.0>
    translate  <0.071489, 1.379903, -0.710461>
  }
  cylinder { // Wisker3
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <-180.0, 86.699142, -180.0>
    translate  <0.016833, 1.410461, -0.713665>
  }
  cylinder { // Wisker4
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <0.0, 79.583496, 0.0>
    translate  <-1.051061, 1.347581, -0.859529>
  }
  cylinder { // Wisker5
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <0.0, 73.769363, 0.0>
    translate  <-1.006418, 1.387095, -0.96083>
  }
  cylinder { // Wisker6
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 1.0>
    rotate <0.0, 84.761032, 0.0>
    translate  <-1.103888, 1.29792, -0.767516>
  }
  object { Eye1 }
  object { Eye2 }
}
union { // LadyMouse
  superellipsoid { // LadyBase
    <1.0, 0.2>
    texture {
      txtLadyMouseBaseMWhiteDull
    }
    scale <1.5, 1.5, 0.1>
    translate  -4.5*z
  }
  sphere { // Shoulders
    <0,0,0>,1
    texture {
      txtDressMRedDull
    }
    scale <1.1, 1.0, 0.657861>
    translate  -1.5*z
  }
  object { Body }
  object { Boob1 }
  object { // Boob2->Boob1
    Boob1
    texture {
      txtDressMRedDull
    }
    rotate <0.0, 0.0, 0.0>
    translate  <-0.8, 0.0, 0.0>
  }
  sphere { // Waist
    <0,0,0>,1
    texture {
      txtDressMRedDull
    }
    scale <1.1, 1.0, 0.657861>
    translate  -3.8*z
  }
  object { UpperArmGrp1 }
  object { UpperArmGrp2 }
  object { HeadGrp }
  texture {
    txtSkinMAlteredPinkDull
  }
  scale 0.7
  rotate <0.0, 0.0, 90.0>
  translate  <-6.2, 0.0, 9.325>
}


