//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


#declare flare_position = <-7,3.8,0>
#declare flare_type = 4
#declare flare_size = 0.6
#declare flare_brightness = 0.38
#declare flare_spots = false


#include "include\lensflar\lensflar.inc"



#declare StarGlow =
texture {
   pigment { color Clear }
   halo {
      emitting
      linear
      spherical_mapping
      max_value 0.3
      colour_map {
         [0 color Red transmit 1 ]
         [0.1 color Red transmit 0.4 ]
         [0.12 color Red transmit 0.2  ]
         [0.18 color Orange transmit 0.1 ]
      }
      samples 10
   }
}


#declare ElectricBlue =
texture {
    pigment { color Clear }
    halo {
        emitting
        linear
        spherical_mapping
        color_map {
              [ 0.0 color DarkSlateBlue transmit 1 ]
              [ 0.4 color Blue transmit 0.6 ]
              [ 0.5 color Cyan transmit 0.2 ]
              [ 0.65 color White transmit 0.1 ]
              [ 0.8 color White transmit -1 ]
        }
        samples 10
    }
}


#declare RedStarTex =
texture {
    pigment {
        spotted
        color_map {
            [ 0.0  rgb <1,0,0> ]
            [ 0.6  rgb <1,0,0> ]
            [ 0.63 rgb <1,0.3,0.3> ]
            [ 0.66 rgb <1,0.4,0> ]
            [ 0.69 rgb <1,0.35,0.1> ]
            [ 0.72 rgb <1,0.3,0.3> ]
            [ 0.75 rgb <1,0,0> ]
            [ 1.0  rgb <1,0,0> ]
        }
        scale 0.2
    }
    finish {
        ambient 0.5
        diffuse 0.5
    }
    normal {
        spotted
        scale 0.2
    }
}


#declare RedStar =
union {
    sphere {
        <0,0,0>, 1
        texture { StarGlow }
        hollow
        no_shadow
        scale <2.3,2.3,2.3>
    }
    sphere {
        <0,0,0>, 1.5
        texture {  RedStarTex  }
        no_shadow
    }
}

#declare BlueStar =
sphere {
    <0,0,0>, 0.15
    texture { ElectricBlue }
    hollow
    no_shadow
}


#declare StellarPlasma =
texture {
    pigment {
        rgbf<1,1,1,1>
    }
    halo {
        emitting
        linear
        cylindrical_mapping
        turbulence <0.7,0.1,0.7>
        frequency 2
        color_map {
              [ 0.1 color Red transmit 1 ]
              [ 0.2 color NeonPink transmit 0.9 ]
              [ 0.4 color Yellow transmit 0.77 ]
              [ 0.5 color White  transmit 0.55 ]
              [ 0.6 color Yellow transmit 0.75 ]
              [ 0.8 color Orange transmit 0.9  ]
              [ 0.9 color Red transmit 1 ]
        }
        samples 10
    }
}


#declare StellarDisk =
cylinder {                          // accretion disk of binary star system
    <0,-1,0>, <0,1,0>, 1
    texture {  StellarPlasma  }
    hollow
    no_shadow
    scale <2.1,0.05,1.4>
}


union {                                     // binary star system
    object {
        RedStar
        scale <0.5,0.5,0.5>
        translate flare_position
        translate <1.8,0,0>
    }
    object {
        BlueStar
        translate flare_position
    }
    object {
        StellarDisk
        rotate <-21,0,0>
        translate flare_position
        translate <1.4,0,0>
    }
}


