//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


#declare ConnectTex =
texture {
    pigment {
        color DarkGreen*0.25 + LimeGreen*0.25 + Goldenrod*0.3 + Yellow*0.2
    }
    finish {
        ambient .2
        diffuse .6
        reflection .2
        metallic
    }
}


#declare RedConnectTex =
texture {
    pigment { Red }
    finish {
        Shiny
        metallic
    }
}


#declare BoardBaseTex =
texture {
    pigment {
        color DarkGreen*0.75 + Goldenrod*0.1 + ForestGreen*0.15
    }
    finish {
        ambient .3
        diffuse .7
        roughness .01
    }
}


#declare BoardTex =
texture {
    material_map {
        gif "board.gif"
        once
        texture { BoardBaseTex }
        texture { RedConnectTex }
        texture { pigment { Blue } }
        texture { pigment { Blue } }
        texture { ConnectTex }
        texture { pigment { Blue } }
        texture { pigment { Blue } }
        texture { Soft_Silver }
    }
    rotate <-90,0,0>
}


difference {                                    // electronic board
    polygon {
        5,
        <0,0,0>, <0,0,-1>, <1,0,-1>, <1,0,0>, <0,0,0>
        texture {  BoardTex  }
        scale <7,1,10>
    }
    box {
        <-0.1,-0.5,0.1>, <0.5,0.5,-7.2>
    }
}



#declare GoldenConnector =
box {
    <-0.1,-0.02,-0.08>, <0.5,0.02,0.08>
    texture { T_Gold_1A }
}


object {                                    // golden board connectors
    GoldenConnector
    translate <0,0,-7.6>
}

object {
    GoldenConnector
    translate <0,0,-8>
}

object {
    GoldenConnector
    translate <0,0,-8.4>
}

object {
    GoldenConnector
    translate <0,0,-8.8>
}

object {
    GoldenConnector
    translate <0,0,-9.35>
}

object {
    GoldenConnector
    translate <0,0,-9.75>
}



