//-----------------------------------------------------------------------------
//  Include file for MPHY184.POV
//  Image: "Realms of Physics"
//  June 1997
//-----------------------------------------------------------------------------


//--------------------------- starry background -------------------------------

#declare NStarfield =
texture {
    pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.3,.3,.1> color rgb <.6,.6,.3> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.1,.1,.1> color rgb <.2,.2,.3> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.3,.3,.3> color rgb < .8, .8, .8> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .5
    }
    finish { diffuse 0 ambient 1 }
}


plane {
    z, 10
    texture {
        NStarfield
    }
    hollow
}


#declare Nb1 =
texture {
    pigment {
        bozo
        turbulence <1.5,0.5,1>
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.15 color rgb <1,0.1,0.1> transmit 0.55
                       color Red transmit 0.65 ]
            [0.15, 0.4 color Red transmit 0.65
                       color NeonPink transmit 0.75 ]
            [0.4, 0.55 color NeonPink transmit 0.75
                       color Red transmit 0.85 ]
            [0.55, 0.6 color Violet transmit 0.85
                       color Violet transmit 1 ]
            [0.6, 1.0  color Clear transmit 1
                       color Clear transmit 1 ]
        }
        scale <1, 0.3, 10>
    }
    finish {
        ambient 0.6
        diffuse 0.4
        specular 0
    }
}


#declare nebulosity =
intersection {
    plane {
        z, 9
    }
    box {
        <-100,-3,9-Eps>, <100,1,9+Eps>
    }
    texture {
        Nb1
        scale <10,3,3>
        rotate <0,23,0>
    }
}


object {
    nebulosity
    rotate <0,0,7>
    translate <-1,-2.5,0>
}


