#declare unit_radius = 1.15
#declare height = 4.5
#declare size = 1.35

/****** Left hand mirror ******/
#declare lmirror =
box { <-10,0,0>, <100,100,10>
	texture {
		pigment { color Blue }
		finish { reflection 0.3	}
	}
	rotate y*28
	translate z*30
}


/****** Right hand mirror ******/
#declare rmirror =
box { <10,0,0>, <-100,100,10>
	texture {
		pigment { color Blue }
		finish { reflection 0.3	}
	}
	rotate y*-28
	translate z*30
}


/****** Red plane behind camera ******/
#declare backing =
plane { <0,0,1>, -50
	pigment { color Red }
}


/****** Grating on floor ******/
#declare grating = union {
#declare startx = -15
#declare stopx = 30
#declare number = 15

#declare dist = stopx - startx
#declare Count = 0

#while (Count < dist)

	//#debug concat( "X-Coord: ", str((Count+startx),0,-1), "\n" )

  cylinder { <(Count+startx), -0.25, -10>, <(Count+startx), -0.25, 100>, 0.25
		pigment { color rgb< 0.2, 0.2, 0.2 > }
	}

	cylinder { <20, -0.25, (Count+startx)>, <-20, -0.25, (Count+startx)>, 0.25
		pigment { color rgb< 0.2, 0.2, 0.2 > }
	}

  #declare Count = Count + (dist/number) // increment our counter
#end
}


/****** Gold magnet ******/
#declare magnet =
cylinder { <0,0,0>, <0,1,0>, unit_radius
	rotate <-45,0,80>
	translate y*height
	scale size
	texture { Magnet_tex }
}


/****** Superconductor slab ******/
#declare superconductor =
box { <3.5,2,3.5>, <-3.5,0,-3.5>
	texture { Super_tex }
}


/****** Liquid nitrogen canister ******/
#declare canister = union {
torus { 5, 1
	translate y*1
}
cylinder { <0, 1, 0>, <0, 20, 0>, 6 }
texture {
	pigment { color White }
}
texture {
	pigment {
		image_map {
			tga "warning.tga"
			map_type 2
			once
		}
	}
	scale 4
	translate y*5
}
rotate y*-45
translate <13, 0, 8>
}

/****** Wood Rod ******/
#declare rod = union {
cylinder { <0,0,0>, <30,0,0>, 0.25 }
torus { 0.2, 0.05
	rotate z*90
}
torus { 0.2, 0.05
	rotate z*90
	translate x*30
}
cylinder { <-0.1,0,0>, <30.1,0,0>, 0.2 }
texture { Yellow_Pine
	rotate y*90
	scale 0.5
}
translate <1,3.15,0>
rotate <0,180,-13>
}




