
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "mytex.inc"
#include "objects.inc"

#declare fogswitch = 1

camera
{
	location  <0.0 , 7.0 ,-15.0>
  look_at   <0.0 , 4.0 , 0.0>
}

object { lmirror }
object { rmirror }
object { backing }
object { magnet }
object { superconductor }
object { grating }
object { canister }
object { rod }

/****** Liquid nitrogen frost ******/
#if (fogswitch = 1)
fog {
	distance 1
//	colour rgbf<0.2, 0.5, 0.86, 1.0>
	colour rgbt<0.2, 0.5, 0.86, 0.15>
	fog_type 2
	fog_offset 1
	fog_alt 0.75
	turbulence 1
	turb_depth 0.9
	octaves 10
	lambda 7
	omega 0.2
}
#end


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-15, 15, -40>
}
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <30, 15, -40>
}
