background {color rgb <.9,.95,1>}

camera{
// location <0,80,-100>*8
location <0,0,-380>
rotate x*-30
// location <0,0,-150>
   angle 30
   look_at <0,0,0>
   blur_samples 10
    aperture 1
    focal_point <0,0,0>

}

light_source{ <-500,500,-500>
   color rgb <1,1,1>
}

light_source{ <450,-200,-500> *.2
color rgb <1,.2,.15>
spotlight
point_at <0,0,0>
tightness 1
falloff 60
radius 10
fade_power 1
fade_distance 500 *.2
}

light_source{ <450,-240,-500> *.2
color rgb <1,.87,.75>
spotlight
point_at <0,-45,0>
tightness 1
falloff 10
radius 3
fade_power 1
fade_distance 400 *.1
}

light_source{ <60,0,0>
color rgb <1,.2,.15>
spotlight
point_at <90,0,-40>
tightness 1
falloff 70
radius 15
fade_power 1
fade_distance 50
}

#declare TEX=
texture{
   finish { ambient <.7,.8,0.9>*.35 diffuse 0.9 phong .1}
   normal {bumps .4 scale <2,.5,2>}
   pigment{color rgb <.95,.88,0.8>}
}

#declare HEX_T01=.5
#declare HEX_R01=10
#declare HEX_L01=HEX_R01*sin(pi/6)
#declare HEX_D01=40
#declare HEX_N00=3  //do not change this
#declare HEX_N01=HEX_N00   //n
#declare HEX_N0A=7
#declare HEX_N02=HEX_N0A  //n+1
#declare HEX_N0B=7
#declare HEX_N03=HEX_N0B   //n


#declare HEX01=
union{
#while (HEX_N03>0)
#if(sin(pi/2*HEX_N03)=0)
   #declare HEX_N02=HEX_N0A
   #declare HEX_NAA=1
#else
   #declare HEX_N02=HEX_N0A-1
   #declare HEX_NAA=0
#end
union{
#while(HEX_N02>=0)
#if(HEX_N03=HEX_N0B)
   #if(HEX_N02=0)
      #declare HEX_N01=6
      #declare HEX_A01=0
   #else
      #declare HEX_N01=5
      #declare HEX_A01=0
   #end
#else
   #if(HEX_NAA=1)
      #if(HEX_N02=HEX_N0A)
         #declare HEX_N01=5
         #declare HEX_A01=0
      #else
         #if(HEX_N02=0)
            #declare HEX_N01=5
            #declare HEX_A01=-120
         #else
            #declare HEX_N01=HEX_N00
            #declare HEX_A01=0
         #end
      #end
   #else
      #if(HEX_N02=0)
         #declare HEX_N01=5
         #declare HEX_A01=-120
      #else
         #declare HEX_N01=HEX_N00
         #declare HEX_A01=0
      #end
   #end
#end
   union{
   #while(HEX_N01>0)
      box{<HEX_T01*-1,HEX_L01*-1,0><HEX_T01,HEX_L01,HEX_D01>
         translate x*HEX_R01*cos(pi/6)
         rotate z*60*HEX_N01
         rotate z*HEX_A01}
      #if(HEX_N01>1)
         cylinder{<0,0,0><0,0,HEX_D01>HEX_T01
            translate x*HEX_R01
            rotate z*-30
            rotate z*60*HEX_N01
            rotate z*HEX_A01}
      #else
      #end
      #declare HEX_N01=HEX_N01-1
   #end
   translate x*HEX_R01*cos(pi/6)*HEX_N02*-2
   }
#declare HEX_N02=HEX_N02-1
#end
#if(sin(pi/2*HEX_N03)=0)
   translate x*HEX_R01*cos(pi/6)*1
#else
#end
translate y*HEX_R01*sin(pi/6)*-3*(HEX_N03)
texture{TEX}
}
#declare HEX_N03=HEX_N03-1
#end
translate <HEX_R01*cos(pi/6)*(HEX_N0A-1),HEX_R01*sin(pi/3)*HEX_N0B,0>
}

#declare NEST01=
union{
julia_fractal {
    <-.08,0.2,-0.3,-0.6>
    quaternion
    sqr
    max_iteration 10
 //   precision
 scale <60,55,55>
 rotate z*-90
texture{TEX}}

julia_fractal {
    <-.1,0.5,-0.5,-0.01>
    quaternion
    sqr
    max_iteration 8
 //   precision
 scale <80,50,50>*.5
 rotate z*-90
 translate y*40
texture{TEX}}
}

#declare NEST00=
union{
object{NEST01}
object{HEX01  rotate z*10 scale .28 rotate x*-60 translate <-3,-43,3>}
}

object{NEST00}

#declare WSP_RND=seed(0)
#include "wasp_n.pov"
object {WASP00_f scale .8 rotate <35,20,0> translate <-20,-40,-100>}

#declare WSP_RND=seed(100)
#include "wasp_n.pov"
object {WASP00_f scale .8 rotate <20,-15,-10> translate <10,-50,-150>}

#declare WSP_RND=seed(20)
#include "wasp_n.pov"
object {WASP00_f scale .8 rotate <10,-35,90> translate <40,-62,-55>}

#declare WSP_RND=seed(50)
#include "wasp_n.pov"
object {WASP00_f scale .8
    rotate x*130
    rotate y*160
    translate <-30,-52,45>}

#declare WSP_RND=seed(370)
#include "wasp_n.pov"
object {WASP00_s scale .79 rotate x*-90 rotate y*-35 translate <-3,-45,3>}

#declare WSP_RND=seed(562)
#include "wasp_n.pov"
object {WASP00_s scale .8 rotate x*-90 rotate y*-146  rotate x*15 translate <-15,-43.5,-23>}

#declare WSP_RND=seed(139)
#include "wasp_n.pov"
object {WASP00_s scale .77 rotate z*180 rotate x*-7 rotate y*-39 translate <24.,-13,-24.2>}

// #declare WSP_RND=seed(472)
#include "wasp_n.pov"
object {WASP00_i scale .75 rotate z*180 rotate y*12 translate <10.5,-42,10.5>}

#declare WSP_RND=seed(121)
#include "wasp_n.pov"
object {WASP00_f1 scale .8 rotate z*180 rotate <60,-40,33> translate <38,-73,-160>}

#declare WSP_RND=seed(424)
#include "wasp_n.pov"
object {WASP00_f1 scale .8 rotate <61,38,32> translate <-37,-65,-161>}

#include "talo01.inc"
object {talo scale 2 rotate y*-25  rotate x*-40 translate<-900,2050,4000>}
object {SMOKE01 scale 2 rotate y*-25  rotate x*-40 translate<-900,2050,4000>}

fog{
   fog_type 1
   distance 10000
   turbulence 1
   color <.8,.9,1>*.9
}

#declare ST001=
height_field
{
  gif
  "stone01.gif" scale <36,5,24>
   smooth
}
#declare ST002=
union{
   //object {ST001}
   object {ST001 rotate z*90 translate y*-36}
   box{<-0.0001,0.0001,-0.0001><36.0001,-36.0001,24.0001>}
   rotate x*90
}

union{
   object {ST002}
   object {ST002 translate y*24}
   object {ST002 translate y*24*2}
   object {ST002 translate y*24*3}
   //box{<10,24*3,-36><-100,24*4,0>}
      scale 2
      translate x*70
      //rotate z*-7
      rotate x*-30
      translate <20,-50,30>
      texture{TEX}
   }
