/*
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include"NewcoTex.inc"

global_settings
{
  assumed_gamma 1.0
}

//----------CAMERA
camera
{
  location  <62 , 425.0 ,-380.0>
  angle 45
  look_at   <62.0 ,125.0 , -50.0>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <400, 400, -400>
  shadowless
}
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}
#declare LargPuits=80
#declare PosPuits=<111,0,13>
// ----------------------------------------
*/
#declare P_Champ=
	pigment{
		bozo
		color_map{
		[0 rgb<0,0.35,0>]
		[0.5 rgb<0,0.4,0>]
		[1 rgb<0.15,0.5,0>]
		}
		scale 5
	}

#declare P_dalles=
pigment{bozo
        color_map{
                  [0 rgb<0.25,0.25,0.35>]
                  [1 rgb<0.27,0.27,0.35>]
        }
}


#declare OSol=<-111.5,0,-100>

#declare Sol=
union{


#declare R1=seed(0)
#declare R2=seed(1255)
#declare L_Dalle=0.95
#declare L_Mortier=(1-L_Dalle)/2

#declare zi=0.5 #while (zi<=14)
#declare xi=0.25 #while (xi<=35)
#declare Ech=15


     #if (((xi+.5+mod(zi,2)/2)*Ech+OSol.x>PosPuits.x)*((xi+mod(zi,2)/2-.5)*Ech+OSol.x<PosPuits.x+LargPuits)
     *((zi-.5)*Ech+OSol.z<PosPuits.z)*((zi+.5)*Ech+OSol.z>PosPuits.z-LargPuits)
     =0)

     superellipsoid { <0.3+rand(R1)/5, 0.01+rand(R2)/5>
         scale <L_Dalle/2, .05, L_Dalle/2>
          translate<xi+mod(zi,2)/2,0,zi>
          pigment{
                 P_dalles
                 translate y*rand(R1)*10
         }
     }
     #else
      #if ((xi+mod(zi,2)/2)*Ech+OSol.x<=PosPuits.x)//test si manque demidalle sur le bord en -x
        superellipsoid { <0.3+rand(R1)/5, 0.01+rand(R2)/5>
              scale <L_Dalle/4, .05, L_Dalle/2>
              translate<xi+mod(zi,2)/2-.25,0,zi>
              pigment{
                 P_dalles
                 translate y*rand(R1)*10
              }
         }
       #end
       #if ((xi+1+mod(zi,2)/2)*Ech+OSol.x>=PosPuits.x+LargPuits)//test si manque demidalle sur le bord en +x
         superellipsoid { <0.3+rand(R1)/5, 0.01+rand(R2)/5>
               scale <L_Dalle/4, .05, L_Dalle/2>
               translate<xi+mod(zi,2)/2+1.25,0,zi>
               pigment{
                  P_dalles
                  translate y*rand(R1)*10
               }

         }
       #end
     #end
#declare xi=xi+1 #end
#declare zi=zi+1 #end
}


 object{Sol scale Ech translate OSol}

//-------SOL------------

difference{
           union{
           plane{y,-1 pigment{P_Champ}}//sol exterieur
           box{<-94,-101,-400>,<300,.03,74> pigment{Gray20}}//mortier
           }
           box{PosPuits+y*1,PosPuits+<LargPuits,-100,-LargPuits>
            pigment{crackle
                color_map{
                [0 color rgb <0.3,0.3,0.3>]
                [0.07 color rgb <0.3,0.3,0.3>]
                [0.07 color rgbf<0.4,0.4,0.4,0>]
                [1  color rgbf<0.5,0.5,0.5,0>]
                }
                scale 10
             }

           }//puits
 }

//--------PUITS----------
#declare Montant=
cylinder{y*-150,0,5
          texture{T_Charp rotate z*90}
}
#declare Rondin=
cylinder{0,x*(LargPuits-20),5
        texture{T_Charp rotate y*90}
}

object{Montant translate PosPuits+<5,0,-5>}
object{Montant translate PosPuits+<5,0,-LargPuits+5>}
object{Montant translate PosPuits+<LargPuits-5,0,-5>}
object{Montant translate PosPuits+<LargPuits-5,0,-LargPuits+5>}

#declare i=0 #while (i<=4)
object{Rondin
             translate PosPuits+<10,-5+i*-10,-5>
}
object{Rondin
             rotate y*90
             translate PosPuits+<5,-5+i*-10,-10>
}
object{Rondin
             rotate y*90
             translate PosPuits+<LargPuits-5,-5+i*-10,-10>
}
object{Rondin
             translate PosPuits+<10,-5+i*-10,-LargPuits+5>
}

#declare i=i+1 #end
