
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//
#include "Hand.inc"
/*
#version 3

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <-10, 40, -140.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-10, 40.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 400, -400>
}

// ----------------------------------------
plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}
*/
#declare C_BleueT=pigment{rgbt<.3,.3,1,0.75>}
#declare C_Bleue=pigment{rgb<.3,.3,1>}




// create a smooth blobby shape
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density

#declare Corps=
blob
{
  threshold .5625//=(1-.5^2)^2
  cylinder{y*0,y*40,10 ,StrengthVal }
  cylinder{y*13,y*20,12 ,StrengthVal}
  cylinder{<0,21,0>,<20,19,0>,5,StrengthVal}//bras gauche
  sphere{<15,23,0>,4,1}//bicep gauche
  cylinder{<21,19,0>,<21,25,0>,4,StrengthVal}//avant bras gauche
  cylinder{<0,20,0>,<-21,19,0>,5,StrengthVal}//bras droit
  sphere{<-15,23,0>,4,1}//bicep droit
  cylinder{<-21,19,0>,<-21,25,0>,4,StrengthVal}//avant bras droit
  sphere { y*40,34,StrengthVal }
  sphere{<0,35,-20>,5, StrengthVal pigment{C_Bleue}}//nez
  // [sturm]
}


#declare Genie=
merge{
   //variables de la queue
   #declare Nb=36
   #declare VI=<0,0,0>//vecteur initial
   #declare D=VI//vecteur de dpart
   #declare R1=6
   #declare R2=70
   #declare Dev=8//dnivel par tour
   #declare DevF=20//denivel final
   #declare Gross=2
   #include "queue.inc"
   object{Queue}
   merge{
    object{Corps
             texture{pigment{C_BleueT}}
    }//fin Corps
    intersection{//partie avec logo
         object{Corps}
         box{<-7,8,-15>,<7,22,0>}
             //texture{pigment{C_BleueT}}
             texture{
                 pigment{
                   image_map{
                        gif "atmos.gif"
                        filter 15,1
                        map_type 0
                        once
                   }
                   translate<-.5,-.5,0>
                   scale<14,14,1>
                   translate y*15
                }
             }
             translate z*-.05
      }//fin intersection Corps

      #declare Oeuil=
      sphere{0,1  scale <3,4,3>
                pigment{wood
                        color_map{
                          [0.4 rgb 0]
                          [0.4 rgb 1]
                        }
                        ramp_wave
                  scale 4.1
                }
       }//fin declare Oeuil
       object{Oeuil   translate<-5,41,-17>}//droit
       object{Oeuil   translate<5,41,-17>}//gauche

      union{//levres
           torus{12,1}
           torus{12,1 rotate x*-5}
           translate z*12 rotate x*-45 translate<0,30,-13.5>
           pigment{rgb<0.25,0,0>}
           clipped_by{object{Corps inverse}}
       }
       object{Main scale <-1.2,1.2,1.2> rotate y*90 rotate z*-90 translate<21,25,0>}
       object{Main scale 1.2 rotate y*-90 rotate z*90 translate<-21,25,0>}
       rotate y*-10
       translate <-R2/2,2+1.5*Dev+DevF,0> 
   }

pigment{C_BleueT}
no_shadow
}//fin Genie


#declare Corps2=
blob
{
  threshold .5625//=(1-.5^2)^2
  cylinder{y*0,y*35,15 ,StrengthVal }
  cylinder{y*21,y*22,20 ,StrengthVal  scale<1.3,1,0.8>}//ventre
  cylinder{<0,31,0>,<19,40,0>,5,StrengthVal}//bras gauche
  sphere{<14,39,0>,4,1}//bicep gauche
  cylinder{<19,40,0>,<19,45,0>,4,StrengthVal}//avant bras gauche
  sphere{<19,40,0>,4,-StrengthVal}
  cylinder{<0,31,0>,<-19,40,0>,5,StrengthVal}//bras droit
  sphere{<-14,39,0>,4,1}//bicep droit
  cylinder{<-19,40,0>,<-19,45,0>,4,StrengthVal}//avant bras droit
   sphere{<-19,40,0>,4,-StrengthVal}
  sphere { y*50,30,StrengthVal }//tte
  sphere{<0,48,-18>,5, StrengthVal pigment{rgb<1,0,0>}}//nez
  // [sturm]
}



#declare Genie2=
merge{
   #declare Nb=36
   #declare VI=<0,0,0>//vecteur initial
   #declare D=VI//vecteur de dpart
   #declare R1=6
   #declare R2=0
   #declare Dev=22//dnivel par tour
   #declare DevF=10.5//denivel final
   #declare Gross=15/5
   #include "queue.inc"
   object{Queue  rotate y*90}
   merge{
      object{Corps2 }
       intersection{//partie avec logo
         object{Corps2}
         box{<-7,15,-15>,<7,30,0>}
             //texture{pigment{rgbt<1,0,0,.75>}}
             texture{
                 pigment{
                   image_map{
                        gif "steam.gif"
                        filter 15,1
                        map_type 0
                        once
                   }
                   translate<-.5,-.5,0>
                   scale<25,25,1>
                   translate y*25
                }
             }
             translate z*-.05
      }//fin intersection Corps

      sphere{0,3 pigment{rgb 1} scale <1,1.25,1> translate<-5,52,-15>}//blanc de l"oeil droit
      sphere{<-5,52,-18>,1.5 pigment{rgb 0}}//pupille
      sphere{0,3 pigment{rgb 1} scale <1,1.25,1> translate<5,52,-15>}
      sphere{<5,52,-18>,1.5 pigment{rgb 0}}//pupille
      union{//levres
           torus{10,1}
           torus{10,1 rotate x*-5}
           translate z*10 rotate x*-35 translate<0,43,-16>
           pigment{rgb<0,0,0.25>}
           clipped_by{object{Corps inverse}}
       }
       object{Main scale <-1,1.3,1.3> rotate y*90 rotate z*-90 translate<19,45,0>}
       object{Main scale <1,1.3,1.3> rotate y*-90 rotate z*90 translate<-19,45,0>}
       translate <-R2/2,2+1.5*Dev+DevF,0>
   }
   no_shadow
}
//object{Genie scale 1 }
//cylinder{0,y*55,11 pigment{rgbt<1,1,1,.9>}}
