//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 40 textures and 158 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 06/24/1997    (24.06.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  /*radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }*/
}

//background { color <0.500,0.700,0.900> }

camera {  //  Camera Camera01
  location  <-4.932, -21.003, 2.483>
  direction <0.0,     0.0,  1.9067>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-3.160, 0.691, 1.000>
}

// *******  L I G H T S *******
/*light_source {   // Light001
  <-5.653, -13.946, 13.548>
  color rgb <1.780, 1.600, 1.537>
  atmosphere off
}*/

light_source { // AreaL001
  <-5.654, -13.951, 13.557>
  color  rgb<0.973, 0.918, 0.824>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  atmosphere off
}



// ********  TEXTURES  *******
//

#include "atl9.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******





#declare HgtFld001 = object {
  height_field {
    tga "C:\TEMPLE\IMAGE6.TGA"
    water_level 0.133
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TherHFTex
  }
  scale <2.5, 2.354167, 2.5>
  rotate <177.625031, 0.0, 180.0>
  translate  <-3.230434, -6.679405, -1.410989>
}
difference { // PythHgtFld
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      Sand1Tex1
    }
    scale <150.0, 78.894577, 19.641748>
    translate  <-0.472114, 5.863545, -20.395988>
  }
  object { HgtFld001 }
}


cone { // ConeTrunk001
  <0,0,0>, 0.0, <0,0,1>, 1.5
  texture {
    MastTex
  }
  scale <0.05, 0.05, 5.5>
  rotate -180.0*x
  translate  <-6.8, -2.4, 4.0>
}


#declare PedDecoration1 = union {
  box { // PedDecoLft1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035265, 1.194196, 0.680515>
    rotate 70.0*y
    translate  <-0.614712, 0.0, -0.019165>
  }
  box { // PedDecoRt1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035265, 1.194196, 0.680515>
    rotate -70.0*y
    translate  <0.624574, 0.0, -0.021985>
  }
  box { // PedDecoBottom3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.029373, 1.194196, 1.081044>
    rotate -90.0*y
    translate  <-0.010608, 0.0, -0.209802>
  }
  box { // Frieze1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.048062, 1.115651, 1.319578>
    rotate -90.0*y
    translate  <0.011206, 0.0, -0.340657>
  }
  box { // PedDecoBottom4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.046173, 1.115651, 1.299451>
    rotate -90.0*y
    translate  <0.018793, 0.0, -0.369407>
  }
  box { // PedDecoBottom5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.020973, 1.115651, 1.28265>
    rotate -90.0*y
    translate  <0.018793, 0.0, -0.436609>
  }
  texture {
    colunmTex
  }
}
#declare Roof2 = union {
  box { // RtRoof3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.42468, 1.121218>
    rotate -70.0*y
    translate  <1.217532, 0.0, 0.853456>
  }
  box { // RtRoof4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.42468, 1.121218>
    rotate 70.0*y
    translate  <-0.937785, 0.0, 0.96478>
  }
}
#declare PegimDiff1 = difference {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.217605, 1.0, 0.569454>
    translate  <-0.013349, 0.0, 0.348759>
  }
  object { Roof2 }
  texture {
    TempleTex
  }
  scale <1.0, 1.16, 1.0>
}
#declare Roof3 = union {
  box { // RoofBase1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.311653, 1.0, 0.031586>
    translate  -0.262005*z
  }
  box { // LftRoof1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 1.0, 0.7>
    rotate 70.0*y
    translate  -0.65568*x
  }
  box { // RtRoof5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 1.0, 0.7>
    rotate -70.0*y
    translate  0.65568*x
  }
  texture {
    TempleTex
  }
  scale <1.02313, 1.208172, 1.0>
}
#declare TempleTop1 = union {
  object { PedDecoration1 }
  object { PegimDiff1 }
  object { Roof3 }
  translate  <-0.021918, 0.0, 1.26305>
}
#declare Stairs1 = difference {
  box { // Floor1
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.35, -1.442924, -0.214775>
    rotate -180.0*z
    translate  <-0.032126, -0.193799, -0.71>
  }
  box { // BottomSt1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065071, 0.347374, 1.156054>
    rotate -90.0*y
    translate  <-0.029552, -1.88896, -0.851199>
  }
  box { // Stair3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047248, 0.347374, 1.160062>
    rotate -90.0*y
    translate  <-0.029552, -1.81204, -0.748076>
  }
  box { // Stair4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.059272, 0.347374, 1.156054>
    rotate -90.0*y
    translate  <-0.029552, -1.710684, -0.644877>
  }
  box { // StairTop1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.475589, 0.522467, 1.349194>
    rotate -90.0*y
    translate  <-0.021725, -1.649073, -0.531198>
  }
  texture {
    TempleTex
  }
}
#declare FrontColumns1 = union {
  cylinder { // ColFarleft1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.183041, -1.594988, -0.491065>
  }
  cylinder { // ColMidRt1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <0.408498, -1.594519, -0.491065>
  }
  cylinder { // ColMidleft1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-0.44371, -1.594988, -0.491065>
  }
  cylinder { // ColFarRt1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.149318, -1.596894, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare RtSideColumns1 = union {
  cylinder { // ColRtSideFron2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -1.091319, -0.491065>
  }
  cylinder { // ColRtSide6
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -0.573804, -0.500559>
  }
  cylinder { // ColRtSide7
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -0.026426, -0.491065>
  }
  cylinder { // ColRtSide8
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.137146, 0.51819, -0.491065>
  }
  cylinder { // ColRtSide9
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, 1.064188, -0.500559>
  }
  cylinder { // ColRtSideBack1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.129033, 1.583398, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare LfSideColumns1 = union {
  cylinder { // ColLfSideFron2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -1.091319, -0.491065>
  }
  cylinder { // ColLfSide4
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -0.564619, -0.500559>
  }
  cylinder { // ColLfSide6
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -0.026426, -0.491065>
  }
  cylinder { // ColLftSide5
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.205151, 0.527376, -0.491065>
  }
  cylinder { // ColLfSide7
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.21668, 1.056971, -0.500559>
  }
  cylinder { // ColLfSideBack1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.209155, 1.598397, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare BackColumns1 = union {
  cylinder { // ColFarleft3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.183041, -1.594988, -0.491065>
  }
  cylinder { // ColMidRt3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <0.408498, -1.594519, -0.491065>
  }
  cylinder { // ColMidleft3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-0.44371, -1.594988, -0.491065>
  }
  cylinder { // ColFarRt3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.149318, -1.596894, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
  translate  <-0.033415, 2.12038, 0.0>
}
union { // Temple1
  object { TempleTop1 }
  object { Stairs1 }
  object { FrontColumns1 }
  object { RtSideColumns1 }
  object { LfSideColumns1 }
  object { BackColumns1 }
  scale <2.0, 3.0, 2.0>
  rotate 49.901672*z
  translate  <-48.037384, 239.634843, 7.779089>
}


object {   // HgtFld002
  height_field {
    tga "C:\TEMPLE\WORLD.TGA"
    water_level 0.333
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    MountTex
  }
  scale <500.830078, 47.665863, 30.900352>
  translate  <-62.597372, 252.817266, 5.971126>
}


cylinder { // Cylndr001
  <0,0,1>, <0,0,0>, 1
  texture {
    GroundTex1
  }
  scale <-0.292474, -93.736847, -419.39978>
  rotate -90.0*y
  translate  <-217.040947, -60.427464, -1.671064>
}


sphere { // Sphere001
  <0,0,0>,1
  texture {
    MoonTex
  }
  no_shadow
  scale <1.0, 0.01, 1.0>
  translate  <10.557823, 29.677667, 10.214006>
}


plane { // WaterPlane
  z,0
  texture {
    WaterTex
  }
  translate  <-0.700686, 0.0, -1.858352>
}


#declare PedDecoration = union {
  box { // PedDecoLft
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035265, 1.194196, 0.680515>
    rotate 70.0*y
    translate  <-0.614712, 0.0, -0.019165>
  }
  box { // PedDecoRt
    <-1, -1, -1>, <1, 1, 1>
    scale <0.035265, 1.194196, 0.680515>
    rotate -70.0*y
    translate  <0.624574, 0.0, -0.021985>
  }
  box { // PedDecoBottom
    <-1, -1, -1>, <1, 1, 1>
    scale <0.029373, 1.194196, 1.081044>
    rotate -90.0*y
    translate  <-0.010608, 0.0, -0.209802>
  }
  box { // Frieze
    <-1, -1, -1>, <1, 1, 1>
    scale <0.048062, 1.115651, 1.319578>
    rotate -90.0*y
    translate  <0.011206, 0.0, -0.340657>
  }
  box { // PedDecoBottom1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.046173, 1.115651, 1.299451>
    rotate -90.0*y
    translate  <0.018793, 0.0, -0.369407>
  }
  box { // PedDecoBottom2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.020973, 1.115651, 1.28265>
    rotate -90.0*y
    translate  <0.018793, 0.0, -0.436609>
  }
  texture {
    colunmTex
  }
}
#declare Roof1 = union {
  box { // RtRoof1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.42468, 1.121218>
    rotate -70.0*y
    translate  <1.217532, 0.0, 0.853456>
  }
  box { // RtRoof2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.42468, 1.121218>
    rotate 70.0*y
    translate  <-0.937785, 0.0, 0.96478>
  }
}
#declare PegimDiff = difference {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.217605, 1.0, 0.569454>
    translate  <-0.013349, 0.0, 0.348759>
  }
  object { Roof1 }
  texture {
    TempleTex
  }
  scale <1.0, 1.16, 1.0>
}
#declare Roof = union {
  box { // RoofBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.311653, 1.0, 0.031586>
    translate  -0.262005*z
  }
  box { // LftRoof
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 1.0, 0.7>
    rotate 70.0*y
    translate  -0.65568*x
  }
  box { // RtRoof
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 1.0, 0.7>
    rotate -70.0*y
    translate  0.65568*x
  }
  texture {
    TempleTex
  }
  scale <1.02313, 1.208172, 1.0>
}
#declare TempleTop = union {
  object { PedDecoration }
  object { PegimDiff }
  object { Roof }
  translate  <-0.021918, 0.0, 1.26305>
}
#declare Stairs = difference {
  box { // Floor
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.35, -1.442924, -0.214775>
    rotate -180.0*z
    translate  <-0.032126, -0.193799, -0.71>
  }
  box { // BottomSt
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065071, 0.347374, 1.156054>
    rotate -90.0*y
    translate  <-0.029552, -1.88896, -0.851199>
  }
  box { // Stair1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047248, 0.347374, 1.160062>
    rotate -90.0*y
    translate  <-0.029552, -1.81204, -0.748076>
  }
  box { // Stair2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.059272, 0.347374, 1.156054>
    rotate -90.0*y
    translate  <-0.029552, -1.710684, -0.644877>
  }
  box { // StairTop
    <-1, -1, -1>, <1, 1, 1>
    scale <0.475589, 0.522467, 1.349194>
    rotate -90.0*y
    translate  <-0.021725, -1.649073, -0.531198>
  }
  texture {
    TempleTex
  }
}
#declare FrontColumns = union {
  cylinder { // ColFarleft
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.183041, -1.594988, -0.491065>
  }
  cylinder { // ColMidRt
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <0.408498, -1.594519, -0.491065>
  }
  cylinder { // ColMidleft
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-0.44371, -1.594988, -0.491065>
  }
  cylinder { // ColFarRt
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.149318, -1.596894, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare RtSideColumns = union {
  cylinder { // ColRtSideFront1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -1.091319, -0.491065>
  }
  cylinder { // ColRtSide2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -0.573804, -0.500559>
  }
  cylinder { // ColRtSide3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, -0.026426, -0.491065>
  }
  cylinder { // ColRtSide4
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.137146, 0.51819, -0.491065>
  }
  cylinder { // ColRtSide5
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.145259, 1.064188, -0.500559>
  }
  cylinder { // ColRtSideBack
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.129033, 1.583398, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare LfSideColumns = union {
  cylinder { // ColLfSideFron1
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -1.091319, -0.491065>
  }
  cylinder { // ColLfSide2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -0.564619, -0.500559>
  }
  cylinder { // ColLfSide3
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.206223, -0.026426, -0.491065>
  }
  cylinder { // ColLftSide4
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.205151, 0.527376, -0.491065>
  }
  cylinder { // ColLfSide5
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.21668, 1.056971, -0.500559>
  }
  cylinder { // ColLfSideBack
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.209155, 1.598397, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
}
#declare BackColumns = union {
  cylinder { // ColFarleft2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-1.183041, -1.594988, -0.491065>
  }
  cylinder { // ColMidRt2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <0.408498, -1.594519, -0.491065>
  }
  cylinder { // ColMidleft2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <-0.44371, -1.594988, -0.491065>
  }
  cylinder { // ColFarRt2
    <0,0,1>, <0,0,0>, 1
    scale <0.075, 0.075, 1.3>
    translate  <1.149318, -1.596894, -0.491065>
  }
  texture {
    colunmTex
  }
  scale <1.0, 0.666667, 1.0>
  translate  <-0.033415, 2.12038, 0.0>
}
union { // Temple
  object { TempleTop }
  object { Stairs }
  object { FrontColumns }
  object { RtSideColumns }
  object { LfSideColumns }
  object { BackColumns }
  scale <4.6, 6.900001, 4.6>
  rotate 49.901672*z
  translate  <8.842725, -11.346559, 0.428719>
}


#declare BzPtch5 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.084034, -0.004347, 3.526728>, <-1.000000, -1.104784, 1.993713>, <0.000000, -1.520278, 2.080274>, <3.987405, -1.554902, 2.097587>,
      <-2.084034, 0.000023, 3.527586>, <-1.000000, -1.283977, 0.859629>, <0.000000, -1.283977, 0.859629>, <3.987405, -1.283977, 0.859629>,
      <-2.084034, 0.000002, 3.527581>, <-0.999999, -0.911096, -0.210521>, <0.000000, -0.912260, -0.210521>, <3.987405, -0.913423, -0.210521>,
      <-2.084034, 0.000003, 3.527562>, <-1.000000, 0.006813, -0.999977>, <0.000000, 0.006813, -0.999977>, <3.987405, 0.006813, -0.999977>
    }
  }
}
#declare BzPtch6 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.563029, -0.004347, 4.997318>, <1.000000, -1.104784, 1.993713>, <0.000000, -1.520278, 2.080274>, <-3.987405, -1.554902, 2.097587>,
      <-0.563029, 0.000023, 4.998177>, <1.000000, -1.283977, 0.859629>, <0.000000, -1.283977, 0.859629>, <-3.987405, -1.283977, 0.859629>,
      <-0.563029, 0.000002, 4.998172>, <0.999999, -0.911096, -0.210521>, <0.000000, -0.912260, -0.210521>, <-3.987405, -0.913423, -0.210521>,
      <-0.563029, 0.000003, 4.998153>, <1.000000, 0.006813, -0.999977>, <0.000000, 0.006813, -0.999977>, <-3.987405, 0.006813, -0.999977>
    }
  }
  no_shadow
  translate  <7.974809, 0.0, 0.0>
}
#declare BzPtch7 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.563029, 0.004347, 4.997318>, <1.000000, 1.104784, 1.993713>, <0.000000, 1.520278, 2.080274>, <-3.987405, 1.554902, 2.097587>,
      <-0.563029, -0.000023, 4.998177>, <1.000000, 1.283977, 0.859629>, <0.000000, 1.283977, 0.859629>, <-3.987405, 1.283977, 0.859629>,
      <-0.563029, -0.000002, 4.998172>, <0.999999, 0.911096, -0.210521>, <0.000000, 0.912260, -0.210521>, <-3.987405, 0.913423, -0.210521>,
      <-0.563029, -0.000003, 4.998153>, <1.000000, -0.006813, -0.999977>, <0.000000, -0.006813, -0.999977>, <-3.987405, -0.006813, -0.999977>
    }
  }
  no_shadow
  translate  <7.974809, 0.0, 0.0>
}
#declare BzPtch8 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.084034, 0.004347, 3.526728>, <-1.000000, 1.104784, 1.993713>, <0.000000, 1.520278, 2.080274>, <3.987405, 1.554902, 2.097587>,
      <-2.084034, -0.000023, 3.527586>, <-1.000000, 1.283977, 0.859629>, <0.000000, 1.283977, 0.859629>, <3.987405, 1.283977, 0.859629>,
      <-2.084034, -0.000002, 3.527581>, <-0.999999, 0.911096, -0.210521>, <0.000000, 0.912260, -0.210521>, <3.987405, 0.913423, -0.210521>,
      <-2.084034, -0.000003, 3.527562>, <-1.000000, -0.006813, -0.999977>, <0.000000, -0.006813, -0.999977>, <3.987405, -0.006813, -0.999977>
    }
  }
}
#declare GreekShipHull1 = union {
  object { BzPtch5 }
  object { BzPtch6 }
  object { BzPtch7 }
  object { BzPtch8 }
  rotate 71.121658*z
  translate  <2.54861, 0.0, -0.364087>
}
#declare Eyes1 = union {
  box { // RtEye1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RtEyeTex
    }
    scale <1.0, 1.09, 0.01>
    rotate <90.0, 0.0, -90.0>
    translate  <2.498503, -0.875879, -0.115138>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.001
    translate  <0.042322, -0.282328, -0.19045>
  }
  rotate -18.868164*z
  translate  <0.051255, 0.280844, 0.844313>
}
#declare BowThing = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 1.297138, 2.0>
    translate  <2.404097, -0.711093, 0.4569>
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 1.5
    translate  <2.432749, -2.508794, 1.494288>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 1.354058
    translate  <2.43771, 0.171349, 2.45758>
  }
  rotate -18.868164*z
  translate  0.653864*z
}
#declare SternShadow = difference {
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      MastTex
    }
    scale <4.829573, 2.103493, 4.689261>
    rotate <6.489434, 16.583376, 32.306335>
    translate  <34.432415, 106.103289, 0.277531>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      MastTex
    }
    scale <5.118807, 2.229467, 4.970092>
    rotate <6.489434, 16.583376, 32.306335>
    translate  <33.558185, 105.730648, 0.478167>
  }
  scale 0.5
  rotate <0.0, 0.0, 40.965942>
  translate  <26.52891, -45.923816, 1.738233>
}
#declare HullMastEye1 = union {
  object { GreekShipHull1 }
  object { Eyes1 }
  object { BowThing }
  torus { // Wave
    1.5, 0.5  rotate -x*90
    texture {
      WaveTex
    }
    scale <-1.349061, -0.503435, -0.050856>
    rotate <90.357254, 0.0, -125.733391>
    translate  <2.935937, -0.842182, 0.039833>
  }
  object { SternShadow }
  texture {
    HullTex
  }
  rotate 25.624788*z
  translate  -0.653864*z
}
#declare HorizSailMark1 = union {
  torus { // Torus9
    1.5, 0.5  rotate -x*90
    scale <1.050486, 0.309965, 0.057732>
    rotate <0.0, 0.0, 0.0>
    translate  <2.267545, 4.682184, 3.808266>
  }
  torus { // Torus10
    1.5, 0.5  rotate -x*90
    scale <1.012711, 0.309965, 0.057732>
    rotate <0.0, 0.0, 0.0>
    translate  <2.30532, 4.682184, 4.299344>
  }
  torus { // Torus11
    1.5, 0.5  rotate -x*90
    scale <0.937644, 0.274496, 0.055826>
    rotate <0.0, 0.0, 0.0>
    translate  <2.363063, 4.700543, 4.753633>
  }
  torus { // Torus12
    1.5, 0.5  rotate -x*90
    scale <0.898523, 0.230656, 0.053359>
    rotate <0.0, 0.0, 0.0>
    translate  <2.494197, 4.682184, 5.243725>
  }
  texture {
    SailTex2
  }
  no_shadow
  scale <0.99, 1.0, 1.0>
}
#declare VerSailMarks1 = union {
  torus { // Torus13
    1.5, 0.5  rotate -x*90
    no_shadow
    scale <0.653846, 0.309965, 0.057732>
    rotate <0.0, -90.0, 0.0>
    translate  <1.247614, 4.882437, 4.563771>
  }
  torus { // Torus14
    1.5, 0.5  rotate -x*90
    scale <0.653846, 0.309965, 0.057732>
    rotate <0.0, -90.0, 0.0>
    translate  <2.003118, 4.882437, 4.620433>
  }
  torus { // Torus15
    1.5, 0.5  rotate -x*90
    scale <0.653846, 0.309965, 0.057732>
    rotate <0.0, -90.0, 0.0>
    translate  <2.815286, 4.882437, 4.582658>
  }
  torus { // Torus16
    1.5, 0.5  rotate -x*90
    scale <0.653846, 0.309965, 0.057732>
    rotate <0.0, -90.0, 0.0>
    translate  <3.570791, 4.882437, 4.544883>
  }
  texture {
    SailTex2
  }
  no_shadow
}
#declare Sail2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.475518, -0.500137, 0.425533>, <0.823371, -0.287307, 0.579334>, <0.434945, 0.171788, 0.606467>, <0.020008, 0.089275, 0.613462>,
      <1.228763, -0.249065, 1.023345>, <0.814844, -0.384795, 1.022941>, <0.426419, 0.074299, 1.050073>, <0.011481, -0.008214, 1.057069>,
      <1.216612, -0.313114, 1.319335>, <0.802694, -0.448844, 1.318931>, <0.414269, 0.010251, 1.346063>, <-0.000669, -0.147357, 1.353059>,
      <1.169502, -0.378825, 1.670654>, <0.755583, -0.514555, 1.670249>, <0.367158, -0.055461, 1.697382>, <-0.047780, -0.213068, 1.704377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.169502, -0.378825, 1.670654>, <0.755583, -0.514555, 1.670249>, <0.367158, -0.055461, 1.697382>, <-0.047780, -0.213068, 1.704377>,
      <1.122391, -0.444536, 2.021973>, <0.708473, -0.580266, 2.021568>, <0.320047, -0.121172, 2.048701>, <-0.094890, -0.278780, 2.055696>,
      <1.238021, 0.116072, 2.657588>, <0.824103, -0.019658, 2.657184>, <0.391876, -0.396969, 2.625915>, <-0.023061, -0.554577, 2.632910>,
      <1.202519, -0.203932, 3.259078>, <0.788600, -0.339662, 3.258674>, <0.400175, 0.119433, 3.285806>, <-0.014763, -0.038175, 3.292802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.020008, 0.089275, 0.613462>, <-0.394930, 0.006762, 0.620458>, <-1.415686, 0.370129, 0.418320>, <-1.683944, 0.256748, 0.243024>,
      <0.011481, -0.008214, 1.057069>, <-0.403456, -0.090726, 1.064064>, <-1.584817, -0.077768, 0.818125>, <-1.676399, -0.190987, 0.801937>,
      <-0.000669, -0.147357, 1.353059>, <-0.415606, -0.304965, 1.360054>, <-0.810405, 0.005424, 1.380302>, <-1.354598, -0.472804, 1.583120>,
      <-0.047780, -0.213068, 1.704377>, <-0.462717, -0.370676, 1.711373>, <-0.857516, -0.060288, 1.731621>, <-1.336008, -0.356011, 1.824936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.047780, -0.213068, 1.704377>, <-0.462717, -0.370676, 1.711373>, <-0.857516, -0.060288, 1.731621>, <-1.336008, -0.356011, 1.824936>,
      <-0.094890, -0.278780, 2.055696>, <-0.509828, -0.436387, 2.062692>, <-0.904626, -0.125999, 2.082940>, <-1.317417, -0.239218, 2.066752>,
      <-0.023061, -0.554577, 2.632910>, <-0.437999, -0.712185, 2.639906>, <-0.832797, -0.036788, 2.660154>, <-1.245588, -0.515015, 2.643966>,
      <-0.014763, -0.038175, 3.292802>, <-0.429700, -0.195783, 3.299798>, <-0.824499, 0.114606, 3.320046>, <-1.237289, 0.001387, 3.303858>
    }
  }
  texture {
    SailTex
  }
  no_shadow
  scale <1.485449, 1.0, 0.878638>
  translate  <2.513777, 4.856129, 2.910208>
}
#declare SailandRiggin1 = union {
  object { HorizSailMark1 }
  object { VerSailMarks1 }
  cylinder { // SailBrace1
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    no_shadow
    scale <0.06, 0.06, 4.405181>
    rotate <0.0, -90.0, 0.0>
    translate  <4.647056, 4.954122, 5.866789>
  }
  object { Sail2 }
  scale 1.5
  rotate <-3.324598, -0.118925, 31.497805>
  translate  <4.054521, -3.439532, -2.906424>
}
#declare Rudder1 = union {
  cone { // OarBlade7
    <0,0,0>, 0.4, <0,0,1>, 0.5
    scale <0.611066, 0.001093, 1.023765>
  }
  cylinder { // OarHandle7
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.999792>
    translate  0.454951*z
  }
  rotate <24.067396, 42.417931, -77.713188>
  translate  <4.024296, 9.898123, 0.040828>
}
#declare Oar6 = union {
  cone { // OarBlade8
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle8
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate <-45.473381, -31.188475, 22.79402>
  translate  <4.429278, 0.98721, 0.033425>
}
#declare Oar7 = union {
  cone { // OarBlade9
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle9
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate <-0.137523, -56.943089, 6.771413>
  translate  <5.149812, 2.294937, 0.19383>
}
#declare Oar8 = union {
  cone { // OarBlade10
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle10
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate <-13.695498, -58.110485, 11.690103>
  translate  <5.145222, 3.400237, 0.163546>
}
#declare Oar9 = union {
  cone { // OarBlade11
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle11
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate -58.847004*y
  translate  <5.187023, 4.593568, 0.171899>
}
#declare Oar10 = union {
  cone { // OarBlade12
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle12
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate -55.478462*y
  translate  <5.061619, 6.056621, 0.098856>
}
#declare Oar11 = union {
  cone { // OarBlade13
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.217439, 0.015956, 0.45>
  }
  cylinder { // OarHandle13
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.03, 0.03, 1.29371>
    translate  0.308865*z
  }
  rotate -63.065109*y
  translate  <5.16515, 7.185263, 0.340522>
}
#declare Oars1 = union {
  object { Rudder1 }
  object { Oar6 }
  object { Oar7 }
  object { Oar8 }
  object { Oar9 }
  object { Oar10 }
  object { Oar11 }
  texture {
    Cork2
  }
  no_shadow
  scale 2.0
  rotate -66.590729*z
  translate  <10.0, 103.881747, -2.168739>
}
#declare Oars = difference {
  object { Oars1 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cork2
    }
    scale <8.172603, 1.358485, 0.98655>
    rotate 21.828066*z
    translate  <20.337888, 101.074043, 0.0>
  }
  scale 0.5
  rotate <0.0, 0.0, 66.590729>
  translate  <45.679156, -25.224373, 1.08437>
}
union { // GreekShip1
  object { HullMastEye1 }
  object { SailandRiggin1 }
  cylinder { // Mast1
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    no_shadow
    scale <0.1, 0.1, 7.5>
    rotate <0.0, 0.0, 78.553909>
    translate  <2.821639, 5.170701, -1.190796>
  }
  object { Oars }
  scale 2.0
  rotate -66.590729*z
  translate  <10.0, 103.881747, -2.168739>
}


union { // Bench
  cylinder { // leg1
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.5>
    translate  <-0.900364, -0.100641, -0.444444>
  }
  cylinder { // leg2
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.5>
    translate  <0.899854, -0.099824, -0.44444>
  }
  cylinder { // leg3
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.5>
    translate  <-0.899839, 0.099817, -0.444444>
  }
  cylinder { // leg4
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.5>
    translate  <0.899403, 0.10024, -0.44444>
  }
  superellipsoid { // SuprQ001
    <0.1, 0.1>
    texture {
      DMFDarkOak1
    }
    scale <1.073851, 0.185443, 0.030135>
    translate  0.022378*z
  }
  texture {
    DMFDarkOak2
  }
  scale <3.0, 2.5, 2.5>
  rotate 47.0*z
  translate  <-6.346087, -4.216494, 0.009979>
}


#declare Staffs = difference {
  torus { // Torus001
    1.9, 0.1  rotate -x*90
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.010474, 2.001972, 2.0>
    rotate 45.0*z
    translate  2.17578*y
  }
  texture {
    MastTex
  }
  scale <0.607018, 1.65867, 1.0>
}
#declare Strings = union {
  cylinder { // MidString3
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate -12.0*y
    translate  <0.023319, 0.131055, 0.163234>
  }
  cylinder { // MidString2
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate -8.0*y
  }
  cylinder { // MidString1
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate -4.0*y
  }
  cylinder { // MidString
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
  }
  cylinder { // MidString4
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate 4.0*y
  }
  cylinder { // MidString5
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate 8.0*y
  }
  cylinder { // MidString6
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 5.0>
    rotate 12.0*y
    translate  <-0.093276, 0.0, 0.069957>
  }
  texture {
    OarBladeTex
  }
  rotate -90.0*x
  translate  <0.019877, -4.172762, 0.0>
}
union { // Lyre
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      MastTex
    }
    scale <0.060702, 0.165867, 0.1>
    translate  <-0.998094, 1.560966, 0.0>
  }
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      MastTex
    }
    scale <0.060702, 0.165867, 0.1>
    translate  <1.003758, 1.523556, 0.0>
  }
  object { Staffs }
  sphere { // TShell
    <0,0,0>,1
    texture {
      ShellTex1
    }
    scale <1.0, 0.165279, 1.160504>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.0, -3.15277, 0.32652>
  }
  cone { // Base
    <0,0,0>, 0.8, <0,0,1>, 1.0
    texture {
      MastTex
    }
    scale <0.912201, 0.204678, 1.0>
    rotate 90.0*x
    translate  <0.012803, -3.425876, -0.023319>
  }
  cylinder { // CrossPiece
    <0,0,1>, <0,0,0>, 1
    texture {
      MastTex
    }
    scale <0.01386, 0.07, 3.018713>
    rotate <-180.0, -90.0, 0.0>
    translate  <-1.486502, 0.84829, 0.0>
  }
  object { Strings }
  scale 0.35
  rotate 90.0*x
  translate  <-5.219437, -2.851266, 1.690178>
}


//
// Include file contains 'Jar'
//
#include "atl9.in1"
#declare Jar = object {
  Jar_Raw
  texture {
    Texture03
  }
}
#declare GreekJar = union {
  object { Jar }
  torus { // JarHandl1
    1.65, 0.35  rotate -x*90
    no_shadow
    scale <0.111385, 0.223524, 0.13528>
    rotate <-90.0, -4.544711, 180.0>
    translate  <-0.530705, 0.0, 0.349489>
  }
  torus { // JarHandl2
    1.65, 0.35  rotate -x*90
    scale <0.111385, 0.223524, 0.13528>
    rotate <-90.0, -4.544711, 0.0>
    translate  <0.530705, 0.0, 0.349489>
  }
  translate  <2.524436, -0.160406, 0.123477>
}
#declare BKrator = lathe {
  cubic_spline
  9  // control points
  <0.006296, -0.863876>,
  <0.565978, -0.869895>,
  <0.216222, -0.70106>,
  <0.557087, -0.44555>,
  <0.678578, -0.125498>,
  <0.815722, 0.479581>,
  <0.894325, 0.881832>,
  <0.903711, 0.890709>,
  <-0.007317, 0.884295>
  rotate <90,0,90>
  texture {
    Texture03
  }
  scale 0.8
  translate  <1.64741, 1.790992, -0.156826>
}
//
// Include file contains 'HydraBody'
//
#include "atl9.in2"
#declare HydraBody = object {
  HydraBody_Raw
  translate  <13.604775, -1.700597, 0.0>
}
#declare Hydria = union {
  torus { // Torus4
    1.85, 0.15  rotate -x*90
    scale <0.121685, 0.126359, 0.046895>
    translate  <13.604775, -1.700597, 0.734908>
  }
  torus { // Torus6
    1.85, 0.15  rotate -x*90
    scale <0.087116, 0.088279, 0.042224>
    translate  <13.604775, -1.700597, -0.718105>
  }
  torus { // Torus5
    1.85, 0.15  rotate -x*90
    scale <0.111748, 0.098781, 0.093124>
    translate  <13.604775, -1.700597, -0.741058>
  }
  object { HydraBody }
  torus { // HyrHand1
    1.5, 0.5  rotate -x*90
    scale 0.1
    rotate 65.0*y
    translate  <13.084457, -1.698686, 0.168081>
  }
  torus { // HyHand2
    1.5, 0.5  rotate -x*90
    scale 0.1
    rotate <0.0, 65.0, 180.0>
    translate  <14.134961, -1.698686, 0.168081>
  }
  translate  <-13.609709, 1.698686, -0.049024>
}
union { // Amph
  object { GreekJar }
  object { BKrator }
  object { Hydria }
  texture {
    AmphoriaTex
  }
}


union { // PanPipes
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.7>
    translate  0.149708*x
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.5>
    translate  0.299415*x
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    translate  <-0.152413, 0.0, -0.007116>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.6>
    translate  <-0.304377, 0.0, -0.008227>
  }
  texture {
    Cork2
  }
  scale <0.8, 0.8, 1.0>
  rotate <-90.0, 0.0, -85.417801>
  translate  <-8.321562, -6.107774, 0.21249>
}


//
// Include file contains 'RotSwp2'
//
#include "atl9.in3"
#declare RotSwp2 = object {
  RotSwp2_Raw
  texture {
    SandTex2
  }
  scale <1.076959, 0.415205, 0.788073>
  rotate <-90.0, 0.0, 131.147293>
  translate  <-4.891725, -5.061536, -0.953041>
}
//
// Include file contains 'RotSwp3'
//
#include "atl9.in4"
#declare RotSwp3 = object {
  RotSwp3_Raw
  texture {
    SandTex2
  }
  scale <1.076959, 0.415205, 0.788073>
  rotate <-90.0, 0.0, -42.887997>
  translate  <-3.152407, -5.084114, -0.953041>
}
//
// Include file contains 'RotSwp4'
//
#include "atl9.in5"
#declare RotSwp4 = object {
  RotSwp4_Raw
  texture {
    SandTex2
  }
  no_shadow
  scale <1.0, 1.0, 0.9>
  rotate <-90.0, 0.0, -177.042801>
  translate  <-4.596584, -7.635425, -1.1>
}
union { // Mounds
  object { RotSwp2 }
  object { RotSwp3 }
  object { RotSwp4 }
}


