
// Persistence of Vision Ray Tracer Scene Description File
// File: oserath.pov
// Vers: 3.01
// Desc: Etathostenes sieve
// Date: 12.06.1997
// Auth: Ondrej Svoboda, Praha, Czech Republic, osvo@aristia.cz (osvo@geocities.com) 



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====

#include "SHAPES.INC"
#include "glass.inc"
#include "stones.inc"



camera
{
  location  <7, 3.0 ,-8.0>
  look_at   <7 ,3 , 10>
  angle 90
}

light_source
            { <100,100,-100> color White}

#declare Zelena =                               // texture for Green ball
texture {
         T_Glass1
         pigment {color green 0.90 filter 0.85}
         finish {
            caustics 1.0
            phong 1
            reflection 0.15
         }
      }

#declare Cervena =                              //texture for Red Ball
texture {
         T_Glass1
         pigment {color red 0.90 filter 0.85}
         finish {
            caustics 1.0
            phong 1
            reflection 0.15
         }
      }



#declare C_Box =                                            //basic Box
difference{
           object {box {<-0.01,-0.01,0>,<1.01,1.01,1>}

                   }

           object {
                  box {<0.1,0.1,-0.1>,<0.9,0.9,1.01>}
                  }
           }

#declare O_Box =                                            //Box with 2 holes
difference{
           object {box {<-0.01,-0.01,0>,<1.01,1.01,1>}

                   }
           object {box {<0.1,0.1,-0.1>,<0.9,0.9,1.01>}}
           object {cylinder {<0.5,-0.01,0.5>,<0.5,1.01,0.5>,0.4}}
           }

#declare U_Box =                                           //Box with 1 hole                 
difference{
           object {box {<-0.01,-0.01,0>,<1.01,1.01,1>}

                   }
           object {box {<0.1,0.1,-0.1>,<0.9,0.9,1.01>}}
           object {cylinder {<0.5,0.5,0.5>,<0.5,1.01,0.5>,0.4}}
           }

#declare S_Box =                                           //Box for numbers                                             
           object {box {<-0.01,-0.01,0>,<1.01,1.01,1> texture {T_Stone25}}}

#declare Red_Ball =                                        //Red ball 
object {sphere {<0.5,0.5,0.5>,0.4}
               texture {Cervena}
       }

#declare Green_Ball =                                       //Green ball
object {sphere {<0.5,0.5,0.5>,0.4}
               texture {Zelena}
       }
plane {<0,1,0>,-0.01                                        //Ground
      texture{
              pigment {color Silver}
              normal {bumps 0.5 scale 0.8}
              finish {phong 1 reflection 0.5 ambient 0.4 diffuse 0.2}
              }
      }

plane {<0,0,1>,15                                           //back plane
      texture {T_Stone3 scale 3}
      }

difference {                                                //number boxes
           object {S_Box}
           text { ttf "coprgtb.ttf" " 2" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 3" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate x*1}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 4" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate x*2}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 5" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 3*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 6" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 4*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 7" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 5*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 8" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 6*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" " 9" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 7*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "10" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 8*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "11" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 9*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "12" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 10*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "13" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 11*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "14" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.1*x
  }
  translate 12*x}

difference {
           object {S_Box}
           text { ttf "coprgtb.ttf" "15" 0.1, 0
    pigment { BrightGold }
      finish { reflection .25 specular 1 }
    translate -0.08*z
    translate 0.2*y
    scale <0.6,1,1>
    translate 0.15*x
  }
  translate 13*x}

merge {                                                 //Sieve
//   Row 1(lower)
object {C_Box}
object {C_Box translate x*1}
object {C_Box translate x*2}
object {C_Box translate x*3}
object {C_Box translate x*4}
object {C_Box translate x*5}
object {C_Box translate x*6}
object {C_Box translate x*7}
object {C_Box translate x*8}
object {C_Box translate x*9}
object {U_Box translate x*10}
object {C_Box translate x*11}
object {C_Box translate x*12}
object {C_Box translate x*13}

//  Row 2
object {C_Box translate y*1}
object {C_Box translate <1,1,0>}
object {C_Box translate <2,1,0>}
object {C_Box translate <3,1,0>}
object {C_Box translate <4,1,0>}
object {C_Box translate <5,1,0>}
object {C_Box translate <6,1,0>}
object {C_Box translate <7,1,0>}
object {C_Box translate <8,1,0>}
object {U_Box translate <9,1,0>}
object {C_Box translate <10,1,0>}
object {O_Box translate <11,1,0>}
object {C_Box translate <12,1,0>}
object {C_Box translate <13,1,0>}

//  Row 3
object {C_Box translate y*2}
object {C_Box translate <1,2,0>}
object {C_Box translate <2,2,0>}
object {C_Box translate <3,2,0>}
object {C_Box translate <4,2,0>}
object {U_Box translate <5,2,0>}
object {C_Box translate <6,2,0>}
object {C_Box translate <7,2,0>}
object {C_Box translate <8,2,0>}
object {O_Box translate <9,2,0>}
object {C_Box translate <10,2,0>}
object {O_Box translate <11,2,0>}
object {C_Box translate <12,2,0>}
object {C_Box translate <13,2,0>}

//  Row 4
object {C_Box translate y*3}
object {C_Box translate <1,3,0>}
object {C_Box translate <2,3,0>}
object {U_Box translate <3,3,0>}
object {C_Box translate <4,3,0>}
object {O_Box translate <5,3,0>}
object {C_Box translate <6,3,0>}
object {C_Box translate <7,3,0>}
object {C_Box translate <8,3,0>}
object {O_Box translate <9,3,0>}
object {C_Box translate <10,3,0>}
object {O_Box translate <11,3,0>}
object {C_Box translate <12,3,0>}
object {C_Box translate <13,3,0>}

//  Row 5
object {C_Box translate y*4}
object {U_Box translate <1,4,0>}
object {C_Box translate <2,4,0>}
object {O_Box translate <3,4,0>}
object {C_Box translate <4,4,0>}
object {O_Box translate <5,4,0>}
object {C_Box translate <6,4,0>}
object {U_Box translate <7,4,0>}
object {C_Box translate <8,4,0>}
object {O_Box translate <9,4,0>}
object {C_Box translate <10,4,0>}
object {O_Box translate <11,4,0>}
object {C_Box translate <12,4,0>}
object {U_Box translate <13,4,0>}

//  Row 6
object {U_Box translate y*5}
object {O_Box translate <1,5,0>}
object {U_Box translate <2,5,0>}
object {O_Box translate <3,5,0>}
object {U_Box translate <4,5,0>}
object {O_Box translate <5,5,0>}
object {U_Box translate <6,5,0>}
object {O_Box translate <7,5,0>}
object {U_Box translate <8,5,0>}
object {O_Box translate <9,5,0>}
object {U_Box translate <10,5,0>}
object {O_Box translate <11,5,0>}
object {U_Box translate <12,5,0>}
object {O_Box translate <13,5,0>}

texture {T_Glass2}
translate <0,1.01,0>
}
union {                                                 //Balls
object {Red_Ball translate x*11}
object {Red_Ball translate <9,1,0>}
object {Red_Ball translate <5,2,0>}
object {Red_Ball translate <3,3,0>}
object {Red_Ball translate <1,4,0>}
object {Green_Ball translate <7,4,0>}
object {Green_Ball translate <13,4,0>}
object {Red_Ball translate y*5}
object {Green_Ball translate <2,5,0>}
object {Green_Ball translate <4,5,0>}
object {Green_Ball translate <6,5,0>}
object {Green_Ball translate <8,5,0>}
object {Green_Ball translate <10,5,0>}
object {Green_Ball translate <12,5,0>}
translate <0,1.01,0>}
