#include "Pballtex.inc"

#include "Pballshp.inc"


// lenth of an edge:
#declare Len = vlength(<c36,.5,s36>)

#declare R1  = object{ThickDown rotate y*0   }
#declare R2  = object{ThickDown rotate y*72  }
#declare R3  = object{ThickDown rotate y*144 }
#declare R4  = object{ThickDown rotate y*216 }
#declare R5  = object{ThickDown rotate y*288 }

#declare R6  = object{ThinUp translate <-(1+2*c72),0,0> rotate y*0   }
#declare R7  = object{ThinUp translate <-(1+2*c72),0,0> rotate y*72  }
#declare R8  = object{ThinUp translate <-(1+2*c72),0,0> rotate y*144 }
#declare R9  = object{ThinUp translate <-(1+2*c72),0,0> rotate y*216 }
#declare R10 = object{ThinUp translate <-(1+2*c72),0,0> rotate y*288 }

#declare Top = 
  union {
    object{ R1} object{ R2} object{ R3} object{ R4} object{ R5 }
    object{ R6} object{ R7} object{ R8} object{ R9} object{ R10 }
    // this causes the centre of the final object to be in <0,0,0>:
    translate <0,(Len-.5)/2,0> 
  }

#declare V1 = 
  union {
    object{R3}
    object{R4}
    translate <0,-1.5,0>
    rotate z*2*degrees(atan2(1,2*c36))
    rotate y*180
    translate <2*c36,.5,0>    
  }    

#declare Verticals =
  union {
    object{V1 rotate y*0   }
    object{V1 rotate y*72  }
    object{V1 rotate y*144 }
    object{V1 rotate y*216 }
    object{V1 rotate y*288 }
    // this causes the centre of the final object to be in <0,0,0>:
    translate <0,(Len-.5)/2,0>
  }

#declare Bottom = 
  object { Top rotate z*180 }

#declare PentaBall = 
  union {
    object { Top }
    object { Bottom }
    object { Verticals }
  }  

// "radius" of the object:
#declare PentaBallRad = 1.5 + (Len-.5)/2

