// Newton's Desk

// Created by Peter J. Popov
// for the IRTC (May 1st - June 30th 1997)

// Threw in a little remarks for easier reading
// Anyway, not too much of a complicated picture
// nor too innovative an idea, but that's what I
// can do in the little spare time I have
// (I am preparing for the university entrance
// exams in math and English language).

// Note: for ease, all vectors represent centimeters (sorry, US)
// i.e. sphere {0, 10} means 10 cm in radius

// Here goes table.inc

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "declares.inc"

#declare WoodPigment1 =    // Snatched the color_map for textures.inc
color_map {
            [0.250 color rgbf <1.00000, 0.53373, 0.11665, 0.000>]
            [0.350 color rgbf <0.66275, 0.28607, 0.00000, 0.000>]
            [0.525 color rgbf <1.00000, 0.53363, 0.11715, 0.000>]
            [0.600 color rgbf <0.66475, 0.28647, 0.00000, 0.000>]
            [0.750 color rgbf <1.00000, 0.53353, 0.11565, 0.000>]
            [0.850 color rgbf <0.66275, 0.28667, 0.00000, 0.000>]
            [1.000 color rgbf <1.00000, 0.53143, 0.11795, 0.000>]
        }

#declare WoodPigment2 =    // This one, too
color_map {
            [0.200 color rgbf <0.56695, 0.17347, 0.00000, 0.8250>]
            [0.350 color rgbf <0.96471, 0.54510, 0.22753, 0.7710>]
            [0.400 color rgbf <0.56341, 0.17547, 0.00000, 0.9150>]
            [0.615 color rgbf <0.96472, 0.54510, 0.22553, 0.7590>]
            [0.700 color rgbf <0.56671, 0.17687, 0.00000, 0.7920>]
            [0.850 color rgbf <0.96485, 0.54510, 0.22453, 0.8975>]
            [1.000 color rgbf <0.56478, 0.17247, 0.00000, 0.9750>]
        }

#declare T_Planks =
texture                         // Lower wooden texture
{ pigment
  { wood
    color_map { WoodPigment1 }
    turbulence Turb
    turbulence TurbVector
  }
  normal { bumps 1 scale <.05,0.05,3> scale 2 bump_size 0.75 }
  translate -0.25
}

texture                         // Upper wooden texture
{ pigment
  { wood
    color_map { WoodPigment2 }
    turbulence Turb
    turbulence TurbVector
  }
  normal { bumps 1 scale <.05,0.05,3> scale 2 bump_size 0.75 }
  translate -1
}

#declare T_Table =
texture
{ T_Planks
  rotate y*90
  rotate z*2
  scale <15,1,1>
  scale 0.35
}

#declare p = Plank_Spacing    // For less writing ;-)

#declare Plank =              // The edges have been cut
prism
{ linear_spline
  linear_sweep
  0, 4
  9
  <p, 0      >, <0.5-p, 0>, <0.5, p  >, <0.5, 0.1-p>,
  <0.5-p, 0.1>, <p, 0.1  >, <0, 0.1-p>, <0, p      >
  <p, 0      >
  rotate <90,90,0>
  translate <0,0.1,0.5>
}

#declare Table =              // Six planks with slightly different textures
union
{ object
  { Plank
    texture { T_Table }
  }

  object
  { Plank
    rotate y*10
    texture { T_Table }
    rotate -y*10
    translate z*0.5
  }

  object
  { Plank
    translate 1
    texture { T_Table }
    translate -1
    translate z*1
  }

  object
  { Plank
    texture { T_Table }
    translate z*1.5
  }

  object
  { Plank
    rotate y*10
    texture { T_Table }
    rotate -y*10
    translate z*2
  }

  object
  { Plank
    translate 1
    texture { T_Table }
    translate -1
    translate z*2.5
  }

  scale 20                // Table dimensions are 80*60*2 cm
  translate <-40,-2,-30>  // centered, top leveled at y=0
}

// Here goes apple.inc

#declare AppleTexture =
texture
{ pigment
  { wood turbulence 0
    color_map
    { [0.00, 0.8 color AppleGreen color AppleRed]
      [0.8, 1.00 color AppleRed color AppleRed]
    }
    rotate 90*x
  }
  normal { wrinkles 0.5 scale 0.125 }
  finish { crand 0.1 specular 0.25 roughness 0.01 diffuse 0.33 ambient 0.33}
}

#declare Apple=
union
{ lathe
  { cubic_spline
    9
    <0,.3>,
    <0,.15>, <.25,.1>, <.4,.35>, <.5,.6>, <.4,.85>, <.1,.9>, <0,.8>,
    <0,.6>
    texture { AppleTexture }
  }

  intersection                // That's the stalk
  { torus { 0.3, 0.02 }       // Didn't put a leaf on it, though
    box   { -y, 1 }

    translate -x*0.3
    rotate -z*180
    rotate -x*90
    scale 0.75
    translate y*0.8
    texture
    { pigment { color DarkTan/1.5 }
      normal  { wrinkles 1 scale 0.0001}
    }
  }

  translate -0.1*y           // Otherwise it looks like it's floating in the air.
  scale 8                    // Make it 10 cm in diameter.
}

// And now, newtpage.inc

#declare Page =
bicubic_patch
{ type 1
  u_steps 3
  v_steps 3
  flatness 0
  <0,0,0>, <1,0,0>, <2,0,0>, <3,0.25,0>,
  <0,0,1>, <1,0,1>, <2,0,1>, <3,0,1>,
  <0,0,2>, <1,0,2>, <2,0,2>, <3,0,2>,
  <0,0.5,3>, <1,0,3>, <2,0.125,3>, <3,0,3>
  scale 1/3                  // Unit sized, to fit the image_map

  texture
  { pigment
    { image_map
      { gif "page.gif"
        interpolate 2
      }
      rotate x*90
    }

   normal                   // A little bit like old parchment
   { wrinkles 0.25
      scale <1,0.025,0.025>
      rotate -z*15
      bump_size 0.2
    }

    finish
    { specular 0.125
      diffuse 0.25
      crand 0.015
      ambient 0.25
    }
  }
  translate <-0.5,0,-0.5>
  scale <21.0,25,29.7>       // A4 letter, 297x210 cm
}

// Oops! Telescop.inc

#declare T_Base = texture
{ T_Brass_1B
  normal
  { bumps 0.5
    scale <1,0.01,0.01>
  }
}
#declare T_Column = texture
{ pigment
  { color rgb <0.7,0.4,0.3> }
  normal
  { agate bump_size .33}
  finish
  { ambient 0.2
    diffuse 0.4
    specular 0.7
    roughness 0.005
    reflection 0.2
    brilliance 6
    metallic on
  }
}

#declare T_Ball =
texture
{ pigment
  { color Gray30 }
  finish
  { metallic on
    brilliance 10
    specular 0.15
    roughness 0.01
    diffuse 0.5
    ambient 0.25
  }
  normal
  { bumps 0.1 scale 0.5 }
}

#declare T_Eyepiece = texture { Gold_Metal }
#declare T_Holder = texture { Brushed_Aluminum finish { specular 0.5 } }
#declare T_Pipe_1 =
texture
{ pigment
  { color P_Brass3 }
  finish
  { ambient 0.2
    diffuse 0.45
    metallic on
    specular 0.75
    roughness 0.001
    reflection 0.25
    brilliance 8
  }

  normal                    // The idea is to make it look as if the
    { gradient x            // inner part of the telescope has been
    scale <18,1,1>          // scratched where it has entered the outer one.
    translate 17.5*x
    normal_map
    { [0.0 bumps 0]
      [0.4 bumps 0]
      [0.8 bumps 0.2 scale <2.5,0.125,0.125> ]
      [1.0 bumps 0.2 scale <2.5,0.125,0.125> ]
    }
  }
}

#declare T_Pipe_2 = texture { T_Pipe_1 normal {bumps 0} }

#declare Base =           // The base ;-)
union
{ cylinder { <0,0,0>, <0,1.5,0>, 10 }
  cone { <0,1.5,0>, 10, <0,2,0>, 9.5 }
  texture { T_Base }
}

#declare Column =         // Obvious
union
{ intersection
  { sphere { <0,2,0>, 5 }
    plane { -y, -2 }
  }

  cylinder { <0,6,0>, <0,14,0>, 2 }

  intersection
  { sphere { <0,17,0>, 4.5 }
    plane { y, 16 }
    sphere { <0,17,0>, 4 inverse }
  }

  texture { T_Column }
}

#declare Stand = union { object { Base } object { Column } }

#declare Ball = sphere { 0, 4 texture { T_Ball } }

#declare Eyepiece = union
{ cylinder { 0, 4*y, 0.5 open}
  torus { 0.5, 0.1 translate 4*y }
  texture { T_Eyepiece }
}

#declare Pipe_1 =            // Inner pipe
difference
{ cylinder { <0,8,0>, <17.5, 8,0>, 3.5  }
  cylinder { <-1,8,0>, <18,8,0>, 3.1 }
  texture { T_Pipe_1 }
}

#declare Pipe_2 =            // Outer pipe
difference
{ cylinder { <0,8,0>, <-17.5, 8,0>, 4  }
  cylinder { <1,8,0>, <-18,8,0>, 3.5 }
  texture { T_Pipe_2 }
}

#declare Holder =            // Keeps the two together
union
{ box { <0,3.5,-0.7>,  <17.51,4.6,0.7> }
  box { <-14,3.5,-0.7>, <0, 4, 0.7> }
  box { <17.5,3.5,-0.7>, <18,11.8,0.7> }
  cylinder { 17.5*x+8*y,18*x+8*y, 1.5 }
  texture { T_Holder }
}

#declare TelescopeNoStand =       // Declared for the sake of easy adjustments
union
{ object { Ball }
  object { Pipe_1 }
  object { Pipe_2 }
  object { Eyepiece rotate -90*z translate <17,8,0> }
  object { Holder }
}

#declare Telescope =
union
{ object
 { TelescopeNoStand
   rotate TelescopeRotateVector1       // I use three vectors for clearance
   rotate TelescopeRotateVector2
   rotate TelescopeRotateVector3
   translate y*17
 }
 object { Stand }
 scale TelescopeScaleVector
}

// Here comes cndlhldr.inc

#declare CandleHolder =
lathe
{ cubic_spline
  13
  <-2,0>, <0,0 >, <5,0 >,
  <1.5, 3>, <2.5,4 >, <1,7 >,
  <2.5,10>, <1,13>, <2.5,16>,
  <1,17>, <4,21>, <0,21>,
  <-2,21>
  sturm
  texture { Brass_Metal normal { agate scale 3} }
  scale <0.75,0.35,0.75>
}

// This time candle.inc

#declare Candle =

union
{ intersection
  { blob
    { threshold 0.125
      cylinder { 0, 20*y, 2, 1 }
      // The candle itself

      sphere { 0, 1.95, -2 scale <1,2.5,1> translate 20*y }
      sphere { 0, 1.00, -1 translate <1.9,18.3,0> rotate 60*y}
      sphere { 0, 1.00, -0.75 scale <1,2,1> translate <1.8,18.2,0> }
      // Melted by the heat

      cylinder { <1.23,16,0>, <1.9,10,0>, 0.25, 0.35 }
      cylinder { <1.35,11,0.1>, <1.85, 4, 0.1>, .25,0.135 }
      cylinder { <0,2,0>, <0.75,17,0>, 0.25, .33 scale <1,1,2> translate -1.8*x }
      cylinder { <1.2,16,0>, <1.85,10,0>, 0.33, 0.33 rotate 60*y}
      cylinder { <1,15,0>, <2,0.5,0>, 0.25, 0.25 rotate 60*y}
      // Drops of wax

      sphere { 0, 4, 1 scale <1,0.075,1> translate <0.3,0,-0.1> }
      sphere { 0, 1, 0.125 scale <1,0.66,1.66> translate <3,0,0.1> rotate 60*y }
      sphere { 0, 1, 0.12 scale <1,1.1,1> translate <3,0.125,0.1> rotate 180*y }
      sphere { 0, 1, 0.133 scale <1,1.98,1> translate <3.2,0.1,0.1> rotate -90*y }
      sphere { 0, 1, 0.725 scale <1,0.5,1> translate <2.4,0.1,0.1> rotate 60*y }
      sphere { 0, 1, -0.5 scale <1,0.5,2> translate <3,0,-0.1> }
      sphere { 0, 1, -0.5 scale <1,0.5,2> translate <3,0,-0.1> }
      sphere { 0, 1, -0.125 scale <1,0.5,1> translate <2.8,0.1,0> rotate 60*y }
      sphere { 0, 0.8, -0.1 scale <1,0.9,1> translate <2.9,0,0.1> rotate 120*y }
      sphere { 0, 1.5, -0.14 scale <1,1,1> translate <2.6,-0.05,0.1> rotate -120*y }
      sphere { 0, 2, -0.166 scale <1,1.5,1> translate <2.6,0.05,0.1> rotate -60*y }
      // And this was the base part of the candle,
      // where the wax has been dripping

//    sturm     // May not be needing it
    }

    plane { -y,0 }  // Flatten the lower part

    texture         // With high ambient, looks like it's
      { pigment     // beeing illuminated by the flame
        { onion
          color_map
          { [0.0, 0.5 color CandleColor color CandleColor]
            [0.5, 1.0 color CandleColor color rgb <255,200,100>/255 ]
          }
          scale <5,20,5>
        }

      finish
      { specular 0.25
        roughness 0.001
        diffuse 0.75
        ambient 0.25
        metallic on
      }

      normal               // Makes it look like a really old candle,
      { bumps              // the kind made by pulling a string in and
        scale <0.3,5,0.3>  // out of a bucket of wax (or whatever it was)
        bump_size 0.25
        rotate <2,0,2>
      }
    }
  }

  union                    // A little clear drop of molten wax
  { cylinder { <1.15,17.1,0>, <1.9,14,0>, 0.35 }
    sphere { <1.15,17.1,0>, 0.35 }
    sphere { <1.9,14,0>, 0.35 }
    texture
    { pigment
      { color CandleColor transmit 0.97 }
      finish
      { refraction on
        ior 1.526
        reflection 0.45
        specular 1
        roughness 0.0001
      }
    }
  }
}

// The flame.inc

#declare Flame =       // It's just two halos
sphere
{ 0, 3
  hollow
  pigment { color Clear }
  halo
  { emitting
    spherical_mapping
    linear
    max_value 0.75
    samples 10
    aa_level 2
    aa_threshold 0.35
    color_map
    { [0.0 color rgbt <1,0,0,1>]
      [0.5 color rgbt <1,1,0,0>]
      [1.0 color rgbt <1,1,0,-1>]
    }
    scale <1,2,1>
    turbulence <0.1,1,0.1>
  }
    halo
  { emitting
    spherical_mapping
    linear
    max_value 1
    samples 10
    aa_level 2
    aa_threshold 0.35
    color_map
    { [0.0 color rgbt <1,0,0,1>]
      [0.5 color rgbt <1,1,0,0>]
      [1.0 color rgbt <1,1,0,-1>]
    }
    scale <1.2,2.8,1.2>
    rotate 120*y
    translate -y*0.75
    turbulence <0,1,0>
  }
  rotate z*180
  translate <0.16,2.2,0>

  scale FlameScaleVector
  rotate FlameRotateVector
  translate FlameTranslateVector
}
#declare Nib = union

// Generated by a program I wrote for the case

{
cone { <38.000,-8.773,0> , 0.250 ,<38.309,-7.308,0> , 0.226}
cone { <38.309,-7.308,0> , 0.226 ,<38.561,-5.832,0> , 0.202}
cone { <38.561,-5.832,0> , 0.202 ,<38.757,-4.347,0> , 0.178}
cone { <38.757,-4.347,0> , 0.178 ,<38.895,-2.856,0> , 0.154}
cone { <38.895,-2.856,0> , 0.154 ,<38.976,-1.361,0> , 0.130}
cone { <38.976,-1.361,0> , 0.130 ,<39.000,0.136,0> , 0.106}
cone { <39.000,0.136,0> , 0.106 ,<38.966,1.633,0> , 0.082}
cone { <38.966,1.633,0> , 0.082 ,<38.874,3.128,0> , 0.058}
cone { <38.874,3.128,0> , 0.058 ,<38.726,4.618,0> , 0.034}
cone { <38.726,4.618,0> , 0.034 ,<38.520,6.101,0> , 0.010}
cone { <38.000,-8.773,0> , 0.250 ,<37.906,-9.171,0> , 0.226}
cone { <37.906,-9.171,0> , 0.226 ,<37.808,-9.567,0> , 0.202}
cone { <37.808,-9.567,0> , 0.202 ,<37.706,-9.962,0> , 0.178}
cone { <37.706,-9.962,0> , 0.178 ,<37.600,-10.357,0> , 0.154}
cone { <37.600,-10.357,0> , 0.154 ,<37.489,-10.750,0> , 0.130}
cone { <37.489,-10.750,0> , 0.130 ,<37.375,-11.142,0> , 0.106}
cone { <37.375,-11.142,0> , 0.106 ,<37.256,-11.533,0> , 0.082}
cone { <37.256,-11.533,0> , 0.082 ,<37.133,-11.922,0> , 0.058}
cone { <37.133,-11.922,0> , 0.058 ,<37.006,-12.310,0> , 0.034}
cone { <37.006,-12.310,0> , 0.034 ,<36.875,-12.697,0> , 0.010}
}

// The feather.inc

#declare Feather =
union
{ object
  { Nib
  scale <1,1,0.1>
  texture
  { pigment { color Gray85 }
    normal { onion frequency 27.5 bump_size 0.1125 turbulence 0.0855 }
    finish { ambient 0.125 diffuse 0.455 specular 0.2245 roughness 0.001 }
  }
  texture
  { pigment
    { radial
      color_map
      { [0/360, 6/360  color InkBlue color InkBlue  ]
        [6/360, 10/360 color InkBlue color InkBlueC ]
        [10/360, 1     color Clear   color Clear    ]
      }
      turbulence 0.275
      rotate 90*x
      rotate -19*z
    }
  }
}
  intersection
  { sphere { 0, 2 translate 40*x rotate 8*z }
    plane { -z, 0 }
  }
  intersection
  { sphere { 0, 2 scale <1,2,1> rotate -10*z translate 40*x rotate -8*z }
    plane { -z, 0 }
  }
 intersection
  { torus { 40, 2 rotate 90*x}
    plane { -z, 0 }
    plane { y, 0 rotate 8*z }
    plane { -y, 0 rotate -8*z }
  }
     texture
    { pigment
     { onion scale 4 phase 0.5
       pigment_map
       { [0.0 marble turbulence T frequency F color_map { [0.0, 1.0 color Light color Dark] } rotate 45*z]
         [0.25 marble turbulence T frequency F color_map { [0.0, 1.0 color Light color Dark] } rotate 45*z]
         [0.25 marble turbulence T frequency F color_map { [0.0, 1.0 color Light color Dark] } rotate-71*z]
         [1.0 marble turbulence T frequency F color_map { [0.0, 1.0 color Light color Dark] } rotate-71*z]
       }
     }
    normal
    { onion scale 4 phase 0.5
    normal_map
       { [0.0 marble sine_wave frequency 25 rotate 45*z bump_size 0]
         [0.25 marble sine_wave frequency 25 rotate 45*z bump_size 0.15]
         [0.25 marble sine_wave frequency 25 rotate-71*z bump_size 0.15]
         [1.0 marble sine_wave frequency 25 rotate-71*z bump_size 0]
       }
    }
  }

// Here's ink-pot.inc

#declare Inkpot =
union
{ difference
  { superellipsoid { <0.2,0.5> scale <1,0.75,1> }
    superellipsoid { <0.2,0.5> scale <1,0.75,1> scale 0.8 pigment { InkBlue } }
    cylinder { 0, y, 0.40 }
  }
  difference
  { cylinder { 0, y, 0.5 }
    superellipsoid { <0.2,0.5> scale <1,0.75,1> scale 0.8 }
    cylinder { -0.01, 1.01*y, 0.4 }
  }
  torus
  { 0.45,0.05 translate y }
  torus { 0.5, 0.1 scale <1,0.25,1> translate 0.8*y }

  texture
  { pigment { color Firebrick*0.85 }
    normal { bumps scale 0.25 scale <1,0.05,1> bump_size 0.35 }
    finish { diffuse 0.5 ambient 0.5 specular 0.133 roughness 0.01 crand 0.15 }
  }
  texture
  { pigment
    { gradient y
      color_map
      { [0.0, 0.70 color Clear color Clear]
        [0.70, 0.75 color InkBlueC color InkBlue]
        [0.75, 0.95 color InkBlue color InkBlue]
        [0.95, 1.0 color InkBlue color InkBlueC]
      }
      turbulence <0.2,1.2,0.2>/3
      scale <0.35, 1.25, 0.35>
        translate -y*0.15
    }
      finish { specular 0.75 roughness 0.0001 ambient 0.33 diffuse 0.5}
      normal { bumps scale 0.05 bump_size 0.75}
  }
}
}
//-----------------------------------------------------------//

// Now the phun begins

object { Table translate <25,0,8>}
object { Page rotate y*-20 translate <10,0,8>}
object { Apple translate <11,0,3> }
object { Telescope translate <30, 0, 8> }
object { Inkpot translate y scale pi translate <-2,0,-5> }
object { Feather rotate x*90 translate -40*x rotate y*70 translate <18,0.05,-8>}
union          // The candle
{ object { CandleHolder }
  object { Candle scale <0.75,0.35,0.75> translate 7.42*y }
  object { Flame }
  cylinder
  { <0.1,13,0>, <0.1,14,0>, 0.075 pigment { Black } }
  sphere
  { 0, 1 scale <1,0.4,1> translate 13.42*y
    texture
    { pigment { color CandleColor transmit 0.9 }
      finish { refraction on ior 1.526 reflection 0.333 specular 1 roughness 0.001}
      normal { onion sine_wave frequency 10 bump_size 0.2 translate 13.42*y }
   }
  }
  rotate y*65
  translate <25, 0, -12>
}

light_source
{ 0 color Gray50
  area_light
  4*x, 4*y
  2, 2
  translate <25,18,-12>
  jitter
}
light_source
{ 0 color Gray50
  area_light
  4*y, 4*z
  2, 2
  translate <25,18,-12>
  jitter
}
light_source
{ <15,8,-20> color White
  spotlight
  point_at <25,13,-12>
  radius 15
  falloff 110
  tightness 65
}

camera { location <5,30,-25> look_at <16,0,4> }
