/*
  Double Shell Generator For PoV 3.01
  Written by Wong Chee Fah on Thursday 22th May 1997
*/

// Enter Double Shell parameters here
#declare NumIterations = 32	// Number of Iterations (More for denser grid)
#declare U_Start = 0		// Start Value of U Parameter
#declare U_End = 4*pi		// End Value of U Parameter
#declare U_Step = 3		// Number of U Increments per Grid Square
#declare V_Start = -pi		// Start Value of V Parameter
#declare V_End = pi		// End Value of V Parameter
#declare V_Step = 3		// Number of V Increments per Grid Square
#declare Thickness = 2		// Grid Thickness
				// Enter 1 for Thick, 2 for Medium, 3 for Thin
#declare X_Rot = 0		// Rotation Angle of Double Shell about X-Axis
#declare Y_Rot = 0		// Rotation Angle of Double Shell about Y-Axis
#declare Z_Rot = 0		// Rotation Angle of Double Shell about Z-Axis
#declare Scale = 15		// Scale Factor for Color Map

#declare Increment = pi/NumIterations

// The Double Shell is computed here
#declare Shell = union {

#declare Origin_Occupied = 0

#declare U = U_Start
#while ( U <= U_End )

#declare V = V_Start
#while ( V <= V_End )

	#declare X_Pos_0 = U * pow(cos(V),3) * cos(U)
	#declare Y_Pos_0 = U * pow(cos(V),3) * sin(U)
	#declare Z_Pos_0 = U * cos(V) * sin(V)

	#if (( X_Pos_0 = 0 ) & ( Y_Pos_0 = 0 ) & ( Z_Pos_0 = 0 ))
		#declare At_Origin = 1
	#else
		#declare At_Origin = 0

		object {
		        sphere {0, Increment/Thickness}
       			translate < X_Pos_0, Y_Pos_0, Z_Pos_0 >
			}

	#end	// End of IfElse

	#if (At_Origin & (!Origin_Occupied))
		#declare Origin_Occupied = 1

		object {
		        sphere {0, Increment/Thickness}
       			translate < X_Pos_0, Y_Pos_0, Z_Pos_0 >
			}

	#end	// End of If

	#if (!( U = 0 ))
		#declare V_1 = V - Increment/V_Step

		#declare X_Pos_1 = U * pow(cos(V_1),3) * cos(U)
		#declare Y_Pos_1 = U * pow(cos(V_1),3) * sin(U)
		#declare Z_Pos_1 = U * cos(V_1) * sin(V_1)

		object {
			cylinder {
		  	  < X_Pos_0, Y_Pos_0, Z_Pos_0 >,
			  < X_Pos_1, Y_Pos_1, Z_Pos_1 >,
		  	  Increment/Thickness
 				 }
			}
	#end	// End of If

#declare V = V + Increment/V_Step
#end	// End of While

#declare U = U + Increment
#end	// End of While

#declare V = V_Start
#while ( V <= V_End )

#declare U = U_Start + Increment/U_Step
#while ( U <= U_End )

	#if (!( cos(V) = 0 ))
		#declare X_Pos_0 = U * pow(cos(V),3) * cos(U)
		#declare Y_Pos_0 = U * pow(cos(V),3) * sin(U)
		#declare Z_Pos_0 = U * cos(V) * sin(V)

		#declare U_1 = U - Increment/U_Step

		#declare X_Pos_1 = U_1 * pow(cos(V),3) * cos(U_1)
		#declare Y_Pos_1 = U_1 * pow(cos(V),3) * sin(U_1)
		#declare Z_Pos_1 = U_1 * cos(V) * sin(V)

		object {
			cylinder {
		  	  < X_Pos_0, Y_Pos_0, Z_Pos_0 >,
			  < X_Pos_1, Y_Pos_1, Z_Pos_1 >,
		  	  Increment/Thickness
	 			 }
			}
	#end	// End of If

#declare U = U + Increment/U_Step
#end	// End of While

#declare V = V + Increment
#end	// End of While

} // End of Union (Shell)

// Define texture for the Double Shell
#declare Atexture = texture {
                         finish{
                                ambient 0.2
                                diffuse 0.8
                                phong 1.0
                                phong_size 30.0
                               }
                             }

// Define colors for the color map 
#declare Color0 = color rgb< 1, 0, 0 >
#declare Color1 = color rgb< 1, 1, 0 >
#declare Color2 = color rgb< 0, 1, 0 >
#declare Color3 = color rgb< 0, 1, 1 >
#declare Color4 = color rgb< 0, 0, 1 >
#declare Color5 = color rgb< 1, 0, 1 >

// Place the Double Shell in the scene
object {
        Shell
        texture { Atexture
                pigment {
			onion
                        color_map {
                                [ 0.0 Color0 ]
			        [ 1/6 Color1 ]
				[ 1/3 Color2 ]
                                [ 0.5 Color3 ]
				[ 2/3 Color4 ]
				[ 5/6 Color5 ]
				[ 1.0 Color0 ]
				  }
                        }
		 scale Scale
                }
	 rotate < X_Rot, Y_Rot, Z_Rot >
	} // End of Object

// Place camera
camera {
	location  < 14.5, 14.5, 14.5 >
	direction <  0.0,  0.0,  1.0 >
	up	  <  0.0,  1.0,  0.0 >
	right	  <  4/3,  0.0,  0.0 >
	look_at   < -2.0, -1.9, -4.0 >
	}

// Let there be light
object { light_source { <300, 300, 300> color rgb< 1, 1, 1 > } }
