
// --------------------------------- Logarithmic snail -----------------------
// This file creates a logarithmic snail like the ones existent in nature ; it works
// with Persistence of Vision Raytracer v 3.0 or greater .
// You can change declared X , Y and Z to obtain fine parametric equations ,
// File created by Stefano Basso  Via Roggia di Palma 58 33100 Udine   Italy .
//  For suggestions and answers please e-mail to : bassos@iol.it

#include "colors.inc"



 light_source { <20,20,-5> color  rgb <0.9,0.5,0.3>    }
 
 light_source { <-10,-10,-20> color  rgb <0.7,0.7,0.7> }

camera {
          direction <0,0,1>
          up <0,1,0>
          location  <-5 , 5 ,-16>
          look_at   <-5.1 , 2 , 0.0>
       }

//--------------------------------  Main Object  ----------------------------------
#declare Main =  sphere  {<0,0,0> , 0.6 }


#declare min_A =-3.14
#declare max_A = 3.14
#declare min_B = -38
#declare max_B = 18
#declare dens_A = 25
#declare dens_B = 210
#declare A= min_A
#declare B= min_B

#while (A<=max_A)

// ------------------------------------- Main Equations ------------------------------
// Numbers 0.11 and 2.2 could be changed a little to obtain more convoluted shapes.

#declare fi=pow(2.7182,(0.11*B))
#declare X=((cos(A)*(fi/2.2)+fi))*sin(B)
#declare Y=((cos(A)*(fi/2.2)+fi))*cos(B)
#declare Z=sin(A)*(fi/2.2)-fi

object { Main    scale <abs(Z)*(.3),abs(Z)*(.3),abs(Z)*(.3)>
                 translate <X,Y,Z>
                 rotate <180,0,0>
                 rotate <0,-35,0>

                     texture {
                              pigment {  colour rgb <abs(cos(A)),abs(sin(A)),abs(cos(A))>  }

                               finish  {
                                       ambient 0.3
                                       reflection 0.5
                                       phong 1
                                       specular 1
                                       brilliance 4

                                       }
                             }
       }

#declare  B=B+(max_B - min_B)/ dens_B

  #if (B=max_B)
     #declare  A=A+(max_A - min_A)/ dens_A
  #end

  #if (B=max_B)
     #declare B=min_B
  #end

#end




