#declare accretion = true
#declare accretion_halo = true
#declare use_lights = true
#declare force_delta = 8
#declare show_jets = true
#declare show_albert = true
#declare show_stars = true

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"

#declare ft=12

camera
{
  location  <-5*ft , 22*ft ,16*ft>
  sky z
  look_at   <0, 0 , 4*ft>
}

#if (use_lights)
light_source
    {
    <-500*ft,300*ft,1000*ft>
    color 1
    }

light_source
    {
    <-200*ft,-1000*ft,-500*ft>
    color 1
    }

light_source
    {
    y*-100
    color 1
    shadowless
    fade_distance 10
    fade_power 2
    }
#else
global_settings
{
  assumed_gamma 1.0
}
#end

//#if (show_stars)
sphere { 0, 1 hollow texture{ Starfield scale 1 } finish { ambient .3 diffuse 0 } scale 1e5 translate y*-100}
//#end


#if (show_albert)
merge
{
// main board
merge
    {
    cylinder
        {
        0,  2*z,  1*ft
        texture { pigment {Yellow} }
        }
    box
        {
        <-2,-11,-0.01>, <2,11,2.01>
        texture { pigment {Red} }
        }
    scale <1,6,1>
    }

// fin
intersection
    {
    box { <-1,-6*ft,-1*ft> <1,-5*ft,0> }
    difference
        {
        cylinder { <-2.5,-6*ft,0> <2.5,-6*ft,0> 1*ft }
        cylinder { <-3,-6*ft,-6> <3,-6*ft,-6> 6 }
        }
    texture{ pigment{ Yellow } }
    }
rotate y*30
translate z*5
}

// Albert!
box
    {
    <0, 0, 0>
    < 1,  1, 0.01>
    pigment
        {
        image_map
            {
            gif "bike2.gif"
            map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
            transmit 214 1
            once
            } // image_map
        }
    finish { ambient 1 }
    scale <3*ft, 6*ft, 1>
    rotate <90,0,0>
    translate <-1*ft,-1.2*ft,0>
    }
#end // show_albert


// The 'force' lines of the gravity wave
#declare i = 0
#while (i < 360)
torus
    {
    110, 0.3
    translate x*-181+z*15
    rotate z*i
    translate y*-100
    texture { pigment {color rgb<0.2,0.2,2> } finish { diffuse 0 reflection 0 ambient .5  } }
    no_shadow
    }
#declare i = i + force_delta
#end


#if (accretion)
// accretion disk
lathe
    {
    cubic_spline

    17,

    < .155 ,   .0324>,
    < .1676,   .2824>,
    < .4118,   .0676>,
    < .447 ,   .0558>,
    <1.1236,   .0676>,
    <1.7264,   .2118>,
    <1.943 ,   .8 >,
    <2.0,      .2264>,
    <2.003,       0>,
    <2.0,     -.2264>,
    <1.943,   -.8 >,
    <1.7264,  -.2118>,
    <1.1236,  -.0676>,
    < .447 ,  -.0558>,
    < .4118,  -.0676>,
    < .1676,  -.2824>,
    < .155 ,  -.0324>

#if (accretion_halo)
    hollow
    inverse
#end

    texture
        {

#if (!accretion_halo)
       pigment
            {
            onion // pattern
            color_map
                {
                [0 color White ]
                [0.2 color White ]
                [0.3 color  rgbf <1,   1, 1, 0.1> ]
                [0.5 color  rgbf <1,   1, 0, 0.3> ]
                [0.65 color rgbft<1,   0, 0, 0.1, 0.3> ]
                [0.85 color rgbft<0.3, 0, 0, 0.2, 0.3> ]
                [1 color    rgbft<1,   1, 1, 0,   1> ]
                }
            turbulence <0.15,0.15,0>
            scale <2.5,2.5,4>// transformations
            }
#else

        pigment { color rgbt <1, 1, 1, 1> }
        halo
            {
            emitting
            cylindrical_mapping
            linear
            turbulence .2
            frequency 1
            color_map
                {
                [0 color    rgbft<1,   1, 1, 0,   1> ]
                [0.15 color rgbft<0.3, 0, 0, 0.2, -0.2> ]
                [0.35 color rgbft<1,   0, 0, 0.1, -0.2> ]
                [0.5 color  rgbft<1,   1, 0, 0.1, -0.2> ]
                [0.7 color  rgbft<1,   1, 1, 0.1, -0.1> ]
                [0.83 color White ]
                [1 color White ]
                }
            scale 2.25
            samples 50
            rotate x*90
            }

#end
        finish
            {
            diffuse 0    // no shine at all
            ambient 0.7
            }
        rotate x*90
        }

    no_shadow
    scale <2*ft, 6, 2*ft>
    rotate x*90
    scale 3
    translate y*-100
    }
#else
torus
    {
    1*ft 2
    rotate x*90
    scale <6,6,1>
    pigment { color White }
    }
#end

#declare jet =
cone { 0, .1, y, 1
    hollow
//
    texture
        {
        pigment { color rgbt <1, 1, 1, 1> }
        halo
            {
            emitting
            cylindrical_mapping
            linear
            turbulence 2
            frequency 1
            color_map
                {
                [ 0  color rgbt <0.3, 0.3, 0.3, 1> ]
                [ 0.1  color rgbt <1,1,1, -1> ]
                [ 0.3  color rgbt <0.3, 0.1, 1, -1> ]
//                [ 1  color rgbt <0.3, 0.3, 1, -.5> ]
                [ 1 color rgbft <1,1,1,1> ]
                }
            samples 10
            scale 0.3
            }
        }
//
    scale <20,35*ft,20>
    rotate x*90
    }

#if (show_jets)
object { jet translate y*-100 }
object { jet rotate x*180 translate y*-100 }
#end
