//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 5 lights, 8 textures and 18 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 06/26/1997    (26.06.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//


// Hardy Black
// hardywblac@aol.com


global_settings {
  adc_bailout 0.004
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 4    // Rayleigh
  distance     0.1
  color <0.5,0.5,0.5,0.5,0.5>
  scattering   0.1
  samples      2
  jitter       0.0
  aa_threshold 1.0
  aa_level     3.0
}

camera {  //  Camera StdCam
  location  <8.644, -44.039, 15.619>
  direction <0.0,     0.0,  1.8276>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <4.100, 0.164, 5.791>  // Focal blur settings
  focal_point  <4.100, 0.164, 5.791> // Always Lookat
  aperture     1.0
  blur_samples 7
  confidence   0.5
  variance     0.02

}



// *******  L I G H T S *******
light_source {   // Light004
  <29.298, -43.688, 26.351>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light003
  <-12.755, -43.710, 26.327>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light002
  <-13.508, 20.806, 25.912>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light001
  <29.355, 20.044, 26.524>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Spotlight SpotL001
  <5.170, -44.234, 26.854>
  color  rgb <1.000, 1.004, 1.008>
  spotlight
    point_at  <5.303, -43.346, 26.413>
    falloff   4.0  // outer radius (in deg)
      radius    1.1  // inner radius
}


// ********  TEXTURES  *******
//

#include "table.inc"



// ********  REFERENCED OBJECTS  *******

#declare laser_unit = intersection {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 2.0>
    translate  -1.0*z
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.715014, 0.818314, 1.032035>
  }
  texture {
    Silver2
  }
  scale <0.5, 0.5, 0.75>
  rotate -90.0*y
  translate  <0.114344, -9.989382, 9.637576>
}
#declare laser = union { // laser
  object { laser_unit }
  cylinder { // laser_beam
    <0,0,1>, <0,0,0>, 1
    texture {
      laser_beam_text
    }
    no_shadow
    hollow
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <6.866109, -9.95542, 9.575563>
  }
  translate  <2.857079, 0.210471, 0.0>
}


//
// Include file contains 'table_leg'
//
#include "table.in1"
#declare table_leg = object {
  table_leg_Raw
  texture {
    DMFDarkOak1
  }
  scale <1.0, 1.0, 4.0>
  translate  <10.003869, -0.411115, 4.155916>
}




// ********  OBJECTS  *******











plane { // wall
  z,0
  texture {
    wall_text
  }
  rotate 90.0*x
  translate  30.556308*y
}


plane { // Plane001
  z,0
  texture {
    floor_text
  }
}


object { // laser2->laser
  laser
  rotate -36.933365*z
  translate  <7.921088, 4.181097, 0.0>
}


object { // laser1->laser
  laser
  rotate -89.029503*z
  translate  <19.92892, 0.783098, 0.0>
}


object { laser }


union { // table
  box { // table_top
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blood_Marble1
    }
    scale <-8.625113, -7.630789, -0.345517>
    rotate <-180.0, 0.0, -180.0>
    translate  <5.181822, -5.100012, 8.590095>
  }
  object { // RotSwp4->table_leg
    table_leg
    translate  <-9.816298, -9.61156, 0.163621>
  }
  object { // RotSwp3->table_leg
    table_leg
    translate  <-9.717744, 0.0, -0.245431>
  }
  object { // RotSwp2->table_leg
    table_leg
    translate  <0.449215, -10.003869, 0.0>
  }
  object { table_leg }
}


sphere { // target
  <0,0,0>,1
  texture {
    target_text
  }
  scale 0.5
  translate  <10.199697, -9.591016, 9.549644>
}


