
// Glenn's Buildings POV-Ray Scene File
// first concept 23-May-97 last update 22-Jun-97
// copyright Glenn McCarter 1997
// This file does not render.  #include "Buildings.inc" in another .pov file
//
// A collection of various buildings
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//===============================================
//             Variable Declarations
//===============================================



//===============================================
//             Textures
//===============================================

#declare TanBricks =
	texture {
		pigment {
			brick rgb<.2,.2,.2>, rgb<.6,.6,.4>
			brick_size <16,6,9>
			mortar 0.8
			rotate x*90
		}
	}

#declare BrownBricks =
	texture {
		pigment {
			brick rgb<.6,.6,.6>, rgb<.3,.2,.05>
			brick_size <16,6,9>
			mortar 0.8
			rotate x*90
		}
	}

#declare DullBrownPaint =
	texture {
		pigment { color rgb<.2,.1,.05> }
		finish { specular .04 roughness .2 }
	}

#declare GlassTex =
	texture {
		pigment { color rgb<.6,.6,.8> }
		finish { specular .96 roughness .001 reflection .5 }
	}

#declare LitGlassTex =
	texture {
		pigment { color rgb<.8,.8,.4> }
		finish { ambient .95 specular .96 roughness .001  }
	}


//===============================================
//       Objects
//===============================================

#declare SWindow = //simple, unlit, on X-Z plane
// origin at lower LH corner
	union {
		box { // frame
			<0,-1,0>,<30,1,48>
			texture { DullBrownPaint }
		}
		box { // window
			<2,-1.2,2>,<28,.1,46>
			texture { GlassTex }
		}
	}

#declare SWindowLit = //simple, lit up, on X-Z plane
// origin at lower LH corner
	union {
		box { // frame
			<0,-1,0>,<30,1,48>
			texture { DullBrownPaint }
		}
		box { // window
			<2,-1.2,2>,<28,.1,46>
			texture { LitGlassTex }
		}
	}

//===============================================
//       Building Assemblies
//===============================================

#declare Bldg1 = // very simple 2-story brick, with lit windows
	union {
		box { // building
			<0,0,0>,<42*Feet,42*Feet,22*Feet>
			texture { TanBricks }
		}
		box { // roof
			<-1*Feet,-1*Feet,21.5*Feet>,<43*Feet,43*Feet,22.5*Feet>
			texture { pigment { color rgb <.4,.4,.2> } }
		}
		box { // box on roof
			<8*Feet,8*Feet,22*Feet>,<16*Feet,16*Feet,29*Feet>
			texture { pigment { color rgb <.1,.1,.1> } }
		}
		object { SWindow rotate z*-90 translate <0*Feet,8*Feet,70> }
		object { SWindowLit rotate z*-90 translate <0*Feet,16*Feet,70> }
		object { SWindow rotate z*-90 translate <0*Feet,24*Feet,70> }
		object { SWindowLit rotate z*-90 translate <0*Feet,32*Feet,70> }
		object { SWindowLit rotate z*-90 translate <0*Feet,8*Feet,14*Feet> } // second story
		object { SWindowLit rotate z*-90 translate <0*Feet,16*Feet,14*Feet> }
		object { SWindow rotate z*-90 translate <0*Feet,24*Feet,14*Feet> }
		object { SWindow rotate z*-90 translate <0*Feet,32*Feet,14*Feet> }
		translate <-21*Feet,-21*Feet,0> // center of bldg on origin
	}

#declare Bldg2 = // very simple 1-story brick, narrow and long-X
#declare LengthX = 70*Feet
#declare WidthY = 26*Feet
#declare HeightZ = 16*Feet
	union {
		box { // building
			<0,0,0>,<LengthX,WidthY,HeightZ>
			texture { BrownBricks }
		}
		box { // roof
			<-1*Feet,-1*Feet,HeightZ-.5*Feet>,<LengthX+1*Feet,WidthY+1*Feet,HeightZ+.5*Feet>
			texture { pigment { color rgb <.4,.4,.2> } }
		}
		translate <-LengthX/2,-WidthY/2,0> // center of bldg on origin
	}
