
// Glenn's Locomotive Steam POV-Ray Scene File
// first concept 30-May-97 last update 30-May-97
// copyright Glenn McCarter 1997
// This file does not render.  #include "LocoSteam.inc" in another .pov file
//
// A couple of locomotive steam specifications
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system

//===============================================
//             Variable Declarations
//===============================================



//===============================================
//             Textures
//===============================================


#declare SimpleSteamTex =
	texture {
		pigment { color rgb<1.0,1.0,1.0> }
		finish {
			ambient 0.6
			specular 0.3
			roughness .1
		}
	}


//===============================================
//       Objects
//===============================================

#declare SimpleSteamBall =
	sphere {
		<0,0,0>,1
		texture { SimpleSteamTex }
		scale <1,1,1>
		translate <0,0,0>
	}
#declare TSimpleSteamBall = // for testing
	sphere {
		<0,0,0>,1
		texture { pigment { color rgb<.8,.8,0> } }
		scale <1,1,1>
		translate <0,0,0>
	}

#declare SimpleSteam = // origin at first ball
	union {
		object { SimpleSteamBall scale 6 translate <0,0,0> }
		object { SimpleSteamBall scale 7 translate <1,2,2> }
		object { SimpleSteamBall scale 6 translate <2,-2,4> }
		object { SimpleSteamBall scale 8 translate <4,-3,5> }
		object { SimpleSteamBall scale 10 translate <6,3,8> }
		object { SimpleSteamBall scale 9 translate <8,6,18> }
		object { SimpleSteamBall scale 12 translate <10,2,24> }
		object { SimpleSteamBall scale 11 translate <14,8,36> }
		object { SimpleSteamBall scale 13 translate <19,1,48> }
		object { SimpleSteamBall scale 9 translate <25,11,52> }
		object { SimpleSteamBall scale 13 translate <31,2,55> }
		object { SimpleSteamBall scale 14 translate <33,6,65> }
		object { SimpleSteamBall scale 17 translate <36,11,78> }
		object { SimpleSteamBall scale 15 translate <41,4,78> }
		object { SimpleSteamBall scale 19 translate <47,8,88> }
		object { SimpleSteamBall scale 17 translate <53,14,106> }
		object { SimpleSteamBall scale 22 translate <66,27,119> }
		object { SimpleSteamBall scale 19 translate <82,34,133> }
		object { SimpleSteamBall scale 21 translate <94,44,143> }
	}

#declare HaloSteamBall =
	sphere { 0, 1
		texture {
		pigment { color rgbt <1, 1, 1, 1> } // clear
		halo {
			attenuating
//emitting
//			dust
//			dust_type 2
//			constant
			spherical_mapping
			linear
//			max_value 1.0
			colour_map {
//				[ 0 color rgbf <1, 1, 1, 0.0> ]
//				[ 1 color rgbf <1, 1, 1, 0.1> ]
				[ 0 color rgbt <.5, .5, .5, 1.0> ]
				[ 1 color rgbt <.5, .5, .5, 0.1> ]
//				[ 0 color rgbt <1, 1, 1, 1.0> ]
//				[ 1 color rgbt <1, 1, 1, 0.1> ]
			}
			samples 10
			aa_level 5
			aa_threshold 0.1
			jitter 0.8
		}
//		finish { ambient .9 }
		}
		hollow
		scale 1.5
	}

#declare HaloSteam =
	union {
		object { HaloSteamBall scale 4 translate <0,0,0> }
		object { HaloSteamBall scale 5 translate <1,2,3> }
		object { HaloSteamBall scale 6 translate <2,-2,4> }
		object { HaloSteamBall scale 7 translate <4,-3,12> }
		object { HaloSteamBall scale 8 translate <6,3,16> }
		object { HaloSteamBall scale 9 translate <8,6,18> }
		object { HaloSteamBall scale 10 translate <10,2,24> }
		object { HaloSteamBall scale 11 translate <14,8,36> }
		object { HaloSteamBall scale 13 translate <18,1,48> }
		object { HaloSteamBall scale 9 translate <22,11,52> }
		object { HaloSteamBall scale 13 translate <27,2,55> }
		object { HaloSteamBall scale 8 translate <14,2,57> } // puff ball
		object { HaloSteamBall scale 14 translate <32,6,65> }
		object { HaloSteamBall scale 17 translate <36,11,78> }
		object { HaloSteamBall scale 15 translate <41,4,78> }
		object { HaloSteamBall scale 8 translate <26,3,78> } // puff ball
		object { HaloSteamBall scale 19 translate <47,8,88> }
		object { HaloSteamBall scale 17 translate <53,14,106> }
		object { HaloSteamBall scale 8 translate <36,8,106> } // puff ball
		object { HaloSteamBall scale 22 translate <66,27,119> }
		object { HaloSteamBall scale 19 translate <82,34,133> }
		object { HaloSteamBall scale 21 translate <94,44,143> }
	}

#declare WheelSteam =
	sphere { 0, 1
		texture {
			pigment { color rgbt <1, 1, 1, 1> }
			halo {
				attenuating
				spherical_mapping
				linear
				colour_map {
					[ 0 color rgbt <.8, .8, .8, 1.0> ] // transparent
					[ 1 color rgbt <.8, .8, .8, 0.1> ] // saturated
				}
				turbulence 1
				samples 10
				aa_level 5
				aa_threshold 0.1
				jitter 0.8
			}
				scale .6
		}
		hollow
		scale 1
	}
