
#include "Rocks.inc"

// Glenn's Railroad POV-Ray Object File
// This file does not render.  #include "Railroad.inc" in another .pov file
// first concept 21-May-97  last update 22-June-97
// copyright 1997 Glenn McCarter

// A railroad
// Intended scale is English system (inches)
// Railroad has a wood crossing at the origin, and extends +/- 3 miles in X-direction
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#declare RustyIron =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.13,.28> ] // iron
				[0.45 color rgb<.26,.18,.08> ] // light rust
				[0.50 color rgb<.09,.03,.01> ] // dark rust
				[0.55 color rgb<.26,.18,.08> ] // light rust
				[1.00 color rgb<.20,.13,.28> ] // iron
			}
			scale .3
		}
		finish { specular .1 roughness .14 }
	}

#declare RRTieTex =
	texture {
		pigment {
//			color rgb<.5,.4,.2> // test color
			agate
			color_map { // black cracks in wood
				[ 0.0  color rgb<0.20,0.10,0.05> ]
				[ 0.45  color rgb<0.16,0.08,0.03> ]
				[ 0.45  color rgb<0.60,0.52,0.40> ] // acts like crand highlights
				[ 0.47  color rgb<0.50,0.44,0.25> ] // acts like crand highlights
				[ 0.5  color rgb<0.06,0.03,0.01> ] // black streak
				[ 0.7  color rgb<0.06,0.03,0.01> ] // black streak
				[ 0.7  color rgb<0.16,0.08,0.03> ]
				[ 1.0  color rgb<0.20,0.10,0.05> ]
			}
			scale <6,24,6>
		}
		normal {
			wood 0.2 // z-axis
			turbulence 0.05
			rotate <90,1.4,1.4>
			scale 0.3
		}
		finish { specular .3 roughness .1 }
	}

//===============================================
//             Objects
//===============================================

#declare Rail = // top of rail at z=4.0
	prism {
		linear_spline
		0,6*Miles
		15
		<0,0>,<1.8,0>,<1.8,.6>,
		<.7,.9>,<.7,3.1>,<1.5,3.3>,<1.5,3.8>,
		<0,4.0>,
		<-1.5,3.8>,<-1.5,3.3>,<-.7,3.1>,<-.7,.9>,
		<-1.8,.6>,<-1.8,0>,<0,0>
		texture {
			pigment {
				gradient z
				color_map {
//					[ 0.0  color rgb<0.21,0.11,0.04> ] // dull reddish
//					[ 0.5  color rgb<0.27,0.20,0.33> ]
//					[ 1.0  color rgb<.57,.37,0.80> ] // bright steel
					[ 0.00  color rgb<0.23,0.11,0.10> ] // dull reddish
					[ 0.94 color rgb<0.33,0.20,0.33> ]
					[ 1.00  color rgb<.67,.47,0.86> ] // bright steel on top
				}
				scale <1,1,6>
				translate z*-2
			}
			finish { metallic specular .8 roughness .002 }
		}
	}
#declare RRTie = // along Y-axis
	intersection {
		superellipsoid {
			<.2,.2>
			scale <4,33,4>
			texture { RRTieTex }
		}
		box {
			<-5,-32,-5>,<5,32,5>
			texture { RRTieTex }
		}
	}
#declare SpikeStuff =
	union {
		box { // base plate
			<-3,-12,0>,<3,2,.45>
			texture { RustyIron }
		}
		sphere { // spike
			<0,0,0>,.7
			texture { RustyIron }
			scale <1,1,.8>
			translate <1.5,0,.55>
		}
		sphere { // spike
			<0,0,0>,.7
			texture { RustyIron }
			scale <1,1,.8>
			translate <-1.5,0,.55>
		}
		torus { // rail tiedown
			1.5,.4
			texture { RustyIron }
			rotate <0,0,90>
			rotate <0,0,18>
			translate <.55,-2,.2>
		}
		torus { // rail tiedown
			1.5,.4
			texture { RustyIron }
			rotate <0,0,90>
			rotate <0,0,-18>
			translate <-.55,-2,.2>
		}
	}

#declare RS = seed(16643)
#declare RockGroup1 =
	union {
		#declare RockY = 0
		#while ( RockY > -10 )
			#declare RockX = 0
			#while ( RockX < 9 )
				object {
					BlankHFRock1
					#declare BaseGrey = rand(RS)/3+.2
					texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
					rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
					scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
					translate <RockX+rand(RS),RockY+rand(RS),-RockY+rand(RS)>
				}
				#declare RockX = RockX + 1
				#end
			#declare RockY = RockY - 1
		#end
//		bounded_by { box { <-2,-2,-2>,<12,20,20> } }
	}
#declare RockGroup2 =
	union {
		#declare RockY = 0
		#while ( RockY > -10 )
			#declare RockX = 0
			#while ( RockX < 9 )
				object {
					BlankHFRock1
					#declare BaseGrey = rand(RS)/3+.2
					texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
					rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
					scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
					translate <RockX+rand(RS),RockY+rand(RS),-RockY+rand(RS)>
				}
				#declare RockX = RockX + 1
				#end
			#declare RockY = RockY - 1
		#end
//		bounded_by { box { <-2,-2,-2>,<12,20,20> } }
	}

#declare RS = seed(40482) // random number seed
#declare ScatteredRocks =
	union {
		#declare RockY = 0
		#while ( RockY > -6 ) // rows
			#declare RockX = 0
			#while ( RockX < 12 ) // columns
				object {
					BlankHFRock1
					#declare BaseGrey = rand(RS)/3+.2
					texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
					rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
					scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
					translate <RockX*1.6+rand(RS)*2,RockY+rand(RS),rand(RS)>
				}
				#declare RockX = RockX + 1
				#end
			#declare RockY = RockY - 1
		#end
//		bounded_by { box { <-2,-2,-2>,<12,20,20> } }
	}

#declare SpecialRocks = // specifically placed rocks
	union {
//		sphere { <0,0,0>,3 texture {pigment{ color White } } } // test
		object {
			BlankHFRock1
			#declare BaseGrey = rand(RS)/2+.2
			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
//			texture { pigment { color rgb<BaseGrey*2,BaseGrey*2,BaseGrey*2> } }
			rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
			translate <0,0,0>
		}
		object {
			BlankHFRock1
			#declare BaseGrey = rand(RS)/2+.2
			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
//			texture { pigment { color rgb<BaseGrey*4,BaseGrey*2,BaseGrey> } }
			rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
			translate <-4,0,0>
		}
		object {
			BlankHFRock1
			#declare BaseGrey = rand(RS)/2+.2
			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
//			texture { pigment { color rgb<BaseGrey,BaseGrey*3,BaseGrey> } }
			rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
			translate <-16,0,0>
		}
		object {
			BlankHFRock1
			#declare BaseGrey = rand(RS)/2+.2
			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
//			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey*3> } }
			rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
			translate <-12,0,0>
		}
		object {
			BlankHFRock1
			#declare BaseGrey = rand(RS)/2+.2
			texture { pigment { color rgb<BaseGrey,BaseGrey,BaseGrey> } }
//			texture { pigment { color rgb<BaseGrey*2,BaseGrey*2,BaseGrey> } }
			rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
			scale <rand(RS)*.4+.4,rand(RS)*.4+.4,rand(RS)*.4+.4>
			translate <-8,4,0>
		}
	}

#declare CrossTies =
	union {
		object { RRTie rotate <0,0,90> scale <5,1,1> translate <0,0,0> }
		object { RRTie rotate <0,90,90> scale <5,1,1> translate <0,5,0> }
		object { RRTie rotate <0,180,90> scale <5,1,1> translate <0,-5,0> }
		object { RRTie rotate <0,270,90> scale <5,1,1> translate <0,15,0> }
		object { RRTie rotate <0,0,90> scale <5,1,1> translate <0,-15,0> }
		object { RRTie rotate <0,90,90> scale <5,1,1> translate <0,33,0> }
		object { RRTie rotate <0,270,90> scale <5,1,1> translate <0,-33,0> }
		object { RRTie rotate <0,180,90> scale <5,1,1> translate <0,43,0> }
		object { RRTie rotate <0,0,90> scale <5,1,1> translate <0,-43,0> }
	}
#declare RRTies =
	union {
		#declare CountX = 1
		#while ( CountX < 30 )
			object { RRTie
				rotate y*90*CountX // flips each consecutive tie (so textures aren't identical)
				translate x*CountX*18
			}
			object { SpikeStuff translate <CountX*18,28,3.95> } // set on top of tie
			object { SpikeStuff transform InverseY translate <CountX*18,-28,3.95> }
			#declare CountX = CountX + 1
		#end
	}

#declare RROffset = 0
#declare RailRoad =
	union {
		object { Rail rotate z*90 translate <3*Miles,24,0> }
		object { Rail rotate z*90 translate <3*Miles,-24,0> }
		object { RRTies translate <-20*Feet+RROffset,0,-4.6> }
		object { CrossTies translate <6*Feet,0,0> }
		object { RockGroup1 rotate <0,0,0> translate <-110+RROffset,34,-10> }
		object { RockGroup2 rotate <0,0,0> translate <-110+RROffset,31,-10> } // behind
		object { RockGroup2 rotate <0,0,0> translate <-128+RROffset,34,-10> }
		object { RockGroup1 rotate <0,0,0> translate <-120+RROffset,31,-10> } // behind
		object { ScatteredRocks translate <-136+RROffset,34,-4> }
		object { SpecialRocks translate <-120+RROffset,38,-4> }
	}

