
// Persistence of Vision Ray Tracer Scene Description File
// File: wbspctrm.pov
// Vers: 3
// Desc: Classic white-light-through-prism demonstration. For the May-June 97 IRTC
//			topic "Physics and Math"
// Date: 10 June 1997
// Auth: William Bobzien

// >>>> INCLUDES <<<<
#include "colors.inc"
#include "textures.inc"

// >>>> CAMERA <<<<
camera
{
	location <0,12,-30>
	rotate y*112
	look_at <0,0,0>
}

// >>>> PIGMENTS & TEXTURES <<<<

// "marble" material for top of lab table

#declare Top =
pigment
{
	marble
	turbulence .7
	color_map
	{
		[ 0.00 color Black ]
		[ 0.40 color Black ]
		[ 0.45 color Gray  ]
		[ 0.50 color White ]
		[ 0.55 color Gray  ]
		[ 0.60 color Black ]
		[ 1.00 color Black ]
	}
	scale 1/48
}

#declare TableTop =
texture
{
	gradient z
	texture_map
	{
		[ 0.00 pigment { Top } finish { ambient .07 } ]
		[ 1.00 pigment { Top } finish { ambient .01 } ]
	}
	scale 48
}
// floor tiles

#declare Blue_Tile =
pigment
{
	marble
	turbulence .7
	color_map
	{
		[ 0.00 color SlateBlue ]
		[ 0.40 color SlateBlue ]
		[ 0.45 color Gray      ]
		[ 0.50 color White     ]
		[ 0.55 color Gray      ]
		[ 0.60 color SlateBlue ]
		[ 1.00 color SlateBlue ]
	}
	scale <.4,.1,.1>
}

#declare White_Tile =
pigment
{
	marble
	turbulence .7
	color_map
	{
		[ 0.00 color White     ]
		[ 0.40 color White     ]
		[ 0.45 color Gray      ]
		[ 0.50 color SlateBlue ]
		[ 0.55 color Gray      ]
		[ 0.60 color White     ]
		[ 1.00 color White     ]
	}
	scale <.4,.1,.1>
}

// Case of light source

#declare Light_Tex =
texture
{
	granite
	turbulence .5
	texture_map
	{
		[ 0.00 pigment { Khaki } finish { ambient .07 } ]
		[ 1.00 pigment { Khaki } finish { ambient .01 } ]
	}
	scale .125
}

// Fixture texture

#declare Fixture =
texture
{
	gradient z
	texture_map
	{
		[ 0.00 pigment { Silver } finish { ambient .05 reflection .125 metallic } ]
		[ 1.00 pigment { Silver } finish { ambient .01 reflection .125 metallic } ]
	}
	translate -.5*z
}

// >>>> OBJECTS <<<<

// Floor
box
{
	<-240,-52,-240>,<240,-48,240>
	texture
	{
		gradient x
		texture_map
		{
			[ 0.00 pigment { checker pigment {White_Tile}, pigment {Blue_Tile} scale .03 }
			  finish { ambient .05 } ]
			[ 1.00 pigment { checker pigment {White_Tile}, pigment {Blue_Tile} scale .03 }
			  finish { ambient .01 } ]
		}
		scale 300
	}
}

// Wall
box
{
	<240,-52,-240>,<246,72,240>
	pigment {White}
	finish {ambient .025}
}

// Side Wall
box
{
	<240,-52,-240>,<-240,72,-246>
	pigment {White}
	finish {ambient .025}
}

// Base
difference
{
	box
	{
		<-21,-48,-46>,<24,-2,5>
	}
	box
	{
		<-12,-10,-9>,<12,-1,9>
		translate z*-37
	}
	pigment
	{
		MediumWood
	}
		finish
	{
		ambient.15
	}
}

// Tabletop
difference
{
	union
	{
		box
		{
			<-24,-2,-49>,<24,0,8>
		}
		box
		{
			<-12,-9,-9>,<12,-2,9>
			translate z*-37
		}
	}
	union
	{
		box
		{
			<-9,-8,-9>,<9,1,9>
		}
		box
		{
			<-12,-8,-6>,<12,1,6>
		}
		cylinder
		{
			<-9,-8,-6>,<-9,1,-6>,3
		}
		cylinder
		{
			<9,-8,6>,<9,1,6>,3
		}
		cylinder
		{
			<-9,-8,6>,<-9,1,6>,3
		}
		cylinder
		{
			<9,-8,-6>,<9,1,-6>,3
		}
		translate z*-37
		texture
		{
			gradient y
			texture_map
			{
				[ 0.00 pigment { DarkSlateGray } finish { ambient .07 } ]
				[ 1.00 pigment { DarkSlateGray } finish { ambient .01 } ]
			}
			scale 7
		}
	}
	texture
	{
		TableTop
	}
}

// Spigot
union
{
	cylinder
	{
		0,y*4,.375
	}
	difference
	{
		torus
		{
			2.625,.375
		}
		box
		{
			<-3.1,-.475,-3.1>,<3.1,.475,0>
		}
		rotate x*-90
		translate y*4
		translate x*-2.625
	}
	cylinder
	{
		<-5.25,4,0>,<-5.25,3.75,0>,.5
	}
	cone
	{
		<-5.25,3.75,0>,.3125,<-5.25,2,0>,.0625
	}
	translate <15,0,-37>
	texture
	{
		Fixture
	}
}

// Faucet handles
union
{
	cylinder
	{
		<0,0,3>,<0,1.5,3>,.25
	}
	cylinder
	{
		<0,0,-3>,<0,1.5,-3>,.25
	}
	sphere
	{
		<0,1.5,3>,.25
	}
	sphere
	{
		<0,1.5,-3>,.25
	}
	cylinder
	{
		-.0625*x,.0625*x,1
		scale <1,.25,1>
		translate <0,1.5,4>
	}
	cylinder
	{
		-.0625*x,.0625*x,1
		scale <1,.25,1>
		translate <0,1.5,-4>
	}
	translate <15,0,-37>
	texture
	{
		gradient x
		texture_map
		{
			[ 0.00 pigment { Silver } finish { ambient .05 reflection .125 metallic } ]
			[ 1.00 pigment { Silver } finish { ambient .01 reflection .125 metallic } ]
		}
		translate -.5*x
	}
}

// Gas jets
union
{
	cylinder
	{
		<2,0,0>,<2,1,0>,.25
	}
	cylinder
	{
		<-2,0,0>,<-2,1,0>,.25
	}
	sphere
	{
		<2,1,0>,.5
	}
	sphere
	{
		<-2,1,0>,.5
	}
	cylinder
	{
		<2,1,0>,<2.75,1,0>,.25
	}
	cylinder
	{
		<-2,1,0>,<-2.75,1,0>,.25
	}
	cylinder
	{
		<2.75,1,0>,<3,1,0>,.375
	}
	cylinder
	{
		<-2.75,1,0>,<-3,1,0>,.375
	}
	cone
	{
		<3,1,0>,.25,<4.5,1,0>,.125
	}
	cone
	{
		<-3,1,0>,.25,<-4.5,1,0>,.125
	}
	translate z*-25
	texture
	{
		Fixture
	}
}

// Posterboard
	box
	{
		<-20,0,-15>,<20,0.05,5>
		pigment {White}
		finish {ambient .055}
	}

// Light
// . . . main body
union
{
	box
	{
		<-1.25,0.25,-4>,<1.25,1.75,0>
	}
	box
	{
		<-1.5,0.5,-4>,<1.5,1.5,0>
	}
	cylinder
	{
		<-1.25,1.5,-4>,<-1.25,1.5,0>,.25
	}
	cylinder
	{
		<1.25,1.5,-4>,<1.25,1.5,0>,.25
	}
	cylinder
	{
		<-1.25,0.25,-4>,<-1.25,0.25,0>,.25
	}
	cylinder
	{
		<1.25,0.25,-4>,<1.25,0.25,0>,.25
	}
	texture {Light_Tex}
	translate z*-16
	rotate y*60
}

// . . .feet
union
{
	cylinder
	{
		<-1.25,0.25,-0.5>,<-1.25,0,-0.5>,.25
	}
	cylinder
	{
		<1.25,0.25,-0.5>,<1.25,0,-0.5>,.25
	}
	cylinder
	{
		<-1.25,0.25,-3.5>,<-1.25,0,-3.5>,.25
	}
	cylinder
	{
		<1.25,0.25,-0.5>,<1.25,0,-3.5>,.25
	}
	pigment {Black}
	translate z*-16
	rotate y*60

}
// . . .lens
difference
{
	cylinder
	{
		0,z*-.5,.375
	}
	union
	{
		cone
		{
			z*.1,.25,z*.3,.1
		}
		cylinder
		{
			z*.1,z*-.6,.1
		}
	}
	pigment {Black}
	finish
	{
		ambient .6
	}
	translate z*-15.5
	rotate y*60
	translate y
}

// Slit Card
difference
{
	union
	{
		box
		{
			<-3,0.05,-.025>,<3,2.15,.025>
			pigment
			{
				White
			}
			finish
			{
				ambient .08
			}
		}
		cylinder
		{
			<0,1.05,-.026>,<0,1.05,0>,1.075
			pigment
			{
				onion
				color_map
				{
					[ 0.000 color White            ]
					[ 0.312 color White            ]
					[ 0.500 color White transmit 1 ]
					[ 0.688 color White            ]
					[ 1.000 color White            ]
				}
				scale 2.15
				translate y
			}
			finish
			{
				ambient 1
			}
		}
	}
	box
	{
		<-.125,.30,-.030>,<.125,1.8,.030>
	}
	translate z*-8
	rotate y*60
}

// Beam--from slit card
cylinder
{
	z*-.075,z*-.5, 1
    pigment
	{
		gradient x
		color_map
		{
			[ 0.00 color White            ]
			[ 0.50 color White transmit 1 ]
			[ 1.00 color White            ]
		}
		scale 1.5
	}
	finish { ambient 1 }
	scale <.5,.1,16>
	rotate y*60
}

// Prism
prism
{
    linear_sweep
    linear_spline
    0, 2, 4,

    <2,1>, <0,-1>, <-2,1>, <2,1>

    pigment
	{
		White
		transmit 1
	}
	finish
	{
		refraction 1
		ior 1.5
		reflection .1
	}
	translate <0,.05,-.5>
}

// Spectrum
intersection
{
	union
	{
		box
		{
			<-20,0,-15>,<20,0.06,5>
		}
		box
		{
			<-3.25,0.05,-13.974>,<3.25,2.05,-14.026>
		}
	}
	cone
	{
		z*-5.25,1,z*-14,3.2
		scale <1,5,1>
	}
	pigment
	{
		radial
		frequency 10
		color_map
		{
			[ 0.000 color rgbt <0.5, 0.0, 0.0, 1.00> ]
			[ 0.125 color rgbt <1.0, 0.0, 0.0, 0.75> ]
			[ 0.250 color rgbt <1.0, 0.5, 0.0, 0.75> ]
			[ 0.375 color rgbt <1.0, 1.0, 0.0, 0.75> ]
			[ 0.500 color rgbt <0.0, 1.0, 0.0, 0.75> ]
			[ 0.625 color rgbt <0.0, 1.0, 1.0, 0.75> ]
			[ 0.875 color rgbt <0.0, 0.0, 1.0, 0.75> ]
			[ 1.000 color rgbt <0.0, 0.0, 0.5, 1.00> ]
		}
	}
	finish
	{
		ambient .7
	}
	rotate y*-60
}

// Spectrum card
box
{
	<-4,0.05,-0.025>,<4,2.55,-0.025>
	pigment
	{
		color White
	}
	finish
	{
		ambient .08
	}
	translate z*-14
	rotate y*-60
}
