
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera {
	location <0,5,-30>
	look_at  <0,10,0>
}

global_settings { max_trace_level 10 }

light_source {<40,20,-30> color White}
//background {White}

#declare Forest = on
#declare Effects = on
#declare Effects_high = on
#declare Quick_room = off
#declare Hill = on
#declare Rooms = on
#declare Fair1 = on
#declare Fair2 = on
#declare Fair3 = on
#declare Fair4 = on

#include "13t2.inc"

#if (Hill = on)
height_field
{ gif "mountain.gif"
	smooth
	translate <-0.5,0,-0.5>
  	rotate <0,270,0>
  	rotate <-25,0,0>
  	scale <30,20,20>
  	translate <1,-14,0>

	texture{Moss}
}
#end

#include "logo.inc"
object {Logo rotate <0,-10,0> translate <5,1,-14> texture{Moss2}}

#if (Forest = on)
#declare Background =
box {<0,0,0><1,1,0>
texture{pigment{
image_map
{ gif "forest.gif"}
}}
}

object {Background translate <-0.5,-0.5,0> scale <800,550,1> translate <0,120,500>}
#end

#include "fairy_tex.inc"

#if (Fair1 = on)
#include "fairy1.pov"
object {Fairy1
scale 10
translate <-1.5,4,-17>}
#end

#if (Fair2 = on)
#include "fairy2.pov"
object {Fairy2
scale 7
translate <-7,10,-15>}
#end

#if (Fair3 = on)
#include "fairy3.pov"
object {Fairy3
scale 6
translate <2,10,-12>}
#end

#if (Fair4 = on)
#include "fairy4.pov"
object {Fairy4
scale 5
translate <7,15,-10>}
#end


#declare cam_loc = <0,5,-30>
#declare lookat = <0,10,0>

#declare light_loc = <7,17,-10>                               
#declare sky_vect = <0,1,0>
#declare flare_type = "35mm"
#declare num_spots = 0
#declare flare_scale_factor = 0.75
#declare flare_amount = 0.75
#include "lnsflare.inc"

#declare light_loc = <3,13,-12>
#declare flare_scale_factor = 0.85
#include "lnsflare.inc"

#declare light_loc = <-6.25,13,-15>
#declare flare_scale_factor = 1.2
#include "lnsflare.inc"

#declare light_loc = <-7,7,-15>
#declare flare_scale_factor = 0.25
#include "lnsflare.inc"

#declare light_loc = <-1.5,5,-17>
#declare flare_scale_factor = 1.5
#include "lnsflare.inc"

// mushroom definitions
#if (Rooms = on)

#declare Stalk_plus = 0
#declare Head_rotate = -5
#declare Mushroom_type = 1
#declare Patt_rand = 13
#include "13mush.inc"

object {Mushroom translate <0,2.9,-10>}

#declare Stalk_plus = 2
#declare Head_rotate = 0
#declare Mushroom_type = 2
#declare Patt_rand = 22
#include "13mush.inc"

object {Mushroom translate <3,2.9,-10>}

#declare Stalk_plus = 0
#declare Head_rotate = 5
#declare Mushroom_type = 1
#declare Patt_rand = 11
#include "13mush.inc"

object {Mushroom translate <2,0,-12>}

#declare Stalk_plus = 0
#declare Head_rotate = 2.5
#declare Mushroom_type = 1
#declare Patt_rand = 99
#include "13mush.inc"

object {Mushroom translate <-3,0,-12>}

#declare Stalk_plus = 0
#declare Head_rotate = -2
#declare Mushroom_type = 3
#declare Patt_rand = 54
#include "13mush.inc"

object {Mushroom translate <-1,-1,-15>}

#declare Stalk_plus = 0
#declare Head_rotate = 10
#declare Mushroom_type = 4
#declare Patt_rand = 16
#include "13mush.inc"
object {Mushroom translate <13,-0.5,-8>}

#declare Stalk_plus = 0
#declare Head_rotate = 2
#declare Mushroom_type = 3
#declare Patt_rand = 76
#include "13mush.inc"

object {Mushroom translate <8,2,-7>}

#declare Stalk_plus = 3
#declare Head_rotate = 7
#declare Mushroom_type = 1
#declare Patt_rand = 55
#include "13mush.inc"

object {Mushroom translate <12,2,-7>}

#declare Stalk_plus = 8
#declare Head_rotate = 0
#declare Mushroom_type = 3
#declare Patt_rand = 49
#include "13mush.inc"

object {Mushroom translate <12,3,-3>}

#declare Stalk_plus = 6
#declare Head_rotate = -3.5
#declare Mushroom_type = 1
#declare Patt_rand = 32
#include "13mush.inc"

object {Mushroom translate <16,3,-3>}

#declare Stalk_plus = 6
#declare Head_rotate = 4.5
#declare Mushroom_type = 2
#declare Patt_rand = 48
#include "13mush.inc"

object {Mushroom translate <8,3,-3>}

#declare Stalk_plus = 0
#declare Head_rotate = -1
#declare Mushroom_type = 2
#declare Patt_rand = 36
#include "13mush.inc"

object {Mushroom translate <5,2.5,-10>}

#declare Stalk_plus = 0
#declare Head_rotate = 0
#declare Mushroom_type = 1
#declare Patt_rand = 77
#include "13mush.inc"

object {Mushroom translate <10,0,-10>}

#declare Stalk_plus = 0
#declare Head_rotate = 2
#declare Mushroom_type = 3
#declare Patt_rand = 93
#include "13mush.inc"

object {Mushroom translate <15,4.5,-5>}

#declare Stalk_plus = 0
#declare Head_rotate = 20
#declare Mushroom_type = 4
#declare Patt_rand = 72
#include "13mush.inc"

object {Mushroom translate <10,4.5,-5>}

#declare Stalk_plus = 0
#declare Head_rotate = -5
#declare Mushroom_type = 1
#declare Patt_rand = 112
#include "13mush.inc"

object {Mushroom translate <-5,2.5,-12>}

#declare Stalk_plus = 0
#declare Head_rotate = 5
#declare Mushroom_type = 2
#declare Patt_rand = 123
#include "13mush.inc"

object {Mushroom translate <-7,0,-15>}
#end

#if (Effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug
	#else
	#declare Rad_Quality = Radiosity_Final
#end

#include "rad_def.inc"
#end
