// Knight in shining armour

#declare Armour_Metal =
texture {
        pigment { rgb <0.6, 0.7, 0.8> }
        finish {
               ambient 0.2
               diffuse 0.7
               brilliance 6.0
               reflection 0.2
               phong 0.8
               phong_size 120
        }
        normal {dents 0.2 scale 0.1}
}

#declare Chain_Mail =
texture {
        pigment {
                 spotted
                 color_map {
                 [0.0 color Black]
                 [0.5 color rgb <0.4, 0.4, 0.4>]
                 [1.0 color Black]}
                 scale 0.05
                }
        finish {Shiny}
        normal {bumps 1.0 scale 0.1}
}

#declare Brassy =
texture {
         pigment {
                 crackle
                 turbulence 1
                 color_map {
                 [0.0 color Brass]
                 [1.0 color Orange]}
                 scale 0.1
                 }
         finish {Shiny
                 ambient 0.4}
}

#declare Sword_Magic =
texture {
        pigment{
        crackle
        turbulence 0.9
        color_map {
        [0.0 color NeonPink filter 0.98]
        [0.5 color White filter 0.98]
        [1.0 color Clear] }
        scale 0.2
        }
        finish {ambient 0.7}
}

// ------------------------------------------
// helmet

#declare Helmet = union {

sphere {<0, 0, 0>, 1
       clipped_by {plane {y, 0 inverse}}
}
cylinder {<0, 0, 0>, <0, -1.3, 0>, 0.8 texture {Chain_Mail} }
// nose guard
cylinder {<-0.1, 0, -0.05>, <0.1, 0, -0.05>, 1}
box {<-0.1, -1.2, -1.05>, <0.1, 0, -0.9>}

difference {
           cylinder {<0, 0, 0>, <0, -1.3, 0>, 1}
           box {<-0.5, 0.1, -1.3>, <0.5, -0.2, 0>}
           cylinder {<-1.1, 0, -1.1>, <-1.1, 0, 1.1>, 1 scale <1, 0.3, 1> translate <0, -1.3, 0>}
           cylinder {<1.1, 0, -1.1>, <1.1, 0, 1.1>, 1 scale <1, 0.3, 1> translate <0, -1.3, 0>}
           cylinder {<0, 0.1, 0>, <0, -1.1, 0>, 0.9 }
           cylinder {<-0.2, -0.7, -1>, <-0.2, -0.7, 0>, 0.05}
           cylinder {<0.2, -0.7, -1>, <-0.2, -0.7, 0>, 0.05}
           cylinder {<-0.2, -0.5, -1>, <-0.2, -0.5, 0>, 0.05}
           cylinder {<0.2, -0.5, -1>, <0.2, -0.5, 0>, 0.05}
           cylinder {<-0.2, -0.3, -1>, <-0.2, -0.3, 0>, 0.05}
           cylinder {<0.2, -0.3, -1>, <0.2, -0.3, 0>, 0.05}
           cylinder {<-0.4, -0.5, -1>, <-0.4, -0.5, 0>, 0.05}
           cylinder {<0.4, -0.5, -1>, <0.4, -0.5, 0>, 0.05}
           cylinder {<-0.4, -0.3, -1>, <-0.4, -0.3, 0>, 0.05}
           cylinder {<0.4, -0.3, -1>, <0.4, -0.3, 0>, 0.05}
} // end diff

texture {Armour_Metal}
} // end helmet union

// ------------------------------------------
// torso
#declare Torso = union {

#include "breastplate.inc"
object {Breastplate}
cylinder {<-1, -5.5, 0>, <1, -5.5, 0>, 0.6 texture {Chain_Mail}}

// skirt
cone { <0, -4.2, 0>, 0.7
       <0, -4.7, 0>, 1
       scale <1.7, 1, 1>}
cone { <0, -4.6, 0>, 0.9
       <0, -5.1, 0>, 1.1
       scale <1.7, 1, 1>}
difference {
cone { <0, -5.0, 0>, 1
       <0, -5.5, 0>, 1.2
       scale <1.7, 1, 1>}
cone { <0, -5.0, 0>, 0.9
       <0, -5.6, 0>, 1.0
       scale <1.7, 1, 1>}
cylinder { <0, -5.6, -2>, <0, -5.6, 2>, 0.4}
}
difference {
cone { <0, -5.4, 0>, 1.1
       <0, -5.9, 0>, 1.3
       scale <1.7, 1, 1>}
cone { <0, -5.4, 0>, 1
       <0, -6, 0>, 1.2
       scale <1.7, 1, 1>}
box { <-0.4, -6, -2>, <0.4, -5.3, 2>}
}

// Crest on breastplate
text {
     ttf
     "angie.ttf"
     "K"
     1, 0
     rotate <0, 20, 0>
     translate <-0.6, -2.5, -1.06>
     texture {Brassy}
}
text {
     ttf
     "angie.ttf"
     "M"
     1, 0
     rotate <0, -20, 0>
     translate <0.18, -3.2, -1.1>
     texture {Brassy}
}

texture {Armour_Metal}
} // end torso union

// --------------------------------------------
// Arm parts

#declare Upper_Arm = union {
sphere {<0, 0, 0>, 0.5
       texture {Chain_Mail}
}
difference {
sphere {<0, 0, 0>, 0.6
       clipped_by {plane {x, 0.3} }
       clipped_by {plane {x, -0.5 inverse} }
       scale <3, 1, 1>
       translate <-1, 0, 0>
       texture {Armour_Metal}
}
box {<-3, 0, -0.2>, <3, -1.5, 0.2> pigment {color Black}}
}
} // end upper arm union

#declare Lower_Arm = union {
sphere {<0, 0, 0>, 0.4}
sphere {<0, 0, 0>, 0.4
       clipped_by {plane {x, 0.3} }
       clipped_by {plane {x, -0.3 inverse} }
       scale <3, 1, 1>
       translate <-1, 0, 0>
       texture {Armour_Metal}
}
// hand
sphere {<-1.9, 0, 0>, 0.4}
cylinder {<-2, 0.3, 0.3>, <-2.4, 0.31, 0.3>, 0.1}
cylinder {<-2.2, 0.15, 0.3>, <-2.6, 0.15, 0.3>, 0.1}
cylinder {<-2.2, -0.15, 0.3>, <-2.5, -0.15, 0.3>, 0.1}
cylinder {<-2.05, -0.3, 0.3>, <-2.35, -0.3, 0.3>, 0.1}

texture {Chain_Mail}
} // end lower arm union


// ---------------------------------------------
// Leg parts

#declare Upper_Leg = union {
sphere {<0, 0, 0>, 0.8
       texture {Chain_Mail}
}
difference {
sphere {<0, 0, 0>, 0.7
       clipped_by {plane {y, 0.3} }
       clipped_by {plane {y, -0.5 inverse} }
       scale <1, 4, 1>
       translate <0, -1, 0>
       texture {Armour_Metal}
}
box {<1.5, 3, -0.2>, <0, -4, 0.2> pigment {color Black}}
}
rotate <0, 0, -10>
rotate <-30, 0, 0>
} // end upper leg union

#declare Lower_Leg = union {
sphere {<0, 0, 0>, 0.6}
sphere {<0, 0, 0>, 0.7
        clipped_by {plane {y, 0 rotate <70, 0, 0>}}
        clipped_by {plane {y, 0 inverse rotate <20, 0, 0> }}
        rotate <0, 0, 10>
        texture {Armour_Metal}
}
sphere {<0, 0, 0>, 0.6
       clipped_by {plane {y, 0.3} }
       clipped_by {plane {y, -0.3 inverse} }
       scale <1, 3, 1>
       translate <0, -1, 0>
       texture {Armour_Metal}
}
sphere {<0, -1.9, 0>, 0.4}
// foot
sphere {<0, 0, 0>, 0.6
       scale <1, 0.45, 3>
       clipped_by {plane {z, 0} rotate <-45, 0, 0>}
       translate <0, -1.9, 0>
       texture {Armour_Metal}
}

rotate <-45, 0, 0>
texture {Chain_Mail}
} // end lower leg union

// ---------------------------------------------
// Sword with glowing jewel in handle

#declare Sword = union {
// handle
difference {
union {
cylinder {<0, 0.1, -0.3>, <0, 0.1, 0.3>, 0.3}
cylinder {<0, 0, 0>, <0, -1, 0>, 0.2}
} // end union
cylinder {<0, 0.1, -0.4>, <0, 0.1, 0.4>, 0.25}
} // end diff
sphere {<0, 0.1, 0>, 0.25
       texture {
               pigment {color Red filter 0.7}
               finish {Shiny
                      ambient 0.5}
               normal {crackle 1.0 scale 0.01}
       }
}
light_source {<0, 0.1, 0> color Red
                  fade_distance 1
                  fade_power 1
}

// hilt
box {<-0.5, -1, -0.3>, <0.5, -1.2, 0.3>}
difference {
cylinder {<-0.5, -1.1, -0.4>, <-0.5, -1.1, 0.4>, 0.2 texture {Brassy}}
cylinder {<-0.7, -0.9, -0.41>, <-0.7, -0.9, 0.41>, 0.2}
cylinder {<-0.7, -1.3, -0.41>, <-0.7, -1.3, 0.41>, 0.2}
}
difference {
cylinder {<0.5, -1.1, -0.4>, <0.5, -1.1, 0.4>, 0.2 texture {Brassy}}
cylinder {<0.7, -0.9, -0.41>, <0.7, -0.9, 0.41>, 0.2}
cylinder {<0.7, -1.3, -0.41>, <0.7, -1.3, 0.41>, 0.2}
}

// blade
difference {
           box {<-0.3, -1, 0.2>, <0.3, -7, -0.2>}
           cylinder {<-0.1, -7.1, -0.19>, <-0.4, -1, -0.2>, 0.2 scale <1.8, 1, 1>}
           cylinder {<-0.1, -7.1, 0.19>, <-0.4, -1, 0.2>, 0.2 scale <1.8, 1, 1>}
           cylinder {<0.1, -7.1, -0.19>, <0.4, -1, -0.2>, 0.2 scale <1.8, 1, 1>}
           cylinder {<0.1, -7.1, 0.19>, <0.4, -1, 0.2>, 0.2 scale <1.8, 1, 1>}
} // end diff

// magic aura
cylinder {<0, -1.2, 0>, <0, -5, 0>, 0.35
         texture {Sword_Magic}
}
cone {<0, -5, 0>, 0.3
      <0, -7, 0>, 0.1
      texture {Sword_Magic}
}

texture {Armour_Metal}

} //end Sword union

// --------------------------------------------
// Shield

#declare Shield = union {

difference {
           box {<-3, 1, -0.3>, <1, -7, -0.5>}
           sphere {<-1, 4, -0.4>, 4}
           sphere {<-15, 0, 0>, 16 inverse}
           sphere {<13, 0, 0>, 16 inverse}
} // end difference
sphere {<-1, -2, -0.3>, 1
       scale <1, 1, 0.8>
       clipped_by {plane {z, -0.3}}
//       texture {Brassy}
       texture {
               pigment {
                       spiral2 2
                       color_map { 
                       [0.0 color Black]
                       [1.0 color Brass] }
                       }
               finish {Shiny ambient 0.4}
               }
               
}

texture {Armour_Metal}
} // end shield union

// --------------------------------------------
// The knight

#declare Knight = union {

object {Helmet
       rotate <0, 30, 0>
       translate <0, 0.3, 0>
}
object {Torso}
// left arm (with shield)
sphere { <0, 0, 0>, 0.9
         scale <2, 1, 1>
         clipped_by {plane {y, 0.2 inverse}}
         clipped_by {plane {x, 0 inverse}}
         translate <0.8, -1.6, 0>
}
object {Upper_Arm
       rotate <0, 180, 0>
       rotate <0, 0, 20>
       translate <1.7, -1.7, 0>
}
object {Lower_Arm
       rotate <180, 0, 0>
       rotate <0, -40, 0>
       translate <4, -0.7, 0>
}
object {Shield
       rotate <0, -40, 0>
       rotate <0, 0, 20>
       translate <3.7, 0.7, 0>
}

// right arm (with sword)
sphere { <0, 0, 0>, 0.9
         scale <2, 1, 1>
         clipped_by {plane {y, 0.2 inverse}}
         clipped_by {plane {x, 0} }
         translate <-0.8, -1.6, 0>
}
object {Upper_Arm
       rotate <0, 0, 45>
       translate <-1.7, -1.7, 0>
}
object {Lower_Arm
       rotate <0, -90, 0>
       rotate <-30, 0, 0>
       translate <-3.7, -3.5, 0>
}
object {Sword
        rotate <0, 110, 0>
        rotate <100, 0, 0>
        translate <-3.7, -4.8, -1.3>
}
// right leg (back)
object {Upper_Leg
       translate <-1, -5.5, 0>
}
object {Lower_Leg
       translate <-1.6, -8.3, 1.7>
}
// left leg (forawrd)
object {Upper_Leg
       rotate <0, 180, 0>
       translate <1, -5.5, 0>
}
object {Lower_Leg
       translate <1.6, -8.3, -1.1>
}



texture {Armour_Metal}

} //end union

