// Magican.inc
// include file for Attack!
// entry in the ITRC competition July/Aug 1997
// By The Butter-Fingered Juggler


#declare R2=seed(12314)

// Blast Magic
#declare Blast_Magic = union {

#declare Count = 1
#while (Count < 11)

#declare OffX = 15 - (1.35 * Count)
#declare OffZ = -5 - (1.4 * Count)

sphere { <0, 0, 0>, 1
       pigment { color rgbt <1, 1, 1, 1> }
       halo {
        emitting
        planar_mapping
        linear
        turbulence 3
        color_map {
        [0.0 color rgbft <1, 1, 1, 1, 1>]
        [0.8 color rgbft <0, 1, 0, 1, 0.5> ]
        [0.9 color White]
        [1.0 color rgbft <1, 1, 1, 1, 1>] }
    samples 2
    scale 2
    }
    hollow
    rotate < rand (R2)*360, 0, 0>
    scale <Count * 0.1, Count * 0.2, Count * 0.1>
    translate <OffX, 10, OffZ>
}
#if (int(Count)=Count)
light_source {<OffX, 10, OffZ> color rgb <0, 0.5, 0>
             fade_distance 2
             fade_power 2
}
#end

#declare Count=Count + 0.5
#end

// side effects halo 2
sphere { <0, 0, 0>, 1

       pigment { color rgbt <1, 1, 1, 1> }
       halo {
        emitting
        planar_mapping
        linear
        turbulence 3
        color_map {
        [0.0 color rgbft <1, 1, 1, 1, 1>]
        [0.8 color rgbft <0, 1, 0, 1, 0.5> ]
        [0.9 color White]
        [1.0 color rgbft <1, 1, 1, 1, 1>] }
    samples 2
    scale 3
    }
    hollow
    rotate <0, 0, 100>
    scale <1.5, 2, 1>
    translate <-0.5, 8, -19.5>
}

// side effects halo 3
sphere { <0, 0, 0>, 1

       pigment { color rgbt <1, 1, 1, 1> }
       halo {
        emitting
        planar_mapping
        linear
        turbulence 3
        color_map {
        [0.0 color rgbft <1, 1, 1, 1, 1>]
        [0.8 color rgbft <0, 1, 0, 1, 0.5> ]
        [0.9 color White]
        [1.0 color rgbft <1, 1, 1, 1, 1>] }
    samples 2
    scale 2
    }
    hollow
    rotate <-30, 0, 10>
    scale <1.5, 2, 2>
    translate <-2, 12, -21>
}
} // end Blast Magic union

// -------------------------------------------------
// Fireball
#declare FireBall=union {
#declare Count = 0
#while (Count < 200)

cone {<0, 0, 0>, 0.01
      <0, 0.5, 0>, 0
      rotate < rand (R2) * 360, rand (R2) * 360, rand (R2) * 360>
      pigment {color Cyan filter 0.9}
      finish {ambient 0.6}
}

sphere {<0, 0, 0>, 0.02
        translate <rand (R2)/2, 0, 0>
        rotate < rand (R2) * 360, rand (R2) * 360, rand (R2) * 360>
        pigment {color rgb <rand (R2), rand(R2), 1 >}
        finish {ambient 0.6}
}

#declare Count = Count + 1
#end
sphere {<0, 0, 0>, 0.5
       scale <1, 1.3, 1>
       translate <0, 0.1, 0>
       pigment {
               bozo
               turbulence 0.5
               color_map {
               [0.0 color Cyan transmit 0.65]
               [0.2 color Clear]
               [0.4 color White transmit 0.65]
               [0.6 color Clear]
               [1.0 color Cyan transmit 0.65]}
               }
       finish {ambient 0.3}
}

light_source { <0.5, 0, 0> color Cyan
             fade_distance 3
             fade_power 2
             }
} // end Fireball union

// --------------------------------------------------
// Wizard's staff

#declare R3 = seed (98823)
#declare TURNS = 7.3      //Half turns per unit high.
#declare RADIUSX = 0.25    //mess with these to make oblong coils,
#declare RADIUSZ = 0.25    //or wider coils
#declare HEIGHT = 4.5
#declare MINOR_RADIUS = 0.15 //radius of sphere
#declare INCREMENT = 0.02 //decrease to make smoother but takes longer to render

#declare WHY = 0

#declare Staff = union {
difference {
cylinder { <0, 0, 0>, <0, 7, 0>, 0.25}

#while ( WHY < HEIGHT )
sphere { < 0.0, 0.0, 0.0 > MINOR_RADIUS
          translate < sin(WHY*(TURNS*pi))*RADIUSX,
                      WHY*2,                      // squeeze and relax coil
                      cos(WHY*(TURNS*pi))*RADIUSZ >
        }
sphere { < 0.0, 0.0, 0.0 > MINOR_RADIUS
          translate < cos(WHY*(TURNS*pi))*RADIUSX,
                      WHY*2,                      // squeeze and relax coil
                      sin(WHY*(TURNS*pi))*RADIUSZ >
       }
#declare WHY = WHY + INCREMENT +(rand (R3) / 20)
#end
} // end diff

// head
#declare Count=0
#while (Count < 6)
       cylinder {<0.05, 0, 0>, <-0.05, 0, 0>, 0.5
                open
                rotate <0, Count*30, 0>
                scale <1, 2, 1>
                translate <0, 7, 0>
                pigment {color Green}
}
#declare Count=Count + 1
#end

texture {Rosewood}
} // end staff union

// ---------------------------------------------
// Neck chain

#declare Link =
torus { 0.1, 0.02
        scale <1, 1, 0.5>
        rotate <90, 0, 0>
        texture {Gold_Metal}
}

// ------------------------------------
// Wiz himself

// taken from blob scultor sample
#declare Hand = blob {
   threshold 0.6
   component 1.000000, 1.508230, <-0.413502, 0.025316, 0.000000>
   component 1.000000, 1.599720, <0.430380, -0.008439, 0.000000>
   component 1.000000, 1.457520, <-0.548523, -1.189870, 0.000000>
   component 1.000000, 1.434800, <0.700422, -1.206750, 0.000000>
   component 1.000000, 0.983246, <1.493670, -0.548523, 0.000000>
   component 1.000000, 0.747382, <1.729960, 0.109705, 0.000000>
   component 1.000000, 0.683805, <1.797470, 0.683544, 0.000000>
   component 1.000000, 0.676372, <1.822780, 1.215190, 0.000000>
   component 1.000000, 0.714533, <0.759494, 0.911392, 0.000000>
   component 1.000000, 0.676372, <0.742616, 1.502110, 0.000000>
   component 1.000000, 0.749914, <0.691983, 2.160340, 0.000000>
   component 1.000000, 0.708316, <0.599156, 2.793250, 0.000000>
   component 1.000000, 0.718941, <0.430380, 3.502110, 0.000000>
   component 1.000000, 0.679169, <-0.210970, 1.088610, 0.000000>
   component 1.000000, 0.714533, <-0.312236, 1.746840, 0.000000>
   component 1.000000, 0.629936, <-0.464135, 2.421940, 0.000000>
   component 1.000000, 0.698434, <-0.666667, 3.097050, 0.000000>
   component 1.000000, 0.715417, <-0.919831, 3.805910, 0.000000>
   component 1.000000, 0.640875, <-1.021100, 1.021100, 0.000000>
   component 1.000000, 0.621859, <-1.308020, 1.645570, 0.000000>
   component 1.000000, 0.670744, <-1.578060, 2.236290, 0.000000>
   component 1.000000, 0.620842, <-1.864980, 2.843880, 0.000000>
   component 1.000000, 1.210770, <-1.434600, -0.151899, 0.000000>
   component 1.000000, 1.241680, <-1.333330, -1.265820, 0.000000>
   component 1.000000, 0.670743, <-2.042190, 0.691983, 0.000000>
   component 1.000000, 0.674501, <-2.413500, 1.299580, 0.000000>
   component 1.000000, 0.785310, <1.805910, 1.907170, 0.000000>
   component 1.000000, 0.555298, <-2.751050, 1.772150, 0.000000>

   pigment {color Flesh}
}

// --------------------------------------------------
#declare Robe_cloth=
texture {
        pigment {color Blue}
        normal {crackle 0.4
                turbulence 0.8
                scale 0.3}
}

#include "w_belt.inc"
#include "w_body.inc"
#include "w_cowl.inc"
#include "w_l_arm.inc"
#include "w_r_arm.inc"

// ----------------------------------------------------
#declare Wizard = union {
object {W_Body
       texture {Robe_cloth}
}
object {W_Cowl
       texture {Robe_cloth}
}
object {W_L_ARM
       texture {Robe_cloth}
}
object {W_R_ARM
       texture {Robe_cloth}
}
object {W_Belt}


// Left Hand
object {Hand
   scale <-0.1, 0.1, 0.2>
   rotate <0, 0, 90>
   rotate <0, -90, 150>
   translate <1.2, 3.2, -1.8>
}
// Right Hand
object {Hand
   scale <0.1, 0.1, 0.2>
   rotate <0, -45, 0>
   translate <-1.1, 6.5, -1.8>
}
cylinder {<-1.1, 6.5, -1.8>,<-1.3, 6, -1.3>, 0.2
pigment {color Flesh}
}
object {FireBall
       translate <-1.1, 7, -1.8>
}

// Head
height_field { gif "face.gif"
               water_level 0.1
               smooth
               rotate <-90, 0, 0>
               pigment {image_map
                        {gif "km.gif"}}
               translate <-0.5, -0.5, 0>
               scale <0.8, 1.2, 0.7>
               translate <0.1, 5.6, 0>
//               pigment {color rgb <0.9058, 0.7686, 0.749>}
}

// neck chain
object {Link translate <0, 4, -0.8>}
object {Link
       rotate <45, 0, -45>
       translate <-0.14, 4.06, -0.8>}
object {Link
       rotate <45, 0, 45>
       translate <0.14, 4.06, -0.8>}
object {Link
       rotate <0, 0, -60>
       translate <-0.21, 4.2, -0.8>}
object {Link
       rotate <0, 0, 60>
       translate <0.21, 4.2, -0.8>}
object {Link
       rotate <45, 5, -80>
       translate <-0.25, 4.35, -0.7>}
object {Link
       rotate <45, -5, 80>
       translate <0.25, 4.35, -0.7>}
object {Link
       rotate <0, 15, -90>
       translate <-0.26, 4.53, -0.7>}
object {Link
       rotate <0, -15, 90>
       translate <0.26, 4.53, -0.6>}


} // end wizard union
