// -----------------------------------------
// Scenary.inc
// Various bits and pieces of background
// Created for Attack!
// Entry to the POV-Ray competition Aug 1997


// -----------------------------------------
// colours / textures

#declare BlueSteel = texture {
   pigment {color rgb <0.560784, 0.660784, 0.837255>}
   finish {
      metallic
      ambient 0.2
      diffuse 0.7
      brilliance 3
      phong 1
      phong_size 200
   }
   normal {dents 0.6 scale 0.1}
}

#declare Stone=
texture {
      pigment {
              granite
              scale 0.5
              color_map {
              [0.0 color Gray90]
              [0.5 color rgb <0.9, 0.78, 0.78>]
              [1.0 color rgb <0.78, 0.9, 0.9>]}
              }
}
texture {
        pigment {
                crackle
                turbulence 0.4
                color_map {
                [0.0 color Clear]
                [0.9 color Clear]
                [1.0 color Black]}
                }
        finish {Dull
               crand 0.2}
        normal {dents 1.0 scale 0.2}
}

#declare Stone_Floor=
texture{Stone}
texture {
        pigment {
                marble
                turbulence 0.2
                color_map {
                [0.0 color Clear]
                [0.95 color Clear]
                [0.95 color Gray90]
                [1.0 color Gray50] }
                }
                scale 4
}
texture {
        pigment {
                marble
                turbulence 0.2
                color_map {
                [0.0 color Clear]
                [0.95 color Clear]
                [0.95 color Gray90]
                [1.0 color Gray80] }
                }
                rotate <0, 90, 0>
                scale 4
}

#declare Throne_Texture =
texture {
        pigment {
                leopard
                turbulence 0.5
                color_map {
                [0.0 color rgb <0.6745, 0.4745, 0.2>]
                [1.0 color rgb <0.996, 0.996, 0.7215>]}
                scale 0.5
                }
        finish {
               phong 1.5
               phong_size 150
               reflection 0.1
               }
        normal {crackle 0.4 scale 0.2}
}



// -----------------------------------------
// Floor Braziers
#declare Coal =
box {<0, 0, 0>, <0.8, 0.8, 0.8>
clipped_by {sphere {<0.3, 0.5, 0.1>, 0.4}}
pigment {
        granite
        color_map {
        [0.0      color Black]
        [0.6      color Black]
        [0.65     color Red]
        [0.9      color Yellow]
        [1.0      color Black] }
        scale 0.4
        }
finish {ambient 0.5}
}

#declare R1=seed (8821)

#declare Brazier=union {

// base
cone { <0, 0, 0>, 2.5
       <0, 1, 0>, 0.5}
sphere {<0, 1, 0>, 1}

#declare TURNS = 4      //Half turns per unit high.
#declare RADIUSX = 0.4    //mess with these to make oblong coils,
#declare RADIUSZ = 0.4    //or wider coils
#declare HEIGHT = 4.5
#declare MINOR_RADIUS = 0.5 //radius of sphere
#declare INCREMENT = 0.01 //decrease to make smoother but takes longer to render

#declare WHY = 0.75

// Stem
#while ( WHY < HEIGHT )
sphere { < 0.0, 0.0, 0.0 > MINOR_RADIUS
          translate < sin(WHY*(TURNS*pi))*RADIUSX,
                      WHY*2,                      // squeeze and relax coil
                      cos(WHY*(TURNS*pi))*RADIUSZ >
       }
#declare WHY = WHY + INCREMENT
#end

// top end
sphere {<0, 0, 0>, 1.2
       scale <1, 0.25, 1>
       translate <0, 9, 0>
}
sphere {<0, 0, 0>, 1.4
       scale <1, 0.25, 1>
       translate <0, 9.25, 0>
}

// cage + coals
#declare Count = 0
#while (Count < 6)

cylinder {<-0.15, 10.5, 0>, <0.15, 10.5, 0>,2
         open
         clipped_by {plane {y, 11}}
         rotate <0, Count * 30, 0>
}
object {Coal
       translate <1.4-(rand(R1)*3), 9+(rand(R1)*1.5), 1.5-(rand(R1)*3)>
}
object {Coal
       translate <1.4-(rand(R1)*3), 9+(rand(R1)*1.5), 1.5-(rand(R1)*3)>
}
object {Coal
       translate <1.4-(rand(R1)*3), 9+(rand(R1)*1.5), 1.5-(rand(R1)*3)>
}
object {Coal
       translate <1.4-(rand(R1)*3), 9+(rand(R1)*1.5), 1.5-(rand(R1)*3)>
}
#declare Count = Count + 1
#end

// fire halo
sphere {<0, 0, 0>, 1
	pigment { color rgbt <1, 1, 1, 1> }
    halo {
        emitting
        planar_mapping
        linear
        turbulence 1.7
        color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ] }
    samples 10
    scale 0.6
    }
    hollow
    scale <2, 3, 2>
    translate <0, 11, 0>
}
light_source { <0, 12, 0> color rgb <0.5, 0.4, 0.3>
             fade_distance 5
             fade_power 1
}

// smoke halo
sphere {<0, 0, 0>, 1
	pigment { color rgbt <1, 1, 1, 1> }
    halo {
        attenuating
        planar_mapping
        linear
        turbulence 2.5
        color_map {
        [ 0 color rgbt <0, 0, 0, 1> ]
        [ 1 color rgbt <0, 0, 0, 0> ] }
    samples 8
    scale 0.4
    rotate <0, 180, 0>
    }
    hollow
    scale <2, 4, 2>
    translate <0, 14, 0>
}

texture {BlueSteel}
} // end Brazier union


// -----------------------------------------------
// Archways

#declare Column = union {

difference {
cylinder { <0, 1, 0>, <0, 13, 0>, 1 }

#declare Flute = 0
#while (Flute < 10)
      cylinder { <1, 1.5, 0>, <1, 12.5, 0>, 0.2
               rotate <0, 36 * Flute, 0> }
      #declare Flute = Flute + 1
#end
}

box {<-1.5, 13.5, -1.5>, <1.5, 14, 1.5>
    texture {Stone}
}
box {<-1.5, 0.5, -1.5>, <1.5, 0, 1.5>
    texture {Stone}
}
cylinder {<0, 0.5, 0>, <0, 1, 0>, 1.2}
cylinder {<0, 13, 0>, <0, 13.5, 0>, 1.2}

height_field { gif "skull.gif"
               smooth
               water_level 0.1
               rotate <-90, 0, 0>
               translate <0, -0.5, 0>
               scale 1.8
               translate <-0.9, 15, -0.8>
}

texture {Stone}
} // end column union

// -----------------------------------------------

#declare ArchStone = union {
box {<-1, 0, -1>, <1, 2, 1>
    texture {Stone}
}
box {<-1, 2, -1.05>, <1, 2.05, 1.05>
    pigment {color Black}
}
} // end archstone union

// ------------------------------------------

#declare ArchWay = union {

object {Column
       translate <-5, 0, 0> }
object {Column
       translate <5, 0, 0> }

#declare Arch_no = 0
#while (Arch_no < 8)
       object {ArchStone
              translate <5, 0, 0>
              rotate <0, 0, Arch_no*10>
              translate <0, 14, 0>
              }
       object {ArchStone
              translate <-5, 0, 0>
              rotate <0, 0, -Arch_no*10>
              translate <0, 14, 0>
              }
#declare Arch_no = Arch_no + 1
#end

// keystone
cone {<0, 18, 0>, 1.1
      <0, 20, 0>, 2.5
}

// wall filler
difference {
box {<-6, 14, 0>, <6, 21, -0.5>
    texture {Stone}
}
sphere {<0, 14, -1>, 5 pigment {color Clear}}
}
box {<-6, 21, 0>, <6, 20, 20>}
texture {Stone}
} // end Arch union

// -----------------------------------------------
// Throne

#declare Throne_Leg = union {
sphere {<0, 0, 0>, 0.25}
cone {<0, 0, 0>, 0.1
      <0, 2.5, 0>, 0.25}
rotate <10, 0, 0>
} // end leg union

#declare Throne_horn = union {
#declare Count = 1
#while (Count > 0.2)
//    cylinder {<-0.8, 6+Count, 0>, <-2.5, 5.8+Count, 0>, Count
      cone {<-0.8, 6+Count, 0>, Count-0.1
            <-2.5, 5.7+Count, 0>, Count
             rotate <0, 0, Count * 120>
             pigment {
             bozo
             turbulence 0.4
             color_map {
             [0.0 color rgb <0.8843, 0.8686, 0.6>]
             [0.8 color White]
             [1.0 color Tan]}
             scale 0.2
             }
             finish {Dull}
             normal {bumps 0.2 scale <0.5, 1, 0.5>}
    }
#declare Count = Count - 0.1
#end

cone { <-0.8, 1.8, 0>, 0
           <4, 2, 0>, 1.1
           rotate <0, 0, 120>
           translate <-1, -8, 0>
}

} // end horn union

// ---------------------------------------------

#declare Throne = union {

object {Throne_Leg
       translate <0, 0, -3>
}
object {Throne_Leg
       translate <-1, 0, -3>
}
object {Throne_Leg
       translate <1, 0, -3>
}
object {Throne_Leg
       translate <-2, 0, -3>
}
object {Throne_Leg
       translate <2, 0, -3>
}
object {Throne_Leg
       translate <-2.75, 0, -3>
}
object {Throne_Leg
       translate <2.75, 0, -3>
}
// seat
box {<-3, 2.5, -3>, <3, 3, 3>}
box {<-2.5, 2.5, -2.5>, <2.5, -1, 2.5>}
box {<-2.5, 3, -2.5>, <2.5, 3.5, 2.5> pigment {color Red}}

// arms
// left
box {<-3, 3, -3>, <-2.7, 5.3, 3>}
cylinder {<-2.85, 5, -3>, <-2.85, 5, 3>, 0.4}
height_field { gif "skull.gif"
               water_level 0.1
               rotate <-90, 0, 0>
               translate <-0.5, -0.5, 0>
               scale 0.8
               translate <-2.85, 5, -3>
}

// right
box {<3, 3, -3>, <2.7, 5.3, 3>}
cylinder {<2.85, 5, -3>, <2.85, 5, 3>, 0.4}
height_field { gif "skull.gif"
               water_level 0.1
               rotate <-90, 0, 0>
               translate <-0.5, -0.5, 0>
               scale 0.8
               translate <2.85, 5, -3>
}


// back
difference {
box {<-3, 3, 2.5>, <3, 12, 3>}
cylinder {<0, 0, 2>, <0, 0, 4>, 0.7
          scale <1, 0.5, 1>
          translate <-2.5, 12, 0>
}
cylinder {<0, 0, 2>, <0, 0, 4>, 0.7
          scale <1, 0.5, 1>
          translate <2.5, 12, 0>
}

#declare Count = 0
#while (Count < 6)
       box {<-0.25, -6+Count, -2>, <0.25, -2, 2>
            rotate <0, 0, Count * -20>
            translate <0, 10.2, 2>
            }
       box {<-0.25, -6+Count, -2>, <0.25, -2, 2>
            rotate <0, 0, Count * 20>
            translate <0, 10.2, 2>
            }

#declare Count = Count + 1
#end

} // end diff

height_field { gif "skull.gif"
               water_level 0.1
               rotate <-90, 0, 0>
               translate <-0.5, -0.5, 0>
               scale <3, 3.5, 0.5>
               translate <0, 11, 2.5>
}

object {Throne_horn
        translate <1.5, 11, 3>
}
object {Throne_horn
        rotate <0, 180, 0>
        translate <-1.5, 11, 3>
}


texture {Throne_Texture}
} // end throne union


// ------------------------------------
// Crystal Ball

#declare Crystal_Ball = union {

difference {
union {
#declare Count = 0
#while (Count < 36)

cone { <0, 8, 0>, 0
       <-4, -1, 0>, 1
       pigment
              {
              spiral2 1
              color_map {
              [0.0 color rgb <0.6745, 0.4745, 0.2>]
              [1.0 color Black]}
              scale 0.5
              }
       finish {ambient 0.25}
       rotate <0, Count * 30, 0>
}

#declare Count = Count + 1
#end
} // end union
sphere {<1.5, 6, -1.5>, 3 pigment {color Red}}
} // end difference

#declare Count = 2.5
//#while (Count > 1.5)
#while (Count > 2)
sphere {<0.8, 5, -0.8>, Count
       pigment {color rgbf <0.95, 0.9, 0.9, 0.8>}
       finish {
           ambient 0
           diffuse 0.1
           irid {
                 0.25
                 thickness 1
                 turbulence 0.25
    }
  }
}
#declare Count = Count - 0.2
#end

} // end crystal union
