// Persistence of Vision Ray Tracer Scene Description File
// File: room.pov
// Vers: 3.01 Watcom Win32
// Desc: Attic
// Date: June 13, 1997
// Auth: Sonya Roberts
// Note: Sets up basic room, rafters, window, floor, etc.

#declare FloorBoards=
object {
	#declare BSD=seed(2)
	#declare Dimens=<20,.25,30>
	#declare NumBoards=<22,1,5>
	#include "boards.inc"
	translate <-10,-.25,-15>
}

#declare RoofSide1=
object {
	#declare BSD=seed(3)
	#include "boards.inc"
	rotate z*45
	translate <-10,-.25,-15>
}

#declare RoofSide2=
object {
	#declare BSD=seed(4)
	#include "boards.inc"
	translate <-20,0,0>
	rotate z*-45
	translate <10,-.25,-15>
}

#declare EndWall1=
object {
	#declare BSD=seed(1)
	#declare Dimens=<20,15,.25>
	#declare NumBoards=<4,16,1>
	#include "boards.inc"
	translate <-10,-.25,-15>
}

#declare Wall=
object {
	#declare BSD=seed(2)
	#include "boards.inc"
	translate <-10,-.25,0>
}

#if (I_Window)
	#declare WindowFrame=
	object {
		union {
			intersection {
				torus {4,.1	rotate x*90}
				box {<0,0,-.11>,<4.11,4.11,.11>}
			}
			cylinder {<0,0,0>,<4,0,0>,.1}
			cylinder {<0,0,0>,<0,4,0>,.1}
			cylinder {<0,0,0>,<0,4,0>,.1	rotate z*-30}
			cylinder {<0,0,0>,<0,4,0>,.1	rotate z*-60}
			sphere {<0,0,0>,.1}
			sphere {<4,0,0>,.1}
			sphere {<0,4,0>,.1}
			scale <1,1,4>
			texture {T_Wood8}
		}
	}
#end

#declare EndWall2=
object {
	union {
		difference {
			object {Wall}
			intersection {
				cylinder {<-.25,3,-.5>,<-.25,3,.5>,4}
				box {<-4.5,3,-.6>,<-.25,8.5,.6>}
			}
			intersection {
				cylinder {<.25,3,-.5>,<.25,3,.5>,4}
				box {<.25,3,-.6>,<4.5,8.5,.6>}
			}
		}
		#if (I_Window)
			object {WindowFrame translate <.25,3,.125>}
			object {WindowFrame rotate y*180	translate <-.25,3,.125>}
		#end
	}
	translate <0,0,15>
}

#if (I_Rafters)
	#declare Rafters=
	object {
		#declare Z1=-15
		#declare SD1=seed(1)
		union {
			#while (Z1<15)
				union {
					box {
						<0,-.5,-.25>,<15,0,.25>
						rotate z*45
						translate <-10,0,Z1>
						texture {T_Wood10	rotate <rand(SD1)*360,rand(SD1)*360,rand(SD1)*360>}
					}
					box {
						<-15,-.5,-.25>,<0,0,.25>
						rotate z*-45
						translate <10,0,Z1>
						texture {T_Wood10	rotate <rand(SD1)*360,rand(SD1)*360,rand(SD1)*360>}
					}
					box {
						<-4,6.5,Z1-.1>,<4,6.75,Z1+.1>
						texture {T_Wood10	rotate <rand(SD1)*360,rand(SD1)*360,rand(SD1)*360>}
					}
				}
				#declare Z1=Z1+5
			#end
		}
	}
#end


// ---- Position Items ----

object {FloorBoards}
object {RoofSide1}
object {RoofSide2}
object {EndWall1}
object {EndWall2}
#if (I_Rafters)		#object {Rafters}	#end

