// Magic : scene 1

#declare PREVIEW = 0
#declare HALO = 1
#declare SOFTSHADOW = 1

#include "colors.inc"
#include "skies.inc"

#include "views.inc"
#include "tower1.inc"
#include "wall1.inc"
#include "csphere.inc"
#include "axe.inc"

global_settings {
	ambient_light color rgb <1.0, 1.25, 1.35>
	max_trace_level 10	// default is 5
}

camera { Inside1 }

light_source { <-7500, 40000, -7500> color rgb 1
#if (SOFTSHADOW=1)
	area_light <1200, 0, 0>, <0, 0, 1200>, 5, 5
	adaptive 1
	jitter
#end
}

//light_source { <0, 30, 0> color rgb 1 }
//light_source { <-30, 30, -30> color rgb 1 }

//background { color rgb <0.3, 0.7, 1> }

// ********************************************************

object { tower rotate y*180 }

#declare j=0
#while (j<16)
object { wall1 translate <0, 0, (j*20)+20> }
#declare j=j+1
#end
#declare j=0
#while (j<16)
object { wall1 rotate y*90 translate <(j*20)+20, 0, 370> }
#declare j=j+1
#end
#declare j=0
#while (j<16)
object { wall1 rotate y*(-90) translate <(j*20)+40, 0, 0> }
#declare j=j+1
#end

object { tower rotate y*270 translate z*370 }

object { crystal_sphere1 }
object { crystal_sphere1 translate z*370 }


object { axe1 scale 0.45 translate <11.5, 20, 17.4> }

// ********************************************************

#declare Oblak2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color rgb <0.435, 0.258, 0.258>  ]
        [0.5, 1.001 color rgb <0.435, 0.258, 0.258>
                    color rgb <0.435, 0.258, 0.258> ]
    }
    scale <6, 1, 6>
}
#declare Oblak3 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.65 green 0.60 blue 0.55]
        [0.1, 0.5   color red 0.65 green 0.60 blue 0.55
                    color rgb <0.309, 0.184, 0.184> ]
        [0.5, 1.001 color rgb <0.309, 0.184, 0.184>
                    color rgb <0.2, 0.1, 0.1>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ]
            [0.25 Oblak2 scale 0.25 rotate z*5]
            [0.60 Oblak3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

