// Magic : object 1
//         - tower v1.0

#ifndef (PREVIEW)
#declare PREVIEW=0
#end

#if (PREVIEW=1)

#declare Mramor1 =
texture {
	pigment { color rgb <0.8, 0.8, 1> }
	finish { phong 1 ambient 0.3 }
}

#declare BrickStone =
texture {
    pigment { color rgb <1, 1, 1> }
    finish { phong 1 ambient 0.3 }
}

#declare DarkMetal1 =
texture {
    pigment { color rgb <0.1, 1, 0.3> }
    finish { phong 1 ambient 0.3 }
}

#declare Gold1 =
texture {
    pigment { color rgb <1, 1, 0> }
    finish { phong 1 ambient 0.3 }
}

#declare Bone1 =
texture {
    pigment { color rgb <1, 1, 1> }
    finish { phong 1 diffuse 1 brilliance 0.5 ambient 0.3 }
}

// ********************************************************
#else

#declare Mramor1 =
texture {
	pigment { marble
		color_map {
			[ 0 color rgb <0.7, 0.7, 0.8> ]
			[ 0.6 color rgb <0.5, 0.5, 0.5> ]
			[ 1 color rgb <0.9, 1, 1> ]
		}
		turbulence 0.5
		scale 20
		rotate <45, 45, 0>
	}
	finish {
		ambient 0.3
		brilliance 3
		phong 1 phong_size 80
		reflection 0.2
	}
}
texture {
	pigment { crackle
		color_map {
			[ 0.0005 color rgbt <1, 1, 1, 0> ]
			[ 0.001 color rgbt <0, 0, 0, 0> ]
			[ 0.01 color rgbt <0, 0, 0, 1> ]
			[ 1 color rgbt <0, 0, 0, 1> ]
		}
		turbulence 0.2
		scale 30
	}
	finish {
		ambient 0.4
		brilliance 3
		phong 1 phong_size 80
		reflection 0.2
	}
}

#declare Gold1 =
texture {
	pigment { color rgb <0.5, 0.5, 0> }
	finish {
		brilliance 5
		ambient <0.3, 0.3, 0>
		phong 1 phong_size 100
		reflection 0.5
	}
}

#declare BrickStone =
texture {
    pigment { crackle
		color_map {
			[0.25 color rgb <0.42, 0.45, 0.45> ]
			[0.5 color rgb <0.3, 0.42, 0.46> ]
			[0.75 color rgb <0.5, 0.55, 0.4> ]
			[1 color rgb <0.5, 0.4, 0.2> ]
		}
		scale 0.1
		turbulence 0.5
	}
	normal {
		quilted 1
		control0 0
		control1 0
		turbulence 0.1
		scale <6, 2, 6>
	}
    finish {
		ambient 0.5
		diffuse 0.5
		brilliance 0.5
	}
}

#declare DarkMetal1 =
texture { crackle
	texture_map {
		[0.1
			pigment { color rgb <0.4, 0.4, 0.4> }
			normal { dents turbulence 0.2 scale 1 }
			finish { phong 0.5 reflection 0.3 ambient 0.3 }
		]
		[1
			pigment { color rgb <0.6, 0.3, 0.1> }
			normal { dents turbulence 0.2 scale 1 }
			finish { phong 0.2 ambient 0.35 }
		]
	}
	scale 3
	turbulence 1
	rotate <45, 40, 35>
}

#declare Bone1 =
texture {
    pigment { marble
		color_map {
			[0.95 color rgb <1, 1, 1> ]
			[1 color rgb <1, 1, 0.9> ]
		}
		scale 3
		turbulence 0.3
		rotate z*60
	}
    finish {
		specular 1 roughness 0.003
		reflection 0.1
		diffuse 1 brilliance 0.5
		ambient <0.6, 0.55, 0.5>
	}
}

#end

// ********************************************************

#declare arck =
difference {
    intersection {
        cone { <0, 0, 0>, 30, <0, 40, 0>, 25 }
        intersection {
            cylinder { <90, 0, -31>, <90, 0, 31>, 110 }
            cylinder { <-90, 0, -31>, <-90, 0, 31>, 110 }
        }
    }
    union {
        cylinder { <0, -1, 0>, <0, 41, 0>, 20 }
        box { <-31, -1, -20>, <31, 41, 31> }
        intersection {
            cylinder { <70, 0, -32>, <70, 0, 32>, 80 }
            cylinder { <-70, 0, -32>, <-70, 0, 32>, 80 }
        }
    }
    texture { BrickStone }
}

#declare step =
union {
    difference {
		cylinder { <0, -8, 0>, <0, 0, 0>, 32 }
		union {
        	box { <-10, -2, -32>, <10, 1, -30> }
        	box { <-10, -2, -32>, <10, 1, -30> rotate y*90 }
        	box { <-10, -2, -32>, <10, 1, -30> rotate y*180 }
        	box { <-10, -2, -32>, <10, 1, -30> rotate y*270 }
		}
    }
    #declare i=0
    #while (i<2)
        box { <-10, -2, -32>, <10, -4, -30> rotate y*i*90 }
        box { <-10, -4, -34>, <10, -6, -30> rotate y*i*90 }
        box { <-10, -6, -36>, <10, -8, -30> rotate y*i*90 }
    #declare i=i+1
    #end
    texture { BrickStone }
}

#declare top =
difference {
    cylinder { <0, 40, 0>, <0, 62, 0>, 28 }
    union {
        torus { 28, 3  scale <1, (7/3), 1> translate <0, 40, 0> }
        torus { 20, 3  scale <1, (7/3), 1> translate <0, 54, 0> }
        cylinder { <0, 54, 0>, <0, 63, 0>, 23 }
        box { <-(8/sqrt(2)), -(8/sqrt(2)), -30>, <(8/sqrt(2)), (8/sqrt(2)), -20>
            rotate z*45 scale <(6/8), 1, 1> translate <6, 62, 0> }
        box { <-(8/sqrt(2)), -(8/sqrt(2)), -30>, <(8/sqrt(2)), (8/sqrt(2)), -20>
            rotate z*45 scale <(6/8), 1, 1> translate <-6, 62, 0> }
        box { <-31, 39, -20>, <31, 63, 31> }
        box { <-31, 39, -31>, <-13, 63, -19> }
        box { <31, 39, -31>, <13, 63, -19> }
    }
    texture { BrickStone }
}

#declare horn =
difference {
    sphere { <0, 0, 0>, 25  scale <(5/25), 1, 1> }
    union {
         cylinder { <-6, 15, 0>, <6, 15, 0>, 33 }
         box { <-6, 0, -26>, <6, 26, 26> }
         box { <-6, -26, 0>, <6, 26, 26> }
    }
    texture { Bone1 }
}

#declare darck =
difference {
    cylinder { <0, 0, -2>, <0, 0, 2>, 20
        scale <1, (33/20), 1> }
    union {
        cylinder { <0, 0, -6>, <0, 0, 6>, 18
            scale <1, (32/18), 1 > }
        box { <-21, 0, -6>, <21, -34, 6> }
        box { <0, 0, -6>, <21, 34, 6> }
    }
    texture { DarkMetal1 }
}

#declare something1 =
union {
    intersection {
        box { <-5, -3, -13>, <5, 0, 0> }
        cone { <0, -1.5, 0>, 6, <0, -1.5, -12>, 4 }
    }
    difference {
        cone { <0, -3, 0>, 6, <0, -3, -12>, 0 }
        box { <-7, -3, -13>, <7, 10, 1> }
    }
    texture { BrickStone }
    translate <0, -20, -28>
}

#declare base =
union {
    difference {
        cylinder { <0, -8, 0>, <0, -13, 0>, 32 }
        torus { 32, 2 scale <1, (5/2), 1> translate <0, -13, 0> }
    texture { BrickStone }
    }
    difference {
        cylinder { <0, -13, 0>, <0, -200, 0>, 30 }
        torus { 30, 1 translate <0, -19, 0> }
    texture { BrickStone }
    }
    #declare i=0
    #while (i<8)
        object { something1 rotate y*i*45 }
    #declare i=i+1
    #end
}

#declare decor1 =
union {
    sphere { <0, 0, 0>, 1  scale <1, 10, 1> }
    sphere { <0, 0, 0>, 1  scale <4, 1, 1> }
    scale 0.5
    texture { Gold1 }
}

#declare decor2 =
difference {
	torus { 25, 1 }
	union {
		box { <-30, -2, -30>, <-13, 2, 30> }
		box { <30, -2, -30>, <13, 2, 30> }
	}
	texture { Gold1 }
	translate <0, 40, 0>
}

// ********************************************************

#declare tower =
union {
    object { base }

    object { arck }
    object { arck rotate y*90 }
    object { arck rotate y*180 }
    object { arck rotate y*270 }

	#declare i=0
	#while (i<4)
		box { <-13, 0, 18>, <-10, 40, 20> texture { DarkMetal1 } rotate y*90*i }
		box { <13, 0, 18>, <10, 40, 20> texture { DarkMetal1 } rotate y*90*i }
	#declare i=i+1
	#end
	
    object { step }

    object { top }
    object { top rotate y*90 }
    object { top rotate y*180 }
    object { top rotate y*270 }

    union {
        object { horn  translate <0, 72, -27> rotate y*20 }
        object { horn  translate <0, 72, -27> rotate y*(-20) }
    }
    union {
        object { horn  translate <0, 72, -27> rotate y*20 }
        object { horn  translate <0, 72, -27> rotate y*(-20) }
    rotate y*90
    }
    union {
        object { horn  translate <0, 72, -27> rotate y*20 }
        object { horn  translate <0, 72, -27> rotate y*(-20) }
    rotate y*180
    }
    union {
        object { horn  translate <0, 72, -27> rotate y*20 }
        object { horn  translate <0, 72, -27> rotate y*(-20) }
    rotate y*270
    }

    object { darck translate <0, 47, 0> }
    object { darck translate <0, 47, 0> rotate y*90 }
    object { darck translate <0, 47, 0> rotate y*180 }
    object { darck translate <0, 47, 0> rotate y*270 }

    difference {
        cylinder { <0, 43, 0>, <0, 47, 0>, 23 }
        cylinder { <0, 39, 0>, <0, 48, 0>, 18 }
        texture { DarkMetal1 }
    }
	
	// wall decor
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*25 }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*(-25) }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*25
        rotate y*90 }
    object { decor1 translate <0, 250, -30> rotate x*(degrees(atan2(1, 8))) rotate y*(-25)
        rotate y*90 }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*25
        rotate y*180 }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*(-25)
        rotate y*180 }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*25
        rotate y*270 }
    object { decor1 translate <0, 25, -30> rotate x*(degrees(atan2(1, 8))) rotate y*(-25)
        rotate y*270 }
	object { decor2 }
	object { decor2 rotate y*90 }
	
	// floor decor
	cylinder { <0, -1, 0>, <0, 0.0001, 0>, 19  texture { Mramor1 scale (1/4) } }
	difference {
		cylinder { <0, -1, 0>, <0, 0.0001, 0>, 20 }
		cylinder { <0, -2, 0>, <0, 1, 0>, 19 }
		texture { Gold1 }
	}
	// letters
	#declare sl=seed(666)
	#declare i=0
	#while (i<36)	
		text { ttf "tengwar.ttf", chr(65+(rand(sl)*25)), 1, 0 scale <6, 6, 1> rotate x*(-90)
			translate <-0.5, -0.9998, -16> rotate y*10*i texture { Gold1 } }
	#declare i=i+1
	#end
}
