#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"

#declare INCTOAD = 1
#declare INCBOTTLE = 1
#declare INCQUILL = 1
#declare INCFOG = 1
#declare INCBOOKS = 1
#declare WALLTYPE = 1

global_settings
{
	assumed_gamma 1.5
}
camera
{
	direction z*1.5
	right x*4/3
	location <80, 50, -60>
	look_at <0, 13.13, 0>
}

// LIGHTS *******************************************
light_source
{
	-z*200
	colour rgb<1,1,1>
	rotate<40,-45,0>
	spotlight
	radius 2
	falloff 15
	point_at<-20,24,0>
}

light_source
{
	-z*200
	colour rgb<1,1,1>
	rotate<30,60,0>
	spotlight
	radius 2
	falloff 15
	point_at<-20,0,0>
}

light_source
{
	<90, 100, -60>
	colour Gray10
}

// TOAD ******************************************
#if( INCTOAD )
union
{
	union
	{
		#include "head.inc"

		pigment { rgb < 0.0000, 0.5020, 0.0000 > }
		finish { phong 0.5 }
		normal{ dents -0.5 scale 0.2}
	}
	sphere
	{
		<0,0,0>, 1.5
		pigment{ image_map{ tga "eyemap1.tga" map_type 1 }}
		finish{ specular 1 roughness 0.001 }
		rotate y*200
		translate <3.1,0,0>
	}
	rotate x*-20
	translate y*24
}

union
{
	#include "cloak.inc"
	pigment
	{
		rgb < 0, 0, 0.6275 >
	}
	finish { brilliance 0.5 }
	normal
	{
		quilted 0.2
		control0 1
		control1 1
		scale 0.2
	}
}
#end	//INCTOAD

// TABLE ******************************************************
#declare TTR = seed(666)
#declare TabPlankX = -65
#while( TabPlankX <= 55 )
	box
	{
		<-4.9,-10,-50>,<5,0,30>
		texture
		{
			T_Wood17
			scale 3
			rotate <-4+rand(TTR),(rand(TTR)-0.5),0>
			translate < ((rand(TTR)-0.5)*8),(rand(TTR)-0.5)*8,0>
		}
		translate x*TabPlankX
	}
	#declare TabPlankX = TabPlankX + 10
#end

// BOOK ************************************************
union
{
	box	// pages
	{
		<-20,0.5,-15>,<20,5,15>

		pigment
		{
			image_map{ png "bookmap.png" interpolate 4}
			translate <-0.5,-0.5,0>
			rotate x*90
			rotate y*180
			scale <40,1,30>
		}
	}
	union
	{
		box	// cover
		{
			<-22,0,-17>,<22,0.8,17>
		}
		cylinder{ <-22,0.4,17>,<22,0.4,17>,0.4 }
		cylinder{ <-22,0.4,17>,<-22,0.4,-17>,0.4}
		sphere{ <-22,0.4,17>,0.4 }
		pigment{ color red 0.2 green 0 blue 0 }
		normal
		{
			crackle 0.5
			scale 0.5
		}
	}
	rotate y*20
	translate <10,0,-40>
}

// QUILL *****************************************************
#if( INCQUILL )
union
{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.5000, 0.5000, 2.0000> <3.8326, 0.5000, 2.4446> <0.1908, 0.1006, 2.2492> <-2.5000, 0.0000, 2.0000>
		<8.4292, 0.5000, 1.6785> <5.7618, 0.5000, 2.1230> <0.3408, 0.1006, 1.6492> <-2.3500, 0.0000, 1.4000>
		<12.7175, 0.0757, 1.4422> <8.3675, 0.0757, 1.5922> <2.2821, -0.0528, 0.5146> <-2.0694, -0.0528, 0.6123>
		<12.5000, 0.0000, -0.5000> <8.1500, 0.0000, -0.3500> <2.3515, 0.0000, -0.0977> <-2.0000, 0.0000, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.0000, 0.3261, -2.4638> <8.0213, 0.2731, -2.1976> <12.2732, -0.0789, -2.5252> <12.5000, 0.0000, -0.5000>
		<3.6212, 0.3885, -2.7770> <5.6425, 0.3355, -2.5108> <7.9232, -0.0789, -2.3752> <8.1500, 0.0000, -0.3500>
		<0.3848, 0.4403, -2.6735> <0.3848, 0.3261, -1.9507> <2.4336, 0.0625, -0.8222> <2.3515, 0.0000, -0.0977>
		<-2.0000, 0.3804, -2.4094> <-2.0000, 0.2663, -1.6866> <-1.9179, 0.0625, -0.7245> <-2.0000, 0.0000, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.0000, 0.0000, -1.0240> <-5.5110, 0.0729, -1.4860> <-3.5507, 0.3415, -2.2377> <-2.0000, 0.3804, -2.4094>
		<-7.8439, -0.0413, -0.7621> <-6.3550, 0.0316, -1.2241> <-3.5507, 0.2274, -1.5148> <-2.0000, 0.2663, -1.6866>
		<-9.8299, 0.0000, -0.8822> <-7.5003, 0.0000, -0.8822> <-4.2468, 0.0625, -0.6722> <-1.9179, 0.0625, -0.7245>
		<-9.7652, 0.0000, 0.0000> <-7.4356, 0.0000, 0.0000> <-4.3290, 0.0000, 0.0523> <-2.0000, 0.0000, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.8690, 0.0000, 0.7620> <-7.7352, 0.0000, 0.5235> <-9.6994, 0.0000, 0.8960> <-9.7652, 0.0000, 0.0000>
		<-5.5556, 0.0000, 1.1236> <-6.4218, 0.0000, 0.8851> <-7.3699, 0.0000, 0.8960> <-7.4356, 0.0000, 0.0000>
		<-3.8556, -0.0507, 1.8745> <-3.7056, -0.0507, 1.2745> <-4.3984, -0.0528, 0.6646> <-4.3290, 0.0000, 0.0523>
		<-2.5000, 0.0000, 2.0000> <-2.3500, 0.0000, 1.4000> <-2.0694, -0.0528, 0.6123> <-2.0000, 0.0000, 0.0000>
	}
	difference
	{
		cone{ <-14,0,0>,0.25, <12,0,0>,0.05 }
		sphere{ <-14,-.75,0>, 1}
		pigment{rgb<.9,.9,.9>}
		scale 1/1.2

	}
	scale 1.2
	rotate x*-90

	pigment{ image_map{ png "quillmap.png" once} scale <29,6,1> translate<-14.5,-3,0>}
	rotate x*90
	rotate y*-60
	translate <-20,0.21, -20>

}
#end	//INCQUILL

// INK BOTTLE ***************************************
#if( INCBOTTLE )
difference
{
	merge
	{
		superellipsoid{ <.3,.3> }
		intersection
		{
			quadric
			{
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -1
			}
			cylinder{ <0,-1.1,0>,<0,1,0>,2 }
			scale 0.5
			translate y*1.5
		}
	}
	union
	{
		superellipsoid{ <.3,.3> scale 0.8 translate y*0.1}
		intersection
		{
			quadric
			{
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -1
				scale 0.6
			}
			cylinder{ <0,-1.5,0>,<0,1.2,0>,2 }
			scale 0.5
			translate y*1.5
		}
	}

	scale <1,.75,1>*4
	rotate z*90
	rotate y*-90
	translate y*4

	pigment{rgbt<.2,.2,.4, 0.7>}
	finish{specular 1 roughness 0.01 refraction 1 ior 1.5}
	normal{ bumps 0.5 }

	translate <-27,0,-11>
}
#end	//INCBOTTLE

// INK SPLAT
blob
{
	threshold 0.1
	sphere{ < 0,0,0>, 4.0, 1 }
	sphere{ < 4,0,0>, 2.0, 1 }
	sphere{ <-4,0,1>, 2.5, 1 }
	sphere{ < 1,0,4>, 4.5, 1 }
	sphere{ < -2,0,3>, 3, 1 }

	scale <1,.1,1>
	pigment{ Black }

	translate z*8
	rotate y*-180
	translate <-27,0,-11>
}

// CANDLE ON CANDLESTICK *********************************************************
union
{
	blob
	{
		threshold 0.3

		cylinder{ <0,-2,0>,<0,.75,0>,2.5,0.5}
		sphere{ <0,1.1,-0.75>, 2.75, -.75 }

		cylinder{ <0,.1,-1.2>,<0,-2.4,-1.3>,.6,.4}
		sphere{ <0,0,-1.2>, .7, .2 }
		sphere{ <0,-.5,-1.2>, .8, .2 }
		sphere{ <0,-1.1,-1.2>, .7, .3 }
		sphere{ <0,-1.5,-1.4>, .7, .2 }

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*40}
		sphere{ <0,.4,-1.2>, .7, .2  rotate y*40}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*40}
		sphere{ <0,-1.2,-1.2>, .9, .3  rotate y*40}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*40}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*80}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*80}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*80}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*80}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*80}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*120}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*120}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*120}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*120}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*120}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*160}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*160}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*160}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*160}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*160}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*200}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*200}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*200}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*200}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*200}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*240}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*240}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*240}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*240}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*240}

		cylinder{ <0,.4,-1.2>,<0,-2.2,-1.3>,.6,.4 rotate y*280}
		sphere{ <0,.4,-1.2>, .7, .4  rotate y*280}
		sphere{ <0,-.4,-1.2>, .8, .2  rotate y*280}
		sphere{ <0,-1.2,-1.2>, .7, .3  rotate y*280}
		sphere{ <0,-1.7,-1.2>, .7, .2  rotate y*280}

		cylinder{ <0,.1,-1.2>,<0,-2.3,-1.3>,.6,.4 rotate y*320}
		sphere{ <0,.1,-1.2>, .7, .4  rotate y*320}
		sphere{ <0,-.5,-1.2>, .8, .2  rotate y*320}
		sphere{ <0,-1.3,-1.2>, .7, .3  rotate y*320}
		sphere{ <0,-1.8,-1.5>, .7, .2  rotate y*320}

		pigment
		{
			gradient y
			colour_map
			{
				[0 Gray50]
				[1 White]
			}
			scale 2.8
			translate y*-1.9
		}
		finish{ ambient .5 }
	}

	cylinder	// wick
	{
		<0,.3,0>,<0,-2,0>, .1
		pigment{Black}
	}

	sphere	// flame
	{
		0, .6
		hollow
		pigment{Clear}
		halo
		{
			emitting
			cubic
			colour_map
			{
				[0 Clear]
				[1 Yellow transmit -1]
			}
			translate y*-.2
		}
		scale <1,3,1>
		translate y*1.1

	}

	union
	{
		intersection
		{
			quadric
			{
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -1
				scale <1.5,.5,1.5>
				translate y*-5
			}
			cylinder{ <0,-7.5,0>,<0,-5,0>,3}
		}
		cylinder{ <0,-5,0>,<0,-2,0>,1.5}

		texture{ T_Brass_3C }
	}

	light_source{ y*.9 colour Gray30 fade_power 1 fade_distance 2}
//	light_source{ y*.7 colour Gray30 fade_power 2 fade_distance 1}
//	light_source{ y*.9 colour Gray30 fade_power 2 fade_distance 1}

	translate <20,7.0,-20>
}

// FLOOR ******************************
plane
{
	y, -70
	pigment
	{
		granite
		colour_map
		{
			[0 Gray50]
			[1 Gray75]
		}
	}
}

//WALL ********************************
#if( WALLTYPE = 1 )
#declare Wall =
union
{
	#declare SWY = 0
	#while( SWY < 6 )
		#declare SWZ = 0
		#while( SWZ < 15 )
			#if( floor(SWY/2) = floor((SWY+1)/2) )
				#declare SWZ1 = SWZ
			#else
				#declare SWZ1 = SWZ + 0.5
			#end
			superellipsoid
			{
				<0.2,0.2>
				translate <0,SWY*2+1,-SWZ1*2>
			}
			#declare SWZ = SWZ + 1
		#end
		#declare SWY = SWY + 1
	#end
	scale <10,10,20>
	pigment
	{
		bozo
		colour_map
		{
			[0 Gray50]
			[.2 White]
			[.2 Gray50]
			[1 Gray75]
		}
	}
}
#else	// WALLTYPE
#declare Wall = box
{
	<-1,-1,-640>,<1,130,1>
	pigment{Gray60}
}
#end	//WALLTYPE
object
{
	Wall
	translate <-400,-70,400>
}
object
{
	Wall
	translate <0,0,600>
	rotate y*90
	translate <-400,-70,400>
}

// MISTY FOG STUFF *******************************************************
#if( INCFOG )
box
{
	<-1,0,-1>,<1,.5,1>
	pigment{ Clear }
	hollow
	halo
	{
		attenuating
		poly exponent .1
		planar_mapping
		colour_map
		{
			[0 rgbt<.522,.42,.25, .5 >]
			[1 rgbt<1,1,1, 1>]
		}
		turbulence 2
		samples 40
		octaves 3
		frequency 2
		aa_level 3
		aa_threshold 0.2
		jitter 0.1
		scale <.05,.5,.05>
	}
	scale <400,70,400>
	translate <0,-70,0>
}
#end	//INCFOG

// Bookcase **************************************************
#declare ShelfBook =
union
{
	intersection
	{
		box{ <-0.5,-0.1,-2.5>,<0.5,5.1,0> }
		cylinder{ <0,0,0>,<0,5,0>,1 }
	}
	box{ <-0.5,0,0>,<0.5,5,2.5>}
	translate <.5,0,-2.5>
}

#declare T = texture{ T_Wood34 }
union
{
	box{ <-95,0,-5>,<100,200,0> texture{T rotate x*90}}	// back
	box{ <0,0,-45>,<5,200,0>  texture{T rotate x*90} translate x*-100}	// left
	box{ <-5,0,-45>,<0,200,0>  texture{T rotate x*90} translate x*100}	// right

	box{ <-95,0,-40>,<100,5,-5> texture{T rotate y*90} translate y*50}	// shelf
	box{ <-95,0,-40>,<100,5,-5> texture{T rotate y*90} translate y*100}	// shelf
	box{ <-95,0,-40>,<100,5,-5> texture{T rotate y*90} translate y*150}	// shelf
	box{ <-95,0,-40>,<100,5,-5> texture{T rotate y*90}}	// bottom
	box{ <-105,0,-50>,<105,5,0> texture{T rotate y*90} translate y*200}	// top

// books
#if( INCBOOKS )
	#declare BookRow = 0
	#declare BookTransY = 5
	#declare BookSeed = seed(153)
	#declare NumBooks = 20 + floor(rand(BookSeed) * 4)
	#while( BookRow < 3 )
		#declare BookNum = 0
		#declare BookX = 0
		#while( BookNum < NumBooks )
			#declare BookScaleX = 1 - rand(BookSeed) / 4
			#declare BookScaleY = 1 - rand(BookSeed) / 5
			#declare BookColourIndex = floor(mod( rand(BookSeed) * 50,5 ))
			object
			{
				ShelfBook
				scale<BookScaleX,BookScaleY,1>
				translate x*BookX
				#switch( BookColourIndex )
					#case(0)
						pigment{ Red * 0.4 * (rand(BookSeed)/4+.75)}
						#break
					#case(1)
						pigment{ Blue *0.4 * (rand(BookSeed)/4+.75)}
						#break
					#case(2)
						pigment{ DarkGreen * (rand(BookSeed)/4+.75)}
						#break
					#case(3)
						pigment{ DarkBrown * (rand(BookSeed)/4+.75)}
						#break
					#case(4)
						pigment{ Gray50 * (rand(BookSeed)/4+.75)}
						#break
				#end //switch

				scale 8
				translate <-95,BookTransY,-5>
			}
			#declare BookX = BookX + BookScaleX+.1
			#declare BookNum = BookNum + 1
		#end // while BookNum
		#declare BookRow = BookRow + 1
		#declare BookTransY = BookTransY + 50
	#end //while BookRow
#end // if INCBOOKS
	rotate y*-90
	translate <-390, -70,170>
}

// INSTRUMENT ****************************************************************
#declare Leg = prism
{
	cubic_spline
	-1,1, 12,
	<0,13>,
	<-1,9>,<4,8>,
	<12,0>,<14,-1>,<18,-1>,
	<18,2>,<14,3>,
	<7,10>,<0,13>,
	<-1,9>,
	<4,8>

	translate <0,0,-5>
	rotate x*-90
	translate y*5
//	rotate y*20
}
union
{
	union
	{
		difference
		{
			cylinder{0,y, 20}
			cylinder{<0,.8,0>,<0,1.1,0>,19}
		}
		difference
		{
			cylinder{ z*-0.5,z*.5, 21 }
			cylinder{ z*-0.51,z*.51, 20 }
		}
		difference
		{
			cylinder{ z*-0.5,z*.5, 21 }
			cylinder{ z*-0.51,z*.51, 20 }
			rotate y*60
		}
		difference
		{
			cylinder{ z*-0.5,z*.5, 21 }
			cylinder{ z*-0.51,z*.51, 20 }
			rotate y*120
		}
		union
		{
			cylinder{ z*15,z*19.5, .2 }
			cylinder{ z*15,z*19.5, .2 rotate y*30}
			cylinder{ z*15,z*19.5, .2 rotate y*60}
			cylinder{ z*15,z*19.5, .2 rotate y*90}
			cylinder{ z*15,z*19.5, .2 rotate y*120}
			cylinder{ z*15,z*19.5, .2 rotate y*150}
			cylinder{ z*15,z*19.5, .2 rotate y*180}
			cylinder{ z*15,z*19.5, .2 rotate y*210}
			cylinder{ z*15,z*19.5, .2 rotate y*240}
			cylinder{ z*15,z*19.5, .2 rotate y*270}
			cylinder{ z*15,z*19.5, .2 rotate y*300}
			cylinder{ z*15,z*19.5, .2 rotate y*330}
			translate y*.8
		}
		#declare P1 = <cos(radians(0))*12,.9,sin(radians(0))*12>
		#declare P2 = <cos(radians(72))*12,.9,sin(radians(72))*12>
		#declare P3 = <cos(radians(72*2))*12,.9,sin(radians(72*2))*12>
		#declare P4 = <cos(radians(72*3))*12,.9,sin(radians(72*3))*12>
		#declare P5 = <cos(radians(72*4))*12,.9,sin(radians(72*4))*12>
		cylinder{P1,P3,.2}
		cylinder{P3,P5,.2}
		cylinder{P5,P2,.2}
		cylinder{P2,P4,.2}
		cylinder{P4,P1,.2}

		pigment{ rgb<1, 0.7, 0.3>}
		finish{ specular 10 roughness 0.01 brilliance 3 metallic diffuse 1 ambient .15}
		normal{wrinkles .3 scale 0.25}
		translate <10,30,0> rotate z*20 translate y*-36
	}
	union
	{
		object{ Leg }
		object{ Leg rotate y*90}
		object{ Leg rotate y*180}
		object{ Leg rotate y*270}
		cylinder{ <0,8,0>,<0,34,0>, 3 }
		sphere{ <0,13,0>,1 scale<4,1,4>}
		sphere{ <0,8,0>,1 scale<4,1,4>}
		sphere{ <0,24,0>,1 scale<4,1,4>}
		sphere{ <0,34,0>,5 }
		cylinder{ <-10,0,0>,<10,0,0>,2 rotate z*20 translate y*34}
		sphere{ <10,0,0>, 3 rotate z*20 translate y*34}
		cylinder{ <10,0,0>,<10,10,0>,2 rotate z*20 translate y*34}
		sphere{ <10,10,0>, 3 rotate z*20 translate y*34}

		pigment{ rgb<1, 0.7, 0.3>}
		finish{ specular 10 roughness 0.01 brilliance 3 metallic diffuse 1 ambient .15}

	//	rotate y*30
		translate y*-70
	}
	rotate y*-90
	translate <-110,0,190>
}

