// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// dragonfly.inc
// Dragonfly Include File for POV-Ray 3.x
// 16 July 97, SjG (libelle@webbwerks.com)
//
// Model of a dragonfly. Not yet animated...
//
// The dragonfly's origin is actually near the tip of its tail. Yuck!
//
// If you'd like multiple dragonflies in a scene with different
// poses, you can #declare dragonflySeed as a random number seed,
// and call this include file repeatedly.
//
// Typically, the wings are designed to look like the camera used a
// high-shutter-speed, and they're frozen in motion. You can #declare
// blurredWings to a value to get a more motion-blurred effect.
//
// This was originally designed after a dragonfly picture from the
// amazing site at http://www.our-town.com/dragonfly/.
// Later, it was pointed out to me that the bodies would look better
// if they could be curled back. So, if you #declare curlAngle to
// an angle greater than 26.8 (in degrees), the tail of the dragonfly
// will curl that angle. That is, if curlAngle is 180, the dragonfly's
// tail will curl back under it to form the shape of the letter C.
// If the curlAngle is less than 26.8 degrees, it will be the original
// default body.
//
// Samuel Goldstein. libelle@webbwerks.com
// -=-=-=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


#ifndef (dragonflySeed)
	#declare dragonflySeed = seed(23119)
#end

#declare eyeTex = texture {
		finish {
			irid
  				{
   				 0.2
    			 thickness 0.2
    			turbulence 0.7
  				}
		}
		normal {
			crackle
			scale <0.2,0.2,0.2>
			}
		pigment {MediumForestGreen}
}

#ifndef(blurredWings)
	#debug "\nDragonfly: snapshot wings\n"
	#declare wingTex = texture {
			finish {
			//specular 1 roughness 0.0001
			ambient 0.2
			irid
  					{
   					 0.35
    				 thickness 0.2
    				turbulence 0.27
  					}
			}
			pigment {
			crackle
			color_map
				{
				[0 color Gray40]
				[0.11 color Gray40]
				[0.2 rgb <.839, .827,.784>]			
				[0.5 color White]			
				[1 color White]
				}
			}
			scale <1.25,1.25,1.25>
	}
#else
	#debug "\nDragonfly: motion blurred wings\n"
	#declare wingTex1 = texture {
			finish {ambient 0.1 diffuse 0.1 phong 0.3 phong_size 60}
			normal {crackle}
			pigment {
				crackle
				color_map {
					[0	color rgbt <0,0,0,0.96>]
					[0.1 color rgbt <1,1,1,0.96>]
					[1 color rgbt <1,1,1,0.96>]
				}
			}
			scale <1.25,3,1.25>
	}
	
	#declare wingTex2 = texture {
			finish {ambient 0.2 diffuse 0.2 phong 0.3 phong_size 60}
			normal {crackle}
			pigment {
				crackle
				color_map {
					[0	color rgbt <0,0,0,0.94>]
					[0.1 color rgbt <1,1,1,0.94>]
					[1 color rgbt <1,1,1,0.94>]
				}
			}

			scale <1.25,3,1.25>
	}
	
	#declare wingTex3 = texture {
			finish {ambient 0.3 diffuse 0.3 phong 0.3 phong_size 60}
			normal {crackle}
			pigment {
				crackle
				color_map {
					[0	color rgbt <0,0,0,0.92>]
					[0.1 color rgbt <1,1,1,0.92>]
					[1 color rgbt <1,1,1,0.92>]
				}
			}

			scale <1.25,3,1.25>
	}
	
	#declare wingTex4 = texture {
			finish {ambient 0.4 diffuse 0.4 phong 0.3 phong_size 60}
			normal {crackle}
			pigment {
				crackle
				color_map {
					[0	color rgbt <0,0,0,0.90>]
					[0.1 color rgbt <1,1,1,0.90>]
					[1 color rgbt <1,1,1,0.90>]
				}
			}

			scale <1.25,3,1.25>
	}
	
	#declare wingTex5 = texture {
			finish {ambient 0.5 diffuse 0.5 phong 0.3 phong_size 60}
			normal {crackle}
			pigment {
				crackle
				color_map {
					[0	color rgbt <0,0,0,0.88>]
					[0.1 color rgbt <1,1,1,0.88>]
					[1 color rgbt <1,1,1,0.88>]
				}
			}

			scale <1.25,3,1.25>
	}
#end

#declare abTex = texture {
		finish {specular 1 roughness 0.0001 reflection 0.13}
		pigment {
		gradient z
		turbulence 0.5
		color_map
			{
			[0 color Black]
			[0.1 color rgb<.523,.062,0>]
			[0.2 color rgb<.427,.055,.063>]
			[0.7 color rgb<.89,.666,.388>]
			[1 color rgb <.839, .827,.784>]
			}
		}
}

#declare bodyTex = texture {
		finish {specular 1 roughness 0.0001 reflection 0.13}
		pigment {
		bozo
		color_map
			{
			[0 transmit 1]
			[0.4 color rgb<.427,.055,.063>]
			[1 color rgb<.89,.666,.388> ]
			}
		}
}

#declare backWing = merge {
	difference {
		cylinder{<-15,0,0>,<-15,0.001,0>,16}
		intersection {
			plane {x,0 rotate <0,70.97,0>}
			plane {x,0 rotate <0,78.44,0> translate <0,0,-2.5>}
			}
		}
	difference {
		merge {
			cylinder{<-31,0,-12>,<-31,0.001,-12>,2.5}
			box {<-31,0,-16>,<-15,0.02,-6>}
			}
		plane {x,0 rotate <0,-77.47,0> translate <-27,0,-15>}
		plane {x,0 rotate <0,55,0> translate <-32,0,-9.75>}
		plane {x,0 rotate <0,77,0> translate <-27,0,-7>}
	}
}

#declare frontWing = merge {
	cylinder{<33,0,4.5>,<33,0.001,4.5>,2.4}
	difference {
		box {<0,0,-4>,<30,0.001,7>}
		intersection {
			plane {z,0 rotate <0,165.96,0> translate <18,0,4>}
			plane {z,0 rotate <0,175,0> translate <18,0,4>}
		}
		plane {z,0 rotate <0,158,0> translate <5,0,3>}
		plane {z,0 rotate <0,-20,0> translate <30,0,0>}
		plane {z,0 translate <0,0,-4>}
		plane {z,0 rotate <0,11.77,0> translate <12,0,-4>}
		plane {z,0 rotate <0,41.2,0> translate <3,0,-2>}
		
	}
	intersection {
		plane {z,0 rotate <0,14.03,0> translate <32,0,7>}
		plane {z,0 rotate <0,153.4,0> translate <30,0,0>}
		cylinder{<0,0,0>,<0,0.001,0>,3.7 scale <1.1,1,1>
			translate <30.5,0,3.5>} // 30,0,3.5
	}
}


#ifndef(blurredWings)
	#declare wings = union {
		object{frontWing rotate <-8,0,0> rotate <0,0,2>
			translate <1,4.5,32.5> texture {wingTex}}
		object{frontWing scale <-1,1,1>  rotate <-8,0,0>
			rotate <0,0,-2> translate <-1,4.55,32.5> texture {wingTex}}
		object{backWing  rotate <-8,0,0> rotate <0,0,-1>
			translate <-1,3,30> texture {wingTex}}
		object{backWing scale <-1,1,1>  rotate <-8,0,0>
			rotate <0,0,1> translate <1,3,30> texture {wingTex}}
	}
 #else
	#if (rand(dragonflySeed) > 0.5)
		// wings beating down
		#debug " (Wings down)"
		#declare wingCount=1
		#declare wings=union{
		
		#while (wingCount < 5)
			union {
			object {frontWing rotate <-8,0,0> rotate <0,0,2-(wingCount*5)>
				translate <1,4.5,32.5>}
			object {frontWing scale <-1,1,1> rotate <-8,0,0> 
				rotate <0,0,-2+(wingCount*5)> translate <-1,4.55,32.5>}
			object{backWing rotate <-8,0,0> rotate <0,0,-1+(wingCount*5)>
				translate <-1,3,30>}
			object{backWing scale <-1,1,1> rotate <-8,0,0> 
				rotate <0,0,1-(wingCount*5)> translate <1,3,30>}
			// doh! nasty nasty nasty
			#if (wingCount=1)
				texture{wingTex1}
			#end
			#if (wingCount=2)
				texture{wingTex2}
			#end
			#if (wingCount=3)
				texture{wingTex3}
			#end
			#if (wingCount=4)
				texture{wingTex4}
			#end
			#if (wingCount=5)
				texture{wingTex5}
			#end
			}
			#declare wingCount=wingCount+1
		#end //while
		}
	#else
		// wings beating up
		#debug " (Wings Up) "
		#declare wingCount=1
		#declare wings=union{
		#while (wingCount < 5)
			union {
			object {frontWing rotate <-8,0,0> rotate <0,0,2+(wingCount*5)>
				translate <1,4.5,32.5>}
			object {frontWing scale <-1,1,1> rotate <-8,0,0> 
				rotate <0,0,-2-(wingCount*5)> translate <-1,4.55,32.5>}
			object{backWing rotate <-8,0,0> rotate <0,0,-1-(wingCount*5)>
				translate <-1,3,30>}
			object{backWing scale <-1,1,1> rotate <-8,0,0> 
				rotate <0,0,1+(wingCount*5)> translate <1,3,30>}
			// doh! nasty nasty nasty
			#if (wingCount=1)
				texture{wingTex1}
			#end
			#if (wingCount=2)
				texture{wingTex2}
			#end
			#if (wingCount=3)
				texture{wingTex3}
			#end
			#if (wingCount=4)
				texture{wingTex4}
			#end
			#if (wingCount=5)
				texture{wingTex5}
			#end
			}
			#declare wingCount=wingCount+1
		#end //while
		}	
	#end //if 
#end


#declare hindLeg = union {
	sphere{<0,0,0>,0.5}
	cylinder{<0,0,0>,<2,-0.5,2>,0.15}
	sphere{<2,-0.5,2>,0.15}
	cylinder{<2,-0.5,2>,<1.5,-1,2.5>,0.15}
	sphere{<1.5,-1,2.5>,0.15}
	cone{<1.5,-1,2.5>,0.15,<1.1,-1.1,2.7>,0.05}
	texture{bodyTex}
}

#declare midLeg = union {
	sphere{<-0.2,0,0>,0.5}
	sphere{<0,0,0.5>,0.4}
	cylinder{<0,0,0.5>,<3,-6,-6.5>,0.2}
	cylinder{<0,-0.07,0.5>,<3,-6.07,-6.5>,0.2}
	sphere{<3,-6,-6.5>,0.2}
	cone{<3,-6,-6.5>,0.2,<2,-8.5,-1>,0.1}
	sphere{<2,-8.5,-1>,0.1}
	cylinder{<2,-8.5,-1>,<2,-10,-0.5>,0.1}
	sphere{<2,-10,-0.5>,0.1}
	cone{<2,-10,-0.5>,0.1,<2,-11,0.5>,0.05}
	texture{bodyTex}
}

#declare frontLeg = union {
	sphere{<-2,1.5,0>,0.3}
	cylinder{<-2,1.5,0>,<-5,-1.5,3.5>,0.2}
	sphere{<-5,-1.5,3.5>,0.2}
	cone{<-5,-1.5,3.5>,0.2,<-2,-0.5,6>,0.12}
	sphere{<-2,-0.5,6>,0.12}
	cone{<-2,-0.5,6>,0.12,<-1.2,-0.4,7>,0.1}
	sphere{<-1.2,-0.4,7>,0.1}
	cone{<-1.2,-0.4,7>,0.1,<-0.7,-0.35,6.5>,0.05}
	texture{bodyTex}
}

#declare head = union {
	cylinder{<0,0,0>,<0,0,1>,1 texture{bodyTex}}
	sphere {<0,0,0>,1.5 scale <1,1,0.7> rotate <0,0,30>
		translate <2,1.5,2.5> texture{eyeTex}}
	sphere {<0,0,0>,1.5 scale <1,1,0.7> rotate <0,0,30>
		translate <-2,1.5,2.5> texture{eyeTex}}
	intersection {
		sphere{<0,2,7.5>,7.5}
		union {
			sphere {<-1,1,4>,1}
			sphere {<1,1,4>,1}
			sphere {<0,0,0>,3 scale <1,1,0.7> rotate <0,0,35>
				translate <0,0,2.5>}
			}
		texture{bodyTex}
	}
}


// is it completely obvious to Everyone Involved that this
// body curl stuff was an afterthought? Plan, plan, plan!

#ifndef (curlAngle)
	#declare curlAngle = 0
#end
#debug concat(" Body curl ",str(curlAngle,5,5), " degrees.")

#declare curlAngle = curlAngle/8
#if (curlAngle < 3.35)
#debug "\nDefault Abdomen/Thorax\n"
#declare thoraxAbdomen = union {
	union {
		cone {<-0.5,0,-3>,0.2,<-0.5,0,-1>,0.5}
		cone {<0.5,0,-3>,0.2,<0.5,0,-1>,0.5}
		sphere {<0,-0.5,0>,1 scale <1,1,2>}
		 texture{abTex}}
	cone {<0,-0.25,1>,1,<0,-0.25,3>,0.9 texture{abTex
							scale <1,1,2> translate <0,0,1>}}
	cone {<0,-0.25,3>,1.25,<0,-0.25,6>,1.1 scale <1.05,1,1> texture{abTex
							scale <1,1,4> translate <0,0,3>}}
	cone {<0,-0.25,6>,1.25,<0,-0.67,10>,1.1 scale <1.1,1,1> texture{abTex
							scale <1,1,4> translate <0,0,6>}}
	cone {<0,-0.67,10>,1.25,<0,-1,14>,1.2 scale <1.15,1,1> texture{abTex
							scale <1,1,4> translate <0,0,10>}}
	cone {<0,-1,14>,1.3,<0,-1,18.5>,1.1 scale <1.1,1,1> texture{abTex
							scale <1,1,4.5> translate <0,0,14>}}
	cone {<0,-1,18.5>,1.2,<0,-0.7,22.5>,1.6 scale <0.8,1,1> texture{abTex
							scale <1,1,4> translate <0,0,18.5>}}
	cone {<0,-0.7,22.5>,1.7,<0,-0.2,27.5>,2.1 scale <0.8,1,1>
					texture{abTex scale <1,1,5> translate <0,0,22.5>}}
	cone {<0,-0.2,27>,2.1,<0,1.2,30.5>,2 scale <0.9,1,1>
					texture{abTex scale <1,1,5> translate <0,0,26>}
					texture{bodyTex}}
	union{
		cone {<0,1.2,30.5>,2,<0,3.5,36.25>,2.25}
		sphere {<0,1.5,34.25>,2.5}
		sphere {<0,2,34.25>,2.5}
		sphere {<0,0,0>,3 scale <0.75,1,1> translate <0.3,2.25,35.25>}
		sphere {<0,0,0>,3 scale <0.75,1,1> translate <-0.3,2.25,35.25>}
		texture{abTex scale <1,1,7> translate <0,0,30>}
		texture{bodyTex}
		}
	object {hindLeg
		rotate <-30+rand(dragonflySeed)*60,0,0>
		translate <1.15,-1,32>}
	object {hindLeg
		rotate <-30+rand(dragonflySeed)*60,0,0>
		scale <-1,1,1> translate <-1.15,-1,32>}
	object {midLeg
		rotate <-30+rand(dragonflySeed)*60,0,-30+rand(dragonflySeed)*60>
		translate <2,0,36>}
	object {midLeg
		rotate <-30+rand(dragonflySeed)*60,0,-30+rand(dragonflySeed)*60>
		scale <-1,1,1> translate <-2,0,36>}
	object {frontLeg translate <0,0,38>}
	object {frontLeg scale <-1,1,1> translate <0,0,38>}
	object {head rotate <0,0,-30+rand(dragonflySeed)*60> translate <0,3,37>}
}

#else

#debug "\nCurled Abdomen/Thorax\n"
#declare thoraxAbdomen = union {

#declare curlZ1 = 27.5
#declare curlY1 = -0.2
#declare curlZ2 = curlZ1 - cos(radians(curlAngle))*5
#declare curlY2 = curlY1 - sin(radians(curlAngle))*5
	cone {<0,curlY2,curlZ2>,1.7,<0,curlY1,curlZ1>,2.1 scale <0.8,1,1>
					texture{abTex scale <1,1,5>  rotate <-curlAngle,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.7 scale <0.8,1,1> texture{bodyTex}}

#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*2))*4
#declare curlY2 = curlY1 - sin(radians(curlAngle*2))*4
	cone {<0,curlY2,curlZ2>,1.2,<0,curlY1,curlZ1>,1.6 scale <0.8,1,1> texture{abTex
							scale <1,1,4> rotate <-curlAngle*2,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.2 scale <0.8,1,1> texture{bodyTex}}

#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*3))*4.5
#declare curlY2 = curlY1 - sin(radians(curlAngle*3))*4.5
	cone {<0,curlY2,curlZ2>,1.3,<0,curlY1,curlZ1>,1.1 scale <1.1,1,1> texture{abTex
							scale <1,1,4.5> rotate <-curlAngle*3,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.1 scale <1.1,1,1> texture{bodyTex}}

#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*4))*4
#declare curlY2 = curlY1 - sin(radians(curlAngle*4))*4
	cone {<0,curlY2,curlZ2>,1.25,<0,curlY1,curlZ1>,1.2 scale <1.15,1,1> texture{abTex
							scale <1,1,4> rotate <-curlAngle*4,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.2 scale <1.15,1,1> texture{bodyTex}}


#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*5))*4
#declare curlY2 = curlY1 - sin(radians(curlAngle*5))*4
	cone {<0,curlY2,curlZ2>,1.25,<0,curlY1,curlZ1>,1.1 scale <1.1,1,1> texture{abTex
							scale <1,1,4> rotate <-curlAngle*5,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.1 scale <1.1,1,1> texture{bodyTex}}


#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*6))*4
#declare curlY2 = curlY1 - sin(radians(curlAngle*6))*4
	cone {<0,curlY2,curlZ2>,1.25,<0,curlY1,curlZ1>,1.1 scale <1.05,1,1> texture{abTex
							scale <1,1,4> rotate <-curlAngle*6,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,1.1 scale <1.05,1,1> texture{bodyTex}}
						

#declare curlZ1 = curlZ2
#declare curlY1 = curlY2						
#declare curlZ2 = curlZ1 - cos(radians(curlAngle*7))*2
#declare curlY2 = curlY1 - sin(radians(curlAngle*7))*2
	cone {<0,curlY2,curlZ2>,1,<0,curlY1,curlZ1>,0.9 texture{abTex
							scale <1,1,2> rotate <-curlAngle*7,0,0> translate <0,curlY2,curlZ2>}}
	sphere{<0,curlY2,curlZ2>,0.9 texture{bodyTex}}
 							
	union {
		cone {<-0.5,0,-3>,0.2,<-0.5,0,-1>,0.5}
		cone {<0.5,0,-3>,0.2,<0.5,0,-1>,0.5}
		sphere {<0,-0.5,0>,1 scale <1,1,2>}
		rotate <-curlAngle*8,0,0>
		translate <0,curlY2,curlZ2>
		 texture{abTex rotate <-curlAngle*8,0,0> translate <0,curlY2,curlZ2>}}


	cone {<0,-0.2,27>,2.1,<0,1.2,30.5>,2 scale <0.9,1,1>
					texture{abTex scale <1,1,5> translate <0,0,26>}
					texture{bodyTex}}
	union{
		cone {<0,1.2,30.5>,2,<0,3.5,36.25>,2.25}
		sphere {<0,1.5,34.25>,2.5}
		sphere {<0,2,34.25>,2.5}
		sphere {<0,0,0>,3 scale <0.75,1,1> translate <0.3,2.25,35.25>}
		sphere {<0,0,0>,3 scale <0.75,1,1> translate <-0.3,2.25,35.25>}
		texture{abTex scale <1,1,7> translate <0,0,30>}
		texture{bodyTex}
		}
	object {hindLeg
		rotate <-30+rand(dragonflySeed)*60,0,0>
		translate <1.15,-1,32>}
	object {hindLeg
		rotate <-30+rand(dragonflySeed)*60,0,0>
		scale <-1,1,1> translate <-1.15,-1,32>}
	object {midLeg
		rotate <-30+rand(dragonflySeed)*60,0,-30+rand(dragonflySeed)*60>
		translate <2,0,36>}
	object {midLeg
		rotate <-30+rand(dragonflySeed)*60,0,-30+rand(dragonflySeed)*60>
		scale <-1,1,1> translate <-2,0,36>}
	object {frontLeg translate <0,0,38>}
	object {frontLeg scale <-1,1,1> translate <0,0,38>}
	object {head rotate <0,0,-30+rand(dragonflySeed)*60> translate <0,3,37>}
}

#end


union {
	object{ thoraxAbdomen }
	object{ wings }
	#ifdef (dfScale)
		scale dfScale
	#end
	#ifdef (dfXlate)
		translate dfXlate
	#end
}
