#ifndef (SnakeIsDeclared)
#declare SnakeIsDeclared=true

#include "colors.inc"

#ifndef (TextSnake)
#declare TextSnake=texture {
   pigment {
      leopard
      color_map {
	 [0   rgb <0,0.75,0>]
	 [0.5 rgb <0,0.5,0>]
	 [1   rgb <0,1,0> ]
      } 
   }
   
   finish {
      phong 1.5
   }
   
   normal {
      quilted   1.5
      control0 0.33
      control1 0
   }
  
   scale 0.05
}
#end

#ifndef (TextSnakeHead1)
#declare TextSnakeHead1=texture {
   pigment { rgb <0,0.75,0> }
   
   finish {
      phong 1.5
   }
   
   normal {
      quilted   1.5
      control0 0.33
      control1 0
   }
  
   scale 0.05
}   
#end

#ifndef (TextSnakeHead2)
#declare TextSnakeHead2=texture {
   pigment { rgb <1,1,0> }
   
   finish {
      phong 1.5
   }
   
   scale 0.05
}   

#end

#ifndef (TextSnakeHead3)
#declare TextSnakeHead3=texture {
   pigment { rgb <0.6,0.3,0> }
   
   finish {
      phong 1.5
   }
   
   normal { granite 1}
   
   scale 0.05
}   
#end


#ifndef (TextSnakeEyes)
#declare TextSnakeEyes=texture {
   pigment { Black }
   finish {
      phong 1.5
      reflection 0.2
      ambient 0
      diffuse 0.1
   }
}
#end

#ifndef (TextSnakeHead)
#declare TextSnakeHead=texture {
   gradient x
   texture_map {
      [0   TextSnake scale <3,1,1>]
      [0.7 TextSnakeHead1]
      [0.9 TextSnakeHead2]
      [1   TextSnakeHead3]
   }
   turbulence <0.1,0,0>
   scale 2
   translate -x*1
}
#end   

#ifndef (TextSnakeTong)
#declare TextSnakeTong=texture {
   pigment { rgb <1,0.3,0.2> }
   finish { phong 1.0 
      ambient 1
      diffuse 1
      reflection 0.0
   }
}
#end   

#declare SnakeBody=isosurface {
   function {
      "Snake",
//      <4, 0.2, 0.7, 0, 0, 0.3, 0.1, -0.5, -1.5, -1, 0, 1>,
       <4, 0.2, 0.3, 0, 0, 0.3, 0.1, -4, -1.5, -1, 0, 1>,
     library "fonc.so"
   }
   max_gradient 5
   eval
   scale <3,1,1>
   texture { TextSnake }
   rotate x*90
}

#declare SnakeTong=union {
   isosurface {
      box <-1,-1,-1>, <0.5,1,1>
      function {
	 "Snake",
	 <2, 0, 0.2, 0, 0.1, 0.033, 0.033, 0, 0, -1, -0.25, 0>
	 library "fonc.so"
      }
      max_gradient 5
      eval
      rotate x*20
   }

   isosurface {
      box <-0.5,-1,-1>, <0.7,1,1>
      function {
	 "Snake",
	 <0.5, 0, 0.2, 0.2, 0.033, 0.033, 0, 0, 0, 0, 0.25, 0.7>
	 library "fonc.so"
      }
      max_gradient 5
      eval
   }
  
    isosurface {
       box <-0.5,-1,-1>, <0.5,1,1>
       function {
	 "Snake",
	 <-0.75, 0, 0.2, 0.2, 0.033, 0.033, 0, 0, 0, 0, 0.25, 0.5>
	 library "fonc.so"
      }
       max_gradient 5
       eval
  }  

   translate <1,0,0>
//   scale 0.5
   translate <3.4,0,0>
   texture { TextSnakeTong }
}
   


#declare SnakeHead=union{
   intersection {
      isosurface {
	 function {
	    "Heart",
	    <-0.5, 0>,
	    library "fonc.so"
	 }
	 max_gradient 2
	 eval
      }
      
      sphere { <0,0,0> , 1 scale <1,1,0.75> }
      
      
      rotate x*90
      rotate y*180
      
      texture { TextSnakeHead }
      
      scale <2,1,1>*0.25
      translate <3,0,0>
   }
   
   sphere { <0,0,0>, 1
      texture { TextSnakeEyes }
      scale <1,0.5,0.25>*0.5
      rotate x*10
      rotate -z*10
      scale 0.2
      translate <3.05,0.1,-0.25>
   }
   
   sphere { <0,0,0>, 1
      texture { TextSnakeEyes }
      scale <1,0.5,0.25>*0.5
      rotate -x*10
      rotate -z*10
      scale 0.2
      translate <3.05,0.1,0.25>
   }

} 


#declare Snake=union {
   object { SnakeBody }
   object { SnakeHead }
//   object { SnakeTong }
}
  
      
      
#end
