// Plugin to create an ellipsoid between two points.
//
//  Author:  warwick@troll.no (Warwick Allison)
//
//  Input:
//    EL_FROM   =  One end of the ellipsoid
//    EL_TO     =  The other end of the ellipsoid
//    EL_RADIUS =  The radius of the ellipsoid perpendicular to the axis
//
//  Uses:
//    EL_DIFF
//
//  Range:
//    EL_FROM should be different from EL_TO
//

sphere {
    0,1
    translate x
    scale <vlength(EL_TO-EL_FROM)/2,EL_RADIUS,EL_RADIUS>

    #declare EL_DIFF=(EL_TO-EL_FROM)
    rotate z*degrees(atan2(EL_DIFF.y,sqrt(EL_DIFF.x*EL_DIFF.x
                                         +EL_DIFF.z*EL_DIFF.z)))
    rotate y*-degrees(atan2(EL_DIFF.z,EL_DIFF.x))
    translate EL_FROM
}
