
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: FEMALE HEAD
// Date: v1 07.06.97
// Auth: NB

/*
#include "metals.inc"
#declare E_R00=0
background {color rgb <.8,.9,1>}

light_source {<-500,500,500>
color rgb <1,1,1>}

camera{
//location<-35,0,0>
//location<0,0,-35>
//location<0,20,0>
location<-25,0,15>*1.2
angle 15
look_at <0,0,0>}

#declare SK_TEX =
texture{
   finish{
   diffuse .4
      ambient <1,.85,.7>*.7
      phong 0.2
      phong_size 20
   }
  normal {bumps .2 scale.005}
   pigment{color rgb <1,.85,.7>}
}
*/

#declare EY_TEX =
texture{
   finish{
   diffuse .9
   specular .9
   roughness .001
   ambient <1,.97,.97>*.7
   reflection .3
   }
   pigment{color rgb <1.0,.00,.00>}
}

#declare HA1_TEX =
texture{
   finish{
   diffuse .9
   phong 0.2
   phong_size 20
   ambient <0.3,0.2,.1>*2
   }
   normal{bumps .5 scale<.1,100,.1>}
   pigment{color rgb <.95,0.9,.8>}
}
#declare HA2_TEX =
texture{
   finish{
   diffuse .6
   phong 0.4
   phong_size 100
   ambient <0.3,0.2,.1>*1.5
   }
   pigment { spiral1 90 ramp_wave
       turbulence <0, 0, .1>
          octaves 3
          lambda 10
          omega 4
          color_map {
          [0.0, 0.5  color rgbf <.95,0.9,.8,1>
                      color rgbf <.95,0.9,.8,.7>]
          [0.5, 1.0  color rgbf <.95,0.9,.8,.7>
                      color rgbf <.95,0.9,.8,1>]}
   rotate x*90
   scale 50}
}

//pigment{color rgb <0,.85,.7>}
#declare HR_01 = .65
#declare HS_01 = 3
#declare HD_01 = HS_01*pow((1-pow(HR_01,2)),2)

#declare HEAD01=
blob{ threshold HD_01

//part 01 - cranium
   cylinder{<0,0,.5><0,0,-.5>,1,HS_01 // frontal
      scale <1.5/HR_01,1.2/HR_01,.85/HR_01>
      translate y*.8
    }
   cylinder{<.9,0,0><-.9,0,0>,1,HS_01 // crown
      scale <.7/HR_01,1.3/HR_01,.8/HR_01>
      rotate z*-40
      translate <0.5,.8,0>
    }
   sphere{0,1,HS_01 // rear
      scale <1.2/HR_01,1.1/HR_01,1.1/HR_01>
      translate <.8,-.3,0>
    }

//part 02 - temple
   cylinder{<0,0,.49><0,0,-.49>,1,HS_01
      scale <.55/HR_01,.75/HR_01,.67/HR_01>
      rotate z*30 translate <-.75,-.3,0>
    }

//part 03 - cheek
   cylinder{<0,0,.49><0,0,-.49>,1,HS_01
      scale <.75/HR_01,.5/HR_01,.68/HR_01>
      translate <-.9,-.95,0>
    }
   cylinder{<0,0,.48><0,0,-.48>,1,HS_01
      scale <.5/HR_01,.5/HR_01,.64/HR_01>
      translate <-.5,-1.45,0>
    }
   sphere{0,1,HS_01
      scale <.4/HR_01,.5/HR_01,.61/HR_01>
      translate <-1.2,-1.6,0>
    }

//part 04 - lips
   sphere{0,1,HS_01
      scale <.3/HR_01,.15/HR_01,.37/HR_01>
      rotate z*-15
      translate <-1.57,-1.5,0>
         //texture {SK_TEX} pigment{color rgb <1,.85,.7>*<.92,.75,.7>}
    }
   sphere{0,1,HS_01
      scale <.3/HR_01,.175/HR_01,.355/HR_01>
      rotate z*7
      translate <-1.52,-1.7,0>
         //texture {SK_TEX} pigment{color rgb <1,.85,.7>*<.92,.75,.7>}
    }

//part05 - chin
   cylinder{<1,0,0><0,0,0>,1,HS_01
      scale <.5/HR_01,.4/HR_01,.48/HR_01>
      rotate y*10
      rotate z*17
      translate <-1.19,-1.97,-.15>
    }
   cylinder{<1,0,0><0,0,0>,1,HS_01
      scale <.5/HR_01,.4/HR_01,.48/HR_01>
      rotate y*-10
      rotate z*17
      translate <-1.19,-1.97,.15>
    }

//part06 - lower jaw
   cylinder{<0,0,0><0,1,0>,1,HS_01
      scale <.9/HR_01,.5/HR_01,.75/HR_01>
      rotate <-7,0,-10>
      translate<-.6,-1.6,-.31>
    }
   cylinder{<0,0,0><0,1,0>,1,HS_01
      scale <.9/HR_01,.5/HR_01,.75/HR_01>
      rotate <7,0,-10>
      translate<-.6,-1.6,.31>
    }

//part071 - nose bridge
   cylinder{<0,0,0><0,.85,0>,1,HS_01
      scale <.30/HR_01,.5/HR_01,.165/HR_01>
      translate <0,0.3,0>
      rotate z*-47
      translate<-2.1,-.90,0>
    }
//part072 - nostrils
   sphere{0,1,HS_01
      scale <.25/HR_01,.13/HR_01,.1/HR_01>*.72
      rotate <0,27,-19>
      translate<-1.82,-.92,-.25>
    }
   sphere{0,1,HS_01
      scale <.25/HR_01,.13/HR_01,.1/HR_01>*.72
      rotate <0,-27,-19>
      translate<-1.82,-.92,.25>
    }
//part073 nose tip
   sphere{0,1,HS_01
      scale <.26/HR_01,.15/HR_01,.25/HR_01>
      rotate <0,0,-2>
      translate<-1.9,-.92,0>
    }
//part074 upper lip
   sphere{0,1,HS_01
      scale <.2/HR_01,.25/HR_01,.3/HR_01>
      rotate z*-20
      translate<-1.6,-1.3,0>
    }

//part08 eye sockets
    // right
   sphere{0,1,-2
      scale <.4/HR_01,.27/HR_01,.45/HR_01>
      rotate <5,-18,0>
      translate<-1.5,-.3,.76>
    }
   sphere{0,0.7,4
      scale <.4/HR_01,.29/HR_01,.48/HR_01>
      rotate <5,-18,0>
      translate<-1.5,-.3,.68>
    }
   sphere{0,0.5,-5
      scale <.4/HR_01,.22/HR_01,.40/HR_01> // Open/close eys using Y scale
      rotate <5,-18,0>
      translate<-1.5,-.32,.60>
      texture {
	 SK_TEX
	 pigment{color rgb <1.0,.0,.0>}
      }
    }

    // left
   sphere{0,1,-2
      scale <.4/HR_01,.27/HR_01,.45/HR_01>
      rotate <5,18,0>
      translate<-1.5,-.3,-.76>
    }
   sphere{0,0.7,4
      scale <.4/HR_01,.29/HR_01,.48/HR_01>
      rotate <5,18,0>
      translate<-1.5,-.3,-.68>
    }
   sphere{0,0.5,-5
      scale <.4/HR_01,.22/HR_01,.40/HR_01> // Open/close eys using Y scale
      rotate <5,18,0>
      translate<-1.5,-.32,-.60>
      texture {
	 SK_TEX
	 pigment{color rgb <1.0,.0,.0>}
      }
    }

//part09 neck
   cylinder{<0,0,0><0,-1.8,0>,1,HS_01
      scale <.9/HR_01,1,.8/HR_01>
      rotate z*7
      translate <.3,-1.5,0>
    }
sturm
texture {SK_TEX}}

#declare EyeBallTexture =
    texture {
        pigment {
            radial
            frequency 10
            turbulence 1
            colour_map {
                [0.0, 0.9 colour White colour White ]
                [0.9, 1.0 colour White colour Red ]
            }
            rotate z*90
	    scale 0.3
        }
	finish { Glossy }
    }

#declare IrisTexture =
    texture {
        pigment {
            radial
            frequency 25
            turbulence 0.2
            colour_map {
                [0.0 colour rgb<0.6,0.6,0> ]
                [0.5 colour rgb<0,1,0> ]
                [1.0 colour rgb<0.6,0.6,0> ]
            }
            rotate z*90
        }
	finish { Glossy }
    }

#declare L_EYE=
  sphere {
    <0,0,0>, 1
    texture {
	gradient x
	texture_map {
	   [ 0 EyeBallTexture ]
	   [ 0.9 EyeBallTexture ]
	   [ 0.9 IrisTexture ]
	   [ 0.98 IrisTexture ]
	   [ 0.98 pigment { colour Clear } finish { Glossy } ]
	   [ 1.0 pigment { colour Clear } finish { Glossy } ]
	}
    }
    scale 0.29
    translate<-1.24,-.30,-.57>
  }

#declare R_EYE=
    object {
	L_EYE
	scale <1,1,-1>
    }

#declare E_Rr01=.7
#declare E_Rr02=.05
#declare EAR_RING01=
union{
torus{E_Rr01,E_Rr02 rotate x*90 translate<0.1,-.9-E_Rr01,1.5> texture{T_Chrome_4D}}
torus{E_Rr01,E_Rr02 rotate x*90 translate<0.1,-.9-E_Rr01,-1.5> texture{T_Chrome_4D}}
}

#declare HEAD02f=
union{
   object{HEAD01}

   object{L_EYE}
   object{R_EYE}
   
   blob{ // ear
   sphere{0,1,HS_01
      scale <.2/HR_01,0.95/HR_01,.4/HR_01>
      rotate <-14,-60,-5>
      translate<0.2,-.44,-1.5>
    }
   sphere{0,1,-4
      scale <.5/HR_01,0.92/HR_01,.35/HR_01>*.6
      rotate <-14,-60,-8>
      translate<0.1,-.35,-1.7>
    }

   sphere{0,1,HS_01
      scale <.2/HR_01,0.95/HR_01,.4/HR_01>
      rotate <14,60,-5>
      translate<0.2,-.44,1.5>
    }
   sphere{0,1,-4
      scale <.5/HR_01,0.92/HR_01,.35/HR_01>*.6
      rotate <14,60,-8>
      translate<0.1,-.35,1.7>
    }

   cylinder{<0,0,1><0,0,-1>,1,HS_01
      scale <.2/HR_01,.25/HR_01,.65/HR_01>
      translate<0,-.44,0>
    }
   scale<.95,.95,1>
   texture {SK_TEX}}
   
   #if (E_R00=1)
   object{EAR_RING01}
   #else
   #end
}


#declare HAIR01=
blob{ threshold HD_01
   #declare Nhf=6
   #while (Nhf>0)
      sphere{0,1,HS_01
         scale <2.2/HR_01,1.3/HR_01,1.5/HR_01>*(1+.05*Nhf)
         translate y*-1.2*Nhf}
   #declare Nhf=Nhf-1
   #end
   cylinder{<0,0,0><0,-2,0>,1,-3
      scale <2.2/HR_01,2,1.5/HR_01>
      translate <-1,-2.7,.1>}
   cylinder{<0,0,0><0,-2,0>,1,-1
      scale <2.2/HR_01,2,.7/HR_01>
      translate <-1,-1.8,.5>}
   cylinder{<0,0,0><0,-2,0>,1,-3
      scale <2.5/HR_01,3,1.5/HR_01>
      translate <-2,-4,0>}
   cylinder{<0,0,0><0,-2,0>,1,-3
      scale <2.5/HR_01,3,1.8/HR_01>
      translate <-1.8,-6,0>}
rotate z*5
translate <-.2,2.2,0>
scale<.9,1,1>
texture {HA1_TEX}
texture {HA2_TEX}}

//object{HEAD02f}
//object{HAIR01}
