#declare moonlight = true
#declare show_stars = true
#declare show_trees = true
#declare show_ground_fog = false // don't use this one...
#declare show_real_fog = true   // use this one!
#declare show_flashlight = true
#declare show_grass = true

#declare ft=12
#declare mi=5280*ft

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "maglight.inc"
#include "torch.inc"
#include "helm2.inc"
#include "torso2.inc"
#include "curvhand.inc"
#include "botleg.inc"
#include "topleg.inc"
#include "boot.inc"

global_settings
    {
    max_trace_level 100 // make sure the ray makes it all the way through all the trees
    }

// locations of guys
#declare first_guy = <0,0,0>
#declare second_guy = <-4*ft,4*ft,0>
#declare third_guy = <-4*ft,-5*ft,0>

// set viewer's position in the scene
camera
    {
    location  <-14*ft, -2*ft, 6*ft> // position of camera <X Y Z>
    direction z                 // which way are we looking <X Y Z> & zoom
    sky       z                // rarely used
    up        z                // which way is +up <X Y Z>
    right     4/3*x            // which way is +right <X Y Z> and aspect ratio
    look_at first_guy+z*5*ft
    }

#if (moonlight)
light_source
{
  z*1e3
  color 0.25
//  area_light <20,0,0><0,20,0> 4 4 // 20 20
  rotate <3,5,0>
}
#end

#if (show_grass)
// our floor - real short height field with a starfield pattern from fractint!
#include "grass.inc"
#else
plane { z, 0 pigment{color Green} }
#end

#if (show_stars)
#include "starfld.inc"
#else
background { color rgb<0,0,.25> }
#end


// helmet


// Vertical strap reinforcing - It's brass
// It's rivited with steel rivets, made from spheres of
//   which you can only see half...
#declare brass_strap = union
    {
    box
        {
        y*-.5, <.125,.5,9>
        texture { T_Brass_4C }
        finish { reflection 0.2 }
        }
#declare i = .5
#while (i < 6)
    sphere { z*i .125 texture { T_Chrome_2A } finish { reflection 0.2 } }
#declare i = i+1
#end
    }


// The helmet shape is two cones, each rotated to create a flat back of the head,
//   each intersected with planes to keep the top and bottom of each cone parallel
//   to the z plane.  The 'plane' vector points toward the 'outside' of the plane,
//   so they seem (to me anyway) to be upside down.  I know it's wierd to use a plane
//   in a CSG intersection, but it's REAL useful!
// We also add some embellishment/reinforcing using brass strapping and steel rivets
#declare helmet_shape = union
    {
    intersection
        {
        cone // top
            {
            z*7,  4,
            z*-2, 6
            rotate y*9
            translate z*6
            }
        plane {  z 0 translate z*12 }
        plane { -z 0 translate z*6 }
        }
    intersection
        {
        cone // bottom
            {
            z*12 6
            z*-1 5
            rotate y*-9
            }
        plane {  z 0 translate z*6 }
        plane { -z 0 }
        translate x*1
        }
    // brass_strap nose reinforcing
    //  I'm going to clip this with the same planes as the
    //  top cone to insure it dosen't extend beyond the cone.
    intersection
        {
        object
            {
            brass_strap
            rotate y*21
            translate <-5.9,0,6>
            }
        plane {  z 0 translate z*12 }
        plane { -z 0 translate z*6 }
        }

    // brass_strap (bottom) reinforcing
    //  I'm going to clip this with the same planes as the
    //  bottom cone to insure it dosen't extend beyond the cone.
    intersection
        {
        object
            {
            brass_strap
            rotate y*-14
            translate <-4.4,0,0>
            }
        plane {  z 0 translate z*6 }
        plane { -z 0 }
        }

    texture{ T_Chrome_2A  normal { dents 0.5 scale 0.5 } }
    finish { reflection 0.2 }
    }

// A complete helmet is the basic shape with cutouts for eyes and
//   breathing holes
#declare helmet = difference
     {
     object {helmet_shape}
     // eye slits
     box{ <-12,1,8> <0,4,8.5> }
     box{ <-12,-1,8> <0,-4,8.5> }
     // breathing holes
     cylinder { <-12,-1,2><0,-1,2> .15 }
     cylinder { <-12,-2,2><0,-2,2> .15 }
     cylinder { <-12,-3,2><0,-3,2> .15 }
     cylinder { <-12,-1,1><0,-1,1> .15 }
     cylinder { <-12,-2,1><0,-2,1> .15 }
     cylinder { <-12,-3,1><0,-3,1> .15 }
     cylinder { <-12,1,2><0,1,2> .15 }
     cylinder { <-12,2,2><0,2,2> .15 }
     cylinder { <-12,3,2><0,3,2> .15 }
     cylinder { <-12,1,1><0,1,1> .15 }
     cylinder { <-12,2,1><0,2,1> .15 }
     cylinder { <-12,3,1><0,3,1> .15 }
     }

// Breast Plate

#declare breastplate_shape = intersection
    {
    sphere { <ft,-ft,0> 3*ft } // left side
    sphere { <ft, ft,0> 3*ft } // right side
    sphere { <-4*ft,0,0> 5.5*ft } // back
    sphere { z*-7.5*ft, 6*ft inverse } // bottom
    sphere { z*3.5*ft, 2*ft inverse } // top
    texture{ T_Chrome_2A  normal { dents 0.5 scale 0.5 } }
    finish { reflection 0.2 ambient 0.5}
    }

#declare breastplate = object
    {
    breastplate_shape
    scale <0.4,0.4,0.6>
    }

#declare right_arm_blob = blob
    {
    threshold 0.2
    cylinder { <0, 0, 0><-14,0,-12> 3 1.0 }
    cylinder { <-14,0,-12><-28,0,-3> 3 1.0 }
    texture{ T_Chrome_2A  normal { dents 0.5 scale 0.5 } }
    finish { reflection 0.2 ambient 0.5}
    }
#declare left_arm_blob = blob
    {
    threshold 0.2
    cylinder { <0, 0, 0><-14,0,-12> 3 1.0 }
    cylinder { <-14,0,-12><-16,0,-15> 3 1.0 }
    texture{ T_Chrome_2A  normal { dents 0.5 scale 0.5 } }
    finish { reflection 0.2 ambient 0.5}
    }

// this is my ground fog...not fog at all, really a halo...
// the trees make this do something funny, like you can't see the halo
//     past the clear portions of the tree boxes...use 'show_real_fog' (below)
#if (show_ground_fog)
box
    {
    -1, 1
    hollow
    texture
        {
        pigment{ color Clear }
        halo
            {
            dust
            dust_type 1
            linear
            planar_mapping
            colour_map
                {
                [ 0 rgbt<1, 1, 1, 0.5>]
                [ 0.5 rgbt<1, 1, 1, -0.5>]
                [ 1 rgbt<1, 1, 1, 0.5>]
                }
            samples 25
            jitter 0.5
            turbulence 1
            }
        }
    rotate x*90
    scale <200*ft,200*ft,5*ft>
    }
#end // #if (show_ground_fog)

#if (show_real_fog)
fog{
    color Gray70
    fog_type 2
    fog_alt 5*ft
    fog_offset 0
    distance 50*ft
    turbulence <.15, .15, .15>
    omega 0.35
    lambda 1.25
    octaves 5
    up z
}
#end

#if (show_trees)
// Trees
#include "tree04.inc"
#include "tree05.inc"
#include "tree10.inc"
#include "tree11.inc"

#declare R1=seed(617)//636
#declare R2=seed(57)
#declare R3=seed(17383)
#declare i = 1
#while ( i <= 25 )
  object { tree04 scale (40+rand(R1)*10)*ft translate x*(20+rand(R1)*85+i*3)*ft+z*rand(R1)*-10*ft rotate z*(rand(R1)*360-20) finish{ambient rand(R2)/4}}
  object { tree05 scale (25+rand(R3)*10)*ft translate x*(10+rand(R3)*65+i*3)*ft+z*rand(R3)*-10*ft rotate z*(rand(R1)*360-20) finish{ambient rand(R3)/4}}
  object { tree10 scale (50+rand(R1)*10)*ft translate x*(20+rand(R1)*75+i*3)*ft+z*rand(R1)*-10*ft rotate z*(rand(R1)*360-20) finish{ambient rand(R2)/4}}
  object { tree11 scale (20+rand(R1)*30)*ft translate x*(20+rand(R1)*75+i*3)*ft+z*rand(R1)*-10*ft rotate z*(rand(R1)*360-20) finish{ambient rand(R2)/4}}
  #declare i = i+1
#end // while i
#end // if (show_trees)

// first guy
object { helmet translate first_guy+z*5*ft }
object { breastplate translate first_guy+z*3.85*ft}

object { top_leg    rotate x*90 rotate z*10 translate first_guy+<2,-5,1.5*ft> }
object { top_leg    rotate x*90 rotate z*-10 translate first_guy+<2, 5,1.5*ft> }
object { bottom_leg rotate x*90 rotate z*10 translate first_guy+<2,-5,1.5*ft> }
object { bottom_leg rotate x*90 rotate z*-10 translate first_guy+<2, 5,1.5*ft> }
object { boot       rotate x*90 rotate z*10 translate first_guy+<2,-5,1.5*ft> }
object { boot       rotate x*90 rotate z*-10 translate first_guy+<2, 5,1.5*ft> }

object { left_arm_blob rotate z*10 translate first_guy+y*-8+z*4.8*ft }
object { right_arm_blob  rotate z*-5 translate first_guy+y*+8+z*4.8*ft  }
object {curv_right_hand rotate x*90 rotate <15,35,135> translate first_guy+<-28,10,4.8*ft-3> }
object {curv_left_hand rotate x*90 rotate <175,220,180> rotate z*30 translate first_guy+<-19,-12,4.8*ft-15> }
#declare flashlight_loc = first_guy+<-40,18,4.8*ft-4>

#if (show_flashlight)
object { mag_light rotate y*72 rotate z*-35 translate flashlight_loc+<0,0,6> } // was x*-5*ft+z*4.2*ft
// this is the dust halo that shows in the flashlight beam
cylinder
    {
    0, y, 1
    hollow
    texture
        {
        pigment{ color Clear }
        halo
            {
            dust
            dust_type 1
            linear
            cylindrical_mapping
            colour_map
                {
                [ 0 rgbt<1, 1, 1, 1>]
                [ 1 rgbt<1, 1, 1, 0.5>]
                }
            samples 10
            turbulence 0
            }
        }
    rotate x*90
    scale <6,6,6*ft>
    translate z*14
    rotate y*72 rotate z*-40 translate flashlight_loc+<0,0,6> //x*-5*ft+z*4.2*ft
    }
#end // show_flashlight


// second guy
#declare second_guy_obj = union
{
object {helmet2 rotate x*90 rotate z*45 translate second_guy+z*5*ft}
// face in the helmet2
cylinder
    {
    0, y, 1
    pigment
        {
        image_map
            {
            gif "emory.gif"
            once
            map_type 2
            }
        }
    rotate x*90
    rotate z*40
    scale <4,4,12>
    translate second_guy+<0,2,4*ft+9>
    finish { ambient 0.2 }
    }

object { torso2 rotate x*90 rotate z*45 translate second_guy+z*2.5*ft }

// second guy's right hand
object {curv_right_hand rotate x*90 rotate z*180+y*75 translate second_guy+<-2*ft-2,4,4*ft+5> }
// second guy's left hand
object {curv_left_hand rotate x*90 rotate <135,90,90> rotate y*180 translate second_guy+<1*ft+3,-20,3*ft-2> }
// a torch in his right hand..
object { torch rotate z*180 translate second_guy+<-2*ft-5,3.5,4*ft+3> }
object { top_leg    rotate x*90 rotate z*45 translate second_guy+<-5,2,1.5*ft> }
object { top_leg    rotate x*90 rotate z*90 translate second_guy+< 7,2,1.5*ft> }
object { bottom_leg rotate x*90 rotate z*45 translate second_guy+<-5,2,1.5*ft> }
object { bottom_leg rotate x*90 rotate z*90 translate second_guy+< 7,2,1.5*ft> }
object { boot       rotate x*90 rotate z*45 translate second_guy+<-5,2,1.5*ft> }
object { boot       rotate x*90 rotate z*90 translate second_guy+< 7,2,1.5*ft> }
} // end second guy union

object { second_guy_obj }

// the third guy.  He's just the second guy rotated.  BUT because the object
//   is defined at the second_guy location, we have to put him back at the origin
//   BEFORE rotating him or he'll be somewhere else!  SO translate him by
//   the negative of the second_guy vector, rotate by 180 and translate him to the
//   third guy vector.  He's got a torch and everything.
object { second_guy_obj translate -1*second_guy rotate z*180 translate third_guy }
