/*
BWindow.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare BrickW = 60
#declare BrickH = 50
#declare BrickL = 120
#declare Mortar = 5

#declare WinW = 850
#declare WinH = 1100

#declare BrickH2 = BrickH+Mortar
#declare BrickW2 = BrickW+Mortar
#declare BrickL2 = BrickL+Mortar

#declare WinH2= WinH-WinW/2

#declare Brick = box {
	0,<BrickW,BrickH,BrickL>
}

#declare r1 = seed(0)

#declare BWindow = union {
	#declare total = WinH2*2+WinW*pi/2
	#declare brickCount = int(total/BrickH2)
	#declare step = total/brickCount

	#declare brickNo = 0
	#declare first = 1

	#while(brickNo<=brickCount)
		#declare i = step*brickNo
		#switch(i)
			#range(0,WinH2)
				#declare x1 = WinW/2
				#declare y1 = i
			#break
			#range(WinH2,WinH2+WinW*pi/2)
				#declare a = (i-WinH2)/(WinW*pi/2) * pi
				#declare x1 = cos(a)*WinW/2
				#declare y1 = sin(a)*WinW/2 + WinH2
			#break
			#else
				#declare x1 = -WinW/2
				#declare y1 = WinH2 - (i-(WinH2+WinW*pi/2))
			#break
		#end
		#if(!first)
			#declare rot = 180-degrees(atan2(x2-x1,y2-y1))
			object {
				Brick
				translate y*(Mortar/2) rotate z*rot translate <x2,y2>
				//pigment { color rgb <rand(r1),rand(r1),rand(r1)> }
			}
		#end
		//#render concat(str(x2,3,3),",",str(y2,3,3)," rot=",str(rot,3,3),"\n")
		#declare x2 = x1
		#declare y2 = y1
		#declare first=0
		#declare brickNo=brickNo+1
	#end

	// the sill
	#declare total = WinW+BrickW2
	#declare brickCount = int(total/BrickL2+.5)
	#declare step = total/brickCount
	#declare brickNo=0
	#while(brickNo<brickCount+1)		// one extra brick only in the back row
		// Front brick row
		#if(brickNo<brickCount)
		object {
			Brick
			rotate y*90
			translate < brickNo*step - total/2, -BrickH2, BrickL/2-Mortar/2 >
			//pigment { color rgb <rand(r1),rand(r1),rand(r1)> }
		}
		#end
		// Back brick row
		object {
			Brick
			rotate y*90
			translate < brickNo*step - total/2 - BrickL/2, -BrickH2, BrickL/2+BrickW+Mortar/2 >
			//pigment { color rgb <rand(r1),rand(r1),rand(r1)> }
		}
	#declare brickNo=brickNo+1
	#end

	texture {
		pigment { color rgb < 1.00, 0.10, 0.05 >*.8 }
		normal {
			dents 0.7
			scale 10
		}
	}
}

#declare WinHole = union {
	cylinder { 0,z*BrickL,WinW/2 translate y*(WinH-WinW/2) }
	box { 0,<WinW,WinH-WinW/2,BrickL> translate x*(-WinW/2) }
	translate y*-(WinH/2) scale 1.01 translate y*(WinH/2)
}
