#ifndef(BookT)
#declare BookT = BookW*4/50
#end
#declare BookR = BookL*.6

#declare BookCyl = cylinder { 0,y*BookH,BookR translate < BookR-BookL,0,BookW/2 > }
#declare BookCyl2= cylinder { y*-1,y*(BookH+1),BookR translate < BookR-BookL,0,BookW/2 > }

#declare r = BookT/2
#declare hej = union {
	box { <-BookL+r, r, 0>, <-r,BookH-r,BookT> }
	cylinder { <-r,r,r>,<-r,BookH-r,r>,r }
	cylinder { <-r,r,r>,<-BookL+r,r,r>,r }
	cylinder { <-r,BookH-r,r>,<-BookL+r,BookH-r,r>,r }
	sphere { <-r,r,r>,r }
	sphere { <-r,BookH-r,r>,r }
}

#declare Book = union {
#if(1)
	union {
		intersection {
			union {
//				box { <-BookL, 0, 0>, <0,BookH,BookT> }	// front
//				box { <-BookL, 0, BookW-BookT>, <0,BookH,BookW> }	// back
				object { hej }
				object { hej translate z*(BookW-BookT) }
			}
			object { BookCyl2 }
		}
		intersection {
			object { BookCyl2 }
			object { BookCyl2 translate x*BookT inverse }
			box { <-BookL, 0, 0>,<0,BookH,BookW> }
		}
		texture { T_Book }
	}
	intersection {
		box { <-BookL, BookT, BookT>,<0,BookH-BookT,BookW-BookT> }
		object { BookCyl2 translate x*BookT}
		object { BookCyl2 translate x*(BookL-BookT*2) inverse }
		pigment {
			gradient z
			triangle_wave
			color_map {
				[ 0.0 color White*0.7 ]
				[ 1.0 color White*1.0 ]
			}
			frequency 5
		}
	}
#end
#ifdef(BookTitle)
#if(strlen(BookTitle)>0)
	intersection {
		text {
			ttf "cyrvetic.ttf",BookTitle,1,0
			translate <0,-.3,-.5>
			scale <BookW*.6,BookW*.6,BookL/2>
			rotate z*-90
			rotate y*90
			translate x*-BookL
			translate y*BookH
			translate z*BookW/2
		}
		object { BookCyl translate x*-.001 }
		texture { T_Title }
	}
#end	// strlen
#end	// BookTitle
}
