/*
CBall.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare P_Image = pigment {
	image_map {
		tga "c:\bilder\pov\tower.tga"
	}
	translate -.5
	scale 2
}

#declare T_Base1 = texture {
	pigment { color rgb < 0.08, 0.05, 0.10 > }
	finish {
		ambient 0.30
		brilliance 3
		diffuse 0.4
		metallic
		specular 0.70
		roughness 1/60
		reflection 0.25
	}
}

#declare T_Base2 = texture {
	T_Base1
/*	T_Wood4
	finish {
		//reflection 0.1
		specular .7
		roughness 0.05
	}
	rotate x*80
	translate < 20, 10, 5 >
	scale 500*/
}

#declare lw = 1.5
#declare lr = 5
#declare Leg = union {
	intersection {
		torus { lr,lw rotate x*90 }
		union {
			plane { -x,0 }
			plane { -x,0 rotate z*-30 }
		}
		plane { y,0 }
	}
	sphere {
		<0,-lr>,lw
		rotate z*-30
	}
	cylinder {
		<lr,0>,<lr,30>,lw
	}
	rotate z*-20
	translate y*(lr+(lw/2))
	texture { T_Base1 }
}

#declare CBall = union {
	sphere {
		0,1
		hollow
		texture {
			pigment { color rgbf < 1,1,1,1 > }
			finish {
				specular 0.7
				roughness 0.002
				reflection 0.1
				refraction on
				ior 1.5
			}
		}
#if(do_halos)
		halo {				// smoke halo
			attenuating
			spherical_mapping
			linear
			color_map {
				[ 0.00 color rgbt <1.00, 1.00, 1.00, 1.00> ]
				[ 0.10 color rgbt <1.00, 1.00, 1.00, 0.55> ]
				[ 0.20 color rgbt <1.00, 1.00, 1.00, 0.15> ]
				[ 0.30 color rgbt <1.00, 1.00, 1.00, 0.60> ]
				[ 1.00 color rgbt <1.00, 1.00, 1.00, 1.00> ]
			}
			turbulence 1
			samples 10
		}
    halo {				// overall fog
			attenuating
			spherical_mapping
			linear
			color_map {
				[ 0.00 color rgbt <1.00, 1.00, 1.00, 0.20> ]
				[ 0.20 color rgbt <1.00, 1.00, 1.00, 0.60> ]
				[ 1.00 color rgbt <1.00, 1.00, 1.00, 1.00> ]
			}
			turbulence 0.2
			samples 10
		}
/*    halo {				// background fog
			attenuating
			planar_mapping
			linear
			color_map {
				[ 0.00 color rgbt <1.00, 1.00, 1.00, 1.00> ]
				[ 0.20 color rgbt <1.00, 1.00, 1.00, 0.90> ]
				[ 1.00 color rgbt <1.00, 1.00, 1.00, 0.40> ]
			}
			scale 2
			rotate x*-90
			translate y*-1
			turbulence 0.2
			samples 10
		}*/
#end
		scale 75
	}
	disc {
		0,z,75
		texture {
			pigment {
				wood
				ramp_wave
				pigment_map {
					[ 0.0 P_Image ]
					[ 0.6 P_Image ]
					[ 0.9 P_Image transmit 0.5 ]
					[ 1.0 rgbt <1,1,1,1> ]
				}
			}
			finish {
				ambient 1
				diffuse 0
			}
			scale 75
		}
	}
	intersection {
		sphere { 0,75.001 }
		sphere { 0,75 inverse }
		plane { y,-50 }
		texture {
			pigment { color Black }
			finish {
				diffuse 0
				ambient 1
			}
		}
	}
	intersection {				// base
		//cone { 0, 40, y*-55, 60 }
		cylinder { y*-55,y*-50,60 }
		sphere { 0,75 inverse }
		//cylinder { y*-56,y*-40,45 inverse }
		texture {
			T_Base2
		}
	}
	object { Leg translate <-70,-85> rotate y*-0}
	object { Leg translate <-70,-85> rotate y*-(0+120)}
	object { Leg translate <-70,-85> rotate y*-(0+240)}
	translate y*85
}
