/*
Compass.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare r6 = 2			// radius of small balls
#declare rt = 2			// minor radius of rings
#declare r1 = 95
#declare r2 = 85
#declare r3 = r2-2*r6-rt
#declare r4 = r3-2*r6-2*rt
#declare r5 = 8			// radius of lower ball
#declare t1 = 2.5		// half the thickness of the frame

//#debug concat("r4 = ",str(r4,5,2),"\n")

#declare T_Compass1 = texture {
	T_Brass_2B
	//pigment { color Red }
}

#declare T_Compass3 = texture {
	//T_Compass1
	pigment { color Black }
	//normal { bumps 1 }
}

#declare T_Compass2 = texture {
	radial
	frequency 24
	texture_map {
		[ 0.03 T_Compass3 ]
		[ 0.03 T_Compass1 ]
	}
	rotate x*90
}

#declare T_Frame = texture {
	//T_Compass1
	wood ramp_wave
	texture_map {
		[(r2/r1)+.01      T_Compass1 ]
		[(r2/r1)+.01      T_Compass2 ]
		[(r2*.3+r1*.7)/r1 T_Compass2 ]
		[(r2*.3+r1*.7)/r1 T_Compass1 ]
	}
	scale r1
}

#declare T_Rose1 = texture {
	T_Wood34
	scale 100
}

#declare T_Rose2 = texture {
	pigment { rgbf <1.0,0.1,0.0,0.7> }
//	scale 100
}

#declare Arrow = intersection {
	prism {
		linear_sweep
		linear_spline
		0,3,
		8,
		<5,-65>,<5,5>,<15,6>,<0,50>,
		<-15,6>,<-5,5>,<-5,-65>,<5,-65>
	}
	union {
		intersection {
			plane { y,0 rotate z*30 translate x*-8 }
			plane { y,0 rotate z*-30 translate x*8 }
		}
		plane { -z,-5 }
	}
	union {
		intersection {
			plane { y,0 rotate z*10 translate x*-15 }
			plane { y,0 rotate z*-10 translate x*15 }
		}
		plane { z,5 }
	}
	plane {
		z,0
		rotate x*-85
		translate z*50
	}
	bounded_by { box { <-15,-1,-65>,<15,4,50> } }
	scale < .5, 1, 1>
	translate z*8
	texture {
		T_Compass1
		pigment { P_Brass1 }
	}
}

#declare Comp1 = union {
	union {
		union {
			torus { r4, rt }
			cylinder { x*-(r3+8),x*-(r4-8),.8 }
			sphere { x*-(r3+rt+r6),r6 }
			sphere { x*-(r4-rt-r6),r6 }
			cylinder { x*(r3+8),x*(r4-8),.8 }
			sphere { x*(r3+rt+r6),r6 }
			sphere { x*(r4-rt-r6),r6 }
			rotate z*(23+27/60)			// rotate 23 degrees, 27 minutes (same as earth's axis)
		}
		torus { r3, rt rotate x*90 }
		rotate y*87
	}
	intersection {		// the frame
		cylinder { z*-t1,z*t1,r1 }
		cylinder { z*-(t1+.01),z*(t1+.01),r2 inverse }
		texture { T_Frame }
	}
	cylinder { y*-100,y*100,1 }	// vertical rod
	sphere { y*-(r1+r5),r5 }	// lower ball
	sphere { y*(r1+r6),r6 }		// upper ball
	sphere { y*-(r3+r6+rt),r6 }	// lower ball between frame and first ring

	object { Arrow rotate y*-152 }
	texture { T_Compass1 }
}

#declare Comp2 = union {
	box {
		<-80,0,-80>,<80,15,80>
		texture {
			T_Wood4
			scale 100
		}
	}
	#declare a = 50
	#declare b = 20
	polygon {
		9,
		<b,0>,<a,-a>,<0,-b>,<-a,-a>,<-b,0>,<-a,a>,<0,b>,<a,a>,<b,0>
		rotate x*90
		translate y*15.001
		texture { T_Rose1 }
	}
	#declare a = 15
	#declare b = 75
	polygon {
		9,
		<b,0>,<a,-a>,<0,-b>,<-a,-a>,<-b,0>,<-a,a>,<0,b>,<a,a>,<b,0>
		rotate x*90
		translate y*15.002
		texture { T_Wood12 scale 100 }
		texture { T_Rose2 }
	}
}

#declare Compass = union {
	object { Comp1 translate y*(r1+r5*2+15) rotate y*2 }
	object { Comp2 rotate y*90 }
}
