// Room.inc

#declare RoomW = 4000
#declare RoomD = 6000
#declare RoomH = 3000
#declare WallT = 100

#declare T_Wall =
	texture {
		pigment { color rgb < 1.0, 1.0, 1.0 > }
		normal {
			bumps 0.5
		}
		scale 8
	}

#declare T_Ceiling = texture { T_Wall }

#declare Wall = intersection {
	plane { -z, 0 }
	plane {  z, WallT }
	texture { T_Wall }
}

#declare Floor = polygon {
	5
	<0,0,0>,
	<RoomW,0,0>,
	<RoomW,0,RoomD>,
	<0,0,RoomD>,
	<0,0,0>
	texture {
		pigment { checker color Brown,color Brown*0.6 scale 100 }
	}
}

#declare Ceiling = polygon {
	5
	<0,RoomH,0>,
	<RoomW,RoomH,0>,
	<RoomW,RoomH,RoomD>,
	<0,RoomH,RoomD>,
	<0,RoomH,0>
	texture { T_Ceiling }
}

#declare Room = intersection {
	union {
		object { Wall translate z*RoomD }
		object { Wall rotate y*90 translate x*RoomW }
		object { Wall rotate y*-90 }
		object { Wall rotate y*180 }
		object { Floor }
		object { Ceiling }
	}
	box {
		<-WallT,-WallT,-WallT>
		<RoomW+WallT,RoomH+WallT,RoomD+WallT>
	}
}
