/*
Tower.inc

Copyright 1997 Martin Vilcans (marvil@algonet.se)
*/

#declare T_Stalk = texture {
	pigment {
		wood
		ramp_wave
		pigment_map {
			[0.0 rgb < 0, 0, 0> ]
			[0.4 rgb < 0, 0, 0> ]
			[0.5 rgb < 0,.5, 0> ]
			[0.9 rgb < 0,.5, 0> ]
			[1.0 rgb <.1,.7, 0> ]
		}
		turbulence .1
	}
}

#declare Leaf =
	prism {
		linear_sweep
		cubic_spline
		0,.01,
		9,
		<-.1000,-.6000>,
		< .0000,-.6000>,
		< .4800,-.5000>,
		< .5000,-.0000>,
		< .0000, .3000>,
		<-.5000,-.0000>,
		<-.4800,-.5000>,
		< .0000,-.6000>,
		< .1000,-.6000>
		translate z*.6000
		scale <.5,1,1>
		scale 25
	}

#declare r1 = seed(0)

#declare Flower = union {
	#declare i = 0
	#while(i<360)
	object { Leaf
		translate z*(5+rand(r1)*15)
		translate y*(rand(r1)*5)
		rotate <-40-(rand(r1)*10),i>
	}
	#declare i=i+10
	#end
	texture {
		pigment { color rgb < 1.00, 0.30, 0.01 > }
	}
}

#declare T_Tower1 = texture {
	pigment { color White }
}

#declare T_Tower2 = texture {
	T_Wood1
	scale 20
}

#declare round = 1
#declare Tower = union {
#while(round<3)
	mesh {
#declare a = 70
#declare b = 5
#declare c = 100

#declare ang = 0
#declare r = a
#declare h = 0 //current height
#declare stang = 4		// step angle
#declare a = radians(stang)
#declare i = 0		// current angle

#declare r1=r

#while(h<600)
	#declare r2 = r-(i+stang)/360*b

	#declare p1 = <0,-stang/360*c,0> + y*h
	#declare p2 = vrotate(<r2,stang/720*c,0>,y*(-(stang/2)-i)) + y*h
	#declare p3 = vrotate(<r1,-stang/720*c,0>,y*((stang/2)-i)) + y*h
	#declare p4 = p1-y*stang/360*c
#if(round=1)
	triangle { p1,p2,p3 }
	triangle { p1,p3,p4 }
#else		// round = 2
	triangle { p3,p2,p2-y*2*c }
	triangle { p3,p3-y*2*c,p2-y*2*c }
#end	// round if
	#declare i=i+stang
	#declare r1=r2
	#declare h=h+c*(stang/360)
	#declare r=r-b*(stang/360)
#end	// h loop
#if(round=1)
	texture { T_Tower2 }
#else		// round=2
	texture { T_Tower1 }
#end
	}		// end mesh
	#declare round=round+1
#end
	cylinder { 0,y*h,r2 texture { T_Tower1 } }
	cylinder { 0,y*(h+20),1 texture { T_Stalk } scale <r2/4,1,r2/4>}
	object { Flower scale 2 translate y*(h+12) }
}

#render concat("top radius = ",str(r2,3,2),"\n")
#render concat("total height = ",str(h,3,2),"\n")
