#declare do_ball			= 1
#declare do_books			= 1
#declare do_compass		= 1
#declare do_halos			= 1
#declare do_paper			= 1
#declare do_planet		= 1
#declare do_room			= 1
#declare do_shelf			= 1
#declare do_table			= 1
#declare do_windows		= 1

#version 3.0

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"

#include "Compass.inc"
#include "CBall.inc"

#include "BWindow.inc"
#include "Room.inc"
#include "Planet.inc"
#include "CandleHolder.inc"

#if(do_shelf)
#include "Shelf.inc"
#end

global_settings { max_trace_level 30 }
global_settings { assumed_gamma 2.2 }

// light for the planet
light_source {
    <-50000,50000,60000>
    color White
		spotlight
		point_at < -12000, 6000, 50000 >
		radius 30
		falloff 40
}

#declare cam=4
#switch(cam)
#case(1)
camera {
	location < 0, 1130, -600>
	right x*4/3
	angle 30
  look_at <100, 1080, 0>
}
#break
#case(2)		// room overview
camera {
	location < -600, 1130, -1600>
	right x*4/3
	angle 30
  look_at <100, 1080, 0>
}
#break
#case(3)
camera {
	location < 140, 1200, -500>
	right x*3/4
	angle 40
  look_at <80, 1100, 0>
}
#break
#case(4)			// tilted
camera {
	location < 0, 0, 0>
	right x*3/4
	angle 40
	rotate <10,-5,-5>
	translate < 140,1200,-500 >
}
#break
#end

#if(do_compass)
object {
	Compass
	rotate y*-10
	translate < 200,1000,150 >
}
#end

#if(do_ball)
object {
	CBall
	translate <30,1000,-130>
}
#end

#declare EyeColour = rgb < 0.00, 0.10, 0.40 >
#include "Eye.inc"
object { Eye scale 10 rotate < 0,-22,14 > translate < 170,1010,-153 > }

#declare EyeColour = rgb < 0.00, 0.40, 0.10 >
#include "Eye.inc"
object { Eye scale 10 rotate < 5,-30,10 > translate < 150,1010,-173 > }

#if(do_room)
intersection {
	object { Room translate <-RoomW/2,0 > }
	object { WinHole translate <-900,1000,RoomD-5> inverse texture { T_Wall} }
	object { WinHole translate < 800,1000,RoomD-5> inverse texture { T_Wall} }
	translate z*-3000
}
#end //do_room

#if(do_windows)
object { BWindow translate < -900,1000,RoomD-3000-5 > }
object { BWindow translate < 800,1000,RoomD-3000-5 > }
#end	// do_windows

#if(do_shelf)
object {
	Shelf
	translate < -300,951,RoomD-3000 >
}
#end

#if(do_table)
#declare T_Table = texture {
	T_Wood3
	finish {
		//reflection 0.1
		specular 0.3
		roughness 0.05
	}
	scale 50
	rotate x*94
}

#declare Table = union {
	#declare TableW = 600
	#declare TableD = 600
	#declare TableH = 1000
	#declare TableLeg = box { <-15,0,-15>,<15,TableH,15> }
	box { <0,TableH-30,0>,<TableW,TableH,TableD> texture {T_Table rotate z*88}}
	object { TableLeg translate < 30,0,30 > texture {T_Table}}
	object { TableLeg translate < TableW-30,0,30 > texture {T_Table}}
	object { TableLeg translate < TableW-30,0,TableD-30 > texture {T_Table}}
	object { TableLeg translate < 30,0,TableD-30 > texture {T_Table}}
}

object {
	Table
	translate <-150,0,-250>
}
#end //do_table

#if(do_planet)
object {
	Planet
	rotate <-33,5,13>
	scale 3000
//	translate < -12000, 6000, 50000 >
	translate < 8000, 6000, 50000 >
}
#end //do_planet

sphere {			// the sky
	0,150000
	hollow
	texture {		// Starfield2 in stars.inc
    pigment {
      granite
      color_map {
          [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
          [ 0.270  0.285 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
          [ 0.285  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
          [ 0.470  0.485 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
          [ 0.485  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
          [ 0.680  0.695 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
          [ 0.695  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
          [ 0.880  0.895 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
          [ 0.895  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
      }
    	turbulence 1
		  sine_wave
    	scale 5
		}
    finish { diffuse 0 ambient 1 }
	}
	texture {
		pigment {
			bozo
			color_map {
			[0.00 rgbf < 0.0, 0.0, 1.0, 1.00 >]
			[0.70 rgbf < 0.0, 0.0, 1.0, 0.85 >]
			[1.00 rgbf < 0.6, 0.0, 1.0, 0.75 >]
			}
			scale 40000
		}
		finish { diffuse 0 ambient 1 }
	}
}

#if(do_paper)
/* The paper sheets */

#declare P_Paper = pigment {
/*	crackle
	color_map {
		[ 0.00 rgb < 1.0, 1.0, 0.6 > ]
		[ 1.00 rgb < 0.9, 0.8, 0.3 > ]
	}*/
	image_map {
		png "paper.png"
	}
	turbulence <0.10,0.05,0.00>*-1
	lambda 3.0
	octaves 4
}

#declare P_PapGrad1 = pigment {
	gradient x
	pigment_map {
		[ 0.00 Clear ]
		[ 0.10 Clear ]
		[ 0.10 rgb < 1.0, 1.0, 153/255 > ]
		[ 0.90 rgb < 1.0, 1.0, 153/255 > ]
		[ 0.90 Clear ]
	}
}

#declare P_PapGrad2 = pigment {
	gradient x
	pigment_map {
		[ 0.00 Clear ]
		[ 0.10 Clear ]
		[ 0.10 P_Paper ]
		[ 0.90 P_Paper ]
		[ 0.90 Clear ]
	}
}

// first sheet
bicubic_patch {
	type 1
	flatness 0.01
	u_steps 3
	v_steps 3
	<0, 0/3,-.00>,<1/3, 0/3, 0>,<2/4,0/3, 0>,<1,0/3,-.02>
	<0, 1/3,-.00>,<1/3, 1/3, 0>,<2/4,1/3, 0>,<1,1/3,-.01>
	<0, 2/3,-.00>,<1/3, 2/3, 0>,<2/4,2/3, 0>,<1,2/3,-.01>
	<0, 3/3,-.10>,<1/3, 3/3, 0>,<2/4,3/3, 0>,<1,3/3,-.02>

	texture {
		pigment {
			gradient y
			pigment_map {
				[ 0.00 Clear ]
				[ 0.10 Clear ]
				[ 0.10 P_PapGrad1 ]
				[ 0.90 P_PapGrad1 ]
				[ 0.90 Clear ]
			}
			turbulence <0.10,0.05,0.00>
			lambda 3.0
			octaves 4
			translate z*500
		}
	}
	rotate x*90
	scale < 150,200,200>
	translate <200,1000.1,-90>
	rotate y*19
}

// second sheet
bicubic_patch {
	type 1
	flatness 0.01
	u_steps 3
	v_steps 3
	<0, 0/3,-.02>,<1/3, 0/3, -.02>,<2/4,0/3,-.02>,<1,0/3,-.03>
	<0, 1/3,-.02>,<1/3, 1/3,    0>,<2/4,1/3,   0>,<1,1/3,-.01>
	<0, 2/3,-.02>,<1/3, 2/3,    0>,<2/4,2/3,   0>,<1,2/3,-.01>
	<0, 3/3,-.04>,<1/3, 3/3, -.02>,<2/4,3/3,-.02>,<1,3/3,-.02>

	texture {
		pigment {
			gradient y
			pigment_map {
				[ 0.00 Clear ]
				[ 0.10 Clear ]
				[ 0.10 P_PapGrad2 ]
				[ 0.90 P_PapGrad2 ]
				[ 0.90 Clear ]
			}
			turbulence <0.10,0.05,0.00>
			lambda 3.0
			octaves 4
		}
	}
	rotate x*90
	scale < 150,200,230>
//	translate <280,1000.2,-160>
	translate <140,1000.2,-160>
	rotate y*24
}

#end	// do_paper

object {
	CandleHolder
	rotate y*180
	translate <-250,0,700>
}

#if(0)
#declare CandleH = 35
#declare CandleR = 16
#include "Candle.inc"

union {
	intersection {
		torus { 30-9,9 translate y*4}
		cylinder { 0,y*8,30 }
		texture {
			T_Wood2
//			pigment { color White }
		}
	}
	object {
		Candle
		translate y*8
	}
//	translate < 400,1000,-30 >
	translate < 250,1000,-230 >
//	translate < 220,1000,-13 >
}
#else
light_source {
	< 250,1016+8+7,-230 >
	color <1.00,0.80,0.60>
	fade_distance 600
	fade_power 2
}
#end

#if(do_books)
#declare BookH = 200
#declare BookW = 60
#declare BookL = 140
#declare BookT = 4
#declare T_Book = texture {
	pigment {
		wrinkles
		color_map {
			[ 0.0 rgb < 0.6, 0.4, 0.0 > ]
			[ 1.0 rgb < 0.6, 0.4, 0.0 >*.3 ]
		}
		scale 20
	}
}
#declare BookTitle = " Simsam"
#declare T_Title = texture {
	pigment {
		bozo
		color_map {
			[0.0 rgbt < 0.0, 0.0, 0.0, 1.0 > ]
			[0.2 rgbt < 0.0, 0.0, 0.0, 1.0 > ]
			[0.2 rgbt < 0.0, 0.0, 0.0, 0.0 > ]
			[0.3 rgbt < 0.0, 0.0, 0.0, 0.0 > ]
			[0.3 rgbt < 1.0, 0.8, 0.1, 0.0 > ]
		}
		scale 8
	}
	finish {
		specular 0.8
	}
}
#include "Book.inc"

object {
	Book
	rotate x*-90
	rotate y*-80
	translate <-100,1000,250>
}
object {
	Book
	rotate x*-90
	rotate y*-60
	translate <-75,1000+BookW,250>
}
#end	//do_books
