//================================================================================
//      GOLD REDEFINITION
//================================================================================
#declare F_MetalD  =finish {ambient 0.15 brilliance 5 diffuse 0.6 metallic specular 0.80 roughness 1/100 reflection 0.35}
#declare GoldBase = <1.00, 0.875, 0.575>  // mine again
#declare CVect5 = GoldBase  - <0.00, 0.00, 0.00>
#declare P_Gold5    = rgb CVect5             // front row
#declare T_Gold_5D = texture { pigment { P_Gold5 } finish { F_MetalD } }

//================================================================================
//      NICE LOCHNESS MONSTER DEFINITION
//================================================================================
#declare SinuSphere= union {
#declare boucle=1
#declare maxboucle=60
#while (boucle < maxboucle)
sphere {<boucle/(300/maxboucle),sin(boucle*(720/maxboucle))/2,0>,.3}
#declare boucle=boucle+1
#end
}
#declare Bebete = union {
sphere {<0,0,0>,5}
sphere {<4,1,0>,2}
sphere {<5,1,0>,2}
sphere {<6,1,0>,2}
difference {sphere {<7,-1,0>,3} sphere {<10,-2,0>,2}}
difference {cone {<0,0,0>,1,<0,3,0>,.2}cone {<1,0,0>,1,<0,3,0>,.2} rotate x*30 scale 2 translate <0,3,2>}
difference {cone {<0,0,0>,1,<0,3,0>,.2}cone {<1,0,0>,1,<0,3,0>,.2} rotate x*30 scale 2 translate <0,3,2> scale <1,1,-1>}
difference {sphere {<4,3,1>,2 pigment {Yellow+White}} cylinder {<6,1,1>,<6,5,1>,.5 pigment {Black}} } 
difference {sphere {<4,3,1>,2 pigment {Yellow+White}} cylinder {<6,1,1>,<6,5,1>,.5 pigment {Black}} scale <1,1,-1>} 
difference {sphere {<4,3,1>,2.2} plane {y,0 rotate z*70 translate <4,3,1>}}
difference {sphere {<4,3,1>,2.2} plane {y,0 rotate z*70 translate <4,3,1>} scale <1,1,-1>}
object {SinuSphere rotate z*-30 scale <1,.5,1> translate <7,-1,0> pigment {Pink}}
object {SinuSphere scale 5 rotate z*-90}
texture {T_Grnt25 scale 10}
normal {spiral1 .3 scale 5}
}

//================================================================================
//      LITTLE ARCHES DEFINITION
//================================================================================
#declare Cnit1 = difference {
cylinder {<0,0,0>,<0,0,3>,5}
cylinder {<0,0,-1>,<0,0,6>,4.8}
cylinder {<0,4,0>,<0,8,0>,.7}
plane {y,0}
plane {z,0 rotate y*30}
plane {z,0 rotate y*-30}
#declare boucle=1
#while (boucle < 36)
sphere {<4.9,0,3>,.07 rotate z*boucle*5}
#declare boucle=boucle+1
#end
texture {T_Gold_5D}
//pigment {White}
}
#declare Cnit = union {object {Cnit1}
object {Cnit1 rotate y*120}
object {Cnit1 rotate y*240} scale 60}

//================================================================================
//      LITTLE TOWER DEFINITION
//================================================================================
#declare dish = union { difference {sphere {<0,30,0>,30}sphere {<0,38,0>,36}}cone {<0,0,0>,3,<0,20,0>,0}sphere {<0,23,0>,2}
translate <0,8,0> rotate <-90,0,0>}#declare boulette = union {cylinder {<0,0,0>,<0,1,0>,.5}
sphere {<0,2,0>,1}}#declare boulette2 = union {               
object {boulette translate x*9 rotate y*0}object {boulette translate x*9 rotate y*90}object {boulette translate x*9 rotate y*180}object {boulette translate x*9 rotate y*270}}
#declare tourelle = union {cone {<0,0,0>,5,<0,15,0>,2.5}cylinder {<0,15,0>,<0,57,0>,2.5}
torus {3 .2 translate y*35 sturm}torus {3 .2 translate y*37 sturm}torus {3 .2 translate y*33 sturm}
cylinder {<0,55,0>,<0,56,0>,3}cylinder {<0,57,0>,<0,58,0>,3}cone {<0,57,0>,2.5,<0,63,0>,0}}
#declare Base5 = union {cylinder {<0,0,0>,<0,92,0>,3.5}torus {4 .2 translate y*50 sturm}
torus {4 .2 translate y*52 sturm}torus {4 .2 translate y*54 sturm}torus {4 .2 translate y*56 sturm}torus {4 .2 translate y*58 sturm}
torus {4 .2 translate y*60 sturm}torus {4 .2 translate y*62 sturm}cone {<0,70,0>,6,<0,74,0>,11}
cone {<0,75,0>,11,<0,76,0>,10}object {boulette2 translate y*76}object {boulette2 translate y*76 rotate y*22.5}
object {boulette2 translate y*76 rotate y*45}object {boulette2 translate y*76 rotate y*67.5}cone {<0,88,0>,3.5,<0,90,0>,6}
sphere {<0,92,0>,3}cylinder {<0,92,0>,<0,100,0>,1.5}sphere {<0,102,0>,1}sphere {<0,104,0>,1}
sphere {<0,106,0>,1}object {tourelle translate x*9 rotate y*45}object {tourelle translate x*9 rotate y*135}
object {tourelle translate x*9 rotate y*225}object {tourelle translate x*9 rotate y*315}
object {dish scale .6  rotate <20,-90,0> translate <20,20,20>}object {dish scale .15 rotate <20,-120,0> translate <4,95,4>}object {dish scale .15 rotate <20,-180,0> translate <0,97,4>}}

//================================================================================
//      FRACTAL OBJECTS DEFINITIONS
//================================================================================
#declare grotte3 = julia_fractal {<1,-.023,.5,1> sqr
 max_iteration 6 precision 55
 slice <1,1,1,1>,0
 scale 10}
#declare grotte1 = julia_fractal {<1,-.023,.5,1> sqr
 max_iteration 5 precision 55
 slice <.04,.3,-0.84,1>,.1
 scale 5}
#declare grotte2 = julia_fractal {<1,-.023,.5,1> sqr
 max_iteration 5 precision 55
 slice <2,.3,-0.84,1>,.1
 scale 5}
#declare MachinFract = union {
 object {grotte3 translate <-5,0,5>}
 object {grotte2}
 cone {<0,3,0>,2,<5,10,5>,.1}
 cylinder {<4,7.5,4>,<4,7.8,4>,.5}
 cylinder {<4,8.5,4>,<4,8.8,4>,.5}
 cylinder {<4,9.5,4>,<4,9.8,4>,.5}
union {object {grotte1}
object {grotte1 rotate y*90 translate y*5}
object {grotte1 translate y*10}
cylinder {<0,0,0>,<0,15,0>,2.5} translate z*10}
pigment {White*2} normal {crackle 10.4} finish {specular .1}
}
//================================================================================
//      PLANT
//================================================================================
#declare VertClair=color rgb <.9,1.3,.8>+<1,1,1>
#declare melange = pigment {
                        radial
                        color_map {
                        [0 DarkGreen+White][.1 DarkGreen+White]
                        [.11 VertClair ][.2 VertClair ]
                        [.21 DarkGreen+White][.3 DarkGreen+White]
                        [.31 VertClair ][.4 VertClair ] 
                        [.41 DarkGreen+White][.5 DarkGreen+White]
                        [.51 VertClair ][.6 VertClair ]
                        [.61 DarkGreen+White][.7 DarkGreen+White]
                        [.71 VertClair ][.8 VertClair ] 
                        [.81 DarkGreen+White][.9 DarkGreen+White]
                        [.91 VertClair ][.99 VertClair ] 
                                } 
                        turbulence .1
                        }
#declare r1=seed(0) 
#declare r2=seed(40) 
#declare boucle = 1
#declare bogue = union {
        sphere {<0,0,0>,3 pigment {melange} finish {phong .7 phong_size 20} normal {bumps .4 scale .1}}
 #while (boucle < 50) 
 #declare dist=rand(r1)/3+.1     
        sphere {<0,0,3+dist>,dist pigment {DarkGreen*2.5} rotate <rand(r2)*360,rand(r2)*360,rand(r2)*360>}
#declare boucle=boucle+1 #end
                        }

#declare plante1=
union {
       difference {
       object {bogue scale <.7,.8,.7>} 
       sphere {<0,0,0>,2 scale <.5,1,.5> translate y*3} 
       translate y*3
                  }
 #declare raydepart=.3 
 #declare rayfin=.3 
 #declare tailldepart=.3
 #declare taillfin=0 
 #declare hauteur=6 
 #declare nbsphere=70                              
 #declare angletot=4*360 
 #declare pig1=<1,0,.3>+<1,1,1> 
 #declare pig2=<2,1,1>+<1,1,1>
union {
 #declare boucle = 0 
 #while (boucle < nbsphere) 
 #declare rayactu = ((boucle/nbsphere)*(rayfin-raydepart))+raydepart 
 #declare taillactu = ((boucle/nbsphere)*(taillfin-tailldepart))+tailldepart    
 #declare hautactu =(boucle/nbsphere)*hauteur 
 #declare anglactu =(boucle/nbsphere)*angletot     
  sphere {<0,0,0>,taillactu translate <rayactu,hautactu,0> rotate y*anglactu
   pigment {color rgb ( (pig1*(boucle/nbsphere)) + (pig2*(1-(boucle/nbsphere))) )}
   finish {phong_size 25 phong .8}}
 #declare boucle=boucle+1
 #end
translate y*3}
 }
#declare GrpPlante1 = union {
object {plante1}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*0}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*60}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*120}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*180}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*240}
object {plante1 rotate x*20+<rand(r2)*6,rand(r2)*6,rand(r2)*6> translate z*3+z*rand(r1) rotate y*300}
}

