#declare WingL = intersection {
   difference {
      difference {
         difference {
            difference {
               cylinder { <0,0,0>, <0,.01,0>, 15 }
               cylinder { <0,-.1,0>, <0,.1,0>, 8 }
            }
            cylinder { <-11,-.1,0>, <-11,.1,0>, 4 }
         }
         cylinder { <-5,-.1,4>, <-5,.1,4>, 3.5 }
      }
      cylinder { <-1,-.1,8.5>, <-1,.1,8.5>, 3 }
   }
   box { <-16,-1,0>, <0,1,16> }
}

#declare WingR = intersection {
   difference {
      difference {
         difference {
            difference {
               cylinder { <0,0,0>, <0,.01,0>, 15 }
               cylinder { <0,-.1,0>, <0,.1,0>, 8 }
            }
            cylinder { <11,-.1,0>, <11,.1,0>, 4 }
         }
         cylinder { <5,-.1,4>, <5,.1,4>, 3.5 }
      }
      cylinder { <1,-.1,8.5>, <1,.1,8.5>, 3 }
   }
   box { <16,-1,0>, <0,1,16> }
}

#declare DragonP = pigment {
   granite
   color_map {
      [0.0 color rgb 0]
      [1.0 color rgb <1,0,0>]
   }
}

#declare Body = blob {
   threshold 0.6
   sphere { <-0.17, 0.06, 0>, 1.03, 1 }
   sphere { < 0.41, 0.01, 0>, 1.14, 1 }
   sphere { <-0.67, 0.20, 0>, 1.01, 1 }
   sphere { < 0.93, 0.08, 0>, 0.86, 1 }
   sphere { < 1.41, 0.18, 0>, 0.60, 1 }
   sphere { < 1.77, 0.15, 0>, 0.43, 1 }
   sphere { < 2.04, 0.08, 0>, 0.41, 1 }
   sphere { < 2.38,-0.02, 0>, 0.42, 1 }
   sphere { < 2.65,-0.17, 0>, 0.35, 1 }
   sphere { < 2.94,-0.22, 0>, 0.30, 1 }
   sphere { < 3.12,-0.30, 0>, 0.29, 1 }
   sphere { < 3.34,-0.35, 0>, 0.25, 1 }
   sphere { < 3.88,-0.24, 0>, 0.19, 1 }
   sphere { < 3.73,-0.27, 0>, 0.21, 1 }
   sphere { < 3.54,-0.32, 0>, 0.23, 1 }
   sphere { < 4.02,-0.22, 0>, 0.18, 1 }
   sphere { < 4.15,-0.25, 0>, 0.15, 1 }
   sphere { < 4.32,-0.31, 0>, 0.10, 1 }
   sphere { < 4.24,-0.28, 0>, 0.09, 1 }
   sphere { < 4.59,-0.27, 0>, 0.05, 1 }
   sphere { < 4.64,-0.28, 0>, 0.03, 1 }
   sphere { < 4.39,-0.31, 0>, 0.08, 1 }
   sphere { < 4.47,-0.29, 0>, 0.08, 1 }
   sphere { < 4.53,-0.27, 0>, 0.08, 1 }
   sphere { <-1.27, 0.46, 0>, 0.67, 1 }
   sphere { <-1.59, 0.65, 0>, 0.45, 1 }
   sphere { <-1.76, 0.85, 0>, 0.34, 1 }
   sphere { <-2.17, 1.19, 0>, 0.77, 1 }
   sphere { <-2.65, 0.84, 0>, 0.20, 1 }
   sphere { <-2.51, 0.96, 0>, 0.30, 1 }
}

#declare Breath = difference {
   sphere {
      0, 1
      pigment { color rgbt 1 }
      halo {
         emitting
         spherical_mapping
         linear
         turbulence .75
         color_map {
            [ 0.0 color rgbt <1, 0, 0,  1> ]
            [ 0.5 color rgbt <1, 1, 0, -1> ]
            [ 1.0 color rgbt <1, 0, 0,  1> ]
         }
         frequency 2
         samples 20
         scale 0.5
      }
      hollow
   }
   box { <-1,0,-1>, <1,-1,1> pigment { color rgbt 1 } }
   scale <.5,4,.5>*5
   rotate <0,0,-70>
   translate <-24,-1,0>
}

#declare Body = union {
   object { WingL scale <2,1,1> translate <-.1,0,-13> rotate <0,0,-45> pigment { DragonP } }
   object { WingR scale <2,1,1> translate < .1,0,-13> rotate <0,0, 45> pigment { DragonP } }
   object { Body rotate <0,90,0> scale 5 pigment { DragonP } }
   rotate <0,270,0>
   scale .75
}

union {
   object { Body }
   object { Breath }
   rotate <0,-30,0>
   translate <85,110,500>

}
