#declare LeafT = texture {
   pigment {
      granite
      color_map {
         [0.4  color rgbt 1 ]
         [0.4  color rgb <.1,.7,0>]
         [0.5  color rgb <.1,.9,0>]
         [0.55 color rgbt 1 ]
         [0.6  color rgb <0,.8,.1>]
         [0.7  color rgb <0,.9,.1>]
         [0.7  color rgbt 1]
      }
   }
   scale .5
}

#declare BarkT = texture {
   pigment {
      granite
      color_map {
         [0.4  color rgb 1.0]
         [0.4  color rgb 0.1]
         [0.5  color rgb 0.4]
         [0.55 color rgb 1.0]
         [0.6  color rgb 0.5]
         [0.7  color rgb 0.3]
         [0.7  color rgb 1.0]
      }
   }
}

#declare BlobBase = blob {
   threshold .75
   sphere { <0,1.5,0>, 1, 3 }
   sphere { <0,2.0,0>, 1, 8 }
   sphere { <0,3.0,0>, 1, 4 }
   sphere { <-.4,1.8,-.6>, 1, 3 }
   sphere { <0.6,2.4,0.1>, 1, 2 }
   sphere { <-.8,2.2,0.6>, 1, 2 }
   texture {LeafT}
}

#declare Blob1 = blob {
   threshold .75
   sphere { <0.6,2.8,-.6>, 1, 3 }
   sphere { <-.9,3.4,.8>, 1, 2 }
   sphere { <0.8,3.0,0.6>, 1, 2 }
   scale <1,.5,1>
   texture {LeafT}
}

#declare Blob2 = blob {
   threshold .75
   sphere { <1.2,2.8,-.6>, 1, 3 }
   sphere { <-.5,2.4,-.8>, 1, 2 }
   sphere { <-.8,2.0,-1.2>, 1, 2 }
   scale <1,.5,1>
   texture {LeafT}
}

#declare Blob3 = blob {
   threshold .75
   sphere { <1.2,3.6,-.6>, 1, 1 }
   sphere { <-.5,3.4,-.8>, 1, 2 }
   sphere { <-.8,3.0,-1.2>, 1, 2 }
   scale <.5,1,.5>
   texture {LeafT}
}

#declare Trunk = union {
   cone { <0,0.0,0>, 0.2, <0,2.3,0>, 0.0 open texture {BarkT} }
   cone { <0,0.4,0>, 0.1, <0,2.6,0>, 0.1 open texture {BarkT} }
   cone { <0,2.6,0>, 0.1, <0,5.4,0>, 0.0 open texture {BarkT} }
   cone { <0,3.0,0>, 0.1 , <-.4,3.8,-.8>, 0.0 open texture {BarkT} }
   cone { <0,3.6,0>, 0.05, <0.6,4.4,0.1>, 0.0 open texture {BarkT} }
   cone { <0,4.4,0>, 0.05, <-.8,5.2,0.6>, 0.0 open texture {BarkT} }
}

#declare R = seed(1)

#declare Loop = 1

#while (Loop < NTrees)
   #declare Canopy = union {
      sphere { <0,1,0>, .6  scale <1,2,1> texture {LeafT} }
      object { BlobBase rotate y*(rand(R)*360) }

      #declare Num = rand(R)
      #if (Num > .66)
         object { Blob1 rotate y*(rand(R)*360) }
      #else
         #if (Num > .33)
            object { Blob2 rotate y*(rand(R)*360) }
         #else
            object { Blob3 rotate y*(rand(R)*360) }
         #end
      #end
   }

   #declare zpos = rand(R) * TDepth
   #declare xpos = rand(R) * (20 + (zpos*.75))

   union {
      object {Canopy  translate <0,2,0>}
      object {Trunk}
      scale <1,1.0 - (rand(R)/5),1>
      rotate <0,rand(R)*360,0>
      translate <xpos-10,0,zpos>
   }

   #declare Loop = Loop + 1
#end
