#debug "<-BOOK.INC->"
#declare BookPap =
pigment {
  image_map { tga "BOOKPAP.TGA" }
  rotate x*90
  rotate y*90
  scale <.8,1,2>
  translate x*-.4
}

#declare BandColour = pigment { rgb<.15,.05,.025> }

#declare BookCoverTex = texture {
  pigment { rgb<.2,.4,.1> }
  normal { granite .18 scale .25 }
  finish { roughness .6 crand .002 }
}

#declare Book=
union {
#declare C=0
#while(C<3)
  torus { .5, .075 pigment { BandColour } scale <1,.5,.25>
  translate <0,(.75*C)+.25,0> }
  #declare C=C+1
#end

box { <-.5,0,0>,<-.4,2,1.5> }
cylinder { <-.45,0,1.5>,<-.45,2,1.5>, .05 }

box { <.4,0,0>,<.5,2,1.5> }
cylinder { <.45,0,1.5>,<.45,2,1.5>, .05 }

difference {
  cylinder { <0,0,0>,<0,2,0>, .5 scale <1,1,.25> }
  box { <-.4,-1,0>,<.4,3,1.4> pigment { rgb<0,1,0> } }
}

box { <-.4,0,0>,<.4,2,1.4> pigment { BookPap } }

texture { BookCoverTex }
translate <0,-1,-.75>
}

// Red book
object { Book
        pigment { rgb<.5,.3,.2> }
        scale <2,4,3.25>/1.5
        rotate z*90
        translate <-6, 4, 4>
        }

// Green book
object { Book
        scale <2,4,3.25>/1.5
        rotate z*90
        rotate y*35
        translate <-6, 5.333, 5>
      }

#declare R=seed(888)
#declare C=0
#while(C<5)
  object { Book
    pigment { rgb<rand(R),rand(R),rand(R)>/2.25 }
    scale <2,4,3.25>/1.5
    translate <-9+(1.65*C), 11, 19.8>
   }
  #declare C=C+1
#end

//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------

