#debug "<-CANDLE.INC->\n"
//******************************************
// INITIALIZATION
//******************************************
#ifndef(SEED)
  #declare SEED = 1
#end

#ifndef(NUM_DRIPS)
  #declare NUM_DRIPS = 12
#end


//******************************************
// CANDLE TEXTURE
//******************************************
#declare CANDLE_TEXTURE = texture {  
  pigment { gradient y
    color_map {   
      [0.0 rgb<1.4,1.3,1.1>]
      [0.5 rgb<1.4,1.3,1.1>]
      [1.0 rgb<1.5,1.4,1.2>]
      }
     scale <1,6,1>
     translate y*-4
    }
  normal { bumps .21 scale .1 }
  finish { roughness .5 crand .008 ambient .22 
           diffuse .355 }
}

 


//******************************************
// MAIN CANDLE OBJECT
//******************************************
#declare Candle=
#declare S = seed(SEED)
union {

//******************************************
// CANDLE HEAD
//******************************************
#declare Head=
blob {
  threshold .6
  #declare C=0
  #declare R=0

  #while(C < 360)
    #declare R = rand(S)
      cylinder {<0,0,0>,<2.1,R,0>, .875, 1.25 rotate y*C }
      #declare C=C+16                  
  #end
no_shadow
}

//******************************************
// WAX DRIPS
//******************************************
#declare C=0
#declare WaxDrips=
union {
#while(C < NUM_DRIPS)
  #declare SingleDrip=
  blob {
    threshold .6
    #declare R=0
    #declare NR=0
    #declare SDC=0
    #while(SDC < 5)
      #declare R = rand(S)
      #declare NR = (NR + R)+.2
        sphere { <2.5,.2-(NR/1.6),0>, .5-(R/2.25), 1.25 }
        #declare SDC=SDC+1
    #end
  }

  #declare R = rand(S)
  object { SingleDrip rotate y*(R*100) }
  #declare C=C+1
#end
no_shadow
}

//******************************************
// CANDLE BODY
//******************************************
  cylinder { <0,-4,0>,<0,0,0>, 2.5 }
  object { Head scale <1,.475,1> }
  object { WaxDrips }
  object { Head scale <1.2,.5,1.2> translate <0,-4,0> }

#ifdef(FLAME)
  object { #include "FLAME.INC" Flame
           translate <0,2.15,0> scale 2.56 }
#end
texture { CANDLE_TEXTURE }
translate y*4
}

//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------


