global_settings {
  assumed_gamma 1.8
  adc_bailout 1/250
  max_trace_level 4
}

// Orthographic views used for debugging (maily to see if objects
// are in right place, and are on a base).
#declare FrontOrtho=
camera {
  location <5, 5, -19>
  look_at <5 5,0>
  angle 55
  orthographic 
}

#declare TopOrtho=
camera {
  location <5, 19, 5>
  look_at <5,0,5>
  angle 55
  orthographic
}


#declare FinalView=
camera {
 location <3, 11, -19>
 look_at <1, 6, 0>
 angle 55
}

camera {
// FrontOrtho
// TopOrtho
 FinalView
}

#include "gnlspell.inc"


// Candle light, and fake light to light up candle wax
light_source { <9.25, 8, 6.25> rgb<1.15,.845,.123> }

light_source { <9.25, 18, 6.25>
    color rgb <1.1,.665,.025>
    spotlight
    point_at <9.25, 8, 6.25>
    radius 255
    falloff 265
    tightness .25
    shadowless
}


// Light coming out of window
light_source { <-30,15,0>
    color rgb .2
    spotlight
    point_at <0, 7, 0>
    radius 25
    falloff 26
    tightness 5
    shadowless
}

#declare Window=
union {
  difference { 
    box { <-3,0,0>,<3,8,.75> }
    box { <-2.5,.5,-1>,<2.5,7.5,2> }
    }
box { <-3,3.875,0>,<3,4.125,.75> }
box { <-.125,0,0>,<.125,8,.75> }

rotate y*90
scale 1.125
translate <-20,5,0>
pigment { rgb <.1,.025,.02> }
finish { crand .08 roughness 1 }
}

#declare Wall=
union {
 difference {
  box { -20,20 }
  union {
    box { -19.5,19.5 }
    box { <-21,5,-3>,<21,13,3> }
    }
  }
box { <19.9,-20.1,-20.1>,<20.1,20.1,20.1> }
  texture { WallTex }
  hollow
  no_shadow 
}

object { Window }

// Outdoor sky. Can be seen on the crystal ball's reflection through
// the window.
sky_sphere {
  pigment {
    gradient y
    color_map {
      [.2 rgb 0]
      [ 1 rgb<0,0,1.33>]
    }
    translate <0,.5,0>
  }
}

//************************************************************************
// FINAL PLACEMENTS OF OBJECTS
//************************************************************************

object { Wall }
object { Shelf }
object { CrystalBall scale 1.75 translate <-5.5, 2.3, -2.25> }
object { Table  }

#include "WAND.INC"
#include "BOOK.INC"
//#include "PAPER.INC"
//#include "SKULL.INC"
#include "JAR.INC"
#include "INK.INC"
#include "KNIFE.INC"

#declare SEED  = 16
#declare FLAME = true
#include "CANDLE.INC"

union {
//  object { Skull scale .765  rotate <15,-44,0> translate <9, 1.28, 2.8622> }
  object { Candle scale .263 rotate y*20 translate <6.9, 4.35, 4.9>}
  scale 1.3
  translate <.25,-.75,0>
}

#declare Rat=
box { <0,0,0>, <6,3,1e-100>
  pigment {
    image_map { gif "RAT.GIF"
    transmit 212 1
    }
    scale <6,3,1>
  }
  finish { ambient .6 }
}

object { Wand scale .875 rotate z*84 rotate y*-45 translate <-1,1.23,11>}
object { Rat rotate y*-45 translate <-10.2,-.15,.2> }
object { InkBottle scale .5 rotate y*170 translate <9.75,.5,1> }
object { Knife rotate y*220 translate <4.5,.5,13>}

#debug "\n\n*****> RENDERING NOW! <*****\n\n\n"

//---------------------------------------------------------------------------
// The Spell -- Copyright (C) 1997, Gautam N. Lad.  All Rights Reserved.
//
// NOTE:  If YOU wish to use this image/file for ANY purpose, you MUST first
//        contact me at my e-mail address to notify me.
//        Visit my website to find software/graphics/links, etc. at:
//        http://www.interlog.com/~gautam
//---------------------------------------------------------------------------

