// Fichero de POVRAY 3 por:
// POVRAY 3 file by:
//  Guillermo S. Romero

// E-mail:     famrom@ran.es
// Snail-mail: P.O.Box 35099-28080 Madrid (Espaa)

// Este fichero contiene:
//  Una invocacion demoniaca (magia negra).
//--
// This file contains:
//  A demon summoning (black magic).


global_settings {
    assumed_gamma 2.4
    max_trace_level 20
}

#include "colors.inc"
background { Blue }
#include "textures.inc"
#include "woods.inc"
#include "teak.map"
// Wall texture
#declare Swap_Colors = 1
#include "bricktex.inc"
#declare T_BottomLayer = texture { T_GRDryAdobe }
#declare M_WallsPaint =
    color_map {
        [ .1 Goldenrod ]
        [ .9 MediumGoldenrod ]
    }
#declare T_WallsPlaster = texture { pigment { rgb <.9, .9, .7> } }
#include "fcitytex.inc"

// If you have time and/or a very fast machine, try this
// The image will look "different"
#include "consts.inc"
#declare Rad_Quality = Radiosity_Normal
#include "rad_def.inc"


// --- Ground
// Stones
#declare GLevel = .05
#declare GScale = 5
#declare Ground =
    height_field {
        gif "tiles.gif"
        water_level GLevel
//        smooth
        translate <-.5, 0, -.5>
        scale <300, GScale, 300>
    }

// Positioning
object { // Left
    Ground
    rotate 90 * y
    translate <-300, 0, 0>
    texture {
        pigment { White }
    }
}
object { // Right
    Ground
    rotate 180 * y
    translate <300, 0, 0>
    texture {
        pigment { White }
    }
}
object { // Left back
    Ground
    scale <1, 1, -1>
    translate <-300, 0, 300>
    texture {
        pigment { White }
    }
}
object { // Center back
    Ground
    rotate -90 * y
    translate <0, 0, 300>
    texture {
        pigment { White }
    }
}
object { // Right back
    Ground
    scale <-1, 1, 1>
    translate <300, 0, 300>
    texture {
        pigment { White }
    }
}


// --- Symbol =-/
#declare Radius = 130
#declare R0 = radians (0)
#declare R72 = radians (72)
#declare R144 = radians (144)
#declare R216 = radians (216)
#declare R288 = radians (288)
#declare Pos0 = <cos (R0), 0, sin (R0)> * Radius
#declare Pos72 = <cos (R72), 0, sin (R72)> * Radius
#declare Pos144 = <cos (R144), 0, sin (R144)> * Radius
#declare Pos216 = <cos (R216), 0, sin (R216)> * Radius
#declare Pos288 = <cos (R288), 0, sin (R288)> * Radius
#declare Symbol =
    merge {
        torus { Radius, 10 hollow }
        cylinder { Pos0, Pos144, 10 hollow }
        cylinder { Pos144, Pos288, 10 hollow }
        cylinder { Pos288, Pos72, 10 hollow }
        cylinder { Pos72, Pos216, 10 hollow }
        cylinder { Pos216, Pos0, 10 hollow }
        scale <1, .1, 1>
        rotate 90 * y
    }

// Carving the ground
difference {
    union {
        object { // Center
            Ground
            texture {
                pigment { White }
            }
        }
        plane { // Sand
            y, GLevel * GScale
            texture {
                bozo
                texture_map {
                    [ .5 pigment { Brown }
                         normal { bumps -2 scale .1 }
                    ]
                    [ .5 T_GRMoss1
                         finish {
                             phong .2
                             phong_size 10
                         }
                         scale 10
                    ]
                }
                scale 10
            }
        }
    }
    object {
        Symbol
        texture {
            pigment { Red }
        }
        scale <1, 5, 1>
        translate <0, GScale, 0>
    }
}

// The lava/fire/cloud/orange thing
object {
    Symbol
    no_shadow
    texture {
        pigment { Clear }
        //finish { ambient 1 diffuse 0 }
        halo {
            linear
            emitting // glowing
            max_value 1
            planar_mapping
            samples 20
            turbulence .3
            frequency -1.5
            phase .65
            color_map {
                [ 0 rgbt <.5, .5, 0, 1> ]
                [ 1/3 rgbt <.5, .4, 0, 1> ]
                [ 2/3 rgbt <.5, .3, 0, 1> ]
                [ 1 rgbt <.5, 0, 0, .75> ]
            }
            scale .8 * <10, 1, 10>
        }
    }
    scale <1, 20, 1>
    translate -<0, GScale, 0>
}


// --- Candles
// Candles on the floor (5 groups of 5 each)
#declare CandleLight = on
#declare CandleGroup = 5
#while (CandleGroup > 0)
    #declare CandleGroup = CandleGroup - 1
    union {
        #declare CandleN = 5
        #while (CandleN > 0)
            #declare CandleN = CandleN - 1
            #include "candle.inc"
            object {
                Candle
                translate -5 * x
                rotate CandleN * 72 * y
            }
        #end // CandleN
        translate <Radius + 20, GScale, 0>
        rotate ((CandleGroup * 72) + 90) * y
    }
#end // CandleGroup


// --- Wall
// Basic surface
plane {
    -z, -450
    texture {
        T_GRWalls2
        scale 100
    }
}

// Dirty, to cover the lower part
cylinder {
    <-1000, GScale, 450>, <1000, GScale, 450>, GScale
    texture {
        pigment {
            bozo
            color_map {
                [ .1 DarkOliveGreen ]
                [ .9 Gray10 ]
            }
            scale 50
        }
        normal {
            bumps 1 scale .1
        }
    }
}

// Wood parts
#declare Timber =
    superellipsoid {
        <.25, .25>
        scale <10, 10, 200>
        texture{
            pigment {
                P_WoodGrain3A
                color_map { M_Teak }
                scale 10
            }
            normal {
                bumps 1
                scale <1, 1, 10>
            }
        }
        rotate 90*y
    }

// Postioning
object { // Low
    Timber
    translate <0, 10+GScale, 450-10>
}
object { // Mid
    Timber
    rotate -90*x
    translate <0, 10+GScale+120, 450-10>
}
object { // Top
    Timber
    rotate 90*x
    translate <0, 10+GScale+240, 450-10>
}
object { // Low left
    Timber
    translate <-400, 10+GScale, 450-10>
}
object { // Mid left
    Timber
    scale -1
    translate <-400, 10+GScale+120, 450-10>
}
object { // Top left
    Timber
    scale -1
    rotate 90*x
    translate <-400, 10+GScale+240, 450-10>
}
object { // Low Right
    Timber
    scale <-1, 1, -1>
    translate <400, 10+GScale, 450-10>
}
object { // Mid Right
    Timber
    scale <-1, -1, 1>
    rotate -90*x
    translate <400, 10+GScale+120, 450-10>
}
object { // Top Right
    Timber
    scale <1, -1, -1>
    rotate 90*x
    translate <400, 10+GScale+240, 450-10>
}
object { // Left vertical
    Timber
    scale <1, 1, 1.1>
    rotate 90*z
    translate <-200, 200+GScale, 450-10>
}
object { // Right vertical
    Timber
    scale <1, 1, 1.1>
    rotate 180*x rotate 90*z
    translate <200, 200+GScale, 450-10>
}
object { // Left roof
    Timber
    rotate -90*y rotate 90*z
    translate <-200, 10+GScale+240, 250-10>
}
object { // Right roof
    Timber
    rotate -90*y rotate 90*z
    translate <200, 10+GScale+240, 250-10>
}

// Corner supports
#declare CornerDim = 60
#declare CornerSize = .5 * sqrt (2 * CornerDim * CornerDim)
#declare Corner =
    superellipsoid {
        <.25, .25>
        scale <9, 9, CornerSize>
        texture{
            pigment {
                P_WoodGrain3A
                color_map { M_Teak }
                scale 10
            }
            normal {
                bumps 1
                scale <1, 1, 10>
            }
        }
        translate -CornerSize * z
        rotate 45 * x
        translate -CornerDim * y
    }

#declare DCorner =
    union {
        object { Corner }
        object { Corner scale <1, -1, 1> }
    }

#declare QCorner =
    union {
        object { DCorner }
        object { DCorner scale <1, 1, -1> }
    }

// Positioning
object { // Roof left
    DCorner
    translate <-200, 10+GScale+240, 450-10>
}
object { // Roof right
    DCorner
    scale <1, -1, 1>
    translate <200, 10+GScale+240, 450-10>
}
object { // Top left
    QCorner
    rotate -90 * y
    translate <-200, 10+GScale+240, 450-10>
}
object { // Top right
    QCorner
    rotate 90 * y
    translate <200, 10+GScale+240, 450-10>
}
object { // Mid left
    QCorner
    rotate -90 * y    rotate 90 * z
    translate <-200, 10+GScale+120, 450-10>
}
object { // Mid right
    QCorner
    rotate 90 * y    rotate 180 * z
    translate <200, 10+GScale+120, 450-10>
}
object { // Low left
    DCorner
    rotate -90 * y     rotate 90 * z
    scale <1, 1, -1>
    translate <-200, 10+GScale, 450-10>
}
object { // Low right
    DCorner
    rotate 90 * y    rotate -90 * z
    translate <200, 10+GScale, 450-10>
}


// Demon
// Monster cloud
sphere {
    0, 1
    hollow
    texture {
        pigment { Clear } 
        halo {
            emitting
            spherical_mapping
            linear
            color_map {
                [ 0 SpringGreen transmit 1 ]
                [ .8 Green transmit .4*.5 ]
                [ 1 DarkGreen transmit -1 ]
            }
            turbulence .9
            frequency 2
            samples 20
            scale .6
        }
    }
    rotate 90 * y
    scale <50, 100, 45>
    translate <0, 120, 0>
}
light_source {
    0 rgb <0, .6, 0>
    fade_power 2
    fade_distance 200
    translate <0, 120, 0>
}

// Eyes
#declare Piriform =
    quartic { // Piriform from ShapesQ
        < 4,   0,   0,   -4,  0,   0,   0,   0,   0,  0,
          0,   0,   0,    0,  0,   0,   0,   0,   0,  0,
          0,   0,   0,    0,  0,   1,   0,   0,   0,  0,
          0,   0,   1,    0,  0>
        sturm
        bounded_by {
            box { <0, -1, -1>, 1 }
        }
        translate <-.5, 0, 0>
    }

#declare Eye =
    union {
        light_source {
            0, rgb <.8, 0, 0>
            fade_power 2
            fade_distance 100
        }
        object {
            Piriform
            no_shadow
            texture {
                pigment { Red }
                finish { ambient .95 diffuse .05 }
            }
            scale <-1.5, .25, .3>
        }
        sphere {
            0, 1
            hollow no_shadow
            texture {
                pigment { Clear }
                halo {
                    emitting
                    cubic spherical_mapping
                    samples 20
                    color_map {
                        [ 0 rgbt <0, 0, 0, 1> ]
                        [ 1 rgbt <1, 0, 0, 0> ]
                    }
                    turbulence .025
                }
            }
            scale <1.5, .5, .5> * 2
            translate -.25 * x
        }
    }

union {
    object { // Right
        Eye
        scale 10
        rotate 20 * z    rotate -20*y
        translate 15 * x
    }
    object { // Left
        Eye
        scale 10
        rotate 20 * z    rotate -20*y
        translate 15 * x
        scale <-1, 1, 1>
    }
    translate <0, 130, -40>
}


// --- Dimensional gate
// Inner disc
#declare T_Outter =
    texture {
        pigment {
            wood ramp_wave
            color_map {
                [ .2 Black transmit .2 ]
                [ .6 Cyan transmit .2 ]
                [ .8 White transmit .2 ]
                [ .9 Clear ]
            }
            lambda 4
            turbulence .01
            scale 1.1
        }
        normal {
            bumps -2
            scale .2
        }
    }
#declare T_Inner =
    texture {
        T_Outter
        finish {
            ambient 1 diffuse 0
            refraction on
            ior 1.1
        }
    }

disc {
    0, -z, 1, 0
    no_shadow
    texture {
        wood ramp_wave
        texture_map {
            [ .8 T_Inner ]
            [ .9 T_Outter ]
        }
    }
    scale <100, 100, 1>
    translate <0, 120, 50>
}

// "Tube"
#declare T_Spiral =
    texture {
        pigment {
            spiral1 6
            color_map {
                [ 0 Blue transmit .2 ]
                [ 1 SkyBlue transmit .2 ]
            }
            scale .5
        }
        finish { ambient 1 diffuse 0 }
    }

cone {
    <0, 0, 0>, 1, <0, 0, 1>, .4 open
    no_shadow
    texture {
        gradient z
        texture_map {
            [ .05 pigment { Clear } ]
            [ .2 T_Spiral ]
            [ .8 T_Spiral ]
            [ .95 pigment { Clear } ]
        }
        turbulence .01
    }
    scale <110, 110, 400>
    translate <0, 120, 50>
}
light_source {
    0 rgb <0, .25, .25>
    fade_power 2
    fade_distance 150
    translate <0, 120, 50+200>
}


// --- Cameras and lights
// Final camera
camera {
    location <20, 100, -650>
    right <4/3, 0, 0>
    up <0, 1, 0>
    angle 28
    look_at <0, 100, 0>
}

/* Top view testing
camera {
    location <0, 650, -50>
    right <4/3, 0, 0>
    up <0, 1, 0>
    angle 35
    look_at <0, 0, 0>
}*/

// Testing light
//light_source { <200, 200, -200> White }


// --- Logo
height_field {
    gif "by-gsr.gif"
    water_level .001
    texture {
        pigment {
            bozo // gradient z+x
            color_map {
                [ 0 color rgb <.25, 1, 1> ]
                [ 1 color rgb <.1, .1, 1> ]
            }
            sine_wave
            scale .25
        }
        finish {
            ambient .2
            diffuse .4
        }
    }
    texture {
        pigment {
            crackle
            color_map {
                [ .05 Black ]
                [ .05 Clear ]
            }
            scale .2
            translate <.5, 0, .5> // To fix big black spots
        }
        finish {
            ambient .1
            diffuse .5
        }
    }
    translate <-.5, 0, -.5>
    scale <50, 1, 20>
    rotate -90*x //rotate -90*z
    translate <-260, 60+GScale+10, 448>
}


// (C) Guillermo Sanz Romero
// Todos los derechos reservados.
// Si deseas utilizar la totalidad o parte de este fichero puedes hacerlo
//  mientras no sea con fines lucrativos.
// En caso de usarlo para publicidad, recopilaciones de software, inclusin
//  en revistas o alguna otra actividad que suponga una transaccin
//  remunerada (con cualquier tipo de bien, por lo que los trueques y los
//  premios de los concursos tambin quedan incluidos), debes ponerte en
//  contacto utilizando las direcciones de la cabezera para poder acordar las
//  condiciones que te permitan hacer dicho uso de los datos contenidos en
//  este fichero o los generados a partir de l, tanto descripciones de
//  imagenes como las imagenes en si, en cualquier formato y/o medio de
//  almacenamiento.
//--
// All rights reserved.
// If you want to use this file in is enterity or only parts of it you can do
//  it while it is a non-profitable purpose.
// In case of using it for advertisment, software recopilations, bunddling it
//  with magazines or another profitable transaction (any sort of profit, so
//  exchange and prizes won in contests are included), you must get in touch
//  with me through the addresses given above to reach an agreement about the
//  conditions to use the data here contained (this file) or build from it,
//  both new image descriptions and images, whatever the format and/or the
//  storage way.

// No dudes en escribirme si tienes alguna pregunta, tanto sobre la clusula
//  arriba expuesta como sobre el fichero de datos que describe las imgenes
//  y las imgenes en si.
// P.D.: los precios son razonables y el dinero esta destinado bsicamente
//  a mejorar mi ordenador y poder seguir creando ms imagenes.
//--
// Do not doubt to write me if you has any question, about the clausule 
//  written above or the descriptions and the images.
// P.S.: prices are reasonable and money is basically to improve my computer
//  so I can keep making more pictures.

// NOTA IMPORTANTE
//  Este es un extracto de la licencia completa (LICENSE.GSR), lee dicho
//  fichero para conocer todas las condiciones y clusulas.
//--
// IMPORTANT NOTE
//  This is an extract of the complete license (LICENSE.GSR), read that file
//  to know all the conditions and clausules.
